/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.responsehandlers;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.reverseproxy.responsehandlers.ResponseHandlerBase;

public class TraceResponseHandler
extends ResponseHandlerBase {
    private boolean proxyTargeted = true;

    public TraceResponseHandler(HttpURLConnection httpConnection) {
        super(httpConnection);
    }

    public void process(HttpServletResponse response) throws IOException {
        if (this.proxyTargeted) {
            response.setStatus(200);
            response.setHeader("content-type", "message/http");
            response.setHeader("Connection", "close");
            String path = "path";
            String protocol = this.getHttpVersion();
            PrintWriter writer = response.getWriter();
            writer.println("TRACE " + path + " " + protocol);
            int i = 1;
            while (true) {
                String name = this.httpURLConnection.getHeaderFieldKey(i);
                String value = this.httpURLConnection.getHeaderField(i);
                if (name == null || value == null) break;
                writer.print(name + ": " + value);
                ++i;
            }
            writer.flush();
            writer.close();
        } else {
            this.setHeaders(response);
            response.setStatus(this.getStatusCode());
            this.sendStreamToClient((ServletResponse)response);
        }
    }

    public int getStatusCode() {
        if (this.proxyTargeted) {
            return 200;
        }
        return super.getStatusCode();
    }
}

