/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.rules;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.model.Rule;
import jeus.servlet.reverseproxy.rules.BaseRule;

public class CompositeRule
extends BaseRule {
    private LinkedList rules = new LinkedList();

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Rule to add cannot be null.");
        }
        this.rules.add(rule);
    }

    public boolean matches(HttpServletRequest request) {
        Iterator itr = this.rules.iterator();
        boolean matches = true;
        while (itr.hasNext() && matches) {
            Rule rule = (Rule)itr.next();
            matches = rule.matches(request);
        }
        return matches;
    }

    public String process(String uri) {
        String returnString = uri;
        for (Rule rule : this.rules) {
            returnString = rule.process(returnString);
        }
        return returnString;
    }

    public String revert(String uri) {
        String returnString = uri;
        ListIterator itr = this.rules.listIterator(this.rules.indexOf(this.rules.getLast()));
        while (itr.hasPrevious()) {
            Rule rule = (Rule)itr.previous();
            returnString = rule.revert(returnString);
        }
        return returnString;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append("CompositeRule containing ");
        for (Rule rule : this.rules) {
            buffer.append("(");
            buffer.append(rule.getClass().getName());
            buffer.append(") ");
        }
        buffer.append(": ");
        buffer.append("]");
        return buffer.toString();
    }
}

