/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.rules;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.rules.BaseRule;

public class IPRule
extends BaseRule {
    private String startRange;
    private String endRange;

    public boolean matches(HttpServletRequest request) {
        boolean match = false;
        if (this.getStartRange() != null && this.getEndRange() != null) {
            String ip = request.getRemoteAddr();
            match = ip.compareTo(this.getStartRange()) >= 0 && ip.compareTo(this.getEndRange()) <= 0;
        }
        return match;
    }

    private boolean validRange(String range) {
        StringTokenizer tokenizer = new StringTokenizer(range, ".");
        boolean correct = true;
        if (tokenizer.countTokens() != 4) {
            correct = false;
        }
        try {
            while (tokenizer.hasMoreTokens() && correct) {
                int tokenValue = Integer.parseInt(tokenizer.nextToken());
                correct = tokenValue >= 0 && tokenValue <= 255;
            }
        }
        catch (NumberFormatException e) {
            correct = false;
        }
        return correct;
    }

    public void setStartRange(String startRange) {
        if (startRange == null) {
            throw new IllegalArgumentException("The startRange cannot be null.");
        }
        if (!this.validRange(startRange)) {
            throw new IllegalArgumentException("IP range has to be between \"0.0.0.0\" and \"255.255.255.255\".");
        }
        if (this.getEndRange() != null && startRange.compareTo(this.getEndRange()) > 0) {
            throw new IllegalArgumentException("Starting range has to come before the ending range.");
        }
        this.startRange = startRange;
    }

    protected String getStartRange() {
        return this.startRange;
    }

    public void setEndRange(String endRange) {
        if (endRange == null) {
            throw new IllegalArgumentException("The endRange cannot be null.");
        }
        if (!this.validRange(endRange)) {
            throw new IllegalArgumentException("IP range has to be between \"0.0.0.0\" and \"255.255.255.255\".");
        }
        if (this.getStartRange() != null && endRange.compareTo(this.getStartRange()) < 0) {
            throw new IllegalArgumentException("Ending range has to come after the starting range.");
        }
        this.endRange = endRange;
    }

    protected String getEndRange() {
        return this.endRange;
    }
}

