/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.servers;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jeus.util.logging.JeusLogger;

public class ClusterResponseWrapper
extends HttpServletResponseWrapper {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private String serverId;
    private static Pattern sessionPattern = Pattern.compile("(JSESSIONID=|PHPSESSID=|ASPSESSIONID=|ASP.NET_SessionId=)([^;\\s\\.]+)", 130);

    public ClusterResponseWrapper(HttpServletResponse response, String serverId) {
        super(response);
        this.serverId = "." + serverId;
    }

    public void addHeader(String name, String originalValue) {
        String value = name.equalsIgnoreCase("set-cookie") ? this.rewriteSetCookie(originalValue) : originalValue;
        super.addHeader(name, value);
    }

    public void setHeader(String name, String originalValue) {
        String value = name.equalsIgnoreCase("set-cookie") ? this.rewriteSetCookie(originalValue) : originalValue;
        super.setHeader(name, value);
    }

    private String rewriteSetCookie(String value) {
        Matcher matcher = sessionPattern.matcher(value);
        String rewritten = matcher.replaceAll("$1$2" + this.serverId);
        if (!rewritten.equals(value)) {
            logger.log(Level.FINEST, "Session found and rewritten \"" + value + "\" >> " + rewritten);
        }
        return rewritten;
    }
}

