/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.servlets;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.FileCachingDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp.resource.JspResourceProvider;
import jeus.servlet.loader.ResourceCache;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.ContextProperties;
import jeus.sessionmanager.util.SessionManagerUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.util.message.JeusMessage_WebContainer8;

public class ResourceServlet
extends HttpServlet
implements ExecutionWrapper {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.servlets");
    private Context context;
    private ServletManager servletManager;
    private String datePattern = "dd-MMM-yyyyy HH:mm";
    private DateFormat dateFormat = new SimpleDateFormat(this.datePattern);
    private String[] welcomeFiles = null;
    private String[] allowedDirs = null;
    private String[] denyDownloadFiles = null;
    private String[] denyDownloadExts = null;
    private String[] denyDownloadDirs = null;
    private String contextPath;
    private ResourceCache rc;
    private Vector modifiedResources = new Vector();

    public void init() throws ServletException {
        Vector files;
        Vector cdir;
        FileCachingDescriptor fileCaching;
        this.context = (Context)this.getServletContext();
        this.servletManager = this.context.getServletManager();
        if (this.servletManager == null) {
            throw new ServletException("the servlet manager must be initialized");
        }
        this.contextPath = this.context.getContextPath();
        ContextDescriptor contextDesc = this.context.getContextDescriptor();
        Hashtable aliasList = contextDesc.getAliasing();
        Vector<String> dirList = contextDesc.getAllowIndexing();
        if (dirList != null && !dirList.isEmpty()) {
            this.allowedDirs = new String[dirList.size()];
            dirList.copyInto(this.allowedDirs);
        }
        Hashtable denyDownload = contextDesc.getDenyDownload();
        Vector fileList = null;
        if (denyDownload != null) {
            fileList = (Vector)denyDownload.get("file");
        }
        if (fileList == null) {
            fileList = new Vector();
        }
        if (fileList != null && !fileList.isEmpty()) {
            this.denyDownloadFiles = new String[fileList.size()];
            fileList.copyInto(this.denyDownloadFiles);
        }
        Vector extList = null;
        if (denyDownload != null) {
            extList = (Vector)denyDownload.get("extension");
        }
        if (extList == null) {
            extList = new Vector();
        }
        if (extList != null && !extList.isEmpty()) {
            this.denyDownloadExts = new String[extList.size()];
            extList.copyInto(this.denyDownloadExts);
        }
        dirList = null;
        if (denyDownload != null) {
            dirList = (Vector)denyDownload.get("directory");
        }
        if (dirList == null) {
            dirList = new Vector<String>();
        }
        dirList.addElement("/WEB-INF/");
        dirList.addElement("/META-INF/");
        if (dirList != null && !dirList.isEmpty()) {
            this.denyDownloadDirs = new String[dirList.size()];
            dirList.copyInto(this.denyDownloadDirs);
        }
        if (JspServletWrapper.FILENAME_IGNORECASE) {
            this.utilConvertStringCase(this.allowedDirs, false);
            this.utilConvertStringCase(this.denyDownloadFiles, false);
            this.utilConvertStringCase(this.denyDownloadExts, false);
            this.utilConvertStringCase(this.denyDownloadDirs, false);
        }
        if ((fileCaching = contextDesc.getFileCaching()) != null && (cdir = fileCaching.getCachingDirectory()) != null && cdir.size() > 0) {
            this.rc = new ResourceCache(fileCaching.getMaxCacheMemory(), fileCaching.getMaxIdleTime(), fileCaching.getCachingDirectory());
            this.rc.init(this.context, aliasList);
        }
        if ((files = this.context.getWelcomeFiles()) != null && !files.isEmpty()) {
            int size = files.size();
            this.welcomeFiles = new String[size];
            for (int i = 0; i < size; ++i) {
                this.welcomeFiles[i] = (String)files.elementAt(i);
            }
        }
    }

    public synchronized void setWelcomeFiles(Vector files) {
        if (files != null && !files.isEmpty()) {
            int size = files.size();
            this.welcomeFiles = new String[size];
            for (int i = 0; i < size; ++i) {
                this.welcomeFiles[i] = (String)files.elementAt(i);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, int dispatchType) throws ServletException, IOException {
        JspResourceProvider provider;
        boolean isIncluded;
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        String originalRequestURI = ((HttpServletRequestImpl)request).getOriginalRequestURI();
        URL url = null;
        boolean bl = isIncluded = dispatchType == 4;
        if (isIncluded) {
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String _cpath = (String)request.getAttribute("javax.servlet.include.context_path");
            requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            requestURI = RequestUtil.removeContextPathFromRequestURI(_cpath, requestURI);
        }
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (servletPath == null) {
            servletPath = "";
        }
        if (pathInfo.equals("")) {
            pathInfo = servletPath;
        }
        if (!pathInfo.startsWith("/")) {
            pathInfo = "/" + pathInfo;
        }
        if (url == null) {
            url = this.context.getResource(pathInfo);
        }
        if ((provider = this.context.getJspResourceProvider()) == null) {
            if (url != null) {
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    File f = new File(this.context.getCtxDocBase().getFile() + pathInfo);
                    if (f.exists()) {
                        if (f.isFile() && (pathInfo.endsWith("/") || pathInfo.endsWith("\\") || pathInfo.endsWith("."))) {
                            response.sendError(404, "File Not Found: " + originalRequestURI);
                        } else {
                            this.processFile(f, requestURI, pathInfo, request, response, dispatchType);
                        }
                    } else {
                        response.sendError(404, "File Not Found: " + originalRequestURI);
                    }
                } else if (url.getProtocol().equalsIgnoreCase("war")) {
                    String documentBase = this.context.getCtxDocBase().toString();
                    URL mappedURL = new URL(documentBase + pathInfo);
                    this.serveURL(mappedURL, requestURI, request, response);
                } else {
                    this.serveURL(url, requestURI, request, response);
                }
            } else {
                response.sendError(404, "File Not Found: " + originalRequestURI);
            }
        } else if (url != null) {
            if (url.getProtocol().equalsIgnoreCase("file")) {
                File f;
                block40: {
                    f = new File(this.context.getCtxDocBase().getFile() + pathInfo);
                    if (this.modifiedResources.contains(pathInfo)) {
                        try {
                            f.getParentFile().mkdirs();
                            FileUtils.copy((InputStream)provider.getResource(pathInfo), (OutputStream)new FileOutputStream(f));
                            this.modifiedResources.remove(pathInfo);
                            if (logger.isLoggable(JeusMessage_WebContainer5_4._5686_LEVEL)) {
                                logger.log(JeusMessage_WebContainer5_4._5686_LEVEL, JeusMessage_WebContainer5_4._5686, (Object[])new String[]{pathInfo, f.getCanonicalPath()});
                            }
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(JeusMessage_WebContainer5_4._5692_LEVEL)) break block40;
                            logger.log(JeusMessage_WebContainer5_4._5692_LEVEL, JeusMessage_WebContainer5_4._5692, (Object)pathInfo, (Throwable)e);
                        }
                    }
                }
                if (f.exists()) {
                    if (f.isFile() && (pathInfo.endsWith("/") || pathInfo.endsWith("\\") || pathInfo.endsWith("."))) {
                        response.sendError(404, "File Not Found: " + originalRequestURI);
                    } else {
                        this.processFile(f, requestURI, pathInfo, request, response, dispatchType);
                    }
                } else {
                    try {
                        f.getParentFile().mkdirs();
                        FileUtils.copy((InputStream)provider.getResource(pathInfo), (OutputStream)new FileOutputStream(f));
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5687_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5687_LEVEL, JeusMessage_WebContainer5_4._5687, (Object[])new String[]{pathInfo, f.getCanonicalPath()});
                        }
                        this.processFile(f, requestURI, pathInfo, request, response, dispatchType);
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5692_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5692_LEVEL, JeusMessage_WebContainer5_4._5692, (Object)pathInfo, (Throwable)e);
                        }
                        response.sendError(404, "File Not Found: " + originalRequestURI);
                    }
                }
            } else if (url.getProtocol().equalsIgnoreCase("war")) {
                String documentBase = this.context.getCtxDocBase().toString();
                URL mappedURL = new URL(documentBase + pathInfo);
                this.serveURL(mappedURL, requestURI, request, response);
            } else {
                this.serveURL(url, requestURI, request, response);
            }
        } else {
            String realPath = this.context.getRealPath(pathInfo);
            File resourceFile = new File(realPath);
            try {
                resourceFile.getParentFile().mkdirs();
                FileUtils.copy((InputStream)provider.getResource(pathInfo), (OutputStream)new FileOutputStream(resourceFile));
                if (logger.isLoggable(JeusMessage_WebContainer5_4._5688_LEVEL)) {
                    logger.log(JeusMessage_WebContainer5_4._5688_LEVEL, JeusMessage_WebContainer5_4._5688, (Object[])new String[]{pathInfo, realPath});
                }
                this.processFile(resourceFile, requestURI, pathInfo, request, response, dispatchType);
            }
            catch (IOException e) {
                if (logger.isLoggable(JeusMessage_WebContainer5_4._5692_LEVEL)) {
                    logger.log(JeusMessage_WebContainer5_4._5692_LEVEL, JeusMessage_WebContainer5_4._5692, (Object)pathInfo, (Throwable)e);
                }
                response.sendError(404, "File Not Found: " + originalRequestURI);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void processFile(File file, String requestURI, String pathInfo, HttpServletRequest request, HttpServletResponse response, int dispatchType) throws ServletException, IOException {
        if (file.isDirectory()) {
            String welcomeFile = this.getWelcomeFile(pathInfo, file);
            if (welcomeFile != null) {
                String redirectedURI = null;
                redirectedURI = !requestURI.endsWith("/") && !welcomeFile.startsWith("/") ? requestURI + "/" + welcomeFile : requestURI + welcomeFile;
                StringTokenizer tokenizer = new StringTokenizer(redirectedURI, "/ ", true);
                StringBuffer encodedURI = new StringBuffer();
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.equals("/")) {
                        encodedURI.append(tok);
                        continue;
                    }
                    if (tok.equals(" ")) {
                        encodedURI.append("%20");
                        continue;
                    }
                    encodedURI.append(URLEncoder.encode(tok));
                }
                ContextProperties props = this.context.getContextProperties();
                String qstr = request.getQueryString();
                if (props.WELCOMEFILE_SENDREDIRECT.value) {
                    if (qstr != null) {
                        response.sendRedirect(encodedURI.toString() + "?" + qstr);
                    } else {
                        response.sendRedirect(encodedURI.toString());
                    }
                } else {
                    RequestDispatcher dispatcher;
                    String url = encodedURI.toString();
                    if (qstr != null) {
                        url = url + "?" + qstr;
                    }
                    String relpath = url;
                    int len = this.contextPath.length();
                    if (len > 1) {
                        relpath = relpath.substring(len);
                    }
                    if ((dispatcher = this.context.getRequestDispatcher(relpath)) != null) {
                        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                    } else {
                        response.sendError(404, url);
                    }
                }
            } else {
                this.serveDir(file, requestURI, request, response);
            }
        } else {
            this.serveFile(file, null, requestURI, request, response, dispatchType);
        }
    }

    public String checkWelcomeFile(String lookupPath) {
        String welcomeFile;
        File f;
        if (lookupPath == null) {
            return null;
        }
        URL url = null;
        try {
            url = this.context.getResource(lookupPath);
        }
        catch (Exception e) {
            return null;
        }
        if (url != null && url.getProtocol().equalsIgnoreCase("file") && (f = new File(url.getFile())).exists() && f.isDirectory() && (welcomeFile = this.getWelcomeFile(null, f)) != null) {
            if (!lookupPath.endsWith("/")) {
                return lookupPath + "/" + welcomeFile;
            }
            return lookupPath + welcomeFile;
        }
        return null;
    }

    private String getWelcomeFile(String pathInfo, File file) {
        String fileName;
        int i;
        String welcomeFile = null;
        if (this.welcomeFiles == null) {
            return null;
        }
        for (i = 0; i < this.welcomeFiles.length; ++i) {
            fileName = this.welcomeFiles[i];
            File f = new File(file, fileName);
            if (!f.exists()) continue;
            welcomeFile = fileName;
            break;
        }
        if (welcomeFile == null && pathInfo != null) {
            if (!pathInfo.endsWith("/")) {
                pathInfo = pathInfo + "/";
            }
            for (i = 0; i < this.welcomeFiles.length; ++i) {
                fileName = this.welcomeFiles[i];
                String urlpattern = pathInfo + fileName;
                if (this.servletManager.lookupPathMappedServlet(urlpattern) == null) continue;
                welcomeFile = fileName;
            }
        }
        return welcomeFile;
    }

    private void serveURL(URL url, String requestURI, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            URLConnection con = url.openConnection();
            con.connect();
            String contentType = con.getContentType();
            int contentLength = con.getContentLength();
            String lastModified = Long.toString(con.getLastModified());
            response.setContentType(contentType != null ? contentType : "text/html");
            response.setContentLength(contentLength >= 0 ? contentLength : 0);
            response.setHeader("Last-Modified", lastModified != null ? lastModified : "");
            InputStream in = con.getInputStream();
            this.serveStream(in, response);
            in.close();
        }
        catch (IOException e) {
            response.sendError(404, "File Not Found: " + ((HttpServletRequestImpl)request).getOriginalRequestURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(File file, String fileName, String requestURI, HttpServletRequest request, HttpServletResponse response, int dispatchType) throws IOException, ServletException {
        String mimeType;
        int i;
        boolean isIncluded = dispatchType == 4;
        boolean isForwarded = dispatchType == 2;
        String filename = file.toString();
        long fileLength = file.length();
        long fileLastModified = file.lastModified();
        String newRequestURI = null;
        String newFileName = null;
        String newContextPath = null;
        String originalRequestURI = ((HttpServletRequestImpl)request).getOriginalRequestURI();
        if (JspServletWrapper.FILENAME_IGNORECASE) {
            newRequestURI = requestURI.toLowerCase();
            newFileName = filename.toLowerCase();
            newContextPath = this.contextPath.toLowerCase();
        } else {
            newRequestURI = requestURI;
            newFileName = filename;
            newContextPath = this.contextPath;
        }
        if (this.denyDownloadFiles != null) {
            for (i = 0; i < this.denyDownloadFiles.length; ++i) {
                if (!newRequestURI.equals(newContextPath + this.denyDownloadFiles[i])) continue;
                response.sendError(404);
                return;
            }
        }
        if (this.denyDownloadExts != null) {
            for (i = 0; i < this.denyDownloadExts.length; ++i) {
                if (!newFileName.endsWith(this.denyDownloadExts[i])) continue;
                response.sendError(404);
                return;
            }
        }
        if (!isIncluded && !isForwarded) {
            if (!JspServletWrapper.FILENAME_IGNORECASE) {
                if (this.denyDownloadDirs != null) {
                    for (i = 0; i < this.denyDownloadDirs.length; ++i) {
                        if (newRequestURI.indexOf(this.denyDownloadDirs[i]) < 0) continue;
                        response.sendError(404);
                        return;
                    }
                }
            } else if (this.denyDownloadDirs != null) {
                block24: for (i = 0; i < this.denyDownloadDirs.length; ++i) {
                    String dirname = this.denyDownloadDirs[i].substring(0, this.denyDownloadDirs[i].length() - 1);
                    int pos = newRequestURI.indexOf(dirname);
                    if (pos < 0) continue;
                    int len = newRequestURI.length();
                    for (int j = pos + dirname.length(); j < len; ++j) {
                        char ch = newRequestURI.charAt(j);
                        if (ch == '/') {
                            response.sendError(404);
                            return;
                        }
                        if (ch != '.') continue block24;
                    }
                }
            }
            if (!this.checkIfHeaders(request, response, fileLength, fileLastModified)) {
                return;
            }
        }
        if ((mimeType = this.context.getMimeType(file.getName())) == null) {
            mimeType = "text/plain";
        }
        boolean isHeadCommand = "HEAD".equals(request.getMethod());
        response.setContentType(mimeType);
        response.setContentLength(SessionManagerUtil.safeCasting(file.length()));
        response.setDateHeader("Last-Modified", file.lastModified());
        if (isHeadCommand) {
            return;
        }
        String range = request.getHeader("range");
        boolean rangeEnabled = range != null;
        FileInputStream in = null;
        if (!rangeEnabled) {
            if (this.rc != null) {
                try {
                    String searchPath = null;
                    searchPath = fileName != null ? fileName : requestURI;
                    byte[] bs = this.rc.getResourceAsBytes(searchPath);
                    if (bs != null) {
                        this.serveBytes(bs, response);
                    }
                    in = new FileInputStream(file);
                    this.serveStream(in, response);
                }
                catch (FileNotFoundException e) {
                    response.sendError(404, "File Not Found: " + originalRequestURI);
                }
                catch (SocketException e) {
                    return;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            } else {
                in = new FileInputStream(file);
                try {
                    this.serveStream(in, response);
                }
                catch (FileNotFoundException e) {
                    response.sendError(404, "File Not Found: " + originalRequestURI);
                }
                catch (SocketException e) {
                    return;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        } else {
            in = new FileInputStream(file);
            try {
                this.serveRangedFile(in, response, range, file);
            }
            catch (FileNotFoundException e) {
                response.sendError(404, "File Not Found: " + originalRequestURI);
            }
            catch (SocketException e) {
                return;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    private void serveBytes(byte[] bs, HttpServletResponse response) throws IOException, ServletException {
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(bs, 0, bs.length);
        }
        catch (IllegalStateException ise) {
            try {
                PrintWriter writer = response.getWriter();
                String res = new String(bs, response.getCharacterEncoding());
                writer.write(res);
            }
            catch (UnsupportedEncodingException uee) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8404, (Object)response.getCharacterEncoding()), (Throwable)uee);
            }
        }
    }

    private void serveStream(InputStream in, HttpServletResponse response) throws IOException {
        try {
            ServletOutputStream out = response.getOutputStream();
            this.serveStreamAsStream(in, (OutputStream)out);
        }
        catch (IllegalStateException ise) {
            PrintWriter out = response.getWriter();
            this.serveStreamAsWriter(in, out);
        }
    }

    private void serveRangedFile(FileInputStream in, HttpServletResponse response, String range, File file) throws IOException {
        char[] cbuf;
        byte[] buf;
        block18: {
            long fileSize = file.length();
            ServletOutputStream out = response.getOutputStream();
            buf = new byte[2048];
            cbuf = new char[2048];
            int read = 0;
            int count = 0;
            Vector offsets = this.parseRangeHeader(range);
            if (offsets == null || offsets.size() < 2) {
                response.setStatus(416);
                out.flush();
                return;
            }
            int start = Integer.parseInt((String)offsets.get(0));
            int end = Integer.parseInt((String)offsets.get(1));
            if (start == -1) {
                start = SessionManagerUtil.safeCasting(fileSize - (long)end);
            } else if (end == -1) {
                end = SessionManagerUtil.safeCasting(fileSize - 1L);
            }
            int transRange = end - start + 1;
            if ((long)transRange < fileSize) {
                response.setStatus(206);
            } else if ((long)transRange == fileSize) {
                response.setStatus(200);
            } else {
                response.setStatus(416);
                out.flush();
                return;
            }
            if ((long)end >= fileSize || (long)start >= fileSize) {
                response.setStatus(416);
                out.flush();
                return;
            }
            response.setContentLength(transRange);
            StringBuffer rangeValueBuffer = new StringBuffer();
            rangeValueBuffer.append("bytes ");
            rangeValueBuffer.append(start);
            rangeValueBuffer.append("-");
            rangeValueBuffer.append(end);
            rangeValueBuffer.append("/");
            rangeValueBuffer.append(fileSize);
            try {
                if (transRange > buf.length) {
                    in.skip(start);
                    while ((read = in.read(buf)) != -1) {
                        if ((count += read) > transRange) {
                            int len = read - (count - transRange);
                            out.write(buf, 0, len);
                            break block18;
                        }
                        out.write(buf, 0, read);
                    }
                    break block18;
                }
                in.skip(start);
                read = in.read(buf, 0, transRange);
                if (read != -1) {
                    out.write(buf, 0, transRange);
                }
            }
            catch (IllegalStateException ise) {
                PrintWriter outWriter = response.getWriter();
                InputStreamReader r = new InputStreamReader(in);
                if (transRange > cbuf.length) {
                    while ((read = r.read(cbuf)) != -1) {
                        if ((count += read) > transRange) {
                            int len = read - (count - transRange);
                            outWriter.write(cbuf, 0, len);
                        }
                        outWriter.write(cbuf, 0, read);
                    }
                }
                r.skip(start);
                read = r.read(cbuf, 0, transRange);
                if (read == -1) break block18;
                outWriter.write(cbuf, 0, transRange);
            }
        }
        buf = null;
        cbuf = null;
    }

    private Vector parseRangeHeader(String range) {
        Vector<String> offsets = new Vector<String>();
        if (!range.startsWith("bytes")) {
            return null;
        }
        String rangeString = range.indexOf(61) != -1 ? range.substring(range.indexOf(61) + 1).trim() : range.substring(range.indexOf("bytes") + "bytes".length()).trim();
        StringTokenizer rangeToken = new StringTokenizer(rangeString, ",");
        while (rangeToken.hasMoreTokens()) {
            String end;
            String start;
            String token = rangeToken.nextToken();
            int dashIndex = (token = token.trim()).indexOf(45);
            if (dashIndex == 0) {
                start = "-1";
                end = token.substring(1);
            } else if (dashIndex == token.length() - 1) {
                start = token.substring(0, dashIndex);
                end = "-1";
            } else {
                if (dashIndex == -1) {
                    return null;
                }
                start = token.substring(0, dashIndex);
                end = token.substring(dashIndex + 1);
            }
            offsets.add(start);
            offsets.add(end);
        }
        return offsets;
    }

    private void serveStreamAsStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    private void serveStreamAsWriter(InputStream in, PrintWriter out) throws IOException {
        InputStreamReader r = new InputStreamReader(in);
        char[] buf = new char[1024];
        int read = 0;
        while ((read = r.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    private boolean isAllowedDir(String requestURI) {
        boolean isUnix = File.separator.equals("/");
        if (!isUnix) {
            requestURI = requestURI.toLowerCase();
        }
        for (int i = 0; i < this.allowedDirs.length; ++i) {
            String allowedDir = this.contextPath + this.allowedDirs[i];
            int pos = requestURI.indexOf(allowedDir);
            if (pos != 0) continue;
            return true;
        }
        return false;
    }

    private void serveDir(File file, String requestURI, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName;
        Enumeration e;
        File f;
        String slashedRequestURI = null;
        slashedRequestURI = requestURI.endsWith("/") ? requestURI : requestURI + "/";
        boolean inInclude = false;
        Object o = request.getAttribute("javax.servlet.dispatch.request_uri");
        if (o != null) {
            inInclude = true;
        }
        if (this.allowedDirs == null || !this.isAllowedDir(slashedRequestURI)) {
            response.sendError(403, "Permission denied: " + ((HttpServletRequestImpl)request).getOriginalRequestURI());
            return;
        }
        Vector<File> dirs = new Vector<File>();
        Vector<File> files = new Vector<File>();
        String[] fileNames = file.list();
        String docBase = this.context.getCtxDocBase().getFile();
        if (!docBase.endsWith("/")) {
            docBase = docBase + "/";
        }
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName2 = fileNames[i];
            f = new File(file, fileName2);
            if (f.isDirectory()) {
                dirs.addElement(f);
                continue;
            }
            files.addElement(f);
        }
        StringBuffer buf = new StringBuffer();
        if (!inInclude) {
            response.setContentType("text/html");
            buf.append("<html>\r\n");
            buf.append("<head>\r\n");
            buf.append("<title>Index of " + requestURI);
            buf.append("</title>\r\n</head><body bgcolor=white>\r\n");
        }
        buf.append("<h2>Index of " + requestURI + "</h2>");
        buf.append("<table cellpadding=3 align=left>");
        buf.append("<tr bgcolor=#B0E2FF><td><b><center>Name</center></b></td>\r\n");
        buf.append("<td><b><center>Size</center></b></td>\r\n");
        buf.append("<td><b><center>Last modified</center></b></td></tr>\r\n");
        if (!requestURI.equals("/")) {
            String toPath = requestURI;
            if (toPath.endsWith("/")) {
                toPath = toPath.substring(0, toPath.length() - 1);
            }
            if ((toPath = toPath.substring(0, toPath.lastIndexOf("/"))).length() == 0) {
                toPath = "/";
            }
            f = new File(file.getParent());
            buf.append("<tr><td><b>[DIR]</b>&nbsp;");
            buf.append("<tt><a href=\"" + toPath + "\">Parent Directory" + "</a>&nbsp;&nbsp</tt>\r\n");
            buf.append("</td><td><center>-</center></td>");
            buf.append("<td align=right><tt>&nbsp;&nbsp;");
            buf.append(this.dateFormat.format(new Date(f.lastModified())));
            buf.append("&nbsp;&nbsp;</tt></td></tr>\r\n");
        }
        if (dirs.size() > 0) {
            e = dirs.elements();
            while (e.hasMoreElements()) {
                f = (File)e.nextElement();
                fileName = f.getName();
                buf.append("<tr><td><b>[DIR]</b>&nbsp;");
                buf.append("<tt><a href=\"" + slashedRequestURI + fileName + "\">" + fileName + "/</a>&nbsp;&nbsp;</tt>\r\n");
                buf.append("</td><td><center>-</center></td>");
                buf.append("<td align=right><tt>&nbsp;&nbsp;");
                buf.append(this.dateFormat.format(new Date(f.lastModified())));
                buf.append("&nbsp;&nbsp;</tt></td></tr>\r\n");
            }
            buf.append("\r\n");
        }
        if (files.size() > 0) {
            e = files.elements();
            while (e.hasMoreElements()) {
                buf.append("<tr");
                buf.append("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n");
                f = (File)e.nextElement();
                fileName = f.getName();
                buf.append("<tt><a href=\"" + slashedRequestURI + fileName + "\">" + fileName + "</a>");
                buf.append("&nbsp;&nbsp;<tt>");
                buf.append("</td></td>\r\n<td align=right><tt>&nbsp;&nbsp;");
                int filesize = SessionManagerUtil.safeCasting(f.length());
                int leftside = filesize / 1024;
                int rightside = filesize % 1024 / 103;
                if (leftside == 0 && rightside == 0 && filesize != 0) {
                    rightside = 1;
                }
                buf.append(leftside + "." + rightside + " KB");
                buf.append("&nbsp;&nbsp;</tt></td>");
                buf.append("<td align=right><tt>&nbsp;&nbsp;");
                buf.append(this.dateFormat.format(new Date(f.lastModified())));
                buf.append("&nbsp;&nbsp;</tt></td></tr>\r\n");
            }
            buf.append("\r\n");
        }
        buf.append("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        buf.append("<tr><td colspan=3 bgcolor=#FDF5E6>");
        buf.append("<b><i>&nbsp;&nbsp;&nbsp;&nbsp;");
        buf.append("</b></i></td></tr></table>");
        if (!inInclude) {
            buf.append("</body></html>\r\n");
        }
        String output = buf.toString();
        byte[] bytes = output.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.serveStream(in, response);
    }

    public String getName() {
        return "jeus.servlet.servlets.ResourceServlet";
    }

    public boolean isResourceServlet() {
        return true;
    }

    public String getClassName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        WebAppContextSwitch.preContextSwitch(this.context.getContextLoader());
        try {
            request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.REQUEST_INTEGER);
            request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", request.getLookupPath());
            FilterFactory factory = FilterFactory.getInstance();
            FilterChainImpl filterChain = factory.createFilterChain((ServletRequest)request, this);
            try {
                if (filterChain != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    this.executeServlet((ServletRequest)request, (ServletResponse)response);
                }
            }
            finally {
                if (filterChain != null) {
                    filterChain.release();
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void executeServlet(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        int dispatchType = 8;
        Integer disInt = (Integer)req.getAttribute("jeus.web.DISPATCHER_TYPE");
        if (disInt != null) {
            dispatchType = disInt;
        }
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8403));
        }
        this.doGet(request, response, dispatchType);
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }

    private void utilConvertStringCase(String[] stringArray, boolean toUpperCase) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = toUpperCase ? stringArray[i].toUpperCase() : stringArray[i].toLowerCase();
        }
    }

    public void resourceModified(String resource) {
        if (!this.modifiedResources.contains(resource)) {
            this.modifiedResources.add(resource);
        }
    }

    private boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, long fileLength, long fileLastModified) throws IOException {
        return this.checkIfMatch(request, response, fileLength, fileLastModified) && this.checkIfModifiedSince(request, response, fileLastModified) && this.checkIfNoneMatch(request, response, fileLength, fileLastModified) && this.checkIfUnmodifiedSince(request, response, fileLastModified);
    }

    private boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, long fileLength, long fileLastModified) throws IOException {
        String eTag = this.getETag(fileLength, fileLastModified);
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, long fileLastModified) {
        try {
            long headerValue = request.getDateHeader("If-Modified-Since");
            if (headerValue != -1L && request.getHeader("If-None-Match") == null && fileLastModified <= headerValue + 1000L) {
                response.setStatus(304);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, long fileLength, long fileLastModified) throws IOException {
        String eTag = this.getETag(fileLength, fileLastModified);
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, long fileLastModified) throws IOException {
        try {
            long headerValue = request.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && fileLastModified > headerValue + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private String getETag(long fileLength, long fileLastModified) {
        return "W/\"" + fileLength + "-" + fileLastModified + "\"";
    }
}

