/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.servlets;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer8;

public class UserJspServlet
implements ExecutionWrapper {
    private ServletManager servletManager = null;
    private Context context;
    private boolean prefixMapping;

    public UserJspServlet(Context context, ServletManager manager, boolean prefixMapping) {
        this.context = context;
        this.servletManager = manager;
        this.prefixMapping = prefixMapping;
    }

    public void init(ServletConfig config) throws ServletException {
        Context context = (Context)config.getServletContext();
        this.servletManager = context.getServletManager();
        if (this.servletManager == null) {
            throw new ServletException("the servlet manager must be initialized");
        }
    }

    public String getName() {
        return "jeus.servlet.servlets.UserJspServlet";
    }

    public String getClassName() {
        return this.getName();
    }

    public boolean isResourceServlet() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        WebAppContextSwitch.preContextSwitch(this.context.getContextLoader());
        try {
            request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.REQUEST_INTEGER);
            request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", request.getLookupPath());
            FilterFactory factory = FilterFactory.getInstance();
            FilterChainImpl filterChain = factory.createFilterChain((ServletRequest)request, this);
            try {
                if (filterChain != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    if (!this.context.enableJSP()) {
                        response.sendError(503, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8401));
                        return;
                    }
                    String jspUri = null;
                    String pathInfo = request.getPathInfo();
                    String servletPath = request.getServletPath();
                    if (this.prefixMapping && pathInfo != null) {
                        jspUri = servletPath + pathInfo;
                        HttpServletRequestImpl orgreq = this.getOriginalRequest(request);
                        if (orgreq != null) {
                            orgreq.setServletPath(jspUri);
                            orgreq.setPathInfo(null);
                        }
                    } else {
                        jspUri = servletPath;
                    }
                    String jspName = null;
                    jspName = JspServletWrapper.FILENAME_IGNORECASE ? jspUri.toLowerCase() : jspUri;
                    JspServletWrapper wrapper = this.servletManager.addJsp(jspName, jspUri, null);
                    if (wrapper != null) {
                        wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
                    }
                }
            }
            finally {
                if (filterChain != null) {
                    filterChain.release();
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void executeServlet(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8403));
        }
        if (!this.context.enableJSP()) {
            response.sendError(503, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8404));
            return;
        }
        String jspUri = null;
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        int dispatchType = 8;
        Integer disInt = (Integer)req.getAttribute("jeus.web.DISPATCHER_TYPE");
        if (disInt != null) {
            dispatchType = disInt;
        }
        if (dispatchType == 4) {
            String includeUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            String _cpath = (String)request.getAttribute("javax.servlet.include.context_path");
            includeUri = RequestUtil.removeContextPathFromRequestURI(_cpath, includeUri);
            if (includeUri == null) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8407));
            }
            jspUri = includeUri;
            if (this.prefixMapping && pathInfo != null) {
                HttpServletRequestImpl orgreq = this.getOriginalRequest(request);
                orgreq.setAttribute("javax.servlet.include.servlet_path", servletPath + pathInfo);
                orgreq.setAttribute("javax.servlet.include.path_info", null);
            }
        } else if (this.prefixMapping && pathInfo != null) {
            jspUri = servletPath + pathInfo;
            HttpServletRequestImpl orgreq = this.getOriginalRequest(request);
            if (orgreq != null) {
                orgreq.setServletPath(jspUri);
                orgreq.setPathInfo(null);
            }
        } else {
            jspUri = servletPath;
        }
        String jspName = null;
        jspName = JspServletWrapper.FILENAME_IGNORECASE ? jspUri.toLowerCase() : jspUri;
        JspServletWrapper wrapper = this.servletManager.addJsp(jspName, jspUri, null);
        try {
            wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8402, (Object)jspUri), t);
        }
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }

    private HttpServletRequestImpl getOriginalRequest(HttpServletRequest request) throws ServletException {
        if (request instanceof HttpServletRequestImpl) {
            return (HttpServletRequestImpl)request;
        }
        if (!(request instanceof ServletRequestWrapper)) {
            return null;
        }
        ServletRequest tmp = ((ServletRequestWrapper)request).getRequest();
        while (true) {
            if (tmp == null) {
                return null;
            }
            if (tmp instanceof HttpServletRequestImpl) {
                return (HttpServletRequestImpl)tmp;
            }
            if (!(tmp instanceof ServletRequestWrapper)) break;
            tmp = ((ServletRequestWrapper)tmp).getRequest();
        }
        throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8408));
    }
}

