/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.syscontext;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import jeus.servlet.common.WebContainerControl;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.ListenerDescriptor;
import jeus.servlet.deployment.descriptor.ResponseHeaderDescriptor;
import jeus.servlet.deployment.descriptor.ServletDescriptor;
import jeus.servlet.deployment.descriptor.ThreadPoolDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.deployment.descriptor.bind.WebMainDescriptorJB;
import jeus.servlet.filter.FilterDef;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusPort;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.message.JeusMessage_WebContainer1;

public class SystemContext {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.deployment");
    public static final String WEBHOME_DIR = JeusBootstrapProperties.JEUS_HOME + File.separator + "webhome" + File.separator;
    private static final String contextGroupName = "JeusSystemContextGroup";
    private static final String CONNECTION_PORT = String.valueOf(JeusPort.SystemEngine);
    private static final String MIN_THREAD_NUM = "5";
    private static final String MAX_THREAD_NUM = "10";
    private static final String DEFAULT_READ_TIMEOUT = "30000";
    private static final String DEFAULT_POST_READ_TIMEOUT = "30000";
    private static final int MAX_KEEPALIVE_REQUEST_COUNT = 100;
    private static final boolean enableKeepAlive = false;
    private String engineGroup = null;
    private String engineName = null;
    private WebContainerDescriptor webContainerDesc = null;
    private boolean enableWebAdmin = false;
    private WebContainerManager containerManager = null;
    private Vector allowedServer;

    public SystemContext(String engineName, boolean enableWebAdmin, Vector allowedServer) throws StartingException {
        this.enableWebAdmin = enableWebAdmin;
        int pos = engineName.indexOf("_system_engine");
        this.engineName = engineName;
        this.engineGroup = engineName.substring(0, pos);
        this.allowedServer = allowedServer;
    }

    public void startup() throws StartingException {
        if (this.enableWebAdmin) {
            try {
                this.initDescriptor();
            }
            catch (DescriptorException de) {
                throw new StartingException(JeusMessage_WebContainer1._2400, (Throwable)((Object)de));
            }
            this.containerManager = new WebContainerManager();
            this.containerManager.initConstants(this.engineName, false, true);
            this.containerManager.setConfigByXML(false);
            this.containerManager.setWebContainerDescriptor(this.webContainerDesc);
            this.containerManager.startContainer();
        }
    }

    public void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.shutdown();
        }
    }

    private void initDescriptor() throws DescriptorException {
        block27: {
            this.webContainerDesc = new WebMainDescriptorJB();
            ContextGroupDescriptor grpDesc = new ContextGroupDescriptor();
            ContextDescriptor jnlpCtxDesc = new ContextDescriptor();
            ContextDescriptor waCtxDesc = new ContextDescriptor();
            WebAppDescriptor waWebAppDesc = new WebAppDescriptor();
            WebAppDescriptor jnlpWebAppDesc = new WebAppDescriptor();
            ResponseHeaderDescriptor rhDesc = new ResponseHeaderDescriptor();
            JeusLogger l = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet");
            String aa = System.getProperty("jeus.webadmin.logLevel");
            if (aa != null && (aa = aa.trim()).length() > 0) {
                if ((aa = aa.toLowerCase()).startsWith("all")) {
                    l.setLevel(Level.ALL);
                } else if (aa.startsWith("severe")) {
                    l.setLevel(Level.SEVERE);
                } else if (aa.startsWith("warning")) {
                    l.setLevel(Level.WARNING);
                } else if (aa.startsWith("info")) {
                    l.setLevel(Level.INFO);
                } else if (aa.startsWith("config")) {
                    l.setLevel(Level.CONFIG);
                } else if (aa.equals("fine")) {
                    l.setLevel(Level.FINE);
                } else if (aa.equals("finer")) {
                    l.setLevel(Level.FINER);
                } else if (aa.equals("finest")) {
                    l.setLevel(Level.FINEST);
                } else {
                    l.setLevel(Level.SEVERE);
                }
            } else {
                l.setLevel(Level.SEVERE);
            }
            grpDesc.setGroupName(contextGroupName);
            grpDesc.setResponseHeaderDescriptor(rhDesc);
            grpDesc.setForcedRequestUrlEncoding("UTF-8");
            grpDesc.setForcedRequestEncoding("UTF-8");
            grpDesc.setForcedResponseEncoding("UTF-8");
            Hashtable<String, String> jspconfig = new Hashtable<String, String>();
            String workdir = JeusBootstrapProperties.JEUS_HOME + File.separator + "workspace" + File.separator + this.engineName + File.separator;
            jspconfig.put("JspWorkDir", workdir);
            jspconfig.put("CompileOutputDir", workdir);
            grpDesc.setJspConfig(jspconfig);
            if (this.enableWebAdmin) {
                File onlineHelpDir;
                File[] helpDirs;
                waCtxDesc.setContextName("WebAdmin");
                waCtxDesc.setContextPath("/webadmin");
                waCtxDesc.setDocBase(WEBHOME_DIR + "admin_home");
                waCtxDesc.setEnableJSP("true");
                waCtxDesc.setAutoReload("false");
                waCtxDesc.setWebinfFitst("true");
                ListenerDescriptor ctxLsnrDesc = new ListenerDescriptor();
                ctxLsnrDesc.setListenerClass("jeus.tool.webadmin.util.ApplicationInitializer");
                waWebAppDesc.addListenerDescriptor(ctxLsnrDesc);
                ServletDescriptor servletDesc = new ServletDescriptor("webadmin", "org.apache.tapestry.ApplicationServlet", "1");
                String lang = System.getProperty("jeus.tool.webadmin.locale.language");
                if (lang != null && !lang.trim().equals("")) {
                    servletDesc.addInitParam("jeus.tool.webadmin.locale.language", lang, "Forced Language");
                }
                waWebAppDesc.addServletDescriptor("webadmin", servletDesc);
                waWebAppDesc.addServletMapping("webadmin", "/app");
                File xsrs = new File(WEBHOME_DIR + "admin_home/WEB-INF/classes/jeus/tool/webadmin/resource/xsd");
                File[] jeus_system = xsrs.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().startsWith("jeus-system");
                    }
                });
                if (jeus_system != null) {
                    StringBuffer langs = new StringBuffer();
                    int length = jeus_system.length;
                    for (int i = 0; i < length; ++i) {
                        String name = jeus_system[i].getName();
                        if (name.lastIndexOf(95) == -1) continue;
                        String language = name.substring(name.lastIndexOf(95) + 1, name.lastIndexOf(46));
                        langs.append(language);
                        if (i + 1 >= length) continue;
                        langs.append(",");
                    }
                    servletDesc.addInitParam("org.apache.tapestry.accepted-locales", langs.toString(), "accepted-locales");
                }
                if ((helpDirs = (onlineHelpDir = new File(WEBHOME_DIR + "admin_home/online-help")).listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) != null) {
                    StringBuffer supportedHelp = new StringBuffer();
                    int length = helpDirs.length;
                    for (int i = 0; i < length; ++i) {
                        supportedHelp.append(helpDirs[i].getName());
                        if (i + 1 >= length) continue;
                        supportedHelp.append(",");
                    }
                    servletDesc.addInitParam("jeus.tool.webadmin.supported-help-locales", supportedHelp.toString(), "supported-help-locales");
                }
                FilterDef filter = new FilterDef();
                filter.setFilterName("redirect");
                filter.setFilterClass("org.apache.tapestry.RedirectFilter");
                waWebAppDesc.addFilterDef("redirect", filter);
                waWebAppDesc.addFilterMapping("redirect", "/*", true, null);
                ServletDescriptor servletDesc2 = new ServletDescriptor("login", "jeus.tool.webadmin.WebAdminLoginServlet", "1");
                waWebAppDesc.addServletDescriptor("login", servletDesc2);
                waWebAppDesc.addServletMapping("login", "/login");
                ServletDescriptor servletDesc3 = new ServletDescriptor("Monitoring", "org.jfree.chart.servlet.DisplayChart", "1");
                waWebAppDesc.addServletDescriptor("Monitoring", servletDesc3);
                waWebAppDesc.addServletMapping("Monitoring", "/monitoring");
                waWebAppDesc.setSessionTimeout(System.getProperty("jeus.webadmin.session_timeout", "30"));
                waWebAppDesc.setMimeMappings("txt", "text/plain");
                waWebAppDesc.setMimeMappings("htm", "text/html");
                waWebAppDesc.setMimeMappings("html", "text/html");
                waWebAppDesc.setMimeMappings("css", "text/css");
                waWebAppDesc.setMimeMappings("js", "text/plain");
                waWebAppDesc.setMimeMappings("gif", "image/gif");
                waWebAppDesc.setMimeMappings("jpg", "image/jpeg");
                waWebAppDesc.setMimeMappings("png", "image/png");
                waWebAppDesc.setMimeMappings("jnlp", "application/x-java-jnlp-file");
                waWebAppDesc.setSystemApp(true);
                waCtxDesc.setWebAppDescriptor(waWebAppDesc);
                grpDesc.addContextDescriptorToDefaultVHostDesc(waCtxDesc);
            }
            ThreadPoolDescriptor tpool = new ThreadPoolDescriptor();
            tpool.setMinThreadNum(MIN_THREAD_NUM);
            tpool.setMaxThreadNum(MAX_THREAD_NUM);
            ConnectionDescriptor connectionDesc = new ConnectionDescriptor();
            connectionDesc.setListenerType("HttpListener");
            connectionDesc.setListenerId("webadmin-http-listener");
            connectionDesc.setPort(CONNECTION_PORT);
            if (this.allowedServer.size() > 0) {
                connectionDesc.setAccessControl("true");
                connectionDesc.setAllowedServer(this.allowedServer);
            }
            connectionDesc.setThreadPoolDescriptor(tpool);
            connectionDesc.setReadTimeout("30000");
            connectionDesc.setPostdataReadTimeout("30000");
            connectionDesc.setMaxKeepAliveRequests(100);
            connectionDesc.setIsKeepAlive(false);
            grpDesc.addConnectionDescriptor(connectionDesc.getWebServerAddress() + ":" + CONNECTION_PORT, connectionDesc);
            try {
                this.webContainerDesc.addContextGroupDescriptor(contextGroupName, grpDesc);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_WebContainer0._1010_LEVEL)) break block27;
                logger.log(JeusMessage_WebContainer0._1010_LEVEL, JeusMessage_WebContainer0._1010, (Object)contextGroupName, (Throwable)e);
            }
        }
        this.webContainerDesc.setRedirectStdOut("false");
        this.webContainerDesc.setRedirectStdErr("false");
        this.webContainerDesc.setSecuritySwitch(true);
        this.webContainerDesc.setShutdownTimeout("0");
    }

    public WebContainerControl getController() {
        return this.containerManager.getController();
    }
}

