/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.tcp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.Cookie;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.tcp.TCPDispatcherConfig;

public abstract class TCPServletRequest
extends HttpServletRequestImpl {
    public static final String TCP_SERVLET_METHOD = "GET";
    public static final String TCP_SERVLET_PROTOCOL = "HTTP/0.9";
    private static final String TCP_SERVLET_CONTENT_TYPE = "text/plain";
    protected TCPDispatcherConfig config;
    protected byte[] header;
    protected byte[] body;

    protected TCPServletRequest(ContextGroup ctxGroup, ThreadPoolManager manager, TCPDispatcherConfig config) {
        super(ctxGroup, manager);
        this.config = config;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getBody() throws IOException {
        if (this.body != null) {
            return this.body;
        }
        if (this.contentLength <= 0) {
            return null;
        }
        this.body = new byte[this.contentLength];
        this.in.readFully(this.body, 0, this.body.length);
        return this.body;
    }

    public String getCharacterEncoding() {
        if (this.userPostdataEncoding != null) {
            return this.userPostdataEncoding;
        }
        if (this.forcedRequestEncoding != null) {
            return this.forcedRequestEncoding;
        }
        if (this.defaultRequestEncoding != null) {
            return this.defaultRequestEncoding;
        }
        return "ISO-8859-1";
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        this.contentType = TCP_SERVLET_CONTENT_TYPE;
        return this.contentType;
    }

    public String getParameter(String name) {
        return null;
    }

    public Map getParameterMap() {
        return (Map)this.parameters.clone();
    }

    public String[] getParameterValues(String name) {
        return new String[0];
    }

    public boolean isSecure() {
        return false;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }
}

