/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public class StandardQueue {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet");
    private static final int INFINITE_BLOCKING_PUT_MODE = 1;
    private static final int FINITE_BLOCKING_PUT_MODE = 2;
    private static final int NON_BLOCKING_PUT_MODE = 3;
    private BlockingQueue queue;
    private AtomicBoolean running = new AtomicBoolean(false);
    private int putMode;
    private int maxWaitQueue;
    private long putTimeout;
    private ThreadPoolManager poolManager;

    public StandardQueue(ThreadPoolManager manager) {
        this(manager, -1);
    }

    public StandardQueue(ThreadPoolManager manager, int capacity) {
        this.running.set(true);
        this.putMode = 1;
        this.putTimeout = 30000L;
        this.poolManager = manager;
        if (capacity <= 0) {
            this.queue = new LinkedBlockingQueue();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, this.queue.getClass() + " is created(capacity=unlimited)");
            }
        } else {
            this.queue = new LinkedBlockingQueue(capacity);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, this.queue.getClass() + " is created(capacity=" + capacity + ")");
            }
        }
    }

    public Socket get() throws InterruptedException {
        if (!this.running.get()) {
            return null;
        }
        return (Socket)this.queue.take();
    }

    public void put(Socket socket) {
        if (socket == null) {
            return;
        }
        if (this.running.get()) {
            try {
                switch (this.putMode) {
                    case 1: {
                        this.queue.put(socket);
                        break;
                    }
                    case 2: {
                        if (!this.queue.offer(socket, this.putTimeout, TimeUnit.MILLISECONDS)) {
                            if (logger.isLoggable(JeusMessage_WebContainer10._10419_LEVEL)) {
                                logger.log(JeusMessage_WebContainer10._10419_LEVEL, JeusMessage_WebContainer10._10419, new Object[]{this.putTimeout, socket});
                            }
                            try {
                                socket.close();
                            }
                            catch (IOException e) {}
                        }
                        break;
                    }
                    case 3: {
                        if (!this.queue.offer(socket)) {
                            if (logger.isLoggable(JeusMessage_WebContainer10._10420_LEVEL)) {
                                logger.log(JeusMessage_WebContainer10._10420_LEVEL, JeusMessage_WebContainer10._10420, (Object)socket);
                            }
                            try {
                                socket.close();
                            }
                            catch (IOException e) {}
                        }
                        break;
                    }
                    default: {
                        this.queue.put(socket);
                        break;
                    }
                }
            }
            catch (InterruptedException ie) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10421_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10421_LEVEL, JeusMessage_WebContainer10._10421, (Object)socket, (Throwable)ie);
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            if (logger.isLoggable(JeusMessage_WebContainer10._10422_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10422_LEVEL, JeusMessage_WebContainer10._10422, (Object)socket);
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.checkMaxWaitQueue();
    }

    private void checkMaxWaitQueue() {
        if (this.queue.size() > this.maxWaitQueue) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "the queue size exceeds max-wait-queue size(" + this.maxWaitQueue + "). so we will check threads");
            }
            this.poolManager.createThreads();
        }
    }

    public void destroy() {
        Socket socket;
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        do {
            if ((socket = (Socket)this.queue.poll()) == null) continue;
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (socket != null);
    }

    public void setMaxWaitQueueSize(int maxWaitQueue) {
        this.maxWaitQueue = maxWaitQueue >= 1 ? maxWaitQueue : 0;
    }

    public void setMaxQueueSize(int capacity) {
    }

    public int getWaitQueueCount() {
        return this.queue.size();
    }
}

