/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager;

import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import jeus.servlet.deployment.descriptor.SessionCookieDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.listener.ListenerManager;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.sessionmanager.AbstractSessionConfig;
import jeus.sessionmanager.Router;
import jeus.sessionmanager.SessionActivationListener;
import jeus.sessionmanager.SessionAttributeListener;
import jeus.sessionmanager.SessionListener;
import jeus.sessionmanager.WebRouterConfig;
import jeus.sessionmanager.WebSessionConfig;

public class WebSessionConfigImpl
extends AbstractSessionConfig
implements WebSessionConfig,
WebRouterConfig {
    private HttpSessionListener[] sessionListeners;
    private HttpSessionAttributeListener[] attributeListeners;
    private HttpSessionActivationListener[] activationListeners;

    public WebSessionConfigImpl() {
        this(null);
    }

    public WebSessionConfigImpl(Router router) {
        super(router);
        if (this.sessionListeners == null) {
            this.sessionListeners = new HttpSessionListener[0];
        }
        if (this.attributeListeners == null) {
            this.attributeListeners = new HttpSessionAttributeListener[0];
        }
        if (this.activationListeners == null) {
            this.activationListeners = new HttpSessionActivationListener[0];
        }
    }

    public ServletContext getServletContext() {
        return WebAppContextSwitch.getCurrentWebContext();
    }

    public HttpSessionListener[] getSessionListeners() {
        return this.sessionListeners;
    }

    public HttpSessionAttributeListener[] getAttributeListeners() {
        return this.attributeListeners;
    }

    public HttpSessionActivationListener[] getActivationListeners() {
        return this.activationListeners;
    }

    public SessionListener getPostCreationListenerSupport() {
        return this.getCurrentContextListenerSupport();
    }

    public SessionListener getPreDestructionListenerSupport() {
        return this.getCurrentContextListenerSupport();
    }

    public SessionActivationListener getPostActivationListenerSupport() {
        return this.getCurrentContextListenerSupport();
    }

    public SessionActivationListener getPrePassivationListenerSupport() {
        return this.getCurrentContextListenerSupport();
    }

    public SessionAttributeListener getAttributeListenerSupport() {
        return this.getCurrentContextListenerSupport();
    }

    public String getSessionCookieName(HttpServletRequest request) {
        return WebSessionConfigImpl.getJeusCookieJSessionIdName(request);
    }

    public String getSessionUrlParamName(HttpServletRequest request) {
        return "jsessionid";
    }

    public String getSessionCookiePath(HttpServletRequest request) {
        return WebSessionConfigImpl.getJeusCookiePath(request);
    }

    public String getSessionCookieDomain(HttpServletRequest request) {
        return WebSessionConfigImpl.getJeusCookieDomain(request);
    }

    public int getSessionCookieVersion(HttpServletRequest request) {
        return WebSessionConfigImpl.getJeusCookieVersion(request);
    }

    public int getSessionCookieMaxAge(HttpServletRequest request) {
        return WebSessionConfigImpl.getJeusCookieMaxAge(request);
    }

    public boolean isSessionCookieSecure(HttpServletRequest request) {
        return WebSessionConfigImpl.isJeusCookieSecure(request);
    }

    public static Cookie getJeusJSessionIdCookie(HttpServletRequest request, String sessionId) {
        String domain;
        Cookie jsessionIdCookie = new Cookie(WebSessionConfigImpl.getJeusCookieJSessionIdName(request), sessionId);
        jsessionIdCookie.setVersion(WebSessionConfigImpl.getJeusCookieVersion(request));
        jsessionIdCookie.setMaxAge(WebSessionConfigImpl.getJeusCookieMaxAge(request));
        jsessionIdCookie.setSecure(WebSessionConfigImpl.isJeusCookieSecure(request));
        String path = WebSessionConfigImpl.getJeusCookiePath(request);
        if (path != null && path.length() > 0) {
            jsessionIdCookie.setPath(path);
        }
        if ((domain = WebSessionConfigImpl.getJeusCookieDomain(request)) != null && domain.length() > 0) {
            jsessionIdCookie.setDomain(domain);
        }
        return jsessionIdCookie;
    }

    public static String getJeusCookieJSessionIdName(HttpServletRequest request) {
        Context jeusContext = WebSessionConfigImpl.getJeusContext(request);
        if (jeusContext == null) {
            return "JSESSIONID";
        }
        SessionCookieDescriptor sessionCookieDesc = jeusContext.getSessionCookieDescriptor();
        if (sessionCookieDesc == null) {
            return "JSESSIONID";
        }
        return sessionCookieDesc.getJsessionidName();
    }

    private static int getJeusCookieVersion(HttpServletRequest request) {
        Context jeusContext = WebSessionConfigImpl.getJeusContext(request);
        if (jeusContext == null) {
            return 0;
        }
        SessionCookieDescriptor sessionCookieDesc = jeusContext.getSessionCookieDescriptor();
        if (sessionCookieDesc == null) {
            return 0;
        }
        return sessionCookieDesc.getVersion();
    }

    private static String getJeusCookieDomain(HttpServletRequest request) {
        Context jeusContext = WebSessionConfigImpl.getJeusContext(request);
        if (jeusContext == null) {
            return SessionCookieDescriptor.DEFAULT_DOMAIN;
        }
        SessionCookieDescriptor sessionCookieDesc = jeusContext.getSessionCookieDescriptor();
        if (sessionCookieDesc == null) {
            return SessionCookieDescriptor.DEFAULT_DOMAIN;
        }
        return sessionCookieDesc.getDomain();
    }

    private static String getJeusCookiePath(HttpServletRequest request) {
        Context jeusContext = WebSessionConfigImpl.getJeusContext(request);
        if (jeusContext == null) {
            return "/";
        }
        if (jeusContext.isSessionShared()) {
            return "/";
        }
        String cookiePath = null;
        if (jeusContext.getSessionCookieDescriptor() != null) {
            cookiePath = jeusContext.getSessionCookieDescriptor().getPath();
        }
        if (cookiePath == null) {
            cookiePath = jeusContext.getContextPath();
        }
        return cookiePath;
    }

    private static int getJeusCookieMaxAge(HttpServletRequest request) {
        Context jeusContext = WebSessionConfigImpl.getJeusContext(request);
        if (jeusContext == null) {
            return -1;
        }
        SessionCookieDescriptor sessionCookieDesc = jeusContext.getSessionCookieDescriptor();
        if (sessionCookieDesc == null) {
            return -1;
        }
        return sessionCookieDesc.getMaxAge();
    }

    private static boolean isJeusCookieSecure(HttpServletRequest request) {
        Context jeusContext = WebSessionConfigImpl.getJeusContext(request);
        if (jeusContext == null) {
            return false;
        }
        SessionCookieDescriptor sessionCookieDesc = jeusContext.getSessionCookieDescriptor();
        if (sessionCookieDesc == null) {
            return false;
        }
        return sessionCookieDesc.isSecure();
    }

    private static Context getJeusContext(HttpServletRequest request) {
        Context jeusContext = null;
        if (request instanceof HttpServletRequestImpl) {
            HttpServletRequestImpl jeusRequest = (HttpServletRequestImpl)request;
            jeusContext = jeusRequest.getContext();
        } else {
            jeusContext = WebAppContextSwitch.getCurrentWebContext();
        }
        return jeusContext;
    }

    private ListenerManager getCurrentContextListenerSupport() {
        Context jeusContext = WebAppContextSwitch.getCurrentWebContext();
        if (jeusContext == null) {
            return null;
        }
        return jeusContext.getListenerManager();
    }
}

