/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.j2ee.statistics.Stats;
import jeus.descriptor.jeusserver.SessionServerDescriptor;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.server.service.SessionServerStatsImpl;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.SessionManager;
import jeus.sessionmanager.central.SessionManagerImpl;
import jeus.sessionmanager.central.SessionServerException;
import jeus.sessionmanager.central.network.SessionServerAcceptor;
import jeus.util.JeusPort;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class CentralSessionServer {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private static Hashtable sessionMans = new Hashtable();
    private SessionManager sessionManager;
    private SessionServerAcceptor acceptor;
    private ScheduledThreadPoolExecutor checkServerExecutor;
    private Future checkServerFuture;
    private long resolution;

    public CentralSessionServer(SessionServerDescriptor desc) throws SessionServerException {
        this.resolution = desc.getResolution();
        this.sessionManager = new SessionManagerImpl(desc);
        sessionMans.put(desc.getServerName(), this.sessionManager);
        this.checkServerExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "CentralSessionServer-CheckServerTimer");
                t.setDaemon(true);
                return t;
            }
        });
        this.acceptor = new SessionServerAcceptor(desc.getPoolMin(), desc.getPoolMax(), desc.getPoolPeriod(), desc.isUseNio());
    }

    public void export(String hostname, J2EEManagedObject mbean) throws SessionServerException {
        try {
            this.acceptor.init(hostname, JeusPort.SessionServer, mbean);
            this.sessionManager.export(hostname + ":" + JeusPort.JeusBase, mbean);
            this.checkServerFuture = this.checkServerExecutor.scheduleAtFixedRate(new CheckServerTimer(), 1L, this.resolution, TimeUnit.MILLISECONDS);
            if (logger.isLoggable(JeusMessage_Session2._21015_LEVEL)) {
                logger.log(JeusMessage_Session2._21015_LEVEL, JeusMessage_Session2._21015);
            }
        }
        catch (Throwable ex) {
            throw new SessionServerException(JeusMessage_Session2._21016, ex);
        }
    }

    public void unexport() {
        block6: {
            try {
                block5: {
                    if (this.checkServerFuture != null) {
                        this.checkServerFuture.cancel(true);
                        this.checkServerFuture = null;
                    }
                    try {
                        this.sessionManager.unexport();
                    }
                    catch (Throwable ex) {
                        if (!logger.isLoggable(JeusMessage_Session2._21017_LEVEL)) break block5;
                        logger.log(JeusMessage_Session2._21017_LEVEL, JeusMessage_Session2._21017, ex);
                    }
                }
                sessionMans.clear();
                this.acceptor.destroy();
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_Session2._21018_LEVEL)) break block6;
                logger.log(JeusMessage_Session2._21018_LEVEL, JeusMessage_Session2._21018, ex);
            }
        }
    }

    public Stats updateStats(SessionServerStatsImpl stats) {
        int size = 0;
        if (this.acceptor != null) {
            size += this.acceptor.getHandlers().size();
        }
        ((CountStatisticImpl)stats.getConnectionCount()).setValue((long)size);
        return stats;
    }

    public List getHandlerNames() {
        ArrayList ret = new ArrayList();
        if (this.acceptor != null) {
            Hashtable list = this.acceptor.getHandlers();
            Enumeration enum1 = list.keys();
            while (enum1.hasMoreElements()) {
                ret.add(enum1.nextElement());
            }
        }
        return ret;
    }

    public static SessionManager getSessionManager(String smName) {
        if (smName == null) {
            return null;
        }
        return (SessionManager)sessionMans.get(smName);
    }

    private class CheckServerTimer
    implements Runnable {
        private CheckServerTimer() {
        }

        public void run() {
            block2: {
                try {
                    CentralSessionServer.this.sessionManager.checkSession();
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_Session2._21019_LEVEL)) break block2;
                    logger.log(JeusMessage_Session2._21019_LEVEL, JeusMessage_Session2._21019, ex);
                }
            }
        }
    }
}

