/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jeus.servlet.connector.pipeline.JeusWebThreadFactory;
import jeus.sessionmanager.central.Entry;

public class SessionStatistic {
    private boolean started = false;
    private ScheduledThreadPoolExecutor countAverageExecutor;
    private Statistic lastMinuteStat = new Statistic(60);
    private Statistic lastFiveMinuteStat = new Statistic(300);
    private Statistic lastFifteenMinuteStat = new Statistic(900);
    private static final Integer SECONDS_1MINUTE = new Integer(60);
    private static final Integer SECONDS_5MINUTE = new Integer(300);
    private static final Integer SECONDS_15MINUTE = new Integer(900);
    private ConcurrentHashMap stats = new ConcurrentHashMap();
    private Future[] futures = new Future[3];
    private AtomicLong totalSessionMemory = new AtomicLong();
    private long sessionPeakMemory;

    public SessionStatistic(int port, String threadPrefix) {
        this.countAverageExecutor = new ScheduledThreadPoolExecutor(3, new JeusWebThreadFactory("SessionStat", port, 5, threadPrefix));
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.futures[0] = this.countAverageExecutor.scheduleAtFixedRate(this.lastMinuteStat, 1L, this.lastMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.futures[1] = this.countAverageExecutor.scheduleAtFixedRate(this.lastFiveMinuteStat, 1L, this.lastFiveMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.futures[2] = this.countAverageExecutor.scheduleAtFixedRate(this.lastFifteenMinuteStat, 1L, this.lastFifteenMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.stats.put(this.lastMinuteStat.getSecondsInt(), this.lastMinuteStat);
        this.stats.put(this.lastFiveMinuteStat.getSecondsInt(), this.lastFiveMinuteStat);
        this.stats.put(this.lastFifteenMinuteStat.getSecondsInt(), this.lastFifteenMinuteStat);
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        for (int i = 0; i < this.futures.length; ++i) {
            this.futures[i].cancel(true);
        }
        this.stats.clear();
        this.started = false;
    }

    public void finish() {
    }

    public boolean gather(Entry removeSession, Entry addSession) {
        int addSize = 0;
        if (addSession != null) {
            addSize = addSession.getSize();
        }
        if (addSize > 0) {
            this.totalSessionMemory.addAndGet(addSize);
        }
        int removeSize = 0;
        if (removeSession != null) {
            removeSize = removeSession.getSize();
        }
        if (removeSize > 0) {
            this.totalSessionMemory.addAndGet(-removeSize);
        }
        if (this.totalSessionMemory.get() > this.sessionPeakMemory) {
            this.sessionPeakMemory = this.totalSessionMemory.get();
        }
        return true;
    }

    public long getMemory1MinuteDifference() {
        return this.getMemoryDifference(SECONDS_1MINUTE);
    }

    public long getMemory5MinuteDifference() {
        return this.getMemoryDifference(SECONDS_5MINUTE);
    }

    public long getMemory15MinuteDifference() {
        return this.getMemoryDifference(SECONDS_15MINUTE);
    }

    private long getMemoryDifference(Integer seconds) {
        Statistic stat = null;
        Object obj = this.stats.get(seconds);
        if (obj instanceof Statistic) {
            stat = (Statistic)obj;
        }
        return stat == null ? 0L : stat.difference();
    }

    public long getTotalSessionMemory() {
        return this.totalSessionMemory.get();
    }

    public long getSessionPeakMemory() {
        return this.sessionPeakMemory;
    }

    public String toString() {
        return null;
    }

    class Statistic
    implements Runnable {
        long lastSize = 0L;
        long difference = 0L;
        int seconds;
        Integer secondsInt;

        public Statistic(int seconds) {
            this.seconds = seconds;
            this.secondsInt = new Integer(seconds);
        }

        public void run() {
            long total = SessionStatistic.this.totalSessionMemory.get();
            this.difference = total - this.lastSize;
            this.lastSize = total;
        }

        public long difference() {
            return this.difference;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public Integer getSecondsInt() {
            if (this.secondsInt == null) {
                this.secondsInt = new Integer(this.seconds);
            }
            return this.secondsInt;
        }
    }
}

