/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central.network;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.JeusSSLConfiguration;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.CentralConstants;
import jeus.sessionmanager.central.network.ServiceHandler;
import jeus.sessionmanager.central.network.SessionManagerAcceptorConnectionListener;
import jeus.util.JeusPort;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class SessionServerAcceptor
implements ConnectionListenerFactory {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private boolean running = true;
    private Hashtable serviceHandlers = new Hashtable();
    private int counter = 0;
    private Endpoint endpoint = null;
    protected static final Object[] connectPiggybackData = new Object[0];
    NodeInfo nodeInfo = null;
    private static final String THREAD_NAME_PREFIX = "SessionManagerAcceptor";
    private int threadPoolMinSize = 2;
    private int threadPoolMaxSize = 5;
    private long threadPoolResizePeriod = 3600000L;
    boolean isNonBlocking = true;
    private boolean isSSL = CentralConstants.SESSION_GLOBAL_USE_SSL;
    private static ThreadPoolExecutor pooledExecutor;
    private ServiceHandler serviceHandler = null;

    public SessionServerAcceptor(int threadPoolMinSize, int threadPoolMaxSize, long threadPoolResizePeriod, boolean isNio) {
        this.threadPoolMinSize = threadPoolMinSize;
        this.threadPoolMaxSize = threadPoolMaxSize;
        this.threadPoolResizePeriod = threadPoolResizePeriod;
        this.isNonBlocking = isNio;
    }

    public Hashtable getHandlers() {
        return this.serviceHandlers;
    }

    public void init(String hostname, int virtualPort, J2EEManagedObject parent) throws IOException, InstanceAlreadyExistsException {
        this.serviceHandler = new ServiceHandler(this);
        pooledExecutor = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)this.threadPoolMaxSize, (int)this.threadPoolMinSize, (long)this.threadPoolResizePeriod);
        String name = THREAD_NAME_PREFIX;
        this.nodeInfo = this.isSSL ? new NodeInfo(hostname, virtualPort) : new NodeInfo(hostname, JeusPort.JeusBase, String.valueOf(virtualPort));
        this.endpoint = new Endpoint(name, this.isNonBlocking ? JeusIOComponentCreator.createNIOCreator((String)("IO-" + name), (int)CentralConstants.WRITE_BUFFER_LIMIT_BYTE, (int)CentralConstants.WRITE_BUFFER_RESTART_BYTE) : JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)0), (SocketID)this.nodeInfo, (StreamContentHandlerCreator)new ContentHandlerCreator(), (ConnectionListenerFactory)this, (Object)(this.isSSL ? JeusSSLConfiguration.sslContext : null));
        this.endpoint.export();
        this.running = true;
    }

    public void destroy() {
        this.running = false;
        if (this.serviceHandlers != null) {
            this.serviceHandlers.clear();
            this.serviceHandlers = null;
        }
        if (this.endpoint != null) {
            this.nodeInfo = null;
            this.endpoint.unexport();
            this.endpoint = null;
        }
        if (this.serviceHandler != null) {
            this.serviceHandler.destroy();
            this.serviceHandler = null;
        }
        if (pooledExecutor != null) {
            pooledExecutor.shutdownNow();
            pooledExecutor = null;
        }
    }

    public void handle(Object message, SocketStream sockStream) {
        if (!this.running) {
            return;
        }
        if (message == null || !(message instanceof byte[]) || sockStream == null) {
            if (logger.isLoggable(JeusMessage_Session2._22081_LEVEL)) {
                logger.log(JeusMessage_Session2._22081_LEVEL, JeusMessage_Session2._22081, (Throwable)new Exception("failed to handle a message"));
            }
            return;
        }
        ++this.counter;
        if (this.counter > 65535) {
            this.counter = 0;
        }
        String handlerId = "ServiceHandler-" + this.counter;
        this.serviceHandlers.put(handlerId, handlerId);
        this.serviceHandler.receivePacket((byte[])message, sockStream, handlerId);
    }

    public void removeHandler(String name) {
        if (this.serviceHandlers != null) {
            this.serviceHandlers.remove(name);
        }
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new SessionManagerAcceptorConnectionListener(this, (Executor)pooledExecutor, this.serviceHandler);
    }
}

