/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jeus.sessionmanager.distributed.ManagerInfo;

public class BackupSelector {
    private final ConcurrentHashMap BACKUP_TABLE = new ConcurrentHashMap();

    public String getBackupEngine(String primaryEngine) {
        if (primaryEngine == null) {
            return null;
        }
        return (String)this.BACKUP_TABLE.get(primaryEngine);
    }

    public void makeupBackupTable(List managerInfos) {
        if (managerInfos == null) {
            return;
        }
        Object[] objs = managerInfos.toArray();
        Arrays.sort(objs);
        ArrayList<Object> sortedManagerInfos = new ArrayList<Object>();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof ManagerInfo)) continue;
            sortedManagerInfos.add(objs[i]);
        }
        this.BACKUP_TABLE.clear();
        for (Object e : sortedManagerInfos) {
            ManagerInfo managerInfo = (ManagerInfo)e;
            ManagerInfo backupManagerInfo = this.chooseBackupManager(managerInfo, sortedManagerInfos);
            if (backupManagerInfo == null) continue;
            backupManagerInfo.increaseCount();
            this.BACKUP_TABLE.put(managerInfo.getEngine(), backupManagerInfo.getEngine());
        }
        sortedManagerInfos.clear();
        objs = null;
    }

    private ManagerInfo chooseBackupManager(ManagerInfo myManagerInfo, List managerInfos) {
        ManagerInfo backupManagerInfo = null;
        boolean reverse = false;
        String replicationGroup = myManagerInfo.getReplicationGroup();
        String preferredGroup = myManagerInfo.getPreferredBackupGroup();
        if (preferredGroup == null && replicationGroup != null) {
            reverse = true;
            preferredGroup = replicationGroup;
        } else {
            reverse = false;
        }
        ArrayList<ManagerInfo> matchPreferredGroup = new ArrayList<ManagerInfo>();
        ArrayList<ManagerInfo> notMatchPreferredGroup = new ArrayList<ManagerInfo>();
        for (ManagerInfo managerInfo : managerInfos) {
            if (myManagerInfo == managerInfo) continue;
            if (preferredGroup == null || !preferredGroup.equals(managerInfo.getReplicationGroup())) {
                if (!reverse) {
                    notMatchPreferredGroup.add(managerInfo);
                    continue;
                }
                matchPreferredGroup.add(managerInfo);
                continue;
            }
            if (!reverse) {
                matchPreferredGroup.add(managerInfo);
                continue;
            }
            notMatchPreferredGroup.add(managerInfo);
        }
        backupManagerInfo = this.chooseBackupManagerWithMachine(myManagerInfo, matchPreferredGroup);
        if (backupManagerInfo == null) {
            backupManagerInfo = this.chooseBackupManagerWithMachine(myManagerInfo, notMatchPreferredGroup);
        }
        return backupManagerInfo;
    }

    private ManagerInfo chooseBackupManagerWithMachine(ManagerInfo myManagerInfo, List managerInfos) {
        ManagerInfo backupManagerInfo = null;
        String machine = myManagerInfo.getMachine();
        ArrayList<ManagerInfo> matchMachine = new ArrayList<ManagerInfo>();
        ArrayList<ManagerInfo> notMatchMachine = new ArrayList<ManagerInfo>();
        for (ManagerInfo managerInfo : managerInfos) {
            if (machine == null || !machine.equals(managerInfo.getMachine())) {
                notMatchMachine.add(managerInfo);
                continue;
            }
            matchMachine.add(managerInfo);
        }
        backupManagerInfo = this.chooseBackupManagerWithCount(notMatchMachine);
        if (backupManagerInfo == null) {
            backupManagerInfo = this.chooseBackupManagerWithCount(matchMachine);
        }
        return backupManagerInfo;
    }

    private ManagerInfo chooseBackupManagerWithCount(List managerInfos) {
        ManagerInfo backupManagerInfo = null;
        for (ManagerInfo managerInfo : managerInfos) {
            if (backupManagerInfo != null && backupManagerInfo.getCount() <= managerInfo.getCount()) continue;
            backupManagerInfo = managerInfo;
        }
        return backupManagerInfo;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("\n    << session manager's backup table information >>\n");
        if (this.BACKUP_TABLE.size() != 0) {
            for (String key : this.BACKUP_TABLE.keySet()) {
                buffer.append("        - primary=").append(key).append(", backup=").append(this.BACKUP_TABLE.get(key)).append("\n");
            }
        } else {
            buffer.append("        no entry").append("\n");
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        BackupSelector backupSelector = new BackupSelector();
        backupSelector.makeupBackupTable(BackupSelector.loadTotalManagerInfosTest());
        System.out.println(backupSelector);
        backupSelector.makeupBackupTable(BackupSelector.loadSameGroupManagerInfosTest());
        System.out.println(backupSelector);
        backupSelector.makeupBackupTable(BackupSelector.loadSameMachineManagerInfosTest());
        System.out.println(backupSelector);
        backupSelector.makeupBackupTable(BackupSelector.loadNoPreferredGroupManagerInfosTest());
        System.out.println(backupSelector);
        backupSelector.makeupBackupTable(BackupSelector.loadJeusDefaultManagerInfosTest());
        System.out.println(backupSelector);
        backupSelector.makeupBackupTable(BackupSelector.loadNothingManagerInfosTest());
        System.out.println(backupSelector);
    }

    private static List loadTotalManagerInfosTest() {
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        managerInfos.add(new ManagerInfo("c", "2carryel2", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("b", "0carryel0", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("a", "0carryel0", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("x", "0carryel0", "crosstown", "headquarters"));
        managerInfos.add(new ManagerInfo("y", "2carryel2", "crosstown", "headquarters"));
        managerInfos.add(new ManagerInfo("z", "2carryel2", "crosstown", "headquarters"));
        return managerInfos;
    }

    private static List loadSameGroupManagerInfosTest() {
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        managerInfos.add(new ManagerInfo("a", "0carryel0", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("b", "0carryel0", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("c", "2carryel2", "headquarters", "crosstown"));
        return managerInfos;
    }

    private static List loadSameMachineManagerInfosTest() {
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        managerInfos.add(new ManagerInfo("a", "0carryel0", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("b", "0carryel0", "headquarters", "crosstown"));
        managerInfos.add(new ManagerInfo("x", "0carryel0", "crosstown", "headquarters"));
        return managerInfos;
    }

    private static List loadNoPreferredGroupManagerInfosTest() {
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        managerInfos.add(new ManagerInfo("a", "0carryel0", "headquarters", null));
        managerInfos.add(new ManagerInfo("b", "2carryel2", "headquarters", null));
        managerInfos.add(new ManagerInfo("x", "0carryel0", "crosstown", null));
        return managerInfos;
    }

    private static List loadJeusDefaultManagerInfosTest() {
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        managerInfos.add(new ManagerInfo("a", null, "node1", null));
        managerInfos.add(new ManagerInfo("b", null, "node1", null));
        managerInfos.add(new ManagerInfo("c", null, "node1", null));
        managerInfos.add(new ManagerInfo("x", null, "node3", null));
        managerInfos.add(new ManagerInfo("y", null, "node4", null));
        return managerInfos;
    }

    private static List loadNothingManagerInfosTest() {
        ArrayList<ManagerInfo> managerInfos = new ArrayList<ManagerInfo>();
        managerInfos.add(new ManagerInfo("a", null, null, null));
        managerInfos.add(new ManagerInfo("b", null, null, null));
        managerInfos.add(new ManagerInfo("c", null, null, null));
        managerInfos.add(new ManagerInfo("x", null, null, null));
        managerInfos.add(new ManagerInfo("y", null, null, null));
        return managerInfos;
    }
}

