/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.FileDBEntry;
import jeus.sessionmanager.session.ByteArraySession;
import jeus.sessionmanager.session.ByteArraySessionImpl;
import jeus.sessionmanager.util.SessionManagerUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;

final class FileDB {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private static final int INVALID_SESSION = -1;
    private String fileDBPath;
    private String fileDBName;
    private Map table = new ConcurrentHashMap();
    private RandomAccessFile DBfile;
    private File file1;
    private File file2;
    private int numHole = 0;
    private DistributedManagerConfig desc;
    private int trigger;

    public FileDB(String dbPath, String dbName, DistributedManagerConfig desc) throws IOException {
        this.fileDBPath = dbPath;
        this.fileDBName = dbName;
        this.desc = desc;
        this.makeDBFile();
    }

    public void destroy() {
        if (this.table != null) {
            this.table.clear();
        }
        if (this.DBfile != null) {
            try {
                this.DBfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void makeDBFile() throws IOException {
        String fileName = this.fileDBPath + File.separator + this.fileDBName + "_1" + ".fdb";
        this.file1 = new File(fileName);
        if (!this.file1.exists() && this.file1.getParent() != null) {
            new File(this.file1.getParent()).mkdirs();
        }
        fileName = this.fileDBPath + File.separator + this.fileDBName + "_2" + ".fdb";
        this.file2 = new File(fileName);
        if (!this.file2.exists() && this.file2.getParent() != null) {
            new File(this.file1.getParent()).mkdirs();
        }
        boolean doRecover = false;
        long file1Time = -1L;
        long file2Time = -1L;
        long tmout = this.desc.getFileStartupClearTo();
        if (tmout == 0L) {
            doRecover = false;
        } else if (tmout < 0L) {
            doRecover = true;
        } else {
            long curTime = System.currentTimeMillis();
            if (this.file1.exists() && this.file1.length() > 0L) {
                file1Time = this.file1.lastModified();
                file1Time = file1Time + tmout - curTime;
            }
            if (this.file2.exists() && this.file2.length() > 0L) {
                file2Time = this.file2.lastModified();
                file2Time = file2Time + tmout - curTime;
            }
            doRecover = file1Time > 0L || file2Time > 0L;
        }
        if (doRecover) {
            if (file1Time >= file2Time) {
                this.trigger = 1;
                this.DBfile = new RandomAccessFile(this.file1, "rw");
            } else {
                this.trigger = 2;
                this.DBfile = new RandomAccessFile(this.file2, "rw");
            }
            if (logger.isLoggable(JeusMessage_Session3._37027_LEVEL)) {
                logger.log(JeusMessage_Session3._37027_LEVEL, JeusMessage_Session3._37027, (Object[])new String[]{this.getDBFileName(), String.valueOf(this.DBfile.length())});
            }
        } else {
            this.file1.delete();
            this.file2.delete();
            this.trigger = 1;
            this.DBfile = new RandomAccessFile(this.file1, "rw");
        }
    }

    public int size() {
        return this.table.size();
    }

    public long fileSize() {
        long size = -1L;
        try {
            size = this.DBfile.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }

    private String getDBFileName() {
        File cfile = null;
        cfile = this.trigger == 1 ? this.file1 : this.file2;
        return cfile == null ? "null" : cfile.getAbsolutePath();
    }

    public synchronized byte[] load(FileDBEntry entry) throws IOException {
        byte[] obj = new byte[SessionManagerUtil.safeCasting(entry.length)];
        long originalPointer = this.DBfile.getFilePointer();
        this.DBfile.seek(entry.startAdd);
        this.DBfile.readFully(obj);
        this.DBfile.seek(originalPointer);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArraySession load(String key, boolean migrate) throws IOException {
        byte[] obj = null;
        FileDB fileDB = this;
        synchronized (fileDB) {
            FileDBEntry entry = (FileDBEntry)this.table.get(key);
            if (entry == null) {
                return null;
            }
            obj = new byte[SessionManagerUtil.safeCasting(entry.length)];
            long originalPointer = this.DBfile.getFilePointer();
            this.DBfile.seek(entry.startAdd);
            this.DBfile.readFully(obj);
            if (migrate) {
                this.table.remove(key);
                this.DBfile.seek(entry.startAdd + 4L);
                this.DBfile.writeInt(-1);
                ++this.numHole;
            }
            this.DBfile.seek(originalPointer);
        }
        ByteArraySessionImpl fileDBSession = new ByteArraySessionImpl();
        try {
            fileDBSession.readSession(obj);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
        return fileDBSession;
    }

    public synchronized void storeEntries(List entries, byte[] buf, int buflen) throws IOException {
        this.packing();
        long filePointer = this.DBfile.getFilePointer();
        this.DBfile.write(buf, 0, buflen);
        for (FileDBEntry entry : entries) {
            this.purge(entry.key);
            if (entry.length >= 0L) {
                entry.startAdd += filePointer;
                this.table.put(entry.key, entry);
                continue;
            }
            if (!logger.isLoggable(JeusMessage_Session3._37085_LEVEL)) continue;
            logger.log(JeusMessage_Session3._37085_LEVEL, JeusMessage_Session3._37085, (Object)entry.key);
        }
    }

    public synchronized void storeEntry(FileDBEntry entry, byte[] buf, int buflen) throws IOException {
        this.packing();
        long filePointer = this.DBfile.getFilePointer();
        this.DBfile.write(buf, 0, buflen);
        this.purge(entry.key);
        if (entry.length >= 0L) {
            entry.startAdd += filePointer;
            this.table.put(entry.key, entry);
        } else if (logger.isLoggable(JeusMessage_Session3._37085_LEVEL)) {
            logger.log(JeusMessage_Session3._37085_LEVEL, JeusMessage_Session3._37085, (Object)entry.key);
        }
    }

    public synchronized boolean purge(Object key) throws IOException {
        FileDBEntry entry = (FileDBEntry)this.table.remove(key);
        if (entry == null) {
            return false;
        }
        ++this.numHole;
        long filePointer = this.DBfile.getFilePointer();
        this.DBfile.seek(entry.startAdd + 4L);
        this.DBfile.writeInt(-1);
        this.DBfile.seek(filePointer);
        return true;
    }

    public synchronized void packing() throws IOException {
        int minHole = this.desc.getFileMinHole();
        float packingRate = this.desc.getFilePackingRate();
        if (this.numHole <= minHole || (float)this.numHole / (float)this.table.size() < packingRate) {
            return;
        }
        RandomAccessFile newDBfile = this.trigger == 1 ? new RandomAccessFile(this.file2, "rw") : new RandomAccessFile(this.file1, "rw");
        for (FileDBEntry entry : this.table.values()) {
            byte[] buffer = new byte[SessionManagerUtil.safeCasting(entry.length)];
            this.DBfile.seek(entry.startAdd);
            this.DBfile.readFully(buffer);
            entry.startAdd = newDBfile.getFilePointer();
            newDBfile.write(buffer);
        }
        this.DBfile.setLength(0L);
        this.DBfile.close();
        this.DBfile = newDBfile;
        this.trigger = this.trigger == 1 ? 2 : 1;
        this.numHole = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void recover() {
        try {
            if (this.DBfile.length() <= 0L) {
                return;
            }
        }
        catch (IOException ioe) {
            return;
        }
        try {
            long length = this.DBfile.length();
            if (length <= 0L) {
                return;
            }
            if (logger.isLoggable(JeusMessage_Session3._37028_LEVEL)) {
                logger.log(JeusMessage_Session3._37028_LEVEL, JeusMessage_Session3._37028, (Object)this.DBfile.toString());
            }
            while (true) {
                int skip;
                FileDBEntry entry;
                long ptr = this.DBfile.getFilePointer();
                int count = 0;
                if (ptr >= length) break;
                int slen = this.DBfile.readInt();
                count += 4;
                if (slen <= 0) {
                    throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37029, (Object[])new String[]{this.getDBFileName(), String.valueOf(slen)}));
                }
                int idlen = this.DBfile.readInt();
                count += 4;
                if (idlen <= 0) {
                    this.DBfile.seek(ptr + (long)slen);
                    continue;
                }
                byte[] sid = new byte[idlen];
                this.DBfile.readFully(sid);
                String sessionId = new String(sid);
                boolean valid = true;
                if ((count += idlen) < slen) {
                    long thisAccessTime = this.DBfile.readLong();
                    count += 8;
                    this.DBfile.readLong();
                    count += 8;
                    int inactiveIntval = this.DBfile.readInt();
                    count += 4;
                    long intervalInSec = (System.currentTimeMillis() - thisAccessTime) / 1000L;
                    int thisInterval = SessionManagerUtil.safeCasting(intervalInSec);
                    if (thisInterval > inactiveIntval) {
                        valid = false;
                        ++this.numHole;
                        if (logger.isLoggable(JeusMessage_Session3._37095_LEVEL)) {
                            logger.log(JeusMessage_Session3._37095_LEVEL, JeusMessage_Session3._37095, (Object)sessionId);
                        }
                    }
                }
                if (valid && this.table.put(sessionId, entry = new FileDBEntry(sessionId, ptr, slen)) != null) {
                    ++this.numHole;
                }
                if ((skip = slen - count) != this.DBfile.skipBytes(skip)) throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37032, (Object)this.getDBFileName()));
            }
        }
        catch (IOException ioe) {
            this.table.clear();
            try {
                this.DBfile.setLength(0L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_Session3._37034_LEVEL)) {
                logger.log(JeusMessage_Session3._37034_LEVEL, JeusMessage_Session3._37034, (Throwable)ioe);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Session3._37900_LEVEL)) {
                logger.log(JeusMessage_Session3._37900_LEVEL, JeusMessage_Session3._37900, t);
            }
            this.copyFileDB();
            this.table.clear();
            try {
                this.DBfile.setLength(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!logger.isLoggable(JeusMessage_Session3._37033_LEVEL)) return;
        logger.log(JeusMessage_Session3._37033_LEVEL, JeusMessage_Session3._37033, (Object[])new String[]{this.getDBFileName(), String.valueOf(this.table.size()), String.valueOf(this.numHole)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileDB() {
        int BUFFER_SIZE = 2048;
        FileOutputStream fos = null;
        String badFileName = this.fileDBPath + File.separator + this.fileDBName + "-" + System.currentTimeMillis() + ".fdb";
        byte[] tempBuffer = new byte[2048];
        try {
            fos = new FileOutputStream(badFileName);
            this.DBfile.seek(0L);
            int readBytes = 0;
            for (long totalLen = this.DBfile.length(); totalLen > 0L; totalLen -= (long)readBytes) {
                readBytes = this.DBfile.read(tempBuffer, 0, 2048);
                if (readBytes < 0) {
                    break;
                }
                fos.write(tempBuffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_Session3._37901_LEVEL)) {
                logger.log(JeusMessage_Session3._37901_LEVEL, JeusMessage_Session3._37901, new Object[]{this.DBfile, badFileName}, (Throwable)ex);
            }
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        if (logger.isLoggable(JeusMessage_Session3._37902_LEVEL)) {
            logger.log(JeusMessage_Session3._37902_LEVEL, JeusMessage_Session3._37902, new Object[]{this.DBfile, badFileName});
        }
    }

    public Set getSessionKeys() {
        if (this.table != null) {
            return this.table.keySet();
        }
        return new HashSet();
    }
}

