/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import jeus.net.helper.MsgSync;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.sessionmanager.distributed.network.SCPacketHeader;
import jeus.sessionmanager.distributed.network.SCSimplePacket;

public abstract class SCPacket
implements SCConstants {
    public final SCPacketHeader header;
    private String smName;
    private byte[] smNameBytes;

    SCPacket() {
        this.header = new SCPacketHeader();
    }

    protected SCPacket(SCPacketHeader header) {
        this.header = header;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.smName = name;
        this.smNameBytes = name.getBytes();
    }

    public String getName() {
        return this.smName;
    }

    public void setNameBytes(byte[] name) {
        if (name == null) {
            return;
        }
        this.smNameBytes = name;
        this.smName = new String(name);
    }

    public byte[] getNameBytes() {
        return this.smNameBytes;
    }

    static String getErrorMessage(int no) {
        if (no >= 0 && no < 6) {
            return ERRCODE[no];
        }
        return "unknown : " + no;
    }

    void send(SocketStream14 outorg, MsgSync reply) throws IOException {
        if (outorg == null) {
            return;
        }
        this.sendBody(outorg, reply);
    }

    public static SCPacket recv(byte[] message) throws IOException {
        if (message == null || message.length < 32) {
            throw new IOException("<distributed-session> a message is null or invalid header length");
        }
        SCPacketHeader header = new SCPacketHeader();
        header.recv(message);
        return new SCSimplePacket(header, message);
    }

    void reset() {
        this.header.reset();
        this.resetBody();
    }

    public abstract void resetBody();

    abstract void sendBody(SocketStream14 var1, MsgSync var2) throws IOException;

    abstract void addBodyInt(int var1);

    abstract void addBodyLong(long var1);

    public abstract void addBodyString(String var1);

    public abstract void addBody(byte[] var1);

    void setBody(byte[] value) {
        this.setBody(value, 0, value.length);
    }

    public abstract void setBody(byte[] var1, int var2, int var3);

    abstract int getBodyInt();

    abstract long getBodyLong();

    public abstract String getBodyString();

    abstract byte[] getBody(int var1);

    public abstract byte[] getBody();

    public String toString() {
        return "Packet[" + (this.header == null ? "" : "0x" + Integer.toHexString(this.header.getOpcode()) + "," + this.header.getSeqno()) + "]";
    }
}

