/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.util.ErrorMsgManager;
import jeus.util.cnet.NetUtil;
import jeus.util.message.JeusMessage_Session3;

public final class SCPacketHeader
implements SCConstants {
    private byte[] header;

    SCPacketHeader() {
        this.header = new byte[32];
    }

    SCPacketHeader(byte[] header) throws IOException {
        this.header = header;
        this.checkMagic();
        this.checkVersion();
    }

    void reset() {
        this.header = new byte[32];
    }

    public void setMagic() {
        NetUtil.writeInt((byte[])this.header, (int)0, (int)10027528);
    }

    public int getMagic() {
        return NetUtil.readInt((byte[])this.header, (int)0);
    }

    public void setOpcode(int value) {
        NetUtil.writeInt((byte[])this.header, (int)4, (int)value);
    }

    public int getOpcode() {
        return NetUtil.readInt((byte[])this.header, (int)4);
    }

    public void setSeqno(int value) {
        NetUtil.writeInt((byte[])this.header, (int)8, (int)value);
    }

    public int getSeqno() {
        return NetUtil.readInt((byte[])this.header, (int)8);
    }

    public void setBodyLength(int value) {
        NetUtil.writeInt((byte[])this.header, (int)12, (int)value);
    }

    public int getBodyLength() {
        return NetUtil.readInt((byte[])this.header, (int)12);
    }

    public void setFlag(int value) {
        NetUtil.writeInt((byte[])this.header, (int)16, (int)(NetUtil.readInt((byte[])this.header, (int)16) | value));
    }

    public int getFlag() {
        return NetUtil.readInt((byte[])this.header, (int)16);
    }

    public void setErrorCode(int value) {
        NetUtil.writeInt((byte[])this.header, (int)20, (int)value);
    }

    public int getErrorCode() {
        return NetUtil.readInt((byte[])this.header, (int)20);
    }

    public void setVersion(int value) {
        NetUtil.writeInt((byte[])this.header, (int)24, (int)value);
    }

    public int getVersion() {
        return NetUtil.readInt((byte[])this.header, (int)24);
    }

    public void setNameLen(int value) {
        NetUtil.writeInt((byte[])this.header, (int)28, (int)value);
    }

    public int getNameLen() {
        return NetUtil.readInt((byte[])this.header, (int)28);
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void recv(byte[] message) throws IOException {
        System.arraycopy(message, 0, this.header, 0, 32);
        this.checkMagic();
        this.checkVersion();
    }

    private void checkMagic() throws IOException {
        int magic = this.getMagic();
        if (magic != 10027528) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37037, (Object)Integer.toHexString(magic)));
        }
    }

    private void checkVersion() throws IOException {
        int version = this.getVersion();
        if (version != 1) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37038, (Object[])new String[]{String.valueOf(version), String.valueOf(1)}));
        }
    }
}

