/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.session.AbstractSession;
import jeus.sessionmanager.session.ObjectSession;
import jeus.sessionmanager.util.DebuggingObjectOutputStream;
import jeus.sessionmanager.util.Deserializer;
import jeus.sessionmanager.util.SessionByteArrayInputStream;
import jeus.util.message.JeusMessage_Session4;

public abstract class AbstractObjectSession
extends AbstractSession
implements ObjectSession {
    protected Object object = null;
    private byte[] serObjectBytes;

    public AbstractObjectSession() {
        this.serObjectBytes = null;
    }

    public AbstractObjectSession(SessionConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupSessions() {
        if (this.object == null || !(this.object instanceof Serializable)) {
            return;
        }
        Object object = this.object;
        synchronized (object) {
            if (this.object == null || !(this.object instanceof Serializable)) {
                return;
            }
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new DebuggingObjectOutputStream(bos);
                oos.writeObject(this.object);
                oos.flush();
                this.serObjectBytes = bos.toByteArray();
            }
            catch (IOException ioe) {
                this.serObjectBytes = null;
                if (logger.isLoggable(JeusMessage_Session4._47651_LEVEL)) {
                    logger.log(JeusMessage_Session4._47651_LEVEL, JeusMessage_Session4._47651, ((DebuggingObjectOutputStream)oos).getStack(), (Throwable)ioe);
                }
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e) {}
            }
            this.object = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.isExpired() || this.object == null) {
            return;
        }
        Object object = this.object;
        synchronized (object) {
            this.object = null;
            this.serObjectBytes = null;
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        if (this.object == null) {
            return null;
        }
        Object object = this.object;
        synchronized (object) {
            if (this.object != null) {
                return this.object;
            }
            if (this.serObjectBytes == null) {
                return null;
            }
            SessionByteArrayInputStream pbis = new SessionByteArrayInputStream(this.serObjectBytes, 0, this.serObjectBytes.length);
            Deserializer ois = null;
            try {
                ois = new Deserializer(pbis);
                this.object = ois.readObject();
            }
            catch (Exception ioe) {
                this.object = null;
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {}
            }
            this.serObjectBytes = null;
            return this.object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Object object) {
        if (this.object == null) {
            this.object = object;
        } else {
            Object object2 = this.object;
            synchronized (object2) {
                this.object = object;
            }
        }
        this.setNeedUpdate(true);
    }
}

