/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.session.AbstractSession;
import jeus.sessionmanager.session.ByteArraySession;

public class ByteArraySessionImpl
extends AbstractSession
implements ByteArraySession {
    private byte[] bytesData = null;
    private int sessionLen = 0;

    public ByteArraySessionImpl() {
    }

    public ByteArraySessionImpl(SessionConfig config) {
        super(config);
    }

    public void backupSessions() {
    }

    public int readSession(byte[] inputBytes, int offset, int length) throws Exception {
        byte[] data;
        int count = 0;
        ByteArrayInputStream bis = new ByteArrayInputStream(inputBytes, offset, length);
        DataInputStream dataInputStream = new DataInputStream(bis);
        int sessionLen = dataInputStream.readInt();
        if (sessionLen <= 0) {
            this.destroy();
            throw new Exception("invalid session length");
        }
        this.sessionLen = sessionLen;
        count += 4;
        int idLen = dataInputStream.readInt();
        if (idLen <= 0) {
            this.destroy();
            throw new Exception("invalid id length");
        }
        count += 4;
        byte[] bytesId = new byte[idLen];
        dataInputStream.readFully(bytesId);
        this.setId(new String(bytesId));
        count += idLen;
        int remain = sessionLen - (count += this.readSessionTimes(dataInputStream));
        if (remain < 0) {
            throw new Exception("invalid session length");
        }
        if (remain > 0) {
            data = new byte[remain];
            dataInputStream.readFully(data);
            count += remain;
        } else {
            data = null;
        }
        this.bytesData = data;
        return count;
    }

    public void writeSession(OutputStream outputStream) throws Exception {
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        if (this.sessionLen <= 0) {
            this.sessionLen = this.calculateSessionLength();
        }
        dataOutputStream.writeInt(this.sessionLen);
        String id = this.getInternalId();
        if (id == null) {
            throw new Exception("invalid id");
        }
        dataOutputStream.writeInt(id.length());
        dataOutputStream.write(id.getBytes());
        this.writeSessionTimes(dataOutputStream);
        if (this.bytesData != null) {
            dataOutputStream.write(this.bytesData);
        }
    }

    public void destroy() {
        if (this.isExpired()) {
            return;
        }
        this.bytesData = null;
        this.sessionLen = 0;
        super.destroy();
    }

    public byte[] getBytesData() {
        return this.bytesData;
    }

    public void setBytesData(byte[] bytesData) {
        this.bytesData = bytesData;
    }

    private int calculateSessionLength() throws Exception {
        int totalSessionLen = 0;
        totalSessionLen += 4;
        String id = this.getInternalId();
        if (id == null) {
            throw new Exception("failed to calculate session length because of invalid id");
        }
        totalSessionLen += 4;
        totalSessionLen += id.length();
        totalSessionLen += 28;
        if (this.bytesData != null) {
            totalSessionLen += this.bytesData.length;
        }
        return totalSessionLen;
    }
}

