/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.session.AbstractWebSession;
import jeus.sessionmanager.session.ByteArraySession;
import jeus.sessionmanager.session.DistributableSession;
import jeus.sessionmanager.util.SessionByteArrayInputStream;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.message.JeusMessage_Session4;

public class DistributableWebSession
extends AbstractWebSession
implements DistributableSession {
    private ByteArraySession byteSession = null;
    private boolean getAccess = false;

    public DistributableWebSession(SessionConfig config) {
        super(config);
    }

    public Object getAttribute(String name) {
        this.getAccess = true;
        return super.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readSession(byte[] inputBytes, int offset, int length) throws Exception {
        Map map = this.attributes;
        synchronized (map) {
            SessionByteArrayInputStream sbais;
            FilterInputStream dataInputStream;
            block16: {
                int n;
                int count = 0;
                dataInputStream = null;
                try {
                    sbais = new SessionByteArrayInputStream(inputBytes, offset, length);
                    dataInputStream = new DataInputStream(sbais);
                    if ((count += this.readSessionTimes((DataInputStream)dataInputStream)) < length - offset) break block16;
                    n = count;
                }
                catch (Exception e) {
                    this.attributes.clear();
                    if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                        logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
                    }
                    throw e;
                }
                return n;
                finally {
                    try {
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            return count += this.internalReadContent(sbais, (DataInputStream)dataInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSession(OutputStream outputStream) throws Exception {
        Map map = this.attributes;
        synchronized (map) {
            if (!(outputStream instanceof SessionByteArrayOutputStream)) {
                throw new Exception(outputStream + " is not supported in DistributableWebSession");
            }
            SessionByteArrayOutputStream sbaos = (SessionByteArrayOutputStream)outputStream;
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = new DataOutputStream(sbaos);
                this.writeSessionTimes(dataOutputStream);
                ByteArraySession byteSession = this.getByteSession();
                if (byteSession != null) {
                    byte[] data = byteSession.getBytesData();
                    if (data != null) {
                        dataOutputStream.write(data);
                    } else {
                        dataOutputStream.writeInt(0);
                    }
                } else {
                    this.internalWriteContent(sbaos, dataOutputStream);
                }
                if (logger.isLoggable(JeusMessage_Session4._48000_LEVEL)) {
                    logger.log(JeusMessage_Session4._48000_LEVEL, JeusMessage_Session4._48000, new Object[]{this, this.getId(), sbaos.getByteArray(), sbaos.getByteArray() == null ? "null" : String.valueOf(sbaos.getByteArray().length), new Integer(sbaos.getCount())});
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                    logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
                }
                throw e;
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public ByteArraySession getByteSession() {
        return this.byteSession;
    }

    public void setByteSession(ByteArraySession byteSession) {
        this.byteSession = byteSession;
        if (byteSession != null) {
            this.initialize(byteSession.getInternalId());
            this.initialize(byteSession.getCreationTime(), byteSession.getLastAccessedTime(), byteSession.getThisAccessedTime(), byteSession.getMaxInactiveInterval());
        }
    }

    public boolean activateSession() throws Exception {
        if (this.byteSession != null) {
            byte[] bytesData = this.byteSession.getBytesData();
            if (bytesData != null) {
                try {
                    this.readContent(bytesData, 0, bytesData.length);
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_Session4._47654_LEVEL)) {
                        logger.log(JeusMessage_Session4._47654_LEVEL, JeusMessage_Session4._47654, (Throwable)e);
                    }
                    this.byteSession = null;
                    throw e;
                }
            }
            this.byteSession = null;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readContent(byte[] inputBytes, int offset, int length) throws Exception {
        Map map = this.attributes;
        synchronized (map) {
            int n;
            FilterInputStream dataInputStream = null;
            try {
                SessionByteArrayInputStream sbais = new SessionByteArrayInputStream(inputBytes, offset, length);
                dataInputStream = new DataInputStream(sbais);
                n = this.internalReadContent(sbais, (DataInputStream)dataInputStream);
            }
            catch (Exception e) {
                this.attributes.clear();
                if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                    logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
                }
                throw e;
            }
            return n;
            finally {
                try {
                    if (dataInputStream != null) {
                        dataInputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(OutputStream outputStream) throws Exception {
        if (!(outputStream instanceof SessionByteArrayOutputStream)) {
            throw new Exception(outputStream + " is not supported in WebSession");
        }
        SessionByteArrayOutputStream sbaos = (SessionByteArrayOutputStream)outputStream;
        Map map = this.attributes;
        synchronized (map) {
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = new DataOutputStream(outputStream);
                this.internalWriteContent(sbaos, dataOutputStream);
                if (logger.isLoggable(JeusMessage_Session4._48000_LEVEL)) {
                    logger.log(JeusMessage_Session4._48000_LEVEL, JeusMessage_Session4._48000, new Object[]{this, this.getId(), sbaos.getByteArray(), sbaos.getByteArray() == null ? "null" : String.valueOf(sbaos.getByteArray().length), new Integer(sbaos.getCount())});
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                    logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
                }
                throw e;
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean getAccess() {
        return this.getAccess;
    }

    public void setGetAccess(boolean getAccess) {
        this.getAccess = getAccess;
    }

    public boolean checkPassivation(long currentTime, long passivationTo) {
        if (this.isExpired()) {
            return false;
        }
        if (passivationTo >= 0L) {
            long thisInterval = currentTime - this.getThisAccessedTime();
            return thisInterval > passivationTo;
        }
        return false;
    }

    public void destroy() {
        this.byteSession = null;
        this.getAccess = false;
        super.destroy();
    }

    protected int internalReadContent(SessionByteArrayInputStream sbais, DataInputStream dataInputStream) throws Exception {
        int count = 0;
        int tempInt = 0;
        int attrCount = dataInputStream.readInt();
        count += 4;
        if (attrCount > 0) {
            tempInt = sbais.getPos();
            this.serAttributes.deserialize(sbais, attrCount, this.attributes);
            count += sbais.getPos() - tempInt;
        }
        return count;
    }

    protected void internalWriteContent(SessionByteArrayOutputStream sbaos, DataOutputStream dataOutputStream) throws Exception {
        int attrCount = 0;
        int attributeCntOffset = sbaos.getCount();
        dataOutputStream.writeInt(0);
        attrCount = this.serAttributes.serialize(sbaos, this.attributes);
        sbaos.writeInt(attributeCntOffset, attrCount);
    }
}

