/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.session.AbstractObjectSession;
import jeus.sessionmanager.util.DebuggingObjectOutputStream;
import jeus.sessionmanager.util.Deserializer;
import jeus.sessionmanager.util.SessionByteArrayInputStream;
import jeus.util.message.JeusMessage_Session4;

public class StandardObjectSession
extends AbstractObjectSession {
    public StandardObjectSession(SessionConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSession(byte[] inputBytes, int offset, int length) throws Exception {
        int end;
        int start;
        int count = 0;
        try {
            SessionByteArrayInputStream pbis = new SessionByteArrayInputStream(inputBytes, offset, length);
            DataInputStream dataInputStream = new DataInputStream(pbis);
            if ((count += this.readSessionTimes(dataInputStream)) >= length - offset) {
                return count;
            }
            Deserializer ois = null;
            try {
                ois = new Deserializer(pbis);
                start = pbis.getPos();
                this.object = ois.readObject();
                end = pbis.getPos();
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            this.object = null;
            if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
            }
            throw e;
        }
        return count += end - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSession(OutputStream outputStream) throws Exception {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            this.writeSessionTimes(dataOutputStream);
            if (this.object == null) {
                return;
            }
            if (!(this.object instanceof Serializable)) {
                throw new Exception(this.object + " is not serializable");
            }
            DebuggingObjectOutputStream oos = null;
            try {
                oos = new DebuggingObjectOutputStream(outputStream);
                Object object = this.object;
                synchronized (object) {
                    oos.writeObject(this.object);
                }
                oos.flush();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session4._47651_LEVEL)) {
                    logger.log(JeusMessage_Session4._47651_LEVEL, JeusMessage_Session4._47651, oos.getStack(), (Throwable)ioe);
                }
                throw ioe;
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
            }
            throw e;
        }
    }
}

