/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import jeus.sessionmanager.util.SecureSessionIdGenerator;

public abstract class AbstractGlobalObjectFactory {
    private static final String JVM_ID = SecureSessionIdGenerator.generateId();
    private HashMap objectMap = new HashMap();

    public Object createObject(CopyOnWriteArrayList params) {
        return this.createObject(null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject(String scope, Object ... params) {
        ObjectMapItem item = null;
        Object object = null;
        if (scope == null) {
            scope = JVM_ID;
        }
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            item = (ObjectMapItem)this.objectMap.get(scope);
            if (item != null) {
                object = item.getObject();
                if (object != null) {
                    return object;
                }
                this.objectMap.remove(scope);
            }
            if ((object = this.allocateObject(params)) == null) {
                return null;
            }
            item = this.getItem(object);
            this.objectMap.put(scope, item);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(String scope) {
        if (scope == null) {
            scope = JVM_ID;
        }
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            ObjectMapItem item = (ObjectMapItem)this.objectMap.get(scope);
            if (item != null && item.destroy(false)) {
                this.objectMap.remove(scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAll() {
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            Iterator i = this.objectMap.values().iterator();
            while (i.hasNext()) {
                ObjectMapItem item = (ObjectMapItem)i.next();
                item.destroy(true);
                i.remove();
            }
            this.objectMap.clear();
        }
    }

    private ObjectMapItem getItem(Object object) {
        return new ObjectMapItem(object);
    }

    protected abstract Object allocateObject(Object[] var1);

    protected abstract void destroyObject(Object var1);

    private class ObjectMapItem {
        private int accessCount;
        private Object object;

        public ObjectMapItem(Object object) {
            this.object = object;
            this.accessCount = 1;
        }

        public Object getObject() {
            if (this.object == null) {
                return null;
            }
            ++this.accessCount;
            return this.object;
        }

        public boolean destroy(boolean force) {
            if (this.object == null) {
                return true;
            }
            --this.accessCount;
            if (!force && this.accessCount > 0) {
                return false;
            }
            AbstractGlobalObjectFactory.this.destroyObject(this.object);
            this.object = null;
            this.accessCount = 0;
            return true;
        }
    }
}

