/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.util;

import java.security.SecureRandom;
import jeus.sessionmanager.util.JeusRandom;
import jeus.util.CUtility;

public class RandomPerJvm {
    private final int DEFAULT_PRIVATE_KEY_LENGTH = 25;
    private final JeusRandom jeusRandom = new JeusRandom();
    private static final RandomPerJvm randomPerJvm = new RandomPerJvm();

    private RandomPerJvm() {
        byte[] privateKeyBytes = RandomPerJvm.getPrivateKeyBytes(25);
        this.jeusRandom.setSeed(privateKeyBytes);
        privateKeyBytes[0] = 0;
    }

    public JeusRandom getJeusRandom() {
        return this.jeusRandom;
    }

    public static RandomPerJvm getRandomPerJvm() {
        return randomPerJvm;
    }

    public static byte[] getPrivateKeyBytes(int keyLength) {
        SecureRandom secureRandom = new SecureRandom();
        try {
            secureRandom.setSeed(System.currentTimeMillis());
            secureRandom.setSeed(Runtime.getRuntime().freeMemory());
            secureRandom.setSeed(Runtime.getRuntime().totalMemory());
            secureRandom.setSeed(System.getProperty("java.version", "default").getBytes());
            secureRandom.setSeed(System.getProperty("java.vendor", "default").getBytes());
            secureRandom.setSeed(System.getProperty("os.name", "default").getBytes());
            secureRandom.setSeed(System.getProperty("os.version", "default").getBytes());
            secureRandom.setSeed(System.getProperty("user.name", "default").getBytes());
            secureRandom.setSeed(System.getProperty("user.dir", "default").getBytes());
            secureRandom.setSeed(System.getProperty("user.home", "default").getBytes());
            secureRandom.setSeed(System.getProperty("java.home", "default").getBytes());
            secureRandom.setSeed(System.getProperty("java.class.path", "default").getBytes());
            secureRandom.setSeed(String.valueOf(CUtility.thisProcessPID).getBytes());
            secureRandom.setSeed(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] abyte0 = new byte[keyLength];
        secureRandom.nextBytes(abyte0);
        return abyte0;
    }
}

