/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.config.DConfigBeanSpecificationSource;
import jeus.service.descriptor.DescriptorFile;
import jeus.tool.builder.Constants;
import jeus.tool.builder.WIOBuilderException;
import jeus.tool.builder.WIOConfig;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.module.EARInspector;
import jeus.tool.builder.inspector.module.EJBInspector;
import jeus.tool.builder.inspector.xml.ModuleXMLInspector;
import jeus.tool.builder.inspector.xml.XMLInspector;
import jeus.tool.builder.module.ModuleDescriptorFacade;
import jeus.tool.builder.resource.MsgRscManager;
import jeus.tool.builder.ui.DefaultFileFilter;
import jeus.tool.builder.ui.DescriptorEditPanel;
import jeus.tool.builder.ui.MessagePanel;
import jeus.tool.builder.ui.SplashWindow;
import jeus.tool.builder.ui.wizard.FileContentsChooserDlg;
import jeus.tool.builder.util.ArchiveUtil;
import jeus.tool.builder.util.FileUtils;
import jeus.tool.builder.util.MessageResourceBundle;
import jeus.tool.builder.util.ModuleUtil;
import jeus.tool.builder.util.SwingUtils;
import jeus.tool.util.FileUtil;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.component.XMLUIBoolean;
import jeus.tool.xmlui.component.XMLUITextArea;
import jeus.tool.xmlui.component.XMLUITextField;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.util.XMLUtil;
import jeus.util.JarExtractor;
import jeus.util.JeusProperties;
import jeus.xml.util.ClasspathLocation;
import jeus.xml.util.ElementOrderTable;
import jeus.xml.util.ElementOrderTableSource;
import org.w3c.dom.Document;

public class JEUSBuilder
extends JFrame {
    public static ElementOrderTableSource tsrc = new ElementOrderTableSource(new ClasspathLocation("jeus/xml/binding/resource"));
    public static DConfigBeanSpecificationSource dconfsource = new DConfigBeanSpecificationSource();
    private static final int DEFAULT_FONT_SIZE = 11;
    private static final int DEFAULT_FRAME_WIDTH = 800;
    private static final int DEFAULT_FRAME_HEIGHT = 700;
    public JPanel mainPanel;
    public MessagePanel msgPanel;
    private JPanel workspacePanel = new JPanel();
    private WIOConfig config;
    private static XMLUIEngine xmluiEngine;
    private FileContentsChooserDlg fileContentsChooserDlg;
    private DescriptorEditPanel newWorkspacePanel;
    private static JEUSBuilder builder;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    JButton btnSave;
    JButton btnFileContents;
    private static boolean fileContentsChanged;
    private JCheckBoxMenuItem autosaveMenuItem = null;

    public static JEUSBuilder getJEUSBuilder() {
        return builder;
    }

    private static JEUSBuilder createWIOBuilder(String title, WIOConfig config) {
        builder = new JEUSBuilder(title, config);
        return builder;
    }

    private JEUSBuilder(String title, WIOConfig config) {
        super(title);
        this.config = config;
        xmluiEngine = new XMLUIEngine("/jeus/tool/resource/ui/builder");
        MessageResourceBundle resourceBundle = new MessageResourceBundle(dconfsource.getReferences());
        xmluiEngine.setResourceBundle(resourceBundle);
        this.setLookAndFeel();
        this.initializeFonts();
        this.fileContentsChooserDlg = new FileContentsChooserDlg(this);
        this.createAndShowGUI();
        this.setEnableSave(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JEUSBuilder.this.exitBuilder();
            }
        });
    }

    private boolean getAutoSaveFlag() {
        try {
            String autoSave = System.getProperty("autosave");
            if (autoSave != null) {
                return autoSave.equalsIgnoreCase("true");
            }
        }
        catch (SecurityException ex) {
            return true;
        }
        return true;
    }

    public static XMLUIEngine getXMLUIEngine() {
        return xmluiEngine;
    }

    private void createAndShowGUI() {
        Image titleImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/jeus/tool/builder/images/jeus_title.gif"));
        this.setIconImage(titleImage);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(new SoftBevelBorder(1));
        this.msgPanel = new MessagePanel();
        this.msgPanel.setBorder(new SoftBevelBorder(1));
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        JSplitPane verticalSplitPane = new JSplitPane(0, this.mainPanel, this.msgPanel);
        verticalSplitPane.setOneTouchExpandable(false);
        verticalSplitPane.setDividerLocation((int)((double)this.getScreenHeight() * 0.5));
        verticalSplitPane.setDividerSize(4);
        this.getContentPane().add((Component)verticalSplitPane, "Center");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setSize(new Dimension(800, 700));
        this.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem newMenuItem = new JMenuItem("New");
        newMenuItem.setMnemonic('N');
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.createModule();
            }
        });
        JMenuItem openMenuItem = new JMenuItem("Open");
        openMenuItem.setMnemonic('O');
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.openModule();
            }
        });
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JEUSBuilder.this.saveModule(JEUSBuilder.this.fileContentsChooserDlg.getArchiveFilePath())) {
                    MessagePanel.showMessage("Module save success:" + JEUSBuilder.this.fileContentsChooserDlg.getArchiveFilePath());
                }
            }
        });
        this.saveAsMenuItem = new JMenuItem("Save as");
        this.saveAsMenuItem.setMnemonic('A');
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.saveAsModule();
            }
        });
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.setMnemonic('X');
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.exitBuilder();
            }
        });
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem aboutMenuItem = new JMenuItem("About JEUS Builder");
        aboutMenuItem.setMnemonic('A');
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.showToolInfo();
            }
        });
        fileMenu.add(newMenuItem);
        fileMenu.add(openMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(this.saveMenuItem);
        fileMenu.add(this.saveAsMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(exitMenuItem);
        helpMenu.add(aboutMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        JButton btnNew = new JButton(SwingUtils.createIcon("/jeus/tool/builder/images/icon_new_module.gif"));
        btnNew.setMnemonic('N');
        btnNew.setToolTipText("New Module");
        btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.createModule();
            }
        });
        JButton btnOpen = new JButton(SwingUtils.createIcon("/jeus/tool/builder/images/icon_open_module.gif"));
        btnOpen.setToolTipText("Open Module");
        btnOpen.setMnemonic('O');
        btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.openModule();
            }
        });
        this.btnSave = new JButton(SwingUtils.createIcon("/jeus/tool/builder/images/icon_save_module.gif"));
        this.btnSave.setToolTipText("Save Module");
        this.btnSave.setMnemonic('S');
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JEUSBuilder.this.saveModule(JEUSBuilder.this.fileContentsChooserDlg.getArchiveFilePath())) {
                    MessagePanel.showMessage("Module save success:" + JEUSBuilder.this.fileContentsChooserDlg.getArchiveFilePath());
                }
            }
        });
        this.btnFileContents = new JButton(SwingUtils.createIcon("/jeus/tool/builder/images/icon_file_dlg.gif"));
        this.btnFileContents.setToolTipText("File Setting");
        this.btnFileContents.setMnemonic('I');
        this.btnFileContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEUSBuilder.this.openFileConentsDlg();
            }
        });
        toolBar.add(btnNew);
        toolBar.add(btnOpen);
        toolBar.addSeparator();
        toolBar.add(this.btnSave);
        toolBar.addSeparator();
        toolBar.add(this.btnFileContents);
        return toolBar;
    }

    private void setEnableSave(boolean abled) {
        this.saveMenuItem.setEnabled(abled);
        this.saveAsMenuItem.setEnabled(abled);
        this.btnSave.setEnabled(abled);
        this.btnFileContents.setEnabled(abled);
    }

    private void openFileConentsDlg() {
        this.fileContentsChooserDlg.show();
    }

    private void createModule() {
        File dir1 = new File(Constants.JEUS_ASSEMBLY_DIR);
        File dir2 = new File(Constants.JEUS_ASSEMBLY_EAR_DIR);
        if (dir1.exists() || dir2.exists()) {
            int answer = JOptionPane.showConfirmDialog(this, "Do you want to delete data on working?", "Confirm", 1);
            if (answer == 0) {
                FileUtil.rmdir(Constants.JEUS_ASSEMBLY_DIR);
                FileUtil.rmdir(Constants.JEUS_ASSEMBLY_EAR_DIR);
                if (this.newWorkspacePanel != null) {
                    this.mainPanel.remove(this.newWorkspacePanel);
                    this.mainPanel.validate();
                    this.mainPanel.repaint();
                }
                MessagePanel.showMessage("Current module is deleted:" + this.fileContentsChooserDlg.getArchiveFilePath());
            } else if (answer == 2) {
                return;
            }
        }
        this.fileContentsChooserDlg.setWorkMode(true);
        this.fileContentsChooserDlg.init();
        this.fileContentsChooserDlg.show();
        if (!this.existContents()) {
            this.setEnableSave(false);
        } else {
            this.setEnableSave(true);
        }
    }

    private boolean validateDDFile(AbstractArchive archive, ModuleType moduleType, String msg) {
        try {
            XMLUtil.validateStandardDDFile(archive, moduleType, tsrc);
            MessagePanel.showMessage(XMLUtil.getStandardDDFilePath(moduleType) + " in " + msg + "...OK");
        }
        catch (FileNotFoundException fnfe) {
            MessagePanel.showMessage(fnfe.getMessage() + "\n\t in " + msg);
        }
        catch (Exception ex) {
            MessagePanel.showMessage("[ERROR]" + ex.getMessage() + "\n\t" + XMLUtil.getStandardDDFilePath(moduleType) + " in " + msg);
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n\t" + XMLUtil.getStandardDDFilePath(moduleType) + " in " + msg, "OPEN Error", 0);
            return false;
        }
        try {
            XMLUtil.validateJeusDDFile(archive, moduleType, tsrc);
            MessagePanel.showMessage(XMLUtil.getJeusDDFilePath(moduleType) + " in " + msg + "...OK");
        }
        catch (FileNotFoundException fnfe) {
            MessagePanel.showMessage(fnfe.getMessage() + "\n\t in " + msg);
        }
        catch (Exception ex) {
            MessagePanel.showMessage("[ERROR]" + ex.getMessage() + "\n\t" + XMLUtil.getJeusDDFilePath(moduleType) + " in " + msg);
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n\t" + XMLUtil.getJeusDDFilePath(moduleType) + " in " + msg, "OPEN Error", 0);
            return false;
        }
        return true;
    }

    private boolean validateDDFile(AbstractArchive archive, ModuleType moduleType) throws Exception {
        MessagePanel.showMessage("Validity check of DDs begins...");
        String entry = null;
        String msg = archive.getArchiveUri();
        Enumeration enum1 = archive.entries();
        if (!this.validateDDFile(archive, moduleType, msg.toString())) {
            archive.close();
            MessagePanel.showMessage("Validity check of DD files in " + msg + "...failed");
            return false;
        }
        if (moduleType.equals(ModuleType.EAR)) {
            String msg1 = null;
            AbstractArchive embeddedArchive = null;
            while (enum1.hasMoreElements()) {
                entry = (String)enum1.nextElement();
                ModuleType embeddedModulType = null;
                embeddedArchive = archive.getEmbeddedArchive(entry);
                msg1 = embeddedArchive.getArchiveUri() + " in " + msg;
                try {
                    embeddedModulType = JeusDeploymentManager.getModuleType(embeddedArchive);
                }
                catch (RuntimeException re) {
                    continue;
                }
                if (!this.validateDDFile(embeddedArchive, embeddedModulType, msg1)) {
                    embeddedArchive.close();
                    archive.close();
                    MessagePanel.showMessage("Validity check of DD files in " + msg1 + "...failed");
                    return false;
                }
                embeddedArchive.close();
            }
        }
        MessagePanel.showMessage("Validity check of DD files in " + msg + " was completed successfully");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openModule() {
        ModuleType moduleType;
        JFileChooser chooser = new JFileChooser(new File(JeusProperties.JEUS_HOME));
        chooser.setDialogTitle("Open Module");
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("ear");
        filter.addExtension("jar");
        filter.addExtension("rar");
        filter.addExtension("war");
        filter.setDescription("Archive");
        chooser.setFileFilter(filter);
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(this);
        File selectedFile = null;
        if (returnVal != 0) {
            return;
        }
        selectedFile = chooser.getSelectedFile();
        FileUtil.rmdir(Constants.JEUS_ASSEMBLY_DIR);
        FileUtil.rmdir(Constants.JEUS_ASSEMBLY_EAR_DIR);
        AbstractArchive archive = null;
        try {
            archive = JarArchiveFactory.openArchiveStatic((File)selectedFile);
            moduleType = JeusDeploymentManager.getModuleType(archive);
            if (moduleType == null) {
                MessagePanel.showMessage("[ERROR]Unsupported module type:" + archive.getArchiveUri());
                return;
            }
            if (!this.validateDDFile(archive, moduleType)) {
                archive.close();
                FileUtil.rmdir(Constants.JEUS_ASSEMBLY_DIR);
                FileUtil.rmdir(Constants.JEUS_ASSEMBLY_EAR_DIR);
                return;
            }
            FileUtils.makeAssemblyDir();
            if (moduleType.equals(ModuleType.EAR)) {
                FileUtils.makeEarArchiveDir();
            }
            JarExtractor extractor = new JarExtractor();
            if (moduleType == ModuleType.EJB) {
                extractor.unJar(selectedFile.toString(), Constants.JEUS_ASSEMBLY_DIR, true);
            } else if (moduleType == ModuleType.EAR) {
                this.extractContentsFromEAR(archive);
            } else {
                extractor.unJar(selectedFile.toString(), Constants.JEUS_ASSEMBLY_DIR, true);
            }
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, t.getMessage(), "Open Error", 0);
            t.printStackTrace();
            return;
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                    archive = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fileContentsChooserDlg.init(moduleType, selectedFile.toString());
        this.fileContentsChooserDlg.updateSelectedFileTree();
        if (moduleType == ModuleType.EAR) {
            this.fileContentsChooserDlg.initDisplayMode();
        }
        this.updateWorkspacePanel();
        MessagePanel.showMessage("Opening module is completed:" + selectedFile.toString());
        if (!this.existContents()) {
            this.setEnableSave(false);
        } else {
            this.setEnableSave(true);
        }
    }

    private void extractContentsFromEAR(AbstractArchive archive) throws IOException {
        JarExtractor extractor = new JarExtractor();
        extractor.unJar(archive.getArchiveUri(), Constants.JEUS_ASSEMBLY_EAR_DIR, true);
        FileUtils.extractEmbeddedContentsFromEAR(new File(Constants.JEUS_ASSEMBLY_EAR_DIR));
    }

    private Vector getParentXMLUIPanels() {
        Vector vPanels = new Vector();
        Hashtable xmluiPanelTable = this.newWorkspacePanel.getParentXmlUIPanels();
        Enumeration keys = xmluiPanelTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            vPanels.add(xmluiPanelTable.get(key));
        }
        return vPanels;
    }

    private boolean checkModuleChanged() {
        if (fileContentsChanged) {
            return true;
        }
        Vector vPanels = this.getParentXMLUIPanels();
        for (int k = 0; k < vPanels.size(); ++k) {
            XMLUIPanel panel = (XMLUIPanel)vPanels.elementAt(k);
            if (!panel.isChanged()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveModule(String filePath) {
        if (!this.existContents()) {
            return false;
        }
        if (filePath == null || "".equals(filePath)) {
            return false;
        }
        ModuleType moduleType = this.fileContentsChooserDlg.getModuleType();
        JarExtractor extractor = new JarExtractor();
        OutputStream j2eeOS = null;
        OutputStream jeusOS = null;
        try {
            Document[] documents = this.newWorkspacePanel.getDocuments();
            if (!this.writeStandardDescriptor(documents[0], ModuleUtil.getStandardFileName(moduleType), moduleType)) {
                boolean bl = false;
                return bl;
            }
            if (documents[1] != null && !this.writeJeusDescriptor(documents[1], ModuleUtil.getJeusFileName(moduleType), moduleType)) {
                boolean bl = false;
                return bl;
            }
            if (moduleType.equals(ModuleType.EAR)) {
                XMLInspector[] xmlInspector = this.newWorkspacePanel.getEmbeddedXMLInspectors();
                String j2eeDDFile = null;
                String jeusDDFile = null;
                String embeddedArchivePath = null;
                for (int k = 0; k < xmlInspector.length; ++k) {
                    Document jeusDocument;
                    XMLInspector childXMLInspector = xmlInspector[k];
                    String type = childXMLInspector.getType();
                    String moduleName = childXMLInspector.getName();
                    Document j2eeDocument = childXMLInspector.getJ2eeElement().getOwnerDocument();
                    if (j2eeDocument != null) {
                        j2eeDDFile = ModuleUtil.getStandardFileName(type);
                    }
                    if ((jeusDocument = childXMLInspector.getJeusElement().getOwnerDocument()) != null) {
                        jeusDDFile = ModuleUtil.getJeusFileName(type);
                    }
                    if (type.equals("J2EEApplication")) {
                        embeddedArchivePath = this.getEmbeddedArchivePath(moduleName + ".ear");
                        moduleType = ModuleType.EAR;
                    } else if (type.equals("EJBModule")) {
                        embeddedArchivePath = this.getEmbeddedArchivePath(moduleName + ".jar");
                        moduleType = ModuleType.EJB;
                    } else if (type.equals("AppClientModule")) {
                        embeddedArchivePath = this.getEmbeddedArchivePath(moduleName + ".jar");
                        moduleType = ModuleType.CAR;
                    } else if (type.equals("ResourceAdapterModule")) {
                        embeddedArchivePath = this.getEmbeddedArchivePath(moduleName + ".rar");
                        moduleType = ModuleType.RAR;
                    } else if (type.equals("WebModule")) {
                        embeddedArchivePath = this.getEmbeddedArchivePath(moduleName + ".war");
                        moduleType = ModuleType.WAR;
                    } else {
                        throw new RuntimeException("type:" + type + " - Unsupported embedded module type");
                    }
                    String j2eeDDFileName = Constants.JEUS_ASSEMBLY_DIR + File.separator + embeddedArchivePath + File.separator + j2eeDDFile;
                    if (!this.writeStandardDescriptor(j2eeDocument, j2eeDDFileName, moduleType)) {
                        boolean bl = false;
                        return bl;
                    }
                    String jeusDDFileName = Constants.JEUS_ASSEMBLY_DIR + File.separator + embeddedArchivePath + File.separator + jeusDDFile;
                    if (!this.writeJeusDescriptor(jeusDocument, jeusDDFileName, moduleType)) {
                        boolean bl = false;
                        return bl;
                    }
                    extractor.makeJar2(Constants.JEUS_ASSEMBLY_DIR + File.separator + embeddedArchivePath, Constants.JEUS_ASSEMBLY_EAR_DIR + File.separator + embeddedArchivePath);
                }
                extractor.makeJar2(Constants.JEUS_ASSEMBLY_EAR_DIR, filePath);
            } else {
                extractor.makeJar2(Constants.JEUS_ASSEMBLY_DIR, filePath);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this, filePath + "\n" + t.getMessage(), "Save Error", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (j2eeOS != null) {
                    j2eeOS.close();
                    j2eeOS = null;
                }
                if (jeusOS != null) {
                    jeusOS.close();
                    jeusOS = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.demarcateValuesOfXMLUIPanels();
        return true;
    }

    private void demarcateValuesOfXMLUIPanels() {
        fileContentsChanged = false;
        Vector vPanels = this.getParentXMLUIPanels();
        for (int k = 0; k < vPanels.size(); ++k) {
            XMLUIPanel panel = (XMLUIPanel)vPanels.elementAt(k);
            panel.setChanged(false);
            Component[] childs = panel.getComponents();
            for (int i = 0; i < childs.length; ++i) {
                this.retrievePanelAndSetValue(childs[i]);
            }
        }
    }

    private void retrievePanelAndSetValue(Component component) {
        if (component instanceof Container) {
            if (component instanceof XMLUITextField) {
                ((XMLUITextField)component).setChanged(false);
                ((XMLUITextField)component).replaceValueWithCurrentValue();
            } else if (component instanceof XMLUITextArea) {
                ((XMLUITextArea)component).setChanged(false);
                ((XMLUITextArea)component).replaceValueWithCurrentValue();
            } else if (component instanceof XMLUIBoolean) {
                ((XMLUIBoolean)component).setChanged(false);
                ((XMLUIBoolean)component).replaceValueWithCurrentValue();
            }
            Component[] childs = ((Container)component).getComponents();
            for (int k = 0; k < childs.length; ++k) {
                this.retrievePanelAndSetValue(childs[k]);
            }
        }
    }

    private String getEmbeddedArchivePath(String moduleName) throws IOException {
        AbstractArchive archive = ArchiveUtil.getEarArchiveFileArchive();
        Enumeration enum1 = archive.entries();
        while (enum1.hasMoreElements()) {
            String entry = (String)enum1.nextElement();
            if (!entry.endsWith(moduleName)) continue;
            return entry;
        }
        throw new RuntimeException(moduleName + ":embedded archive must exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeStandardDescriptor(Document document, String targetFileName, ModuleType moduletype) {
        File tempFile = null;
        File targetFile = null;
        FileOutputStream standardFOS = null;
        try {
            String standardFileName = targetFileName + ".tmp";
            tempFile = new File(standardFileName);
            targetFile = new File(targetFileName);
            standardFOS = new FileOutputStream(tempFile);
            ElementOrderTable t = null;
            t = document.getDocumentElement().getNamespaceURI() == null ? tsrc.getElementOrderTable(document.getDocumentElement().getNodeName(), "http://java.sun.com/xml/ns/j2ee") : tsrc.getElementOrderTable(document);
            ModuleXMLInspector insp = (ModuleXMLInspector)this.newWorkspacePanel.getXMLInspector();
            DescriptorFile descFile = (DescriptorFile)insp.getDeployUnit().getStandardDescriptorFile();
            XMLUtil.writeDocument(document, standardFOS, descFile, t);
            standardFOS.flush();
            FileUtil.copy(tempFile, targetFile);
        }
        catch (Exception e) {
            MessagePanel.showMessage("[ERROR]in writing " + targetFile.getName() + ":" + e.getMessage());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (standardFOS != null) {
                    standardFOS.close();
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MessagePanel.showMessage("write J2EE descriptor file:" + ModuleUtil.getJ2eeDescriptorFileName(moduletype));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeJeusDescriptor(Document document, String targetFileName, ModuleType moduletype) {
        File tempFile = null;
        File targetFile = null;
        FileOutputStream jeusFOS = null;
        try {
            String jeusFileName = targetFileName + ".tmp";
            tempFile = new File(jeusFileName);
            targetFile = new File(targetFileName);
            jeusFOS = new FileOutputStream(tempFile);
            ElementOrderTable t = null;
            t = document.getDocumentElement().getNamespaceURI() == null ? tsrc.getElementOrderTable(document.getDocumentElement().getNodeName(), "http://www.tmaxsoft.com/xml/ns/jeus") : tsrc.getElementOrderTable(document);
            ModuleXMLInspector insp = (ModuleXMLInspector)this.newWorkspacePanel.getXMLInspector();
            DescriptorFile descFile = (DescriptorFile)insp.getDeployUnit().getJeusDescriptorFile();
            XMLUtil.writeDocument(document, jeusFOS, descFile, t);
            jeusFOS.flush();
            FileUtil.copy(tempFile, targetFile);
        }
        catch (Exception e) {
            MessagePanel.showMessage("[ERROR]in writing " + targetFile.getName() + ":" + e.getMessage());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (jeusFOS != null) {
                    jeusFOS.close();
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MessagePanel.showMessage("write JEUS descriptor file:" + ModuleUtil.getJeusDescriptorFileName(moduletype));
        return true;
    }

    private boolean existContents() {
        File file = new File(Constants.JEUS_ASSEMBLY_DIR);
        if (!file.exists()) {
            return false;
        }
        return file.listFiles().length > 0;
    }

    private void saveAsModule() {
        if (!this.existContents()) {
            return;
        }
        JFileChooser chooser = new JFileChooser(new File(JeusProperties.JEUS_HOME));
        chooser.setDialogTitle("Save As Module");
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("ear");
        filter.addExtension("jar");
        filter.addExtension("rar");
        filter.addExtension("war");
        filter.setDescription("Archive");
        chooser.setFileFilter(filter);
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showOpenDialog(this);
        File selectedFile = null;
        if (returnVal != 0) {
            return;
        }
        selectedFile = chooser.getSelectedFile();
        if (!this.saveModule(selectedFile.toString())) {
            return;
        }
        this.fileContentsChooserDlg.init(selectedFile.toString());
        MessagePanel.showMessage("SaveAs success:" + selectedFile.toString());
    }

    private Hashtable doIntrospect() {
        ModuleType moduleType = this.fileContentsChooserDlg.getModuleType();
        if (moduleType.equals(ModuleType.EAR)) {
            AbstractArchive earArchive = null;
            Hashtable<String, Object> EARHashtable = new Hashtable<String, Object>();
            try {
                earArchive = ArchiveUtil.getEarArchiveFileArchive();
                EARHashtable.put("EAR_Inspector", new EARInspector(earArchive));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Enumeration entries = earArchive.entries();
            Hashtable<String, EJBInspector> entityHashtable = new Hashtable<String, EJBInspector>();
            Hashtable<String, EJBInspector> sessionHashtable = new Hashtable<String, EJBInspector>();
            Hashtable<String, EJBInspector> messageHashtable = new Hashtable<String, EJBInspector>();
            while (entries.hasMoreElements()) {
                String archiveName = (String)entries.nextElement();
                if (archiveName.indexOf("APP-INF") > 0 || !archiveName.endsWith(".jar")) continue;
                String classpath = Constants.JEUS_ASSEMBLY_DIR + Constants.FS + archiveName;
                int endIndex = archiveName.lastIndexOf(".");
                int startIndex = archiveName.lastIndexOf(47);
                if (startIndex < 0) {
                    startIndex = -1;
                }
                String moduleName = archiveName.substring(startIndex + 1, endIndex);
                entityHashtable.put(moduleName, new EJBInspector("javax.ejb.EntityBean", classpath));
                sessionHashtable.put(moduleName, new EJBInspector("javax.ejb.SessionBean", classpath));
                messageHashtable.put(moduleName, new EJBInspector("javax.ejb.MessageDrivenBean", classpath));
            }
            EARHashtable.put("Entity_Bean_Inspector", entityHashtable);
            EARHashtable.put("Session_Bean_Inspector", sessionHashtable);
            EARHashtable.put("Message__Driven_Bean_Inspector", messageHashtable);
            return EARHashtable;
        }
        Hashtable<String, EJBInspector> EJBHashtable = new Hashtable<String, EJBInspector>();
        EJBHashtable.put("Entity_Bean_Inspector", new EJBInspector("javax.ejb.EntityBean"));
        EJBHashtable.put("Session_Bean_Inspector", new EJBInspector("javax.ejb.SessionBean"));
        EJBHashtable.put("Message__Driven_Bean_Inspector", new EJBInspector("javax.ejb.MessageDrivenBean"));
        return EJBHashtable;
    }

    public void updateWorkspacePanel() {
        AbstractArchive archive = null;
        ModuleType moduleType = this.fileContentsChooserDlg.getModuleType();
        Hashtable introspectorHashtable = null;
        if (moduleType.equals(ModuleType.EJB) || moduleType.equals(ModuleType.EAR)) {
            introspectorHashtable = this.doIntrospect();
        }
        try {
            archive = moduleType.equals(ModuleType.EAR) ? ArchiveUtil.getEarArchiveFileArchive() : ArchiveUtil.getAssemblyFileArchive();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        IDeployUnit md = ModuleDescriptorFacade.getModuleDescriptor(archive, moduleType);
        md.setModuleName(this.fileContentsChooserDlg.getModuleName());
        md.setModuleType(moduleType);
        this.newWorkspacePanel = new DescriptorEditPanel(md, xmluiEngine, introspectorHashtable);
        if (this.workspacePanel != null) {
            this.mainPanel.remove(this.workspacePanel);
        }
        this.mainPanel.add((Component)this.newWorkspacePanel, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
        this.workspacePanel = this.newWorkspacePanel;
        try {
            if (archive != null) {
                archive.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getScreenHeight() {
        return this.getToolkit().getScreenSize().height;
    }

    private boolean save() {
        if (this.saveModule(this.fileContentsChooserDlg.getArchiveFilePath())) {
            MessagePanel.showMessage("Module Save success:" + this.fileContentsChooserDlg.getArchiveFilePath());
            return true;
        }
        MessagePanel.showMessage("Module Save failed:" + this.fileContentsChooserDlg.getArchiveFilePath());
        return false;
    }

    public void setFileContentsChanged(boolean changed) {
        if (changed) {
            fileContentsChanged = changed;
        }
    }

    private void exitBuilder() {
        int result;
        Container obj;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        Container parent = component.getParent();
        if (parent instanceof XMLUITextField) {
            ((XMLUITextField)parent).focusLost(null);
        } else if (parent instanceof XMLUIBoolean) {
            ((XMLUIBoolean)parent).focusLost(null);
        } else if (component instanceof JTextArea && (obj = parent.getParent().getParent()) instanceof XMLUITextArea) {
            ((XMLUITextArea)obj).focusLost(null);
        }
        if (this.existContents() && this.checkModuleChanged() && ((result = JOptionPane.showConfirmDialog(this, "Do you wish to save the module?", "Exit JEUS Builder", 1)) == 0 ? !this.save() : result == 2)) {
            return;
        }
        FileUtil.rmdir(Constants.JEUS_ASSEMBLY_EAR_DIR);
        FileUtil.rmdir(Constants.JEUS_ASSEMBLY_DIR);
        System.exit(0);
    }

    public void setLookAndFeel() {
        String laf = this.config.getLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("warning: UnsupportedLookAndFeel: " + laf);
        }
        catch (Exception exc) {
            System.err.println("error loading " + laf + ": " + exc);
        }
    }

    private void initializeFonts() {
        Font dialogPlain = new Font("Dialog", 0, 11);
        Font serifPlain = new Font("Serif", 0, 11);
        Font sansSerifPlain = new Font("SansSerif", 0, 11);
        Font monospacedPlain = new Font("Monospaced", 0, 11);
        UIManager.getDefaults().put("Button.font", dialogPlain);
        UIManager.getDefaults().put("ToggleButton.font", dialogPlain);
        UIManager.getDefaults().put("RadioButton.font", dialogPlain);
        UIManager.getDefaults().put("CheckBox.font", dialogPlain);
        UIManager.getDefaults().put("ColorChooser.font", dialogPlain);
        UIManager.getDefaults().put("ComboBox.font", dialogPlain);
        UIManager.getDefaults().put("Label.font", dialogPlain);
        UIManager.getDefaults().put("List.font", dialogPlain);
        UIManager.getDefaults().put("MenuBar.font", dialogPlain);
        UIManager.getDefaults().put("MenuItem.font", dialogPlain);
        UIManager.getDefaults().put("RadioButtonMenuItem.font", dialogPlain);
        UIManager.getDefaults().put("CheckBoxMenuItem.font", dialogPlain);
        UIManager.getDefaults().put("Menu.font", dialogPlain);
        UIManager.getDefaults().put("PopupMenu.font", dialogPlain);
        UIManager.getDefaults().put("OptionPane.font", dialogPlain);
        UIManager.getDefaults().put("Panel.font", dialogPlain);
        UIManager.getDefaults().put("ProgressBar.font", dialogPlain);
        UIManager.getDefaults().put("ScrollPane.font", dialogPlain);
        UIManager.getDefaults().put("Viewport.font", dialogPlain);
        UIManager.getDefaults().put("TabbedPane.font", dialogPlain);
        UIManager.getDefaults().put("Table.font", dialogPlain);
        UIManager.getDefaults().put("TableHeader.font", dialogPlain);
        UIManager.getDefaults().put("TextField.font", sansSerifPlain);
        UIManager.getDefaults().put("PasswordField.font", monospacedPlain);
        UIManager.getDefaults().put("TextArea.font", monospacedPlain);
        UIManager.getDefaults().put("TextPane.font", serifPlain);
        UIManager.getDefaults().put("EditorPane.font", serifPlain);
        UIManager.getDefaults().put("TitledBorder.font", dialogPlain);
        UIManager.getDefaults().put("ToolBar.font", dialogPlain);
        UIManager.getDefaults().put("ToolTip.font", sansSerifPlain);
        UIManager.getDefaults().put("Tree.font", dialogPlain);
    }

    public void showToolInfo() {
        JEUSBuilderInfo info = new JEUSBuilderInfo(this);
        Dimension dlgSize = info.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        info.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        info.show();
    }

    public static void main(String[] args) {
        FileUtils.removeAssemblyDir();
        FileUtils.removeEarArchiveDir();
        SplashWindow splash = new SplashWindow(SwingUtils.createIcon("/jeus/tool/builder/images/jeus_splash.jpg"), null, 150000);
        WIOConfig config = new WIOConfig();
        config.setLanguage("english");
        try {
            MsgRscManager.initResourceManager(config.getLanguage());
        }
        catch (WIOBuilderException e) {
            e.printStackTrace();
        }
        builder = JEUSBuilder.createWIOBuilder(MsgRscManager.getString("jeus.builder.title"), config);
        splash.dispose();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = builder.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        builder.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        builder.setVisible(true);
    }

    static {
        fileContentsChanged = false;
    }

    class JEUSBuilderInfo
    extends JDialog
    implements ActionListener {
        JButton okButton;

        public JEUSBuilderInfo(Frame parent) {
            super(parent);
            this.enableEvents(64L);
            try {
                this.initGUI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pack();
        }

        private void initGUI() throws Exception {
            this.okButton = new JButton(MsgRscManager.getString("dlg.common.ok"));
            this.okButton.addActionListener(this);
            JLabel imgLabel = new JLabel(SwingUtils.createIcon("/jeus/tool/builder/images/jeus_about.jpg"));
            JPanel infoPanel = new JPanel(new BorderLayout());
            infoPanel.add((Component)imgLabel, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.add(this.okButton);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)infoPanel, "Center");
            mainPanel.add((Component)buttonPanel, "South");
            this.setTitle(MsgRscManager.getString("dlg.about.title"));
            this.setResizable(false);
            this.setModal(true);
            this.getContentPane().add((Component)mainPanel, null);
        }

        protected void processWindowEvent(WindowEvent e) {
            if (e.getID() == 201) {
                this.cancel();
            }
            super.processWindowEvent(e);
        }

        void cancel() {
            this.dispose();
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.okButton) {
                this.cancel();
            }
        }
    }
}

