/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.xml;

import java.util.ArrayList;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.xml.AppClientModuleXMLInsp;
import jeus.tool.builder.inspector.xml.EJBModuleXMLInsp;
import jeus.tool.builder.inspector.xml.ModuleXMLInspector;
import jeus.tool.builder.inspector.xml.ResourceAdapterModuleXMLInsp;
import jeus.tool.builder.inspector.xml.WebModuleXMLInsp;
import jeus.tool.builder.inspector.xml.XMLInspector;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class J2EEApplicationXMLInsp
extends ModuleXMLInspector {
    private static final String MODULE = "module";
    private static final String EJB = "ejb";
    private static final String WEB = "web";
    private static final String JAVA = "java";
    private static final String CONNECTOR = "connector";
    private final String WEB_URI = "web-uri";

    public J2EEApplicationXMLInsp(IDeployUnit deployUnit) {
        super(deployUnit, ModuleType.EAR, "META-INF/application.xml");
    }

    public String getType() {
        return "J2EEApplication";
    }

    public String getJ2eeConfigPath() {
        return "/application";
    }

    public String getJ2eeConfigUIName() {
        return "application";
    }

    public String getJeusConfigPath() {
        return null;
    }

    public String getJeusConfigUIName() {
        return null;
    }

    public XMLInspector[] getChildren() {
        if (!this.dirty && this.children != null) {
            return this.children;
        }
        Vector modules = XMLUtil.getChildNodes(this.j2eeElement, MODULE);
        ArrayList<XMLInspector> result = new ArrayList<XMLInspector>();
        for (int i = 0; i < modules.size(); ++i) {
            Element module = (Element)modules.get(i);
            XMLInspector insp = this.createXMLInspector(module);
            if (insp == null) continue;
            result.add(insp);
        }
        this.children = result.toArray(new XMLInspector[result.size()]);
        this.dirty = false;
        return this.children;
    }

    private XMLInspector createXMLInspector(Element module) {
        String path;
        Vector ejb = XMLUtil.getChildNodes(module, EJB);
        for (int i = 0; i < ejb.size(); ++i) {
            Element tree = (Element)ejb.get(i);
            String path2 = XMLUtil.getValue(tree);
            try {
                IDeployUnit ejbUnit = this.deployUnit.getEmbeddedModuleDescriptor(path2);
                return new EJBModuleXMLInsp(ejbUnit);
            }
            catch (Exception e) {
                continue;
            }
        }
        Vector web = XMLUtil.getChildNodes(module, WEB);
        for (int i = 0; i < web.size(); ++i) {
            Element tree = (Element)web.get(i);
            Element weburi = XMLUtil.getFirstElement(tree, "web-uri");
            path = XMLUtil.getValue(weburi);
            try {
                IDeployUnit warUnit = this.deployUnit.getEmbeddedModuleDescriptor(path);
                return new WebModuleXMLInsp(warUnit);
            }
            catch (Exception e) {
                continue;
            }
        }
        Vector java = XMLUtil.getChildNodes(module, JAVA);
        for (int i = 0; i < java.size(); ++i) {
            Element tree = (Element)java.get(i);
            path = XMLUtil.getValue(tree);
            try {
                IDeployUnit javaUnit = this.deployUnit.getEmbeddedModuleDescriptor(path);
                return new AppClientModuleXMLInsp(javaUnit);
            }
            catch (Exception e) {
                continue;
            }
        }
        Vector connector = XMLUtil.getChildNodes(module, CONNECTOR);
        for (int i = 0; i < connector.size(); ++i) {
            Element tree = (Element)connector.get(i);
            String path3 = XMLUtil.getValue(tree);
            try {
                IDeployUnit connectorUnit = this.deployUnit.getEmbeddedModuleDescriptor(path3);
                return new ResourceAdapterModuleXMLInsp(connectorUnit);
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    public String getUniqueId() {
        return "<J2EEApplication[name='" + this.getName() + "']>";
    }
}

