/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.module;

import java.io.File;
import java.io.FileWriter;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.archivist.AbstractArchive;
import jeus.tool.builder.Constants;

public class EmptyDescriptor {
    public static void makeJ2eeDescriptor(AbstractArchive archive, ModuleType moduleType) {
        EmptyDescriptor.makeDescriptor(archive, moduleType, " xmlns=\"http://java.sun.com/xml/ns/j2ee\"", EmptyDescriptor.getJ2eeRootElement(moduleType), EmptyDescriptor.getJ2eeFileName(moduleType));
    }

    public static void makeJeusDescriptor(AbstractArchive archive, ModuleType moduleType) {
        EmptyDescriptor.makeDescriptor(archive, moduleType, " xmlns=\"http://www.tmaxsoft.com/xml/ns/jeus\"", EmptyDescriptor.getJeusRootElement(moduleType), EmptyDescriptor.getJeusFileName(moduleType));
    }

    public static void makeJ2eeWebserviceDescriptor(AbstractArchive archive, ModuleType moduleType) {
        EmptyDescriptor.makeDescriptor(archive, moduleType, " xmlns=\"http://java.sun.com/xml/ns/j2ee\"", "webservices", "webservices.xml");
    }

    public static void makeJeusWebserviceDescriptor(AbstractArchive archive, ModuleType moduleType) {
        EmptyDescriptor.makeDescriptor(archive, moduleType, " xmlns=\"http://www.tmaxsoft.com/xml/ns/jeus\"", "jeus-webservices-dd", "jeus-webservices-dd.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeDescriptor(AbstractArchive archive, ModuleType moduleType, String nameSpace, String rootElementName, String fileName) {
        File file;
        String sourceUri = archive.getArchiveUri();
        String infContext = "META-INF";
        if (moduleType.equals(ModuleType.WAR)) {
            infContext = "WEB-INF";
        }
        if ((file = new File(sourceUri + File.separator + infContext + Constants.FS + fileName)).exists()) {
            return;
        }
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            writer.write("<" + rootElementName + nameSpace + ">\n");
            if (fileName.equals("jeus-application-dd.xml")) {
                writer.write("<deployment-type>EAR</deployment-type>");
            }
            writer.write("</" + rootElementName + ">\n");
            writer.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (file != null) {
                    file = null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static String getJ2eeFileName(ModuleType moduleType) {
        if (moduleType.equals(ModuleType.EAR)) {
            return "application.xml";
        }
        if (moduleType.equals(ModuleType.EJB)) {
            return "ejb-jar.xml";
        }
        if (moduleType.equals(ModuleType.WAR)) {
            return "web.xml";
        }
        if (moduleType.equals(ModuleType.RAR)) {
            return "ra.xml";
        }
        if (moduleType.equals(ModuleType.CAR)) {
            return "application-client.xml";
        }
        return null;
    }

    private static String getJ2eeRootElement(ModuleType moduleType) {
        if (moduleType.equals(ModuleType.EAR)) {
            return "application";
        }
        if (moduleType.equals(ModuleType.EJB)) {
            return "ejb-jar";
        }
        if (moduleType.equals(ModuleType.WAR)) {
            return "web-app";
        }
        if (moduleType.equals(ModuleType.RAR)) {
            return "connector";
        }
        if (moduleType.equals(ModuleType.CAR)) {
            return "application-client";
        }
        return null;
    }

    private static String getJeusFileName(ModuleType moduleType) {
        if (moduleType.equals(ModuleType.EAR)) {
            return "jeus-application-dd.xml";
        }
        if (moduleType.equals(ModuleType.EJB)) {
            return "jeus-ejb-dd.xml";
        }
        if (moduleType.equals(ModuleType.WAR)) {
            return "jeus-web-dd.xml";
        }
        if (moduleType.equals(ModuleType.RAR)) {
            return "jeus-connector-dd.xml";
        }
        if (moduleType.equals(ModuleType.CAR)) {
            return "jeus-client-dd.xml";
        }
        return null;
    }

    private static String getJeusRootElement(ModuleType moduleType) {
        if (moduleType.equals(ModuleType.EAR)) {
            return "application";
        }
        if (moduleType.equals(ModuleType.EJB)) {
            return "jeus-ejb-dd";
        }
        if (moduleType.equals(ModuleType.WAR)) {
            return "jeus-web-dd";
        }
        if (moduleType.equals(ModuleType.RAR)) {
            return "jeus-connector-dd";
        }
        if (moduleType.equals(ModuleType.CAR)) {
            return "jeus-client-dd";
        }
        return null;
    }
}

