/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.module;

import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.tool.builder.constant.WIOParameter;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.module.AbstractModuleDescriptor;
import jeus.tool.builder.module.desc.CARModuleDescriptor;
import jeus.tool.builder.module.desc.EARModuleDescriptor;
import jeus.tool.builder.module.desc.EJBModuleDescriptor;
import jeus.tool.builder.module.desc.RARModuleDescriptor;
import jeus.tool.builder.module.desc.WARModuleDescriptor;

public class ModuleDescriptorFacade {
    public static IDeployUnit getModuleDescriptor(AbstractArchive archive) {
        ModuleType moduleType = JeusDeploymentManager.getModuleType(archive);
        if (moduleType == null) {
            throw new RuntimeException(archive.getArchiveUri() + ":module type must be decided");
        }
        return ModuleDescriptorFacade.getModuleDescriptor(archive, moduleType);
    }

    public static IDeployUnit getModuleDescriptor(AbstractArchive archive, boolean isEmbbedded) {
        ModuleType moduleType = JeusDeploymentManager.getModuleType(archive);
        if (moduleType == null) {
            throw new RuntimeException(archive.getArchiveUri() + ":module type must be decided");
        }
        return ModuleDescriptorFacade.getModuleDescriptor(archive, moduleType, isEmbbedded);
    }

    public static IDeployUnit getModuleDescriptor(AbstractArchive archive, ModuleType moduleType) {
        return ModuleDescriptorFacade.getModuleDescriptor(archive, moduleType, false);
    }

    public static IDeployUnit getModuleDescriptor(AbstractArchive archive, ModuleType moduleType, boolean isEmbedded) {
        AbstractModuleDescriptor md = null;
        if (moduleType == ModuleType.EAR) {
            md = new EARModuleDescriptor(archive, isEmbedded);
        } else if (moduleType == ModuleType.EJB) {
            md = new EJBModuleDescriptor(archive, isEmbedded);
        } else if (moduleType == ModuleType.CAR) {
            md = new CARModuleDescriptor(archive, isEmbedded);
        } else if (moduleType == ModuleType.RAR) {
            md = new RARModuleDescriptor(archive, isEmbedded);
        } else if (moduleType == ModuleType.WAR) {
            md = new WARModuleDescriptor(archive, isEmbedded);
        } else {
            String uri = archive.getArchiveUri();
            int index = uri.lastIndexOf(WIOParameter.FS);
            throw new RuntimeException("unsupported module type:" + uri.substring(index + 1));
        }
        return md;
    }
}

