/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.tree;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class FileTreeNode
implements TreeNode {
    private static final String ROOT_NODE_NAME = "My Computer";
    private static final String NAME_NOT_SET = "NOT SET";
    private String nodeName;
    private Vector children = new Vector();
    private FileTreeNode parentNode;
    private File myFile;

    public FileTreeNode(File myFile, FileTreeNode parentNode) {
        this.myFile = myFile;
        this.nodeName = myFile != null ? myFile.getName() : NAME_NOT_SET;
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.addChild(this);
        }
    }

    public File getFile() {
        return this.myFile;
    }

    public String getName() {
        return this.nodeName;
    }

    public void setName(String name) {
        this.nodeName = name;
    }

    public void addChild(FileTreeNode child) {
        this.children.add(child);
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.elementAt(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        if (this.nodeName != null && this.nodeName.equals(ROOT_NODE_NAME)) {
            return this.nodeName;
        }
        if (this.myFile == null) {
            return NAME_NOT_SET;
        }
        String name = this.myFile.getName();
        if (name == null || name.trim().equals("")) {
            name = this.myFile.getPath();
        }
        if (name == null || name.trim().equals("")) {
            name = this.myFile.toString();
        }
        if (name == null || name.trim().equals("")) {
            name = NAME_NOT_SET;
        }
        return name;
    }
}

