/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jeus.tool.builder.inspector.mbean.MBeanInspector;
import jeus.tool.builder.inspector.mbean.ModuleMBeanInspector;

public class JEUSTreeNode
implements MutableTreeNode {
    private MBeanInspector insp;
    private JEUSTreeNode parentNode;
    private ArrayList children;

    public JEUSTreeNode(MBeanInspector insp) {
        this.insp = insp;
    }

    public JEUSTreeNode(MBeanInspector insp, JEUSTreeNode parentNode) {
        this.insp = insp;
        this.parentNode = parentNode;
    }

    public Enumeration children() {
        this.checkChildren();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public TreeNode getChildAt(int childIndex) {
        this.checkChildren();
        if (this.children.size() < childIndex + 1) {
            return null;
        }
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        this.checkChildren();
        for (int i = 0; i < this.children.size(); ++i) {
            if (node != this.children.get(i)) continue;
            return i;
        }
        return -1;
    }

    void removeChild(JEUSTreeNode child) {
        this.checkChildren();
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public void refresh(DefaultTreeModel model) {
        JEUSTreeNode node;
        int i;
        JEUSTreeNode parent;
        if (!this.insp.exists() && (parent = (JEUSTreeNode)this.getParent()) != null) {
            model.removeNodeFromParent(this);
            parent.refresh(model);
            return;
        }
        if (this.insp instanceof ModuleMBeanInspector) {
            ((ModuleMBeanInspector)this.insp).updateState();
        }
        if (this.children != null && this.children.size() > 0) {
            ArrayList<JEUSTreeNode> removeList = new ArrayList<JEUSTreeNode>();
            for (i = 0; i < this.children.size(); ++i) {
                node = (JEUSTreeNode)this.children.get(i);
                if (!node.getMBeanInspector().exists()) {
                    removeList.add(node);
                    continue;
                }
                node.refresh(model);
            }
            for (i = 0; i < removeList.size(); ++i) {
                node = (JEUSTreeNode)removeList.get(i);
                model.removeNodeFromParent(node);
            }
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        try {
            MBeanInspector[] childInsps = this.insp.getChildren();
            for (i = 0; i < childInsps.length; ++i) {
                node = new JEUSTreeNode(childInsps[i], this);
                if (this.children.contains(node)) continue;
                model.insertNodeInto(node, this, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            try {
                MBeanInspector[] childInsps = this.insp.getChildren();
                for (int i = 0; i < childInsps.length; ++i) {
                    this.children.add(new JEUSTreeNode(childInsps[i], this));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
    }

    public void remove(int index) {
        this.children.remove(index);
    }

    public void remove(MutableTreeNode node) {
        this.children.remove(node);
    }

    public void removeFromParent() {
        this.parentNode.removeChild(this);
    }

    public void setParent(MutableTreeNode newParent) {
        this.parentNode = (JEUSTreeNode)newParent;
    }

    public void setUserObject(Object object) {
        this.insp = (MBeanInspector)object;
    }

    public MBeanInspector getMBeanInspector() {
        return this.insp;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof JEUSTreeNode) {
            return ((JEUSTreeNode)o).getMBeanInspector().equals(this.insp);
        }
        return false;
    }

    public String toString() {
        return this.insp.getJ2eeType() + ":" + this.insp.getJeusType() + ":" + this.insp.getName();
    }
}

