/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jeus.tool.builder.Constants;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.xml.AppClientModuleXMLInsp;
import jeus.tool.builder.inspector.xml.EJBModuleXMLInsp;
import jeus.tool.builder.inspector.xml.J2EEApplicationXMLInsp;
import jeus.tool.builder.inspector.xml.ModuleXMLInspector;
import jeus.tool.builder.inspector.xml.ResourceAdapterModuleXMLInsp;
import jeus.tool.builder.inspector.xml.WebModuleXMLInsp;
import jeus.tool.builder.inspector.xml.XMLInspector;
import jeus.tool.builder.ui.MessagePanel;
import jeus.tool.builder.wizard.WizardEvent;
import jeus.tool.builder.wizard.WizardEventListener;
import jeus.tool.builder.wizard.WizardPanel;
import jeus.tool.builder.wizard.deploy.ModuleTreeCellRenderer;
import jeus.tool.builder.wizard.deploy.ModuleTreeNode;
import jeus.tool.xmlui.XMLUIDialog;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.ChangeHistory;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUIEvent;
import jeus.tool.xmlui.engine.XMLUIListener;
import jeus.tool.xmlui.engine.XMLUINotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DescriptorEditPanel
extends JPanel
implements WizardPanel,
WizardEventListener,
TreeSelectionListener,
ChangeListener,
XMLUIListener {
    public static final String ID = "jeus.tool.builder.deploy.edit-descriptor";
    private ModuleXMLInspector insp;
    private XMLUIEngine engine;
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane treeScrollPane = new JScrollPane();
    private JTree moduleTree = new JTree();
    JTabbedPane configTab = new JTabbedPane();
    private static ModuleTreeNode currentNode;
    private TreePath currentSelectionPath;
    private XMLUIPanel currentJ2eePane;
    private XMLUIPanel currentJeusPane;
    private int selectedTabIndex = -1;
    private Hashtable introspectHashtable;
    private static ModuleType moduleType;
    private Hashtable parentXmlUIPanelsTable = new Hashtable();

    public DescriptorEditPanel(IDeployUnit deployUnit, XMLUIEngine engine, Hashtable introspectHashtable) {
        this.engine = engine;
        this.introspectHashtable = introspectHashtable;
        this.insp = this.getModuleXMLInspector(deployUnit);
        this.initializeUI();
    }

    private ModuleXMLInspector getModuleXMLInspector(IDeployUnit deployUnit) {
        if (deployUnit.getModuleType().equals(ModuleType.EAR)) {
            moduleType = ModuleType.EAR;
            return new J2EEApplicationXMLInsp(deployUnit);
        }
        if (deployUnit.getModuleType().equals(ModuleType.EJB)) {
            moduleType = ModuleType.EJB;
            return new EJBModuleXMLInsp(deployUnit);
        }
        if (deployUnit.getModuleType().equals(ModuleType.WAR)) {
            moduleType = ModuleType.WAR;
            return new WebModuleXMLInsp(deployUnit);
        }
        if (deployUnit.getModuleType().equals(ModuleType.RAR)) {
            moduleType = ModuleType.RAR;
            return new ResourceAdapterModuleXMLInsp(deployUnit);
        }
        moduleType = ModuleType.CAR;
        return new AppClientModuleXMLInsp(deployUnit);
    }

    private void initializeUI() {
        this.moduleTree.setCellRenderer(new ModuleTreeCellRenderer());
        this.moduleTree.setModel(new DefaultTreeModel(new ModuleTreeNode(this.insp), true));
        this.moduleTree.setPreferredSize(new Dimension(200, 0));
        this.moduleTree.setMinimumSize(new Dimension(200, 0));
        this.currentSelectionPath = this.moduleTree.getSelectionPath();
        this.treeScrollPane.getViewport().add(this.moduleTree);
        this.splitPane.setLeftComponent(this.treeScrollPane);
        this.splitPane.setRightComponent(this.configTab);
        this.splitPane.setDividerSize(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        currentNode = (ModuleTreeNode)this.moduleTree.getModel().getRoot();
        this.updateTab(this.insp);
        if (this.configTab.getTabCount() > 0) {
            this.selectedTabIndex = 0;
        }
        this.moduleTree.setSelectionRow(0);
        this.moduleTree.addTreeSelectionListener(this);
        this.configTab.addChangeListener(this);
    }

    public String getWizardPanelID() {
        return ID;
    }

    public synchronized void valueChanged(TreeSelectionEvent e) {
        ModuleTreeNode node = (ModuleTreeNode)e.getPath().getLastPathComponent();
        if (currentNode == node) {
            return;
        }
        if (!this.updateXMLTree()) {
            this.moduleTree.setSelectionPath(this.currentSelectionPath);
            return;
        }
        this.adjust();
        this.selectedTabIndex = 0;
        currentNode = node;
        this.currentSelectionPath = e.getPath();
        this.updateTab(currentNode.getXMLInspector());
        if (this.configTab.getTabCount() < 0) {
            this.selectedTabIndex = 0;
        }
    }

    private boolean updateXMLTree() {
        Vector message;
        Component selected = this.configTab.getSelectedComponent();
        Vector mergedMessages = new Vector();
        Element j2eeElement = null;
        Element jeusElement = null;
        if (this.currentJ2eePane == selected) {
            j2eeElement = (Element)this.currentJ2eePane.getValue();
            message = this.currentJ2eePane.getMessage();
            if (message != null && message.size() > 0) {
                mergedMessages.addAll(message);
            }
        }
        if (this.currentJeusPane == selected) {
            jeusElement = (Element)this.currentJeusPane.getValue();
            message = this.currentJeusPane.getMessage();
            if (message != null && message.size() > 0) {
                mergedMessages.addAll(message);
            }
        }
        if (mergedMessages.size() > 0) {
            XMLUIDialog dlg = XMLUIDialog.getIgnorableDlg(mergedMessages);
            if (dlg != null) {
                dlg.showDialog();
                return !dlg.getOk();
            }
        } else {
            if (this.currentJ2eePane == selected) {
                currentNode.getXMLInspector().setJ2eeElement(j2eeElement);
            }
            if (this.currentJeusPane == selected) {
                currentNode.getXMLInspector().setJeusElement(jeusElement);
            }
        }
        return true;
    }

    public static Vector getCurrentSelectedModuleInfo() {
        Vector<Object> v = new Vector<Object>();
        v.add(moduleType);
        v.add(currentNode.getXMLInspector().getName());
        v.add(currentNode.getXMLInspector().getType());
        return v;
    }

    public Document[] getDocuments() {
        Element ele;
        if (!this.updateXMLTree()) {
            return null;
        }
        this.adjust();
        ModuleTreeNode rootNode = (ModuleTreeNode)this.moduleTree.getModel().getRoot();
        Document j2eeDocument = rootNode.getXMLInspector().getJ2eeElement().getOwnerDocument();
        String moduletype = rootNode.getXMLInspector().getType();
        if (moduletype.equals("J2EEApplication")) {
            ele = j2eeDocument.getDocumentElement();
            ele.setAttribute("version", "1.4");
        } else if (moduletype.equals("ResourceAdapterModule")) {
            ele = j2eeDocument.getDocumentElement();
            ele.setAttribute("version", "1.5");
        }
        Document jeusDocument = null;
        Element jeusElement = rootNode.getXMLInspector().getJeusElement();
        if (jeusElement != null) {
            jeusDocument = jeusElement.getOwnerDocument();
        }
        return new Document[]{j2eeDocument, jeusDocument};
    }

    public XMLInspector[] getEmbeddedXMLInspectors() {
        ModuleTreeNode rootNode = (ModuleTreeNode)this.moduleTree.getModel().getRoot();
        ArrayList<XMLInspector> result = new ArrayList<XMLInspector>();
        Enumeration enum1 = rootNode.children();
        while (enum1.hasMoreElements()) {
            ModuleTreeNode node = (ModuleTreeNode)enum1.nextElement();
            XMLInspector xmlInspector = node.getXMLInspector();
            if (!(xmlInspector instanceof ModuleXMLInspector)) continue;
            result.add(xmlInspector);
        }
        return result.toArray(new XMLInspector[result.size()]);
    }

    public Hashtable getParentXmlUIPanels() {
        return this.parentXmlUIPanelsTable;
    }

    private void updateTab(XMLInspector inspector) {
        this.updateJ2eePanel(inspector);
        this.updateJeusPanel(inspector);
        this.configTab.updateUI();
    }

    private void updateJ2eePanel(XMLInspector inspector) {
        if (this.currentJ2eePane != null) {
            this.configTab.removeChangeListener(this);
            this.configTab.remove(this.currentJ2eePane);
            this.configTab.addChangeListener(this);
        }
        String configUiName = inspector.getJ2eeConfigUIName();
        Element j2eeTree = inspector.getJ2eeElement();
        if (j2eeTree != null) {
            try {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("jeus.tool.xmlui.symbols", new HashMap(inspector.getSymbols()));
                attrs.put("jeus.tool.xmlui.history", new ChangeHistory());
                String type = inspector.getType();
                String rootType = ((ModuleTreeNode)this.moduleTree.getModel().getRoot()).getXMLInspector().getType();
                if ("J2EEApplication".equals(rootType)) {
                    if ("J2EEApplication".equals(type)) {
                        attrs.put("EAR_Inspector", this.introspectHashtable.get("EAR_Inspector"));
                    } else {
                        Hashtable temp = null;
                        if ("EJBModule".equals(type)) {
                            String moduleName = inspector.getName();
                            String classpath = Constants.JEUS_ASSEMBLY_DIR + Constants.FS + moduleName + ".jar";
                            temp = (Hashtable)this.introspectHashtable.get("Entity_Bean_Inspector");
                            if (temp != null) {
                                attrs.put("Entity_Bean_Inspector", temp.get(moduleName));
                            }
                            if ((temp = (Hashtable)this.introspectHashtable.get("Session_Bean_Inspector")) != null) {
                                attrs.put("Session_Bean_Inspector", temp.get(moduleName));
                            }
                            if ((temp = (Hashtable)this.introspectHashtable.get("Message_Driven_Bean_Inspector")) != null) {
                                attrs.put("Message_Driven_Bean_Inspector", temp.get(moduleName));
                            }
                        } else {
                            ModuleTreeNode selectedNode = (ModuleTreeNode)this.moduleTree.getSelectionPath().getLastPathComponent();
                            XMLInspector parentXMLInspector = ((ModuleTreeNode)selectedNode.getParent()).getXMLInspector();
                            String moduleName = parentXMLInspector.getName();
                            String classpath = Constants.JEUS_ASSEMBLY_DIR + Constants.FS + moduleName + ".jar";
                            if ("StatelessSessionBean".equals(type) || "StatefulSessionBean".equals(type)) {
                                temp = (Hashtable)this.introspectHashtable.get("Session_Bean_Inspector");
                                if (temp != null) {
                                    attrs.put("Session_Bean_Inspector", temp.get(moduleName));
                                }
                            } else if ("EntityBean".equals(type)) {
                                temp = (Hashtable)this.introspectHashtable.get("Entity_Bean_Inspector");
                                if (temp != null) {
                                    attrs.put("Entity_Bean_Inspector", temp.get(moduleName));
                                }
                            } else if ("MessageDrivenBean".equals(type) && (temp = (Hashtable)this.introspectHashtable.get("Message_Driven_Bean_Inspector")) != null) {
                                attrs.put("Message_Driven_Bean_Inspector", temp.get(moduleName));
                            }
                        }
                    }
                } else if ("EJBModule".equals(rootType)) {
                    Object ejbInsp = null;
                    if ("EJBModule".equals(type)) {
                        ejbInsp = this.introspectHashtable.get("Entity_Bean_Inspector");
                        if (ejbInsp != null) {
                            attrs.put("Entity_Bean_Inspector", ejbInsp);
                        }
                        if ((ejbInsp = (Object)this.introspectHashtable.get("Session_Bean_Inspector")) != null) {
                            attrs.put("Session_Bean_Inspector", ejbInsp);
                        }
                        if ((ejbInsp = (Object)this.introspectHashtable.get("Message_Driven_Bean_Inspector")) != null) {
                            attrs.put("Message_Driven_Bean_Inspector", ejbInsp);
                        }
                    } else if ("StatelessSessionBean".equals(type) || "StatefulSessionBean".equals(type)) {
                        ejbInsp = this.introspectHashtable.get("Session_Bean_Inspector");
                        if (ejbInsp != null) {
                            attrs.put("Session_Bean_Inspector", ejbInsp);
                        }
                    } else if ("EntityBean".equals(type)) {
                        ejbInsp = this.introspectHashtable.get("Entity_Bean_Inspector");
                        if (ejbInsp != null) {
                            attrs.put("Entity_Bean_Inspector", ejbInsp);
                        }
                    } else if ("MessageDrivenBean".equals(type) && (ejbInsp = (Object)this.introspectHashtable.get("Message_Driven_Bean_Inspector")) != null) {
                        attrs.put("Message_Driven_Bean_Inspector", ejbInsp);
                    }
                }
                this.currentJ2eePane = this.engine.getXMLUIPanel(j2eeTree.cloneNode(true), configUiName, inspector.getJ2eeConfigPath(), attrs);
                this.configTab.add(this.currentJ2eePane.getDisplayName(), this.currentJ2eePane);
                this.parentXmlUIPanelsTable.put(currentNode.getXMLInspector().getName() + "_" + configUiName, this.currentJ2eePane);
            }
            catch (XMLUINotFoundException e1) {
                this.currentJ2eePane = null;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            this.currentJ2eePane = null;
        }
        if (this.currentJ2eePane == null) {
            return;
        }
        this.currentJ2eePane.getSession().addXMLUIListener(this);
    }

    private void updateJeusPanel(XMLInspector inspector) {
        Element jeusTree;
        if (this.currentJeusPane != null) {
            this.configTab.removeChangeListener(this);
            this.configTab.remove(this.currentJeusPane);
            this.configTab.addChangeListener(this);
        }
        if ((jeusTree = inspector.getJeusElement()) != null) {
            try {
                String configUiName = inspector.getJeusConfigUIName();
                this.currentJeusPane = this.engine.getXMLUIPanel(jeusTree.cloneNode(true), configUiName, inspector.getJeusConfigPath());
                this.configTab.add(this.currentJeusPane.getDisplayName(), this.currentJeusPane);
                this.parentXmlUIPanelsTable.put(currentNode.getXMLInspector().getName() + "_" + configUiName, this.currentJeusPane);
            }
            catch (XMLUINotFoundException e1) {
                e1.printStackTrace();
                this.currentJeusPane = null;
            }
        } else {
            this.currentJeusPane = null;
        }
    }

    public synchronized void stateChanged(ChangeEvent e) {
        if (this.selectedTabIndex < 0) {
            return;
        }
        XMLUIPanel panel = (XMLUIPanel)this.configTab.getComponentAt(this.selectedTabIndex);
        Element newTree = (Element)panel.getValue();
        Vector message = panel.getMessage();
        if (message != null && message.size() > 0) {
            XMLUIDialog dlg = XMLUIDialog.getIgnorableDlg(message);
            dlg.showDialog();
            if (dlg.getOk()) {
                this.configTab.removeChangeListener(this);
                this.configTab.setSelectedIndex(this.selectedTabIndex);
                this.configTab.addChangeListener(this);
                return;
            }
        }
        if (panel == this.currentJ2eePane) {
            this.refresh(newTree);
            this.adjust();
            if (this.currentJeusPane != null && currentNode.getXMLInspector().getJeusElement() != null) {
                this.currentJeusPane.setValue(currentNode.getXMLInspector().getJeusElement().cloneNode(true));
            }
        } else {
            currentNode.getXMLInspector().setJeusElement(newTree);
        }
        this.selectedTabIndex = this.configTab.getSelectedIndex();
    }

    public void begin(WizardEvent event) {
    }

    public void cancel(WizardEvent event) {
    }

    public void finish(WizardEvent event) {
    }

    public void previous(WizardEvent event) {
        this.next(event);
    }

    public void next(WizardEvent event) {
        if (!event.getWizardPanelID().equals(ID)) {
            return;
        }
        this.updateXMLTree();
    }

    public XMLInspector getXMLInspector() {
        return this.insp;
    }

    protected boolean adjust() {
        try {
            ModuleXMLInspector modinsp = null;
            for (ModuleTreeNode node = currentNode; node != null; node = (ModuleTreeNode)node.getParent()) {
                if (!(node.getXMLInspector() instanceof ModuleXMLInspector)) continue;
                modinsp = (ModuleXMLInspector)node.getXMLInspector();
                break;
            }
            if (modinsp != null) {
                if (modinsp.getJeusElement() != null) {
                    ChangeHistory history = (ChangeHistory)this.currentJ2eePane.getSession().getAttribute("jeus.tool.xmlui.history");
                    history.execute(modinsp.getJeusElement().getOwnerDocument());
                }
                modinsp.adjust();
            }
        }
        catch (Exception e) {
            e.printStackTrace(MessagePanel.getDebugPrintStream());
            return false;
        }
        return true;
    }

    public void xmlChanged(XMLUIEvent event) {
        this.refresh((Element)this.currentJ2eePane.getValue());
    }

    private void refresh(Element newTree) {
        currentNode.refresh((DefaultTreeModel)this.moduleTree.getModel(), newTree);
        this.moduleTree.repaint();
    }
}

