/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.tool.builder.Constants;
import jeus.tool.builder.JEUSBuilder;
import jeus.tool.builder.module.ModuleUtil;
import jeus.tool.builder.ui.DefaultFileFilter;
import jeus.tool.builder.ui.MessagePanel;
import jeus.tool.builder.ui.common.FileDirMapDescriptor;
import jeus.tool.builder.ui.common.FileTreeNodeRenderer;
import jeus.tool.builder.ui.wizard.ModuleClassPathDlg;
import jeus.tool.builder.util.ArchiveUtil;
import jeus.tool.builder.util.ClassUtil;
import jeus.tool.builder.util.FileUtils;
import jeus.tool.builder.util.StringUtil;
import jeus.tool.util.FileUtil;
import jeus.util.JarExtractor;
import jeus.util.JeusBootstrapProperties;

public class FileContentsChooserPanel
extends JPanel {
    JTextField topDirectoryTF = new JTextField(JeusBootstrapProperties.JEUS_HOME);
    JButton topBT = new JButton("Browse");
    JTree fileContentTree = new JTree();
    private FileDirMapDescriptor fileDirectoryMap;
    private FilenameFilter filenameFilter = new FileNameFilterDefault();
    JTextField tfArchiveFilePath = new JTextField();
    JComboBox cbFileType = new JComboBox();
    JComboBox cbModuleType = new JComboBox<String>(new String[]{"Application(ear)", "Enterprise Bean(jar)", "Application Client(jar)", "Resouce Adapter(rar)", "Web Component(war)"});
    JComboBox cbEarDisplayMode = new JComboBox<String>(new String[]{"Archive", "Extraction"});
    private static final int Ear_Display_Mode_Archive = 0;
    private static final int Ear_Display_Mode_Extraction = 1;
    private JFrame mainFrame = null;
    private static boolean DLG_WORK_MODE_NEW;
    JTree selectedFileContentsTree;
    DefaultMutableTreeNode contentsRootNode;
    TreeModel contentTreeModel;
    JPanel selectedFileBtnPanel;
    private static final int SEARCH_TYPE_ARCHIVE_FILE = 1;
    private static final int SEARCH_TYPE_ALL_FILE = 2;
    private static final String FS;
    private static final int FILE_TYPE_ALL = 0;
    private static final int FILE_TYPE_CLASS = 1;
    private static final int FILE_TYPE_JSP = 2;
    private static final int FILE_TYPE_JAR = 3;

    public FileContentsChooserPanel(JFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.createGuiAndShow();
        this.refreshTree();
    }

    public void init() {
        this.cbModuleType.setEnabled(true);
        this.cbModuleType.setSelectedIndex(1);
        this.tfArchiveFilePath.setText("");
        this.topDirectoryTF.setText(JeusBootstrapProperties.JEUS_HOME);
        this.changeDirectoryAction();
        this.cbFileType.setSelectedIndex(0);
        this.contentsRootNode.removeAllChildren();
        ((DefaultTreeModel)this.contentTreeModel).reload();
    }

    public void init(ModuleType moduleType, String filePath) {
        this.cbModuleType.setEnabled(false);
        this.cbModuleType.setSelectedIndex(moduleType.getValue());
        this.tfArchiveFilePath.setText(filePath);
        this.topDirectoryTF.setText(JeusBootstrapProperties.JEUS_HOME);
        this.changeDirectoryAction();
        this.cbFileType.setSelectedIndex(0);
        this.contentsRootNode.removeAllChildren();
        ((DefaultTreeModel)this.contentTreeModel).reload();
    }

    public void setDlgWorkMode(boolean b) {
        DLG_WORK_MODE_NEW = b;
    }

    public String getModuleName() {
        return ModuleUtil.getModuleName(this.tfArchiveFilePath.getText().trim());
    }

    public String getArchiveFilePath() {
        return this.tfArchiveFilePath.getText().trim();
    }

    public void setArchiveFilePath(String filePath) {
        this.tfArchiveFilePath.setText(filePath);
    }

    public void setCBModuleType(ModuleType moduleType) {
        int index = -1;
        if (moduleType.equals(ModuleType.EAR)) {
            index = 0;
        } else if (moduleType.equals(ModuleType.EJB)) {
            index = 1;
        } else if (moduleType.equals(ModuleType.CAR)) {
            index = 2;
        } else if (moduleType.equals(ModuleType.RAR)) {
            index = 3;
        } else if (moduleType.equals(ModuleType.WAR)) {
            index = 4;
        }
        this.cbModuleType.setSelectedIndex(index);
    }

    public FileDirMapDescriptor getFileDescriptor() {
        return this.fileDirectoryMap;
    }

    public void setFileDescriptor(FileDirMapDescriptor desc) {
        this.fileDirectoryMap = desc;
    }

    private void createGuiAndShow() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createFilePathPanel(), "North");
        this.add((Component)this.createFileContentsPanel(), "Center");
    }

    private JPanel createFilePathPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1), "Module Info"));
        panel.setLayout(new GridBagLayout());
        JButton btnSearch = new JButton("...");
        btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.searchArchiveFilePath();
            }
        });
        btnSearch.setToolTipText("Search the archive file path");
        this.cbModuleType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.repaintComboBoxInSelectedFilePanel();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 5, 5, 0);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 5, 5, 0);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.add((Component)new JLabel("Module Type :"), constraints);
        constraints.insets = new Insets(0, 0, 5, 5);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.cbModuleType, constraints);
        constraints.insets = new Insets(0, 5, 5, 0);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        panel.add((Component)new JLabel("Location : "), constraints);
        constraints.insets = new Insets(0, 0, 5, 5);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.tfArchiveFilePath, constraints);
        constraints.insets = new Insets(0, 0, 5, 5);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        panel.add((Component)btnSearch, constraints);
        return panel;
    }

    private void repaintComboBoxInSelectedFilePanel() {
        if (this.cbModuleType.getSelectedIndex() == ModuleType.EAR.getValue()) {
            this.selectedFileBtnPanel.add(this.cbEarDisplayMode);
        } else {
            this.selectedFileBtnPanel.remove(this.cbEarDisplayMode);
        }
        this.selectedFileBtnPanel.invalidate();
        this.selectedFileBtnPanel.updateUI();
    }

    private JPanel createFileContentsPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new TitledBorder(new EtchedBorder(1), "File Contents"));
        JSplitPane splitPane = new JSplitPane(0, this.createSourceContentsPanel(), this.createTargetContentsPanel());
        splitPane.setOneTouchExpandable(false);
        splitPane.setDividerLocation(200);
        splitPane.setDividerSize(4);
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    private JPanel createSourceContentsPanel() {
        this.fileContentTree.setDragEnabled(true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel startDirInfoPanel = this.createStartDirInfoPanel();
        JPanel btnPanel = this.createBtnPanel();
        this.fileContentTree.setRootVisible(true);
        this.fileContentTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeexpansionevent) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                FileContentsChooserPanel.this.updateForPathExpansion(event.getPath());
            }
        });
        this.fileContentTree.setCellRenderer(new FileTreeNodeRenderer());
        mainPanel.add((Component)startDirInfoPanel, "North");
        mainPanel.add((Component)new JScrollPane(this.fileContentTree), "Center");
        mainPanel.add((Component)btnPanel, "South");
        return mainPanel;
    }

    private JPanel createStartDirInfoPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JButton btnSearch = new JButton("...");
        btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.browingDirectory();
            }
        });
        btnSearch.setToolTipText("Search Starting Dir Path");
        this.topDirectoryTF.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                FileContentsChooserPanel.this.changeDirectoryAction();
            }
        });
        this.topDirectoryTF.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (FileContentsChooserPanel.isEnterKey(ke)) {
                    FileContentsChooserPanel.this.changeDirectoryAction();
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 0);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        panel.add((Component)new JLabel("Directory : "), constraints);
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.topDirectoryTF, constraints);
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        panel.add((Component)btnSearch, constraints);
        return panel;
    }

    private JPanel createBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel leftPanel = new JPanel(new FlowLayout(0));
        this.cbFileType.addItem("All Files");
        this.cbFileType.addItem("Class File");
        this.cbFileType.addItem("Jsp File");
        this.cbFileType.addItem("Archive File");
        this.cbFileType.setSelectedIndex(0);
        leftPanel.add(this.cbFileType);
        JPanel rightPanel = new JPanel(new FlowLayout(2));
        JButton btnAdd = new JButton("Add");
        btnAdd.setMnemonic('A');
        rightPanel.add(btnAdd);
        this.cbFileType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.changeDirectoryAction();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean changed = false;
                changed = FileContentsChooserPanel.this.cbModuleType.getSelectedIndex() == ModuleType.EAR.getValue() ? FileContentsChooserPanel.this.addContentActionWhenEarMode() : FileContentsChooserPanel.this._addContentAction();
                FileContentsChooserPanel.this.setFileContentsChanged(changed);
            }
        });
        panel.add(leftPanel);
        panel.add(rightPanel);
        return panel;
    }

    private void setFileContentsChanged(boolean changed) {
        if (changed) {
            ((JEUSBuilder)this.mainFrame).setFileContentsChanged(changed);
        }
    }

    private JPanel createTargetContentsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.selectedFileContentsTree = new JTree();
        this.contentsRootNode = new DefaultMutableTreeNode("Contents");
        this.contentTreeModel = new DefaultTreeModel(this.contentsRootNode, true);
        this.selectedFileContentsTree.setModel(this.contentTreeModel);
        this.selectedFileContentsTree.setRootVisible(true);
        this.selectedFileContentsTree.setDragEnabled(true);
        this.selectedFileContentsTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeexpansionevent) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
        this.selectedFileContentsTree.setCellRenderer(new FileTreeNodeRenderer());
        JPanel northPanelOfSelectedFile = new JPanel();
        northPanelOfSelectedFile.setLayout(new BoxLayout(northPanelOfSelectedFile, 0));
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(new JLabel("Selected File Contents"));
        JButton btnRemove = new JButton("Remove");
        btnRemove.setMnemonic('R');
        btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.setFileContentsChanged(FileContentsChooserPanel.this.removeContentAction());
            }
        });
        JButton btnClassPath = new JButton("Classpath");
        btnClassPath.setMnemonic('L');
        btnClassPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.setArchiveClasspath();
            }
        });
        this.selectedFileBtnPanel = new JPanel(new FlowLayout(4));
        this.cbEarDisplayMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileContentsChooserPanel.this.repaintSelectedFileTreeInEAR();
            }
        });
        this.selectedFileBtnPanel.add(btnRemove);
        this.selectedFileBtnPanel.add(btnClassPath);
        this.selectedFileBtnPanel.add(this.cbEarDisplayMode);
        northPanelOfSelectedFile.add(labelPanel);
        northPanelOfSelectedFile.add(this.selectedFileBtnPanel);
        panel.add((Component)northPanelOfSelectedFile, "North");
        panel.add((Component)new JScrollPane(this.selectedFileContentsTree), "Center");
        return panel;
    }

    private void repaintSelectedFileTreeInEAR() {
        if (this.cbEarDisplayMode.getSelectedIndex() == 0) {
            this.contentsRootNode.removeAllChildren();
            this._addFileContentsFromMain();
            this.updateSelectedFileTreeWhenArchiveModeInEAR(this.contentsRootNode.children());
        } else if (this.cbEarDisplayMode.getSelectedIndex() == 1) {
            this.contentsRootNode.removeAllChildren();
            this._addFileContentsFromMain();
        }
        ((DefaultTreeModel)this.contentTreeModel).reload();
    }

    private void updateSelectedFileTreeWhenArchiveModeInEAR(Enumeration enum1) {
        while (enum1.hasMoreElements()) {
            String dirName;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof String) || !this.isSupportedModule(dirName = (String)userObject)) continue;
            String dirPath = this.getDestinationDirs(node);
            dirPath = dirPath.substring(Constants.JEUS_ASSEMBLY_DIR.length());
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            node.removeFromParent();
            this.addFileContentNode(parentNode, new File(dirPath + dirName), false);
        }
    }

    private void addFileContentNode(String pkgName, String fileName) {
        DefaultMutableTreeNode parentNode = this.contentsRootNode;
        if (pkgName != null) {
            StringTokenizer st = new StringTokenizer(pkgName, ".");
            while (st.hasMoreTokens()) {
                String nodeName = st.nextToken();
                DefaultMutableTreeNode childNode = this.existPkgNode(parentNode, nodeName);
                if (childNode == null) {
                    parentNode = this.addFileContentNode(parentNode, nodeName, true);
                    continue;
                }
                parentNode = childNode;
            }
        }
        this.addFileContentNode(parentNode, fileName, false);
    }

    private DefaultMutableTreeNode existPkgNode(DefaultMutableTreeNode parentNode, String nodeName) {
        Enumeration<TreeNode> enum1 = parentNode.children();
        while (enum1.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            if (!node.toString().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    private DefaultMutableTreeNode addFileContentNode(DefaultMutableTreeNode parent, Object childUserObject, boolean setAsksAllowsChildren) {
        if (parent == null) {
            parent = this.contentsRootNode;
        }
        String childName = null;
        childName = childUserObject instanceof String ? (String)childUserObject : ((File)childUserObject).getName();
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(childUserObject, setAsksAllowsChildren);
        int count = 0;
        Enumeration<TreeNode> enum1 = parent.children();
        while (enum1.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            String nodeName = node.toString();
            int lastIndex = nodeName.lastIndexOf(File.separator);
            if (lastIndex > 0) {
                nodeName = nodeName.substring(lastIndex + 1);
            }
            if (childNode.toString().endsWith(nodeName)) {
                return node;
            }
            if (node.toString().compareTo(childNode.toString()) > 0) break;
            ++count;
        }
        try {
            ((DefaultTreeModel)this.contentTreeModel).insertNodeInto(childNode, parent, count);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.selectedFileContentsTree.scrollPathToVisible(new TreePath(childNode.getPath()));
        return childNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySelectedFileToTempDir() throws IOException {
        Vector vAllFiles = this.getSelectedFiles(this.contentsRootNode.children(), new Vector(), 2);
        for (int k = 0; k < vAllFiles.size(); ++k) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)vAllFiles.elementAt(k);
            File sourceFile = (File)node.getUserObject();
            String fileName = sourceFile.getName();
            String dirPath = this.getDestinationDirs(node);
            File destFile = new File(dirPath + FS + fileName);
            if (!destFile.exists()) {
                FileUtil.copy(sourceFile, destFile);
            }
            if (!this.getModuleType().equals(ModuleType.EAR)) continue;
            AbstractArchive archive = null;
            ModuleType targetModuleType = null;
            try {
                archive = JarArchiveFactory.openArchiveStatic((File)sourceFile);
                targetModuleType = JeusDeploymentManager.getModuleType(archive);
            }
            finally {
                if (archive != null) {
                    archive.close();
                    archive = null;
                }
            }
            if (targetModuleType == null || destFile.toString().toUpperCase().indexOf("APP-INF" + File.separatorChar + "LIB") > 0) continue;
            File archiveFile = new File(Constants.JEUS_ASSEMBLY_EAR_DIR + File.separatorChar + destFile.getName() + File.separatorChar);
            if (!archiveFile.exists()) {
                archiveFile.mkdirs();
            }
            JarExtractor extractor = new JarExtractor();
            extractor.unJar(sourceFile.toString(), archiveFile.toString(), true);
        }
    }

    private String getDestinationDirs(DefaultMutableTreeNode node) {
        Vector<String> vDirs = new Vector<String>();
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent(); this.contentsRootNode != parent; parent = (DefaultMutableTreeNode)parent.getParent()) {
            vDirs.add(parent.toString());
        }
        StringBuffer sbDir = new StringBuffer("");
        for (int k = vDirs.size() - 1; k >= 0; --k) {
            sbDir.append((String)vDirs.elementAt(k) + File.separatorChar);
        }
        if (sbDir.length() == 0) {
            return Constants.JEUS_ASSEMBLY_DIR;
        }
        return Constants.JEUS_ASSEMBLY_DIR + FS + sbDir.toString();
    }

    private Vector getSelectedFiles(Enumeration enum1, Vector v, int searchType) {
        while (enum1.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            Object userObject = node.getUserObject();
            if (userObject instanceof String) {
                this.getSelectedFiles(node.children(), v, searchType);
                continue;
            }
            if (!(userObject instanceof File)) continue;
            if (searchType == 1) {
                if (!this.isSupportedModule(((File)userObject).getName())) continue;
                v.add(node);
                continue;
            }
            if (searchType != 2) continue;
            v.add(node);
        }
        return v;
    }

    private boolean isSupportedModule(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".ear") || fileName.endsWith(".rar") || fileName.endsWith(".war");
    }

    private void setArchiveClasspath() {
        ModuleClassPathDlg classpathDlg = new ModuleClassPathDlg();
        String mainArchiveName = this.tfArchiveFilePath.getText().trim();
        if (mainArchiveName == null || "".equals(mainArchiveName) || mainArchiveName.lastIndexOf(46) < 0) {
            mainArchiveName = "(EMPTY)";
        } else {
            File file = new File(mainArchiveName);
            mainArchiveName = new File(mainArchiveName).getName();
        }
        ModuleType moduletype = this.getModuleType();
        try {
            if (!moduletype.equals(ModuleType.EAR)) {
                this.copySelectedFileToTempDir();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            AbstractArchive archive = ArchiveUtil.getAssemblyFileArchive();
            String classpath = ArchiveUtil.getArchiveClasspath(archive);
            classpathDlg.insert(mainArchiveName, classpath);
            if (moduletype.equals(ModuleType.EAR)) {
                Vector v = this.traverseEmbeddedArchiveAndCheckManifest(new File(Constants.JEUS_ASSEMBLY_DIR), new Vector());
                for (int k = 0; k < v.size(); ++k) {
                    String[] s = (String[])v.elementAt(k);
                    classpathDlg.insert(s[0], s[1]);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        classpathDlg.show();
    }

    private Vector traverseEmbeddedArchiveAndCheckManifest(File file, Vector vector) {
        File[] files = file.listFiles();
        for (int k = 0; k < files.length; ++k) {
            String dirName;
            if (!files[k].isDirectory() || (dirName = files[k].getName()).indexOf("APP-INF") > 0 || dirName.indexOf("META-INF") > 0 || !this.isSupportedModule(dirName)) continue;
            int startIndex = (Constants.JEUS_ASSEMBLY_DIR + Constants.FS).length();
            String embeddedArchivePath = files[k].toString().substring(startIndex);
            try {
                AbstractArchive embeddedArchive = FileArchiveFactory.openArchiveStatic((String)files[k].toString());
                String classpath = ArchiveUtil.getArchiveClasspath(embeddedArchive);
                vector.add(new String[]{embeddedArchivePath, classpath});
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return vector;
    }

    private String getUpperPath(DefaultMutableTreeNode node) {
        Vector<String> vPath = new Vector<String>();
        DefaultMutableTreeNode parent = null;
        while (true) {
            parent = (DefaultMutableTreeNode)node.getParent();
            String parentNodeName = parent.toString();
            if (this.contentsRootNode == parent) break;
            if (this.getModuleType() == ModuleType.WAR) {
                if (!parentNodeName.equals("lib") && !parentNodeName.equals("classes")) continue;
                DefaultMutableTreeNode tempParent = (DefaultMutableTreeNode)parent.getParent();
                String tempParentName = tempParent.toString();
                if (tempParentName.equals("WEB-INF")) break;
                vPath.add(parent.toString());
                node = parent;
                continue;
            }
            vPath.add(parent.toString());
            node = parent;
        }
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < vPath.size(); ++k) {
            sb.append((String)vPath.elementAt(k) + '/');
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private boolean removeContentAction() {
        int k;
        TreePath[] treePath = this.selectedFileContentsTree.getSelectionPaths();
        if (treePath == null) {
            JOptionPane.showMessageDialog(null, "There is no seleted data", "Warning", 2);
            return false;
        }
        if (this.getModuleType().equals(ModuleType.EAR) && this.cbEarDisplayMode.getSelectedIndex() == 1) {
            JOptionPane.showMessageDialog(null, "On Extraction mode, data cannot be deleted\nChange Extraction into Archive and try again", "Warning", 2);
            return false;
        }
        int answer = JOptionPane.showConfirmDialog(null, "Do you want to delete selected data?", "Question", 0);
        if (answer == 1) {
            return false;
        }
        DefaultMutableTreeNode node = null;
        for (k = 0; k < treePath.length; ++k) {
            node = (DefaultMutableTreeNode)treePath[k].getLastPathComponent();
            if (node == this.contentsRootNode) continue;
            Object userObject = node.getUserObject();
            if (userObject instanceof String) {
                String dirPath = this.getDestinationDirs(node);
                try {
                    File dir = new File(dirPath + FS + (String)userObject);
                    if (!dir.exists()) continue;
                    FileUtil.rmdir(dir);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
            if (!(userObject instanceof File)) continue;
            String filePath = this.getDestinationDirs(node);
            if (this.getModuleType().equals(ModuleType.EAR) && this.cbEarDisplayMode.getSelectedIndex() == 0) {
                String fileName = ((File)userObject).getName();
                if (!this.isSupportedModule(fileName)) continue;
                String dirPath = this.getDestinationDirs(node);
                try {
                    String earDirPath;
                    File dir2;
                    File dir = new File(dirPath + FS + fileName);
                    if (dir.exists()) {
                        FileUtil.rmdir(dir);
                    }
                    if (!(dir2 = new File((earDirPath = StringUtil.replaceString(dirPath, Constants.JEUS_ASSEMBLY_DIR, Constants.JEUS_ASSEMBLY_EAR_DIR)) + FS + fileName)).exists()) continue;
                    dir2.delete();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    MessagePanel.showMessage("[ERROR]removing file failed:" + fileName);
                }
                continue;
            }
            File targetFile = (File)userObject;
            String targetFileName = targetFile.getAbsolutePath();
            try {
                if (targetFileName.indexOf(ArchiveUtil.getAssemblyFileArchive().getArchiveUri()) < 0 || targetFile.delete()) continue;
                MessagePanel.showMessage("[ERROR]removing file failed:" + ((File)userObject).toString());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
        }
        for (k = 0; k < treePath.length; ++k) {
            node = (DefaultMutableTreeNode)treePath[k].getLastPathComponent();
            if (node == this.contentsRootNode) continue;
            node.removeFromParent();
            this.selectedFileContentsTree.updateUI();
        }
        return true;
    }

    public void _addFileContentsFromMain() {
        this.addFileContentsFromMain(new File(Constants.JEUS_ASSEMBLY_DIR), null);
    }

    public void addFileContentsFromMain(File dir, DefaultMutableTreeNode parentNode) {
        File[] fileContents = dir.listFiles();
        DefaultMutableTreeNode tempNode = parentNode;
        for (int k = 0; k < fileContents.length; ++k) {
            if (fileContents[k].isDirectory()) {
                parentNode = this.addFileContentNode(parentNode, new String(fileContents[k].getName()), true);
                this.addFileContentsFromMain(fileContents[k], parentNode);
            } else {
                this.addFileContentNode(parentNode, fileContents[k], false);
            }
            parentNode = tempNode;
        }
    }

    private boolean addContentActionWhenEarMode() {
        String TARGET_DIR = null;
        ArrayList selectedUpmostSourceFiles = this.getSelectedUpmostSourceFiles();
        if (selectedUpmostSourceFiles == null) {
            return false;
        }
        if (this.cbEarDisplayMode.getSelectedIndex() == 1) {
            TreePath[] targetTreePath = this.selectedFileContentsTree.getSelectionPaths();
            if (targetTreePath == null || targetTreePath.length != 1) {
                JOptionPane.showMessageDialog(this, "Select one target directory", "Error", 0);
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)targetTreePath[0].getLastPathComponent();
            if (node.isLeaf()) {
                JOptionPane.showMessageDialog(this, "Select a directory", "Error", 0);
                return false;
            }
            String nodeName = (String)node.getUserObject();
            if (!(nodeName.endsWith(".jar") || nodeName.endsWith(".rar") || nodeName.endsWith(".war"))) {
                JOptionPane.showMessageDialog(this, "Select valid directory(*.jar, *.war, *.rar))", "Error", 0);
                return false;
            }
            String dirs = this.getDestinationDirs(node);
            TARGET_DIR = dirs + FS + nodeName;
        }
        if (this.cbEarDisplayMode.getSelectedIndex() == 0) {
            TARGET_DIR = Constants.JEUS_ASSEMBLY_EAR_DIR;
        }
        try {
            for (int k = 0; k < selectedUpmostSourceFiles.size(); ++k) {
                File tempFile = (File)selectedUpmostSourceFiles.get(k);
                if (tempFile.isDirectory()) {
                    FileUtil.copyDirectory(tempFile.toString(), TARGET_DIR + FS + tempFile.getName());
                    continue;
                }
                FileUtils.makeEarArchiveDir();
                if (tempFile.getName().endsWith(".class")) {
                    String pkgName = ClassUtil.getClassFilePackageName(tempFile);
                    pkgName = pkgName.replace('.', File.separatorChar);
                    if (this.cbEarDisplayMode.getSelectedIndex() == 0) {
                        FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + Constants.DIR_APP_INF_CLASSES + FS + pkgName + FS + tempFile.getName());
                        continue;
                    }
                    if (TARGET_DIR.endsWith(".war")) {
                        FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + Constants.DIR_WEB_INF_CLASSES + FS + pkgName + FS + tempFile.getName());
                        continue;
                    }
                    FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + pkgName + FS + tempFile.getName());
                    continue;
                }
                if (this.isSupportedModule(tempFile.getName())) {
                    AbstractArchive archive = JarArchiveFactory.openArchiveStatic((File)tempFile);
                    ModuleType moduleType = JeusDeploymentManager.getModuleType(archive);
                    archive.close();
                    if (this.cbEarDisplayMode.getSelectedIndex() == 0) {
                        int result;
                        if (moduleType == null) {
                            FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + Constants.DIR_APP_INF_LIB + FS + tempFile.getName());
                            continue;
                        }
                        if ((moduleType.equals(ModuleType.EJB) || moduleType.equals(ModuleType.CAR)) && (result = JOptionPane.showConfirmDialog(this, "Do you want to place this file under /APP-INF/lib?(" + tempFile.getName() + ")", "Question", 0, 3)) == 0) {
                            FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + Constants.DIR_APP_INF_LIB + FS + tempFile.getName());
                            continue;
                        }
                    } else {
                        if (TARGET_DIR.endsWith(".war") && moduleType == null) {
                            FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + Constants.DIR_WEB_INF_LIB + FS + tempFile.getName());
                            continue;
                        }
                        FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + tempFile.getName());
                        continue;
                    }
                }
                FileUtil.copy(tempFile.toString(), TARGET_DIR + FS + tempFile.getName());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        if (this.cbEarDisplayMode.getSelectedIndex() == 0) {
            try {
                FileUtils.makeAssemblyDir();
                FileUtils.extractEmbeddedContentsFromEAR(new File(Constants.JEUS_ASSEMBLY_EAR_DIR));
                FileUtils.removeEarArchiveDir();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.repaintSelectedFileTreeInEAR();
        return true;
    }

    private boolean _addContentAction() {
        ArrayList topLevelFiles = this.getSelectedUpmostSourceFiles();
        if (topLevelFiles == null) {
            return false;
        }
        for (int i = 0; i < topLevelFiles.size(); ++i) {
            this._addFileContentNode(this.contentsRootNode, (File)topLevelFiles.get(i));
        }
        return true;
    }

    private ArrayList getSelectedUpmostSourceFiles() {
        TreePath[] treePath = this.fileContentTree.getSelectionPaths();
        if (treePath == null) {
            return null;
        }
        ArrayList<File> topLevelFiles = new ArrayList<File>();
        DefaultMutableTreeNode node = null;
        for (int k = 0; k < treePath.length; ++k) {
            node = (DefaultMutableTreeNode)treePath[k].getLastPathComponent();
            File file = (File)node.getUserObject();
            boolean contains = false;
            for (int j = 0; j < topLevelFiles.size(); ++j) {
                File top = (File)topLevelFiles.get(j);
                if (!this.isParentFile(top, file)) continue;
                contains = true;
            }
            if (contains) continue;
            topLevelFiles.add(file);
        }
        return topLevelFiles;
    }

    private boolean isParentFile(File candidate, File child) {
        File parent = null;
        while ((parent = child.getParentFile()) != null) {
            if (parent.equals(candidate)) {
                return true;
            }
            child = parent;
        }
        return false;
    }

    private void _addFileContentNode(DefaultMutableTreeNode parent, File file) {
        if (file.isDirectory()) {
            parent = this.addFileContentNode(parent, file.getName(), true);
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this._addFileContentNode(parent, children[i]);
            }
        } else {
            try {
                if (file.toString().endsWith(".class")) {
                    String pkgName = ClassUtil.getClassFilePackageName(file);
                    StringTokenizer st = new StringTokenizer(pkgName, ".");
                    if (!this.getModuleType().equals(ModuleType.WAR)) {
                        parent = this.contentsRootNode;
                        while (st.hasMoreElements()) {
                            String dir = (String)st.nextElement();
                            parent = this.addFileContentNode(parent, dir, true);
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.addFileContentNode(parent, file, false);
        }
    }

    private DefaultMutableTreeNode getNodeInWebmodule(DefaultMutableTreeNode parent, String targetNodeString) {
        Enumeration<TreeNode> enum1 = parent.children();
        DefaultMutableTreeNode targetNode = null;
        while (enum1.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            String nodeName = node.toString();
            if (!nodeName.equals(targetNodeString)) continue;
            targetNode = node;
            break;
        }
        if (targetNode == null) {
            return null;
        }
        return targetNode;
    }

    public void initDisplayMode() {
        this.repaintSelectedFileTreeInEAR();
    }

    public ModuleType getModuleType() {
        return ModuleType.getModuleType((int)this.cbModuleType.getSelectedIndex());
    }

    private void addFileContentsFromDirectory(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> enum1 = node.children();
        DefaultMutableTreeNode child = null;
        File f = null;
        while (enum1.hasMoreElements()) {
            child = (DefaultMutableTreeNode)enum1.nextElement();
            f = (File)child.getUserObject();
            if (f.isDirectory()) {
                this.addFileContentsFromDirectory(child);
                continue;
            }
            this.addFileContentsFromFile(f);
        }
    }

    private void addFileContentsFromFile(File f) {
        String fullPath = f.toString();
        String fileExt = this.getFileExtension(f);
        String fileName = this.getFileName(f);
        String pkgName = null;
        try {
            if (fileExt.equals("class")) {
                pkgName = ClassUtil.getClassFilePackageName(f);
            }
            this.addFileContentNode(pkgName, fileName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getFileName(File f) {
        String path = f.toString();
        int index = path.lastIndexOf(File.separatorChar);
        return path.substring(index + 1);
    }

    public void refreshTree() {
        TreeModel tm = this.getTreeModelFor(new File(this.topDirectoryTF.getText()));
        this.fileContentTree.setModel(tm);
    }

    private TreeModel getTreeModelFor(File directory) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(directory);
        DefaultTreeModel tm = new DefaultTreeModel(root, true);
        this.updateDirectoryChildren(root, directory);
        return tm;
    }

    public void changeDirectoryAction() {
        File directory = new File(this.topDirectoryTF.getText());
        if (directory.exists() && directory.isDirectory()) {
            this.refreshTree();
        }
    }

    void updateForPathExpansion(TreePath tp) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        File f = (File)node.getUserObject();
        if (f.isDirectory()) {
            this.updateDirectoryChildren(node, f);
        }
    }

    private void updateDirectoryChildren(DefaultMutableTreeNode dmtn, File directory) {
        dmtn.removeAllChildren();
        String ext = null;
        File[] subDirectories = directory.listFiles(this.filenameFilter);
        TreeSet<File> sortedFiles = new TreeSet<File>();
        for (int i = 0; i < subDirectories.length; ++i) {
            if (subDirectories[i].isFile() && this.cbFileType.getSelectedIndex() != 0) {
                ext = this.getFileExtension(subDirectories[i]);
                if (ext == null) continue;
                if (this.cbFileType.getSelectedIndex() == 1) {
                    if (!ext.toLowerCase().equals("class")) continue;
                    sortedFiles.add(subDirectories[i]);
                    continue;
                }
                if (this.cbFileType.getSelectedIndex() == 2) {
                    if (!ext.toLowerCase().equals("jsp")) continue;
                    sortedFiles.add(subDirectories[i]);
                    continue;
                }
                if (this.cbFileType.getSelectedIndex() != 3 || !ext.toLowerCase().equals("jar") && !ext.toLowerCase().equals("ear") && !ext.toLowerCase().equals("rar") && !ext.toLowerCase().equals("war") && !ext.toLowerCase().equals("car")) continue;
                sortedFiles.add(subDirectories[i]);
                continue;
            }
            sortedFiles.add(subDirectories[i]);
        }
        for (File next : sortedFiles) {
            DefaultMutableTreeNode node = null;
            node = next.isDirectory() ? new DefaultMutableTreeNode(next, true) : new DefaultMutableTreeNode(next, false);
            dmtn.add(node);
        }
        ((DefaultTreeModel)this.fileContentTree.getModel()).reload(dmtn);
    }

    private String getFileExtension(File file) {
        String path = file.getName();
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return path.substring(index + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getSelectedFilesFrom(TreePath tp, File rootDirectory) {
        Vector<File> v = new Vector<File>();
        Object o = tp.getLastPathComponent();
        if (!(o instanceof DefaultMutableTreeNode)) {
        }
        File f = (File)((DefaultMutableTreeNode)o).getUserObject();
        if (!f.isDirectory()) {
            File relativeFile = FileContentsChooserPanel.relativize(rootDirectory, f);
            v.add(relativeFile);
        }
        try {
            for (File next : FileContentsChooserPanel.getAllFilesUnder(f, this.filenameFilter)) {
                File absolute = new File(f, next.toString());
                File relativeFile = FileContentsChooserPanel.relativize(rootDirectory, absolute);
                v.add(relativeFile);
            }
        }
        finally {
            return v;
        }
    }

    public void browingDirectory() {
        JFileChooser chooser = new JFileChooser(new File(JeusBootstrapProperties.JEUS_HOME));
        chooser.setDialogTitle("Select Work Directory");
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("*.*");
        filter.setDescription("");
        chooser.setFileFilter(filter);
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this);
        File selectedFile = null;
        if (returnVal != 0) {
            return;
        }
        selectedFile = chooser.getSelectedFile();
        this.topDirectoryTF.setText(selectedFile.getAbsolutePath());
        this.changeDirectoryAction();
    }

    private void searchArchiveFilePath() {
        int index;
        String currentDir = this.getArchiveFilePath();
        currentDir = currentDir.length() > 0 ? ((index = currentDir.lastIndexOf(File.separatorChar)) > 0 ? currentDir.substring(0, index) : JeusBootstrapProperties.JEUS_HOME) : JeusBootstrapProperties.JEUS_HOME;
        JFileChooser chooser = new JFileChooser(new File(currentDir));
        chooser.setDialogTitle("Select Archive File Path");
        DefaultFileFilter filter = new DefaultFileFilter();
        filter.addExtension("car");
        filter.addExtension("ear");
        filter.addExtension("jar");
        filter.addExtension("rar");
        filter.addExtension("war");
        filter.setDescription("Archive");
        chooser.setFileFilter(filter);
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showOpenDialog(this);
        File selectedFile = null;
        if (returnVal != 0) {
            return;
        }
        selectedFile = chooser.getSelectedFile();
        MessagePanel.showMessage("Target archive file is selected:" + selectedFile.toString());
        this.tfArchiveFilePath.setText(selectedFile.toString());
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileContentsChooserPanel.recursiveGetFilesUnder(directory, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = directory.listFiles(filenameFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileContentsChooserPanel.recursiveGetFilesUnder(relativizingRoot, files[i], filenameFilter, set, returnDirectories);
                if (!returnDirectories) continue;
                set.add(FileContentsChooserPanel.relativize(relativizingRoot, files[i]));
                continue;
            }
            set.add(FileContentsChooserPanel.relativize(relativizingRoot, files[i]));
        }
    }

    public static boolean isEnterKey(KeyEvent ke) {
        return ke.getKeyCode() == 10;
    }

    static {
        FS = File.separator;
    }

    public class FileNameFilterDefault
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

