/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jeus.tool.builder.Constants;
import jeus.tool.builder.JEUSBuilder;
import jeus.tool.builder.module.EmptyDescriptor;
import jeus.tool.builder.ui.common.FileContentsChooserPanel;
import jeus.tool.builder.util.ArchiveUtil;
import jeus.tool.builder.util.SwingUtils;
import jeus.tool.ddinit.EJBDDInit;
import jeus.tool.ddinit.WEBDDInit;
import jeus.tool.util.FileUtil;
import jeus.util.JarExtractor;

public class FileContentsChooserDlg
extends JDialog {
    protected JPanel mainPanel;
    protected JPanel btnPanel;
    private JButton btnConfirm;
    private JButton btnCancel;
    private ModuleType moduleType;
    private FileContentsChooserPanel fileContentsChooserPanel;
    private JFrame mainFrame;
    private static boolean DLG_WORK_MODE_NEW = false;
    private final String FS = Constants.FS;

    public FileContentsChooserDlg(JFrame mainFrame) {
        super((Frame)mainFrame, true);
        this.mainFrame = mainFrame;
        this.fileContentsChooserPanel = new FileContentsChooserPanel(mainFrame);
        this.createUI();
    }

    private void createUI() {
        this.setTitle("Fille Contents");
        this.mainPanel = new JPanel();
        JPanel leftPanel = new JPanel();
        leftPanel.setBackground(Color.decode("#154B6D"));
        leftPanel.add(new JLabel(SwingUtils.createIcon("/jeus/tool/builder/images/file_config_dlg.jpg")));
        this.makeBtnPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.btnPanel.add(this.btnConfirm);
        this.btnPanel.add(this.btnCancel);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)leftPanel, "West");
        this.mainPanel.add((Component)this.fileContentsChooserPanel, "Center");
        this.mainPanel.add((Component)this.btnPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(290, 280, 530, 550);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    public void init() {
        this.fileContentsChooserPanel.init();
    }

    public void init(ModuleType moduleType, String filePath) {
        this.moduleType = moduleType;
        this.fileContentsChooserPanel.init(moduleType, filePath);
    }

    public void init(String filePath) {
        this.fileContentsChooserPanel.init(this.moduleType, filePath);
    }

    public void initDisplayMode() {
        this.fileContentsChooserPanel.initDisplayMode();
    }

    public void updateSelectedFileTree() {
        this.fileContentsChooserPanel._addFileContentsFromMain();
    }

    public ModuleType getModuleType() {
        return this.fileContentsChooserPanel.getModuleType();
    }

    public String getModuleName() {
        return this.fileContentsChooserPanel.getModuleName();
    }

    public String getArchiveFilePath() {
        return this.fileContentsChooserPanel.getArchiveFilePath();
    }

    public void setWorkMode(boolean b) {
        DLG_WORK_MODE_NEW = b;
        this.fileContentsChooserPanel.setDlgWorkMode(DLG_WORK_MODE_NEW);
    }

    public boolean getWorkMode() {
        return DLG_WORK_MODE_NEW;
    }

    private boolean checkValidLocation() {
        this.moduleType = this.fileContentsChooserPanel.getModuleType();
        String location = this.fileContentsChooserPanel.getArchiveFilePath();
        if (location == null || "".equals(location)) {
            JOptionPane.showMessageDialog(this, "enter the location(target file path)", "Error", 0);
            return false;
        }
        String ext = "";
        if (this.moduleType.equals(ModuleType.EAR)) {
            if (location.endsWith(".ear")) {
                return true;
            }
            ext = "ear";
        } else if (this.moduleType.equals(ModuleType.EJB)) {
            if (location.endsWith(".jar")) {
                return true;
            }
            ext = "jar";
        } else if (this.moduleType.equals(ModuleType.WAR)) {
            if (location.endsWith(".war")) {
                return true;
            }
            ext = "war";
        } else if (this.moduleType.equals(ModuleType.RAR)) {
            if (location.endsWith(".rar")) {
                return true;
            }
            ext = "rar";
        } else if (this.moduleType.equals(ModuleType.CAR)) {
            if (location.endsWith(".jar")) {
                return true;
            }
            ext = "jar";
        }
        JOptionPane.showMessageDialog(this, "You entered the wrong location.\nThe file with " + ext + " extention is required.", "Error", 0);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void doConfirm() {
        if (!this.checkValidLocation()) {
            return;
        }
        try {
            if (this.moduleType.equals(ModuleType.EAR)) {
                archive = ArchiveUtil.getEarArchiveFileArchive();
                j2eeInputstream = archive.getEntry("META-INF" + this.FS + "application.xml");
                if (j2eeInputstream == null) {
                    EmptyDescriptor.makeJ2eeDescriptor(archive, this.moduleType);
                }
                if (new File(Constants.JEUS_ASSEMBLY_DIR + this.FS + "APP-INF").exists()) {
                    FileUtil.copyDirectory(Constants.JEUS_ASSEMBLY_DIR + this.FS + "APP-INF", Constants.JEUS_ASSEMBLY_EAR_DIR + this.FS + "APP-INF");
                }
                if (new File(Constants.JEUS_ASSEMBLY_DIR + this.FS + "META-INF").exists()) {
                    FileUtil.copyDirectory(Constants.JEUS_ASSEMBLY_DIR + this.FS + "META-INF", Constants.JEUS_ASSEMBLY_EAR_DIR + this.FS + "META-INF");
                }
                try {
                    this.copyAndMakeJarWithEAR(new File(Constants.JEUS_ASSEMBLY_DIR));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                if (FileContentsChooserDlg.DLG_WORK_MODE_NEW) {
                    FileUtil.rmdir(Constants.JEUS_ASSEMBLY_DIR);
                }
                this.fileContentsChooserPanel.copySelectedFileToTempDir();
                archive = ArchiveUtil.getAssemblyFileArchive();
                j2eeInputStream = archive.getEntry(this.getJ2eeDescriporPath(this.moduleType));
                jeusInputStream = archive.getEntry(this.getJeusDescriporPath(this.moduleType));
                found = false;
                if (j2eeInputStream != null && jeusInputStream != null) {
                    found = true;
                }
                if (this.moduleType.equals(ModuleType.EJB)) {
                    try {
                        if (found) ** GOTO lbl52
                        EJBDDInit.main(new String[]{Constants.JEUS_ASSEMBLY_DIR});
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Introspection error:" + t.getMessage(), "Error", 0);
                        return;
                    }
                } else if (this.moduleType.equals(ModuleType.WAR)) {
                    if (!found) {
                        WEBDDInit.main(new String[]{"-webcontext", this.fileContentsChooserPanel.getModuleName(), Constants.JEUS_ASSEMBLY_DIR});
                    }
                } else if (this.moduleType.equals(ModuleType.RAR)) {
                    if (j2eeInputStream == null) {
                        EmptyDescriptor.makeJ2eeDescriptor(archive, this.moduleType);
                    }
                    if (jeusInputStream == null) {
                        EmptyDescriptor.makeJeusDescriptor(archive, this.moduleType);
                    }
                } else if (this.moduleType.equals(ModuleType.CAR)) {
                    if (j2eeInputStream == null) {
                        EmptyDescriptor.makeJ2eeDescriptor(archive, this.moduleType);
                    }
                    if (jeusInputStream == null) {
                        EmptyDescriptor.makeJeusDescriptor(archive, this.moduleType);
                    }
                }
            }
lbl52:
            // 11 sources

            this.dispose();
            ((JEUSBuilder)this.mainFrame).updateWorkspacePanel();
            FileContentsChooserDlg.DLG_WORK_MODE_NEW = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getJ2eeDescriporPath(ModuleType moduletype) {
        String path = null;
        if (moduletype.equals(ModuleType.EAR)) {
            path = "META-INF" + this.FS + "application.xml";
        } else if (moduletype.equals(ModuleType.EJB)) {
            path = "META-INF" + this.FS + "ejb-jar.xml";
        } else if (moduletype.equals(ModuleType.WAR)) {
            path = "WEB-INF" + this.FS + "web.xml";
        } else if (moduletype.equals(ModuleType.RAR)) {
            path = "META-INF" + this.FS + "ra.xml";
        } else if (moduletype.equals(ModuleType.CAR)) {
            path = "META-INF" + this.FS + "application-client.xml";
        }
        return path;
    }

    private String getJeusDescriporPath(ModuleType moduletype) {
        String path = null;
        if (moduletype.equals(ModuleType.EJB)) {
            path = "META-INF" + this.FS + "jeus-ejb-dd.xml";
        } else if (moduletype.equals(ModuleType.WAR)) {
            path = "WEB-INF" + this.FS + "jeus-web-dd.xml";
        } else if (moduletype.equals(ModuleType.RAR)) {
            path = "META-INF" + this.FS + "jeus-connector-dd.xml";
        } else if (moduletype.equals(ModuleType.CAR)) {
            path = "META-INF" + this.FS + "jeus-client-dd.xml";
        }
        return path;
    }

    private void copyAndMakeJarWithEAR(File targetFile) throws Throwable {
        int rootLength = (Constants.JEUS_ASSEMBLY_DIR + File.separator).length();
        JarExtractor extractor = new JarExtractor();
        File[] childFiles = targetFile.listFiles();
        String alreadyHandledFile = "";
        for (int k = 0; k < childFiles.length; ++k) {
            String dirs;
            int endIndex;
            String filePath = childFiles[k].toString();
            String fileName = childFiles[k].getName();
            if (filePath.indexOf("APP-INF") > 0 || filePath.indexOf("META-INF") > 0) continue;
            if (childFiles[k].isDirectory()) {
                alreadyHandledFile = fileName;
                if (fileName.endsWith(".ear") || fileName.endsWith(".jar") || fileName.endsWith(".rar") || fileName.endsWith(".war")) {
                    endIndex = filePath.lastIndexOf(File.separatorChar);
                    dirs = "";
                    dirs = Constants.JEUS_ASSEMBLY_DIR.equals(childFiles[k].getParent()) ? "" : filePath.substring(rootLength, endIndex);
                    String targetArchive = null;
                    targetArchive = dirs.length() > 0 ? Constants.JEUS_ASSEMBLY_EAR_DIR + File.separator + dirs + File.separator + fileName : Constants.JEUS_ASSEMBLY_EAR_DIR + File.separator + fileName;
                    extractor.makeJar2(filePath, targetArchive);
                    continue;
                }
                this.copyAndMakeJarWithEAR(childFiles[k]);
                continue;
            }
            if (filePath.indexOf(alreadyHandledFile) > 0) continue;
            endIndex = filePath.lastIndexOf(File.separatorChar);
            dirs = filePath.substring(rootLength + 1, endIndex);
            String targetFilePath = null;
            targetFilePath = dirs.length() > 0 ? Constants.JEUS_ASSEMBLY_EAR_DIR + File.separator + dirs + File.separator + fileName : Constants.JEUS_ASSEMBLY_EAR_DIR + File.separator + fileName;
            FileUtil.copy(filePath, targetFilePath);
        }
    }

    private void doCancel() {
        this.dispose();
    }

    private void makeBtnPanel() {
        this.btnPanel = new JPanel();
        this.btnConfirm = new JButton("Ok");
        this.btnConfirm.setMnemonic('O');
        this.btnConfirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileContentsChooserDlg.this.doConfirm();
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic('C');
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileContentsChooserDlg.this.doCancel();
            }
        });
    }
}

