/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.tool.builder.Constants;
import jeus.tool.builder.util.FileUtils;

public class ArchiveUtil {
    public static AbstractArchive getAssemblyFileArchive() throws IOException {
        FileUtils.makeAssemblyDir();
        return FileArchiveFactory.openArchiveStatic((String)Constants.JEUS_ASSEMBLY_DIR);
    }

    public static AbstractArchive getEarArchiveFileArchive() throws IOException {
        FileUtils.makeEarArchiveDir();
        return FileArchiveFactory.openArchiveStatic((String)Constants.JEUS_ASSEMBLY_EAR_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createManifestFile(AbstractArchive archive) throws IOException {
        OutputStream os = archive.addEntry("META-INF/MANIFEST.MF");
        try {
            Manifest manifest = archive.getManifest();
            Attributes attribs = manifest.getMainAttributes();
            attribs.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            manifest.write(os);
        }
        finally {
            archive.closeEntry(os);
        }
    }

    public static String getArchiveClasspath(AbstractArchive archive) throws IOException {
        String classpath = "";
        Manifest manifest = archive.getManifest();
        if (manifest == null) {
            ArchiveUtil.createManifestFile(archive);
        } else {
            Attributes attribs = manifest.getMainAttributes();
            classpath = attribs.getValue(Attributes.Name.CLASS_PATH);
        }
        return classpath;
    }

    public static void extractArchive(String jarSourcePath, String destPath) throws IOException {
        ArchiveUtil.extractArchive((InputJarArchive)JarArchiveFactory.openArchiveStatic((String)jarSourcePath), destPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractArchive(InputJarArchive archive, String destPath) throws IOException {
        AbstractArchive targetArchive = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            targetArchive = FileArchiveFactory.openArchiveStatic((String)destPath);
            Enumeration enum1 = archive.entries();
            while (enum1.hasMoreElements()) {
                String entryName = (String)enum1.nextElement();
                os = targetArchive.addEntry(entryName);
                is = archive.getEntry(entryName);
                ArchiveHelper.copy((InputStream)is, (OutputStream)os);
            }
        }
        finally {
            if (archive != null) {
                archive.close();
                archive = null;
            }
            if (os != null) {
                os.close();
                os = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }
}

