/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.util;

import java.io.File;
import java.io.IOException;
import jeus.tool.builder.Constants;
import jeus.tool.util.FileUtil;
import jeus.util.JarExtractor;

public class FileUtils {
    public static void makeAssemblyDir() {
        File dir = new File(Constants.JEUS_ASSEMBLY_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void makeEarArchiveDir() {
        File dir = new File(Constants.JEUS_ASSEMBLY_EAR_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void makeAppInfAndClassesDir() {
        File dir = new File(Constants.JEUS_ASSEMBLY_EAR_DIR + Constants.FS + Constants.DIR_APP_INF_CLASSES);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void makeAppInfAndLibDir() {
        File dir = new File(Constants.JEUS_ASSEMBLY_EAR_DIR + Constants.FS + Constants.DIR_APP_INF_LIB);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void removeAssemblyDir() {
        File dir = new File(Constants.JEUS_ASSEMBLY_DIR);
        if (dir.exists()) {
            dir.delete();
        }
    }

    public static void removeEarArchiveDir() {
        File dir = new File(Constants.JEUS_ASSEMBLY_EAR_DIR);
        if (dir.exists()) {
            dir.delete();
        }
    }

    public static void extractEmbeddedContentsFromEAR(File targetDir) throws IOException {
        JarExtractor extractor = new JarExtractor();
        File[] childFiles = targetDir.listFiles();
        for (int k = 0; k < childFiles.length; ++k) {
            if (childFiles[k].isDirectory()) {
                FileUtils.extractEmbeddedContentsFromEAR(childFiles[k]);
                continue;
            }
            String sourceFilePath = childFiles[k].toString();
            String targetFilePathFromRoot = sourceFilePath.substring(Constants.JEUS_ASSEMBLY_EAR_DIR.length() + 1);
            String targetFilePath = Constants.JEUS_ASSEMBLY_DIR + File.separatorChar + targetFilePathFromRoot;
            if (jeus.util.file.FileUtils.isExploded((String)sourceFilePath) || sourceFilePath.indexOf("APP-INF") > 0 || sourceFilePath.indexOf("META-INF") > 0) {
                FileUtil.copy(sourceFilePath, targetFilePath);
                continue;
            }
            File tempDir = new File(targetFilePath);
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            extractor.unJar(sourceFilePath, tempDir.toString(), true);
        }
    }
}

