/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jeus.util.SimpleLogDateFormat;

public class MonitorLogger {
    protected SimpleLogDateFormat sdf = new SimpleLogDateFormat("[yyyy.MM.dd HH:mm:ss]");
    protected SimpleLogDateFormat df = new SimpleLogDateFormat("[yyyy.MM.dd HH:mm:ss]");
    protected SimpleDateFormat fn = new SimpleDateFormat("MMddyyyy");
    String FS = System.getProperty("file.separator");
    protected File logDir;
    protected int bufferSize;
    protected String logFileNamePrefix;
    protected File logFile;
    protected int validDays = -1;
    protected int lastCreatedDay;
    protected PrintWriter out;
    protected boolean noBuffering = false;
    String myLogType = null;
    public static String THREAD_STATE_STRING = "ThreadState";
    public static String DB_STATE_STRING = "DataSourceState";
    public static String SESSION_STATE_STRING = "SessionState";

    public MonitorLogger(String logSavingDirPath, String engineName, String logTypeString, int bufferSize, int validdays, String logFormat) {
        if (logSavingDirPath == null) {
            System.out.println("Log creation Error : saving dir is not set");
        }
        try {
            this.validDays = validdays;
            if (validdays > 0) {
                this.logDir = new File(logSavingDirPath);
                this.logDir.mkdirs();
                this.myLogType = logTypeString;
                this.logFileNamePrefix = engineName + "_" + logTypeString;
                Calendar cal = Calendar.getInstance();
                String suffix = this.fn.format(cal.getTime());
                String logFileName = this.logFileNamePrefix + "_" + suffix + ".log";
                this.logFile = new File(this.logDir, logFileName);
                this.lastCreatedDay = cal.get(6);
            } else {
                this.logFile = new File(this.logDir, this.logFileNamePrefix + ".log");
            }
            this.bufferSize = bufferSize;
            if (bufferSize == 0) {
                this.noBuffering = true;
            }
            this.createLogStream(this.logFile.toString(), this.noBuffering, bufferSize);
        }
        catch (IOException ioe) {
            String msg = "Error: Getting Log file(" + this.logFile.toString() + "): " + ioe.getMessage();
            System.out.println(msg);
            ioe.printStackTrace();
        }
    }

    protected void createLogStream(String fileName, boolean notBuffering, int bSize) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName, true);
        BufferedOutputStream bos = null;
        bos = notBuffering ? new BufferedOutputStream(fos) : new BufferedOutputStream(fos, bSize);
        this.out = new PrintWriter(bos, true);
        if (this.isFirstCreate(fileName)) {
            this.initLog();
        }
    }

    protected boolean invalidLogFile() {
        Calendar cal = Calendar.getInstance();
        int thisDay = cal.get(6);
        if (thisDay == this.lastCreatedDay) {
            return false;
        }
        if (thisDay > this.lastCreatedDay) {
            return thisDay - this.lastCreatedDay >= this.validDays;
        }
        return 365 - this.lastCreatedDay + thisDay >= this.validDays;
    }

    protected void createNewLogger() {
        File lastFile = this.logFile;
        try {
            this.out.close();
            Calendar cal = Calendar.getInstance();
            String suffix = this.fn.format(cal.getTime());
            this.logFile = new File(this.logDir, this.logFileNamePrefix + "_" + suffix + ".log");
            this.lastCreatedDay = cal.get(6);
            this.createLogStream(this.logFile.toString(), this.noBuffering, this.bufferSize);
        }
        catch (IOException ioe) {
            String msg = "Error: Getting Log file(" + this.logFile.toString() + "): " + ioe.getMessage();
            System.out.println(msg);
            ioe.printStackTrace();
            try {
                this.createLogStream(lastFile.toString(), this.noBuffering, this.bufferSize);
            }
            catch (IOException ex) {
                this.out = null;
                this.validDays = -1;
            }
        }
    }

    public void checkLogFile() {
        this.flush();
        if (this.validDays > 0 && this.invalidLogFile()) {
            this.createNewLogger();
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.logFile != null && this.out != null) {
            this.out.close();
        }
    }

    public boolean isFirstCreate(String logFilePath) {
        try {
            FileInputStream fis = new FileInputStream(logFilePath);
            if (fis.available() > 0) {
                return false;
            }
        }
        catch (Exception anyE) {
            return true;
        }
        return true;
    }

    public void initLog() {
        if (this.myLogType.equals(THREAD_STATE_STRING)) {
            this.out.println("[Time]    [Thread Num]  [Execution Thread]  [old(30sec) Thread]  [Max Pool Size]");
        } else if (this.myLogType.equals(DB_STATE_STRING)) {
            this.out.println("[Time]    [DB Pool Max]  [DB Pool in use]");
        } else if (this.myLogType.equals(SESSION_STATE_STRING)) {
            this.out.println("[Time]    [Num of Session]  [Server Name]  [Type]");
        }
    }

    public void log(ArrayList valueList) {
        if (this.myLogType == null) {
            return;
        }
        if (valueList == null) {
            return;
        }
        Date d = new Date();
        String date = this.sdf.format(d);
        if (this.noBuffering) {
            this.out.flush();
        }
        if (this.myLogType.equals(THREAD_STATE_STRING)) {
            if (valueList.size() < 7) {
                return;
            }
            this.out.println(date + "  " + valueList.get(3) + "  " + valueList.get(4) + "  " + valueList.get(5) + "  " + valueList.get(6));
        } else if (this.myLogType.equals(DB_STATE_STRING)) {
            if (valueList.size() < 9) {
                return;
            }
            this.out.println(date + "  " + valueList.get(7) + "  " + valueList.get(8));
        } else if (this.myLogType.equals(SESSION_STATE_STRING)) {
            if (valueList.size() < 12) {
                return;
            }
            this.out.println(date + "  " + valueList.get(9) + "  " + valueList.get(10) + "  " + valueList.get(11));
        }
    }
}

