/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jeus.tool.common.WIOParameters;

public class Translation
implements Serializable {
    public static final String ENGLISH = "English";
    public static final String KOREAN = "Korean";
    public static String language = "English";

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String lang) {
        language = lang;
    }

    public static Font getFont(Component myComp) {
        if (WIOParameters.LANGUAGE != null && WIOParameters.LANGUAGE.equalsIgnoreCase("korean")) {
            return new Font("gulim", 1, WIOParameters.FONT_SIZE);
        }
        return myComp.getFont();
    }

    public void setLanguage(HttpServletRequest request) {
        language = ENGLISH;
        Cookie[] cookielist = request.getCookies();
        if (cookielist != null) {
            for (int i = 0; i < cookielist.length; ++i) {
                if (cookielist[i].getName() == null || !cookielist[i].getName().equals("language")) continue;
                language = cookielist[i].getValue();
            }
        }
        if (request.getAttribute("language") != null) {
            language = (String)request.getAttribute("language");
        }
    }

    public static void setUIFont(FontUIResource f) {
        if (WIOParameters.LANGUAGE == null || WIOParameters.LANGUAGE.equalsIgnoreCase("english")) {
            return;
        }
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public String getLanguage(HttpServletRequest request) {
        Cookie[] cookielist = request.getCookies();
        if (cookielist != null) {
            for (int i = 0; i < cookielist.length; ++i) {
                if (cookielist[i].getName() == null || !cookielist[i].getName().equals("language")) continue;
                language = cookielist[i].getValue();
            }
        }
        if (request.getAttribute("language") != null) {
            language = (String)request.getAttribute("language");
        }
        return language;
    }

    public String convert(String str) {
        try {
            if (str == null) {
                return null;
            }
            return new String(str.getBytes("EUC-KR"), "ISO-8859-1");
        }
        catch (Exception e) {
            return "error";
        }
    }

    public ResourceBundle getResourceBundle(String language) {
        Locale locale = new Locale(language, language);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jeus.tool.common.ObjectResource", locale);
        return resourceBundle;
    }

    public String getObject(String language, String target) {
        if (language == null) {
            language = "english";
        }
        Locale locale = new Locale(language, language);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jeus.tool.common.ObjectResource", locale);
        String result = "";
        try {
            return (String)resourceBundle.getObject(target);
        }
        catch (Exception e) {
            return target;
        }
    }

    public String getObject(String target) {
        ResourceBundle resourceBundle;
        if (language == null) {
            language = "english";
        }
        try {
            Locale locale = new Locale(language, language);
            resourceBundle = ResourceBundle.getBundle("jeus.tool.common.ObjectResource", locale);
        }
        catch (Exception me) {
            return target;
        }
        return (String)resourceBundle.getObject(target);
    }

    public String getDate() {
        Locale locale = Locale.KOREA;
        if (language.equalsIgnoreCase("korean")) {
            locale = Locale.KOREA;
        } else if (language.equalsIgnoreCase("english")) {
            locale = Locale.US;
        }
        Date date = new Date();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        return df.format(date);
    }
}

