/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import jeus.descriptor.ejb.EJBCSIDescriptor;
import jeus.descriptor.ejb.EJBClusterDescriptor;
import jeus.descriptor.ejb.EJBDBInfo;
import jeus.descriptor.ejb.EJBDescriptor;
import jeus.descriptor.ejb.EJBEntityDescriptor;
import jeus.descriptor.ejb.EJBMessageDrivenDescriptor;
import jeus.descriptor.ejb.EJBModDescriptor;
import jeus.descriptor.ejb.EJBRelationshipDescriptor;
import jeus.descriptor.ejb.EJBSessionDescriptor;
import jeus.descriptor.ejb.JNDIInfo;
import jeus.descriptor.ejb.RoleInfo;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ValidString;
import jeus.util.message.JeusMessage_Converter;

public class EJBDescriptorConverter
extends XMLConverter {
    public static final String SYSTEM_ID = "jeus-ejb-dd.dtd";
    public static final String PUBLIC_ID = "-//Tmax Soft, Inc.//DTD Jeus EJB Deployment Info.//EN";
    public static final String JEUS_EJB_DD = "jeus-ejb-dd";
    public static final String STATEFUL = "stateful";
    public static final String STATELESS = "stateless";
    public static final String BEAN_MANAGED = "bean-managed";
    public static final String CONTAINER_MANAGED = "container-managed";
    public static final String EJB_NAME = "ejb-name";
    public static final String EXPORT_PORT = "export-port";
    public static final String EXPORT_NAME = "export-name";
    public static final String PASSIVATION_TIMEOUT = "passivation-timeout";
    public static final String DISCONNECT_TIMEOUT = "disconnect-timeout";
    public static final String ENGINE_TYPE = "engine-type";
    public static final String ENTITY_CACHE_SIZE = "entity-cache-size";
    public static final String NON_MODIFYING_METHODS = "non-modifying-methods";
    public static final String DB_VENDOR = "db-vendor";
    public static final String IS_LOCAL_FILE_DB = "is-local-file-db";
    public static final String REMOTE_PRIMARY_FILE_DB = "remote-primary-file-db";
    public static final String REMOTE_BACKUP_FILE_DB = "remote-backup-file-db";
    public static final String CONN_POOL_SIZE = "conn-pool-size";
    public static final String FILE_DB_PATH = "file-db-path";
    public static final String FILE_DB_NAME = "file-db-name";
    public static final String MIN_HOLE = "min-hole";
    public static final String PACKING_RATE = "packing-rate";
    public static final String POOLING_BEAN = "is-pooling-bean";
    public static final String TABLE_NAME = "table-name";
    public static final String CMFIELDS = "cmfields";
    public static final String FIELD_EXCLUDE = "exclude-field";
    public static final String PRIM_KEY_FIELDS = "prim-key-fields";
    public static final String FIELD = "field";
    public static final String COLUMN_NAME = "column-name";
    public static final String TYPE = "type";
    public static final String DATA_SOURCE_NAME = "data-source-name";
    public static final String FIND_METHODS = "find-methods";
    public static final String METHOD = "method";
    public static final String SQL = "sql";
    public static final String EXCLUSIVE_ACCESS = "EXCLUSIVE_ACCESS";
    public static final String SINGLE_OBJECT = "SINGLE_OBJECT";
    public static final String MULTIPLE_OBJECT = "MULTIPLE_OBJECT";
    public static final String READ_LOCKING = "ReadLocking";
    public static final String WRITE_LOCKING = "WriteLocking";
    public static final String OPTIMISTIC_UPDATE = "OptimisticUpdate";
    public static final String WRITE_LOCKING_FIND = "WriteLockingFind";
    public static final String ORACLE = "oracle";
    public static final String INFORMIX = "informix";
    public static final String DB2 = "db2";
    public static final String MSSQL = "mssql";
    public static final String SYBASE = "sybase";
    public static final String MESSAGE_DRIVEN = "message-driven";
    public static final String BEAN_POOL = "bean-pool";
    public static final String CONNECT_POOL = "connect-pool";
    public static final String THREAD_POOL = "thread-pool";
    public static final String POOL_MIN = "pool-min";
    public static final String POOL_MAX = "pool-max";
    public static final String POOL_STEP = "pool-step";
    public static final String DESTINATION = "destination";
    public static final String MAX_MESSAGE = "max-message";
    public static final String RESIZING_PERIOD = "resizing-period";
    public static final String EXPORT_IIOP = "export-iiop";
    public static final String LOCAL_INVO_OPTIMIZE = "isLocalInvocationOptimized";
    public static final String SINGLE_VM_ONLY = "single-vm-only";
    public static final String RUN_AS_IDENTITY = "run-as-identity";
    public static final String PRINCIPAL_NAME = "principal-name";
    public static final String EJB_REF = "ejb-ref";
    public static final String RES_REF = "res-ref";
    public static final String RES_ENV_REF = "res-env-ref";
    public static final String JNDI_INFO = "jndi-info";
    public static final String REF_NAME = "ref-name";
    public static final String CONNECTION_FACTORY_NAME = "connection-factory-name";
    public static final String ACK_MODE = "ack-mode";
    public static final String DURABLE = "durable";
    public static final String MSG_SELECTOR = "msg-selector";
    public static final String MODULE_INFO = "module-info";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String ENV = "env";
    public static final String MODULE_NAME = "module-name";
    public static final String ROLE_ASSIGN = "role-assign";
    public static final String ROLE_NAME = "role-name";
    public static final String USER = "user";
    public static final String BEANLIST = "beanlist";
    public static final String SUBENGINE_TYPE = "subengine-type";
    public static final String INIT_CACHING = "init-caching";
    public static final String FETCH_SIZE = "fetch-size";
    public static final String CAPACITY = "capacity";
    public static final String IS_CREATING_TABLE = "is-creating-table";
    public static final String IS_DELETING_TABLE = "is-deleting-table";
    public static final String CLUSTERING = "clustering";
    public static final String CLUSTER_NAME = "cluster-name";
    public static final String CLUSTER_EXPORT_NAME = "cluster-export-name";
    public static final String HOME_CLUSTERED = "home-clustered";
    public static final String EJB_HOME_IDEMPOTENT_METHODS = "ejb-home-idempotent-methods";
    public static final String EJB_HOME_COMPONENT_FAILOVER = "ejb-home-component-failover";
    public static final String EJB_REMOTE_IDEMPOTENT_METHODS = "ejb-remote-idempotent-methods";
    public static final String EJB_REMOTE_COMPONENT_FAILOVER = "ejb-remote-component-failover";
    public static final String INVOKE_HTTP = "invoke-http";
    public static final String URL = "url";
    public static final String HTTP_PORT = "http-port";
    public static final String LOCAL_EXPORT_NAME = "local-export-name";
    public static final String RESULT_TYPE = "result-type";
    public static final String CSI = "security-interop";
    public static final String CSI_IC = "integrity-confidentiality";
    public static final String TRUST_IN_CLIENT = "trust-in-client";
    public static final String CLIENT_AUTH = "client-auth";
    public static final String IDENTITY_ASSERTION = "identity-assertion";
    public static final String ENABLE_INSTANT_QL = "enable-instant-ql";
    public static final String RELATION_MAP = "ejb-relation-map";
    public static final String RELATION_NAME = "relation-name";
    public static final String JEUS_RELATIONSHIP_ROLE = "jeus-relationship-role";
    public static final String RELATIONSHIP_ROLE_NAME = "relationship-role-name";
    public static final String COLUMN_MAP = "column-map";
    public static final String FOREIGN_KEY_COLUMN = "foreign-key-column";
    public static final String KEY_COLUMN = "key-column";
    public static final String JNDI_SPI = "jndi-spi";
    public static final String MQ_VENDOR = "mq-vendor";
    public static final String INITIAL_CONTEXT_FACTORY = "initial-context-factory";
    public static final String PROVIDER_URL = "provider-url";
    boolean wio = true;

    public void setWIO(boolean val) {
        this.wio = val;
    }

    public int getType() {
        return 1000;
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1000);
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1000);
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        if (xmlTree.getName().equals(JEUS_EJB_DD)) {
            EJBModDescriptor modDescriptor = new EJBModDescriptor();
            XMLTree moduleInfoTree = xmlTree.getFirstElement(MODULE_INFO);
            String moduleName = XMLUtil.getSubtreeValue(moduleInfoTree, MODULE_NAME);
            if (moduleName != null && moduleName.trim().compareTo("") != 0) {
                modDescriptor.setModuleName(moduleName);
            }
            modDescriptor.setRUTable(this.getRoleAssign(moduleInfoTree));
            XMLTree beanlistTree = xmlTree.getFirstElement(BEANLIST);
            Vector<EJBDescriptor> beanList = new Vector<EJBDescriptor>();
            Enumeration e = beanlistTree.elements();
            while (e.hasMoreElements()) {
                XMLTree beanTree = (XMLTree)e.nextElement();
                beanList.addElement(this.getEJBDescriptor(beanTree));
            }
            modDescriptor.setBeanList(beanList);
            this.fillRelationList(xmlTree, modDescriptor);
            return modDescriptor;
        }
        return null;
    }

    public void fillRelationList(XMLTree xmlTree, EJBModDescriptor modDescriptor) throws XMLConverterException {
        if (xmlTree == null) {
            return;
        }
        Vector relationList = new Vector();
        Enumeration reEnum = xmlTree.elements(RELATION_MAP);
        while (reEnum.hasMoreElements()) {
            XMLTree relationMapTree = (XMLTree)reEnum.nextElement();
            String relationName = XMLUtil.getSubtreeValue(relationMapTree, RELATION_NAME);
            if (relationName == null) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "ejb-relation-map/relation-name");
            }
            String tableNameRelation = XMLUtil.getSubtreeValue(relationMapTree, TABLE_NAME);
            Vector<EJBRelationshipDescriptor> relationItem = new Vector<EJBRelationshipDescriptor>();
            Enumeration jreEnum = relationMapTree.elements(JEUS_RELATIONSHIP_ROLE);
            while (jreEnum.hasMoreElements()) {
                XMLTree jreTree = (XMLTree)jreEnum.nextElement();
                String roleName = XMLUtil.getSubtreeValue(jreTree, RELATIONSHIP_ROLE_NAME);
                if (roleName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "jeus-relationship-role/relationship-role-name");
                }
                EJBRelationshipDescriptor relationDesc = new EJBRelationshipDescriptor();
                relationDesc.setRelationName(relationName);
                relationDesc.setRelationshipRoleName(roleName);
                relationDesc.setRelationTableName(tableNameRelation);
                Enumeration cmEnum = jreTree.elements(COLUMN_MAP);
                while (cmEnum.hasMoreElements()) {
                    XMLTree cmTree = (XMLTree)cmEnum.nextElement();
                    String frKey = XMLUtil.getSubtreeValue(cmTree, FOREIGN_KEY_COLUMN);
                    String key = XMLUtil.getSubtreeValue(cmTree, KEY_COLUMN);
                    if (frKey == null) {
                        throw new XMLConverterException(JeusMessage_Converter._6001, "column-map/foreign-key-column");
                    }
                    if (key == null) {
                        throw new XMLConverterException(JeusMessage_Converter._6001, "column-map/key-column");
                    }
                    relationDesc.fkeyMapColNames.add(frKey);
                    relationDesc.fkeyMapFieldNames.add(key);
                }
                relationItem.add(relationDesc);
            }
            relationList.add(relationItem);
        }
        modDescriptor.setRelations(relationList);
    }

    public XMLTree constructXMLTree(Object object) {
        EJBModDescriptor modDescriptor = (EJBModDescriptor)object;
        XMLTree xmlTree = new XMLTree(JEUS_EJB_DD);
        Vector ruTable = modDescriptor.getRUTable();
        XMLTree moduleInfoTree = new XMLTree(MODULE_INFO);
        String moduleName = modDescriptor.getModuleName();
        XMLUtil.constructSubtree(moduleInfoTree, MODULE_NAME, moduleName);
        for (int i = 0; i < ruTable.size(); ++i) {
            XMLTree roleAssignTree = new XMLTree(ROLE_ASSIGN);
            RoleInfo roleInfo = (RoleInfo)ruTable.get(i);
            XMLUtil.constructSubtree(roleAssignTree, ROLE_NAME, roleInfo.getRole());
            Vector userTable = (Vector)roleInfo.getData();
            if (userTable != null) {
                XMLUtil.constructSubtrees(roleAssignTree, USER, userTable.toArray());
            }
            moduleInfoTree.addElement(roleAssignTree);
        }
        xmlTree.addElement(moduleInfoTree);
        Vector beanlist = modDescriptor.getBeanList();
        XMLTree beanlistTree = new XMLTree(BEANLIST);
        Enumeration e = beanlist.elements();
        while (e.hasMoreElements()) {
            EJBDescriptor descriptor = (EJBDescriptor)e.nextElement();
            XMLTree beanTree = this.constructEJBDescriptorTree(descriptor);
            beanlistTree.addElement(beanTree);
        }
        xmlTree.addElement(beanlistTree);
        return xmlTree;
    }

    public XMLTree constructEJBDescriptorTree(EJBDescriptor descriptor) {
        if (descriptor instanceof EJBSessionDescriptor) {
            EJBSessionDescriptor sessionDescriptor = (EJBSessionDescriptor)descriptor;
            if (sessionDescriptor.isStateful()) {
                return this.constructStatefulTree(sessionDescriptor);
            }
            return this.constructStatelessTree(sessionDescriptor);
        }
        if (descriptor instanceof EJBEntityDescriptor) {
            EJBEntityDescriptor entityDescriptor = (EJBEntityDescriptor)descriptor;
            if (entityDescriptor.isConManaged()) {
                return this.constructContainerManagedTree(entityDescriptor);
            }
            return this.constructBeanManagedTree(entityDescriptor);
        }
        EJBMessageDrivenDescriptor messageDrivenDescriptor = (EJBMessageDrivenDescriptor)descriptor;
        return this.constructMessageDrivenTree(messageDrivenDescriptor);
    }

    public String getCSIString(int val) {
        if (val == 0) {
            return "NotSupported";
        }
        if (val == 1) {
            return "Supports";
        }
        if (val == 2) {
            return "Requires";
        }
        return "NotSupported";
    }

    public int getCSIInt(String val) {
        if (val == null) {
            return 0;
        }
        if (val.equals("NotSupported")) {
            return 0;
        }
        if (val.equals("Supports")) {
            return 1;
        }
        if (val.equals("Requires")) {
            return 2;
        }
        return 0;
    }

    public void constructCSITree(XMLTree xmlTree, EJBDescriptor descriptor) {
        if (descriptor.getEJBCSIDescriptor() == null) {
            return;
        }
        XMLTree csiTree = new XMLTree(CSI);
        EJBCSIDescriptor mycsi = descriptor.getEJBCSIDescriptor();
        XMLUtil.constructSubtreeDefault(csiTree, CSI_IC, this.getCSIString(mycsi.getIC()), "NotSupported");
        XMLUtil.constructSubtreeDefault(csiTree, TRUST_IN_CLIENT, this.getCSIString(mycsi.getTrustInClient()), "NotSupported");
        XMLUtil.constructSubtreeDefault(csiTree, CLIENT_AUTH, this.getCSIString(mycsi.getClientAuth()), "NotSupported");
        XMLUtil.constructSubtreeDefault(csiTree, IDENTITY_ASSERTION, this.getCSIString(mycsi.getIdentityAssertion()), "NotSupported");
        if (csiTree.getElementCount() > 0) {
            xmlTree.addElement(csiTree);
        }
    }

    public void constructHttpInvokeTree(XMLTree xmlTree, EJBDescriptor descriptor) {
        if (!descriptor.isInvocationWithHttp()) {
            return;
        }
        XMLTree invokeHttpTree = new XMLTree(INVOKE_HTTP);
        XMLUtil.constructSubtree(invokeHttpTree, URL, descriptor.getHttpURL());
        XMLUtil.constructSubtree(invokeHttpTree, HTTP_PORT, String.valueOf(descriptor.getHttpPort()));
        xmlTree.addElement(invokeHttpTree);
    }

    public void constructJNDISPI(XMLTree xmlTree, EJBMessageDrivenDescriptor msgDesc) {
        if (msgDesc == null) {
            return;
        }
        if (msgDesc.getVendor() == null) {
            return;
        }
        XMLTree jndiSPITree = new XMLTree(JNDI_SPI);
        XMLUtil.constructStrictSubtree(jndiSPITree, MQ_VENDOR, msgDesc.getVendor());
        XMLUtil.constructStrictSubtree(jndiSPITree, INITIAL_CONTEXT_FACTORY, msgDesc.getInitialContextFactory());
        XMLUtil.constructSubtree(jndiSPITree, PROVIDER_URL, msgDesc.getProviderURL());
        if (jndiSPITree.getElementCount() > 0) {
            xmlTree.addElement(jndiSPITree);
        }
    }

    public void constructCommonTree(XMLTree xmlTree, EJBDescriptor descriptor) {
        Vector resEnvRefs;
        Vector resRefs;
        Vector ejbRefs;
        Vector envs;
        XMLUtil.constructSubtree(xmlTree, EJB_NAME, descriptor.getBeanName());
        XMLUtil.constructSubtreeDefault(xmlTree, EXPORT_PORT, String.valueOf(descriptor.getExportPort()), "0");
        XMLUtil.constructStrictSubtree(xmlTree, EXPORT_NAME, descriptor.getExportName());
        XMLUtil.constructStrictSubtree(xmlTree, LOCAL_EXPORT_NAME, descriptor.getLocalExportName());
        XMLUtil.constructSubtreeDefault(xmlTree, EXPORT_IIOP, String.valueOf(descriptor.getExportIIOP()), "false");
        XMLUtil.constructSubtreeDefault(xmlTree, LOCAL_INVO_OPTIMIZE, String.valueOf(descriptor.isLocalInvocationOptimized()), "true");
        XMLUtil.constructSubtreeDefault(xmlTree, SINGLE_VM_ONLY, String.valueOf(descriptor.isSingleVMOnly()), "false");
        this.constructCSITree(xmlTree, descriptor);
        String role_name = descriptor.getRunAsRole();
        String principal_name = descriptor.getRunAsName();
        if (role_name != null && !role_name.trim().equals("")) {
            XMLTree runAsTree = new XMLTree(RUN_AS_IDENTITY);
            XMLUtil.constructStrictSubtree(runAsTree, ROLE_NAME, role_name);
            XMLUtil.constructStrictSubtree(runAsTree, PRINCIPAL_NAME, principal_name);
            if (runAsTree.getElementCount() > 0) {
                xmlTree.addElement(runAsTree);
            }
        }
        if ((envs = descriptor.getEnvs()) != null && !envs.isEmpty()) {
            for (int i = 0; i < envs.size(); ++i) {
                XMLTree envTree = new XMLTree(ENV);
                JNDIInfo jndiInfo = (JNDIInfo)envs.get(i);
                XMLUtil.constructSubtree(envTree, NAME, jndiInfo.getRefName());
                Object object = jndiInfo.getTarget();
                String type = "";
                type = object instanceof Integer ? "java.lang.Integer" : (object instanceof Float ? "java.lang.Float" : (object instanceof Long ? "java.lang.Long" : (object instanceof Short ? "java.lang.Short" : (object instanceof Boolean ? "java.lang.Boolean" : (object instanceof Byte ? "java.lang.Byte" : (object instanceof Double ? "java.lang.Double" : "java.lang.String"))))));
                XMLUtil.constructStrictSubtree(envTree, TYPE, type);
                XMLUtil.constructStrictSubtree(envTree, VALUE, String.valueOf(jndiInfo.getTarget()));
                if (envTree.getElementCount() <= 0) continue;
                xmlTree.addElement(envTree);
            }
        }
        this.constructHttpInvokeTree(xmlTree, descriptor);
        EJBClusterDescriptor clusterDesc = descriptor.getClusterDesc();
        if (clusterDesc != null) {
            XMLTree clusterTree = new XMLTree(CLUSTERING);
            XMLUtil.constructSubtreeDefault(clusterTree, HOME_CLUSTERED, String.valueOf(clusterDesc.isHomeClustered()), "false");
            Vector homeMethods = clusterDesc.getEJBHomeIdempotentMethods();
            if (homeMethods == null) {
                XMLUtil.constructSubtreeDefault(clusterTree, EJB_HOME_COMPONENT_FAILOVER, "false", "false");
            } else if (homeMethods != null) {
                XMLUtil.constructSubtree(clusterTree, EJB_HOME_COMPONENT_FAILOVER, "true");
                Enumeration en = homeMethods.elements();
                while (en.hasMoreElements()) {
                    XMLUtil.constructSubtree(clusterTree, EJB_HOME_IDEMPOTENT_METHODS, (String)en.nextElement());
                }
            }
            Vector remoteMethods = clusterDesc.getEJBRemoteIdempotentMethods();
            if (remoteMethods == null) {
                XMLUtil.constructSubtreeDefault(clusterTree, EJB_REMOTE_COMPONENT_FAILOVER, "false", "false");
            } else if (remoteMethods != null) {
                XMLUtil.constructSubtree(clusterTree, EJB_REMOTE_COMPONENT_FAILOVER, "true");
                Enumeration en = remoteMethods.elements();
                while (en.hasMoreElements()) {
                    XMLUtil.constructSubtree(clusterTree, EJB_REMOTE_IDEMPOTENT_METHODS, (String)en.nextElement());
                }
            }
            if (clusterTree.getElementCount() > 0) {
                xmlTree.addElement(clusterTree);
            }
        }
        if ((ejbRefs = descriptor.getEJBRefs()) != null && !ejbRefs.isEmpty()) {
            XMLTree ejbRefTree = new XMLTree(EJB_REF);
            for (int i = 0; i < ejbRefs.size(); ++i) {
                XMLTree jndiTree = new XMLTree(JNDI_INFO);
                JNDIInfo jndiInfo = (JNDIInfo)ejbRefs.get(i);
                XMLUtil.constructStrictSubtree(jndiTree, REF_NAME, jndiInfo.getRefName());
                XMLUtil.constructStrictSubtree(jndiTree, EXPORT_NAME, (String)jndiInfo.getTarget());
                if (jndiTree.getElementCount() <= 0) continue;
                ejbRefTree.addElement(jndiTree);
            }
            if (ejbRefTree.getElementCount() > 0) {
                xmlTree.addElement(ejbRefTree);
            }
        }
        if ((resRefs = descriptor.getResourceRefs()) != null && !resRefs.isEmpty()) {
            XMLTree resRefTree = new XMLTree(RES_REF);
            for (int i = 0; i < resRefs.size(); ++i) {
                XMLTree jndiTree = new XMLTree(JNDI_INFO);
                JNDIInfo jndiInfo = (JNDIInfo)resRefs.get(i);
                XMLUtil.constructStrictSubtree(jndiTree, REF_NAME, jndiInfo.getRefName());
                XMLUtil.constructStrictSubtree(jndiTree, EXPORT_NAME, (String)jndiInfo.getTarget());
                if (jndiTree.getElementCount() <= 0) continue;
                resRefTree.addElement(jndiTree);
            }
            if (resRefTree.getElementCount() > 0) {
                xmlTree.addElement(resRefTree);
            }
        }
        if ((resEnvRefs = descriptor.getResourceEnvRefs()) != null && !resEnvRefs.isEmpty()) {
            XMLTree resEnvRefTree = new XMLTree(RES_ENV_REF);
            for (int i = 0; i < resEnvRefs.size(); ++i) {
                XMLTree jndiTree = new XMLTree(JNDI_INFO);
                JNDIInfo jndiInfo = (JNDIInfo)resEnvRefs.get(i);
                XMLUtil.constructStrictSubtree(jndiTree, REF_NAME, jndiInfo.getRefName());
                XMLUtil.constructStrictSubtree(jndiTree, EXPORT_NAME, (String)jndiInfo.getTarget());
                if (jndiTree.getElementCount() <= 0) continue;
                resEnvRefTree.addElement(jndiTree);
            }
            if (resEnvRefTree.getElementCount() > 0) {
                xmlTree.addElement(resEnvRefTree);
            }
        }
        if (descriptor instanceof EJBSessionDescriptor && !((EJBSessionDescriptor)descriptor).isStateful() || descriptor instanceof EJBMessageDrivenDescriptor) {
            return;
        }
        XMLUtil.constructSubtreeDefault(xmlTree, PASSIVATION_TIMEOUT, String.valueOf(descriptor.getPassivationTimeout()), "-1");
        XMLUtil.constructSubtreeDefault(xmlTree, DISCONNECT_TIMEOUT, String.valueOf(descriptor.getDisconnectTimeout()), "-1");
    }

    public void constructThreadPoolTree(XMLTree xmlTree, EJBDescriptor descriptor) {
        XMLTree threadPoolTree = new XMLTree(THREAD_POOL);
        XMLUtil.constructSubtreeDefault(threadPoolTree, POOL_MIN, String.valueOf(descriptor.getThreadPoolSize()), "20");
        XMLUtil.constructSubtreeDefault(threadPoolTree, POOL_MAX, String.valueOf(descriptor.getThreadPoolMax()), "100");
        XMLUtil.constructSubtreeDefault(threadPoolTree, POOL_STEP, String.valueOf(descriptor.getThreadPoolStep()), "20");
        XMLUtil.constructSubtreeDefault(threadPoolTree, RESIZING_PERIOD, String.valueOf(descriptor.getThreadPoolResizingPeriod()), "3600000");
        if (threadPoolTree.getElementCount() > 0) {
            xmlTree.addElement(threadPoolTree);
        }
    }

    public void constructPoolTree(XMLTree xmlTree, EJBDescriptor descriptor) {
        XMLTree beanPoolTree = new XMLTree(BEAN_POOL);
        XMLUtil.constructSubtreeDefault(beanPoolTree, POOL_MIN, String.valueOf(descriptor.getEJBBeanPoolSize()), "0");
        XMLUtil.constructSubtreeDefault(beanPoolTree, POOL_MAX, String.valueOf(descriptor.getEJBBeanPoolMax()), "100");
        XMLUtil.constructSubtreeDefault(beanPoolTree, RESIZING_PERIOD, String.valueOf(descriptor.getEJBBeanPoolResizingPeriod()), "3600000");
        if (beanPoolTree.getElementCount() > 0) {
            xmlTree.addElement(beanPoolTree);
        }
        XMLTree connectPoolTree = new XMLTree(CONNECT_POOL);
        XMLUtil.constructSubtreeDefault(connectPoolTree, POOL_MIN, String.valueOf(descriptor.getConnectPoolSize()), "0");
        XMLUtil.constructSubtreeDefault(connectPoolTree, POOL_MAX, String.valueOf(descriptor.getConnectPoolMax()), "100");
        XMLUtil.constructSubtreeDefault(connectPoolTree, RESIZING_PERIOD, String.valueOf(descriptor.getConnectPoolResizingPeriod()), "3600000");
        if (connectPoolTree.getElementCount() > 0) {
            xmlTree.addElement(connectPoolTree);
        }
        this.constructThreadPoolTree(xmlTree, descriptor);
        XMLUtil.constructSubtreeDefault(xmlTree, CAPACITY, String.valueOf(descriptor.getCapacity()), "10000");
    }

    public XMLTree constructMessageDrivenTree(EJBMessageDrivenDescriptor messageDrivenDescriptor) {
        XMLTree messageDrivenTree = new XMLTree(MESSAGE_DRIVEN);
        this.constructCommonTree(messageDrivenTree, messageDrivenDescriptor);
        this.constructThreadPoolTree(messageDrivenTree, messageDrivenDescriptor);
        XMLUtil.constructSubtree(messageDrivenTree, CONNECTION_FACTORY_NAME, messageDrivenDescriptor.getFactoryName());
        XMLUtil.constructSubtree(messageDrivenTree, DESTINATION, messageDrivenDescriptor.getDestination());
        XMLUtil.constructSubtreeDefault(messageDrivenTree, MAX_MESSAGE, String.valueOf(messageDrivenDescriptor.getMaxMessage()), "10");
        this.constructJNDISPI(messageDrivenTree, messageDrivenDescriptor);
        if (messageDrivenDescriptor.getAckMode() == 3) {
            XMLUtil.constructSubtreeDefault(messageDrivenTree, ACK_MODE, "Auto-acknowledge", "Auto-acknowledge");
        } else {
            XMLUtil.constructSubtreeDefault(messageDrivenTree, ACK_MODE, "Dups-ok-acknowledge", "Auto-acknowledge");
        }
        XMLUtil.constructSubtreeDefault(messageDrivenTree, DURABLE, String.valueOf(messageDrivenDescriptor.isDurable()), "false");
        XMLUtil.constructStrictSubtree(messageDrivenTree, MSG_SELECTOR, messageDrivenDescriptor.getMessageSelector());
        return messageDrivenTree;
    }

    public XMLTree constructStatelessTree(EJBSessionDescriptor sessionDescriptor) {
        XMLTree statelessTree = new XMLTree(STATELESS);
        this.constructCommonTree(statelessTree, sessionDescriptor);
        this.constructThreadPoolTree(statelessTree, sessionDescriptor);
        return statelessTree;
    }

    public XMLTree constructStatefulTree(EJBSessionDescriptor sessionDescriptor) {
        XMLTree statefulTree = new XMLTree(STATEFUL);
        this.constructCommonTree(statefulTree, sessionDescriptor);
        this.constructPoolTree(statefulTree, sessionDescriptor);
        XMLUtil.constructSubtreeDefault(statefulTree, IS_LOCAL_FILE_DB, String.valueOf(sessionDescriptor.isLocalFileDB()), "true");
        if (sessionDescriptor.isLocalFileDB()) {
            XMLUtil.constructStrictSubtree(statefulTree, FILE_DB_PATH, sessionDescriptor.getFileDBPath());
            XMLUtil.constructStrictSubtree(statefulTree, FILE_DB_NAME, sessionDescriptor.getFileDBName());
            XMLUtil.constructSubtreeDefault(statefulTree, MIN_HOLE, String.valueOf(sessionDescriptor.getMinHole()), "1000");
            XMLUtil.constructSubtreeDefault(statefulTree, PACKING_RATE, String.valueOf(sessionDescriptor.getPackingRate()), "0.5");
            XMLUtil.constructSubtreeDefault(statefulTree, POOLING_BEAN, String.valueOf(sessionDescriptor.isPoolingBeans()), "false");
        } else {
            XMLUtil.constructStrictSubtree(statefulTree, REMOTE_PRIMARY_FILE_DB, sessionDescriptor.getPrimaryFileDBName());
            XMLUtil.constructStrictSubtree(statefulTree, REMOTE_BACKUP_FILE_DB, sessionDescriptor.getBackupFileDBName());
            XMLUtil.constructSubtreeDefault(statefulTree, CONN_POOL_SIZE, String.valueOf(sessionDescriptor.getConnectionPoolSize()), "20");
        }
        return statefulTree;
    }

    public XMLTree constructBeanManagedTree(EJBEntityDescriptor entityDescriptor) {
        XMLTree beanManagedTree = new XMLTree(BEAN_MANAGED);
        this.constructCommonTree(beanManagedTree, entityDescriptor);
        this.constructPoolTree(beanManagedTree, entityDescriptor);
        int engine = entityDescriptor.getEngineType();
        String engineType = null;
        if (engine == 1) {
            engineType = EXCLUSIVE_ACCESS;
        } else if (engine == 2) {
            engineType = SINGLE_OBJECT;
        } else if (engine == 3) {
            engineType = MULTIPLE_OBJECT;
        }
        XMLUtil.constructSubtreeDefault(beanManagedTree, ENGINE_TYPE, engineType, EXCLUSIVE_ACCESS);
        int entityCacheSize = entityDescriptor.getEntityCacheSize();
        XMLUtil.constructSubtreeDefault(beanManagedTree, ENTITY_CACHE_SIZE, String.valueOf(entityCacheSize), "0");
        Vector nmMethods = entityDescriptor.getNMMethods();
        for (int i = 0; i < nmMethods.size(); ++i) {
            XMLUtil.constructSubtree(beanManagedTree, NON_MODIFYING_METHODS, (String)nmMethods.get(i));
        }
        return beanManagedTree;
    }

    public XMLTree constructContainerManagedTree(EJBEntityDescriptor entityDescriptor) {
        XMLTree containerManagedTree = new XMLTree(CONTAINER_MANAGED);
        EJBDBInfo dbInfo = entityDescriptor.getEJBDBInfo();
        int cmpVersion = entityDescriptor.getCMPVersion();
        this.constructCommonTree(containerManagedTree, entityDescriptor);
        this.constructPoolTree(containerManagedTree, entityDescriptor);
        int engine = entityDescriptor.getEngineType();
        String engineType = null;
        if (engine == 1) {
            engineType = EXCLUSIVE_ACCESS;
        } else if (engine == 2) {
            engineType = SINGLE_OBJECT;
        } else if (engine == 3) {
            engineType = MULTIPLE_OBJECT;
        }
        XMLUtil.constructSubtreeDefault(containerManagedTree, ENGINE_TYPE, engineType, EXCLUSIVE_ACCESS);
        int entityCacheSize = entityDescriptor.getEntityCacheSize();
        XMLUtil.constructSubtreeDefault(containerManagedTree, ENTITY_CACHE_SIZE, String.valueOf(entityCacheSize), "0");
        if (engine != 1) {
            int subEngine = entityDescriptor.getSubEngineType();
            String subEngineType = null;
            if (subEngine == 1) {
                subEngineType = READ_LOCKING;
            } else if (subEngine == 2) {
                subEngineType = WRITE_LOCKING;
            } else if (subEngine == 4) {
                subEngineType = WRITE_LOCKING_FIND;
            } else if (subEngine == 3) {
                subEngineType = OPTIMISTIC_UPDATE;
            }
            XMLUtil.constructSubtreeDefault(containerManagedTree, SUBENGINE_TYPE, subEngineType, READ_LOCKING);
        }
        boolean initCachingVal = entityDescriptor.isInitCaching();
        XMLUtil.constructSubtreeDefault(containerManagedTree, INIT_CACHING, String.valueOf(initCachingVal), "false");
        int fetchSizeVal = entityDescriptor.getFetchSize();
        XMLUtil.constructSubtreeDefault(containerManagedTree, FETCH_SIZE, String.valueOf(fetchSizeVal), "10");
        Vector nmMethods = entityDescriptor.getNMMethods();
        for (int i = 0; i < nmMethods.size(); ++i) {
            XMLUtil.constructStrictSubtree(containerManagedTree, NON_MODIFYING_METHODS, (String)nmMethods.get(i));
        }
        ArrayList cmFields = dbInfo.cmFields;
        ArrayList cmFieldColNames = dbInfo.cmFieldColNames;
        ArrayList cmFieldTypes = dbInfo.cmFieldTypes;
        ArrayList cmFieldExclude = dbInfo.cmExcludeList;
        for (int i = 0; i < cmFields.size(); ++i) {
            XMLTree cmFieldTree = new XMLTree(CMFIELDS);
            if (cmFieldExclude != null && cmFieldExclude.contains(cmFields.get(i))) {
                XMLUtil.constructSubtree(cmFieldTree, FIELD_EXCLUDE, "true");
            } else {
                String type;
                XMLUtil.constructSubtree(cmFieldTree, FIELD, (String)cmFields.get(i));
                String colName = (String)cmFieldColNames.get(i);
                if (!colName.equals("")) {
                    XMLUtil.constructSubtree(cmFieldTree, COLUMN_NAME, colName);
                }
                if (!(type = (String)cmFieldTypes.get(i)).equals("")) {
                    XMLUtil.constructSubtree(cmFieldTree, TYPE, type);
                }
            }
            containerManagedTree.addElement(cmFieldTree);
        }
        ArrayList primKeyFields = dbInfo.cmPkeyFields;
        for (String primKey : primKeyFields) {
            XMLUtil.constructSubtree(containerManagedTree, PRIM_KEY_FIELDS, primKey);
        }
        ArrayList findMethods = dbInfo.findMethods;
        ArrayList findSQLs = dbInfo.findSQLs;
        boolean[] resTypeList = null;
        if (cmpVersion == 2) {
            resTypeList = dbInfo.getEJBQLReturnTypes();
            if (dbInfo == null) {
                resTypeList = new boolean[findSQLs.size()];
            }
        }
        for (int i = 0; i < findSQLs.size(); ++i) {
            XMLTree findMethodsTree = new XMLTree(FIND_METHODS);
            XMLUtil.constructSubtree(findMethodsTree, METHOD, (String)findMethods.get(i));
            XMLUtil.constructSubtree(findMethodsTree, SQL, (String)findSQLs.get(i));
            if (cmpVersion == 2) {
                if (resTypeList[i]) {
                    XMLUtil.constructSubtree(findMethodsTree, RESULT_TYPE, "Remote");
                } else {
                    XMLUtil.constructSubtree(findMethodsTree, RESULT_TYPE, "Local");
                }
            }
            containerManagedTree.addElement(findMethodsTree);
        }
        XMLUtil.constructSubtree(containerManagedTree, DB_VENDOR, dbInfo.getDBVendor());
        XMLUtil.constructSubtree(containerManagedTree, DATA_SOURCE_NAME, dbInfo.getDataSourceName());
        XMLUtil.constructSubtreeDefault(containerManagedTree, IS_CREATING_TABLE, String.valueOf(dbInfo.isCreatingTable()), "false");
        XMLUtil.constructSubtreeDefault(containerManagedTree, IS_DELETING_TABLE, String.valueOf(dbInfo.isDeletingTable()), "false");
        String tableName = dbInfo.getTableName();
        XMLUtil.constructStrictSubtree(containerManagedTree, TABLE_NAME, tableName);
        return containerManagedTree;
    }

    public Vector getRoleAssign(XMLTree xmlTree) throws XMLConverterException {
        Vector<RoleInfo> ruTable = new Vector<RoleInfo>();
        if (xmlTree != null) {
            Vector roleAssignTrees = xmlTree.getElements(ROLE_ASSIGN);
            for (int i = 0; i < roleAssignTrees.size(); ++i) {
                XMLTree roleAssignTree = (XMLTree)roleAssignTrees.get(i);
                String roleName = XMLUtil.getSubtreeValue(roleAssignTree, ROLE_NAME);
                if (roleName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "role-assign/role-name");
                }
                Vector<String> userTable = new Vector<String>();
                String[] users = XMLUtil.getSubtreeValues(roleAssignTree, USER);
                if (users != null) {
                    userTable.addAll(Arrays.asList(users));
                }
                RoleInfo roleInfo = new RoleInfo(roleName, userTable);
                ruTable.addElement(roleInfo);
            }
        }
        return ruTable;
    }

    public EJBCSIDescriptor getEJBCSIDescriptor(XMLTree xmlTree) {
        if (xmlTree == null) {
            return null;
        }
        XMLTree csiTree = xmlTree.getFirstElement(CSI);
        if (csiTree == null) {
            return null;
        }
        EJBCSIDescriptor myCsiDesc = new EJBCSIDescriptor();
        String icValue = XMLUtil.getSubtreeValueDefault(csiTree, CSI_IC, "NotSupported");
        myCsiDesc.setIC(this.getCSIInt(icValue));
        String trust = XMLUtil.getSubtreeValueDefault(csiTree, TRUST_IN_CLIENT, "NotSupported");
        myCsiDesc.setTrustInClient(this.getCSIInt(trust));
        String clientAuth = XMLUtil.getSubtreeValueDefault(csiTree, CLIENT_AUTH, "NotSupported");
        myCsiDesc.setClientAuth(this.getCSIInt(clientAuth));
        String identityAssert = XMLUtil.getSubtreeValueDefault(csiTree, IDENTITY_ASSERTION, "NotSupported");
        myCsiDesc.setIdentityAssertion(this.getCSIInt(identityAssert));
        if (myCsiDesc.getIC() == 0 && myCsiDesc.getTrustInClient() == 0 && myCsiDesc.getClientAuth() == 0) {
            return null;
        }
        return myCsiDesc;
    }

    public void fillHttpInvoke(EJBDescriptor descriptor, XMLTree xmlTree) throws XMLConverterException {
        if (descriptor == null || xmlTree == null) {
            return;
        }
        XMLTree httpInvokeTree = xmlTree.getFirstElement(INVOKE_HTTP);
        if (httpInvokeTree == null) {
            return;
        }
        String urlPath = XMLUtil.getSubtreeValue(httpInvokeTree, URL);
        if (urlPath == null || urlPath.trim().equals("")) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "invoke-http/url");
        }
        descriptor.setInvocationWithHttp(true);
        descriptor.setHttpURL(XMLUtil.getSubtreeValue(httpInvokeTree, URL));
        String port = XMLUtil.getSubtreeValue(httpInvokeTree, HTTP_PORT);
        try {
            int portNum = Integer.parseInt(port);
            descriptor.setHttpPort(portNum);
        }
        catch (Exception e) {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{HTTP_PORT, "int"});
        }
    }

    public void fillJNDISPI(EJBMessageDrivenDescriptor descriptor, XMLTree xmlTree) throws XMLConverterException {
        if (descriptor == null || xmlTree == null) {
            return;
        }
        XMLTree jndiSPITree = xmlTree.getFirstElement(JNDI_SPI);
        if (jndiSPITree == null) {
            return;
        }
        String vendor = XMLUtil.getSubtreeValue(jndiSPITree, MQ_VENDOR);
        descriptor.setVendor(vendor);
        descriptor.setInitialContextFactory(XMLUtil.getSubtreeValue(jndiSPITree, INITIAL_CONTEXT_FACTORY));
        descriptor.setProviderURL(XMLUtil.getSubtreeValue(jndiSPITree, PROVIDER_URL));
    }

    public EJBDescriptor getEJBDescriptor(XMLTree xmlTree) throws XMLConverterException {
        String dataSource;
        String[] nmMethods;
        XMLTree threadPoolTree;
        XMLTree connectPoolTree;
        String string;
        String min;
        String localExName;
        String exName;
        String exportPort;
        String treeName = xmlTree.getName();
        EJBDescriptor descriptor = null;
        descriptor = treeName.equals(STATELESS) || treeName.equals(STATEFUL) ? new EJBSessionDescriptor() : (treeName.equals(MESSAGE_DRIVEN) ? new EJBMessageDrivenDescriptor() : new EJBEntityDescriptor());
        String beanName = XMLUtil.getSubtreeValue(xmlTree, EJB_NAME);
        if (beanName != null) {
            descriptor.setBeanName(beanName);
        }
        if ((exportPort = XMLUtil.getSubtreeValueDefault(xmlTree, EXPORT_PORT, "0")) != null) {
            descriptor.setExportPort(Integer.valueOf(exportPort));
        }
        if ((exName = XMLUtil.getSubtreeValue(xmlTree, EXPORT_NAME)) != null && !exName.equals("")) {
            descriptor.setExportName(exName);
        }
        if ((localExName = XMLUtil.getSubtreeValue(xmlTree, LOCAL_EXPORT_NAME)) != null && !localExName.equals("")) {
            descriptor.setLocalExportName(localExName);
        }
        String exportIIOP = XMLUtil.getSubtreeValueDefault(xmlTree, EXPORT_IIOP, "false");
        descriptor.setExportIIOP(Boolean.valueOf(exportIIOP));
        String localInvoOptimize = XMLUtil.getSubtreeValueDefault(xmlTree, LOCAL_INVO_OPTIMIZE, "true");
        descriptor.setLocalInvocationOptimized(Boolean.valueOf(localInvoOptimize));
        String singleVMOnly = XMLUtil.getSubtreeValueDefault(xmlTree, SINGLE_VM_ONLY, "false");
        descriptor.setSingleVMOnly(Boolean.valueOf(singleVMOnly));
        descriptor.setEJBCSIDescriptor(this.getEJBCSIDescriptor(xmlTree));
        XMLTree runAsTree = xmlTree.getFirstElement(RUN_AS_IDENTITY);
        if (runAsTree != null) {
            String role_name = XMLUtil.getSubtreeValue(runAsTree, ROLE_NAME);
            String principal_name = XMLUtil.getSubtreeValue(runAsTree, PRINCIPAL_NAME);
            descriptor.setRunAsName(principal_name);
            descriptor.setRunAsRole(role_name);
        }
        this.fillHttpInvoke(descriptor, xmlTree);
        XMLTree clusterTree = xmlTree.getFirstElement(CLUSTERING);
        if (clusterTree != null) {
            EJBClusterDescriptor clusterDesc = new EJBClusterDescriptor();
            String homeClustered = XMLUtil.getSubtreeValueDefault(clusterTree, HOME_CLUSTERED, "false");
            if (homeClustered.compareTo("true") == 0) {
                clusterDesc.setHomeClustered(true);
            } else if (homeClustered.compareTo("false") == 0) {
                clusterDesc.setHomeClustered(false);
            }
            String homeFailover = XMLUtil.getSubtreeValueDefault(clusterTree, EJB_HOME_COMPONENT_FAILOVER, "false");
            if (homeFailover.compareTo("false") == 0) {
                clusterDesc.setEJBHomeIdempotentMethods(null);
            } else if (homeFailover.compareTo("true") == 0) {
                String[] homeMethods = XMLUtil.getSubtreeValues(clusterTree, EJB_HOME_IDEMPOTENT_METHODS);
                if (homeMethods == null) {
                    clusterDesc.setEJBHomeIdempotentMethods(new Vector());
                } else if (homeMethods.length > 0) {
                    clusterDesc.setEJBHomeIdempotentMethods(new Vector<String>(Arrays.asList(homeMethods)));
                } else {
                    clusterDesc.setEJBHomeIdempotentMethods(new Vector());
                }
            }
            String remoteFailover = XMLUtil.getSubtreeValueDefault(clusterTree, EJB_REMOTE_COMPONENT_FAILOVER, "false");
            if (remoteFailover.compareTo("false") == 0) {
                clusterDesc.setEJBRemoteIdempotentMethods(null);
            } else if (remoteFailover.compareTo("true") == 0) {
                String[] remoteMethods = XMLUtil.getSubtreeValues(clusterTree, EJB_REMOTE_IDEMPOTENT_METHODS);
                if (remoteMethods == null) {
                    clusterDesc.setEJBRemoteIdempotentMethods(new Vector());
                } else if (remoteMethods.length > 0) {
                    clusterDesc.setEJBRemoteIdempotentMethods(new Vector<String>(Arrays.asList(remoteMethods)));
                } else {
                    clusterDesc.setEJBRemoteIdempotentMethods(new Vector());
                }
            }
            descriptor.setClusterDesc(clusterDesc);
        } else {
            descriptor.setClusterDesc(null);
        }
        Vector envTrees = xmlTree.getElements(ENV);
        Vector<JNDIInfo> envs = new Vector<JNDIInfo>();
        for (int i = 0; i < envTrees.size(); ++i) {
            XMLTree envTree = (XMLTree)envTrees.get(i);
            String name = XMLUtil.getSubtreeValue(envTree, NAME);
            if (name == null) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "env/name");
            }
            String type = XMLUtil.getSubtreeValue(envTree, TYPE);
            if (type == null) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "env/type");
            }
            String value = XMLUtil.getSubtreeValue(envTree, VALUE);
            Object target = "";
            if (type.compareToIgnoreCase("int") == 0 || type.compareToIgnoreCase("Integer") == 0 || type.equals("java.lang.Integer")) {
                target = Integer.valueOf(value);
            } else if (type.compareToIgnoreCase("long") == 0 || type.compareToIgnoreCase("Long") == 0 || type.equals("java.lang.Long")) {
                target = Long.valueOf(value);
            } else if (type.compareToIgnoreCase("float") == 0 || type.compareToIgnoreCase("Float") == 0 || type.equals("java.lang.Float")) {
                target = Float.valueOf(value);
            } else if (type.compareToIgnoreCase("boolean") == 0 || type.compareToIgnoreCase("Boolean") == 0 || type.equals("java.lang.Boolean")) {
                target = Boolean.valueOf(value);
            } else if (type.compareToIgnoreCase("double") == 0 || type.compareToIgnoreCase("Double") == 0 || type.equals("java.lang.Double")) {
                target = Double.valueOf(value);
            } else if (type.compareToIgnoreCase("byte") == 0 || type.compareToIgnoreCase("Byte") == 0 || type.equals("java.lang.Byte")) {
                target = Byte.valueOf(value);
            } else if (type.compareToIgnoreCase("short") == 0 || type.compareToIgnoreCase("Short") == 0 || type.equals("java.lang.Short")) {
                target = Short.valueOf(value);
            } else if (type.compareToIgnoreCase("char") == 0 || type.compareToIgnoreCase("Char") == 0 || type.equals("java.lang.Character")) {
                char[] carray = value.toCharArray();
                target = new Character(carray[0]);
            } else {
                target = value;
            }
            JNDIInfo jndiInfo = new JNDIInfo(name, target);
            envs.addElement(jndiInfo);
        }
        descriptor.setEnvs(envs);
        XMLTree ejbRefTree = xmlTree.getFirstElement(EJB_REF);
        Vector<JNDIInfo> ejbRefs = new Vector<JNDIInfo>();
        if (ejbRefTree != null) {
            Vector jndiTrees = ejbRefTree.getElements();
            for (int i = 0; i < jndiTrees.size(); ++i) {
                XMLTree jndiTree = (XMLTree)jndiTrees.get(i);
                String refName = XMLUtil.getSubtreeValue(jndiTree, REF_NAME);
                if (refName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "ejb-ref/ref-name");
                }
                String exportName = XMLUtil.getSubtreeValue(jndiTree, EXPORT_NAME);
                if (exportName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "ejb-ref/export-name");
                }
                JNDIInfo jndiInfo = new JNDIInfo(refName, exportName);
                ejbRefs.addElement(jndiInfo);
            }
        }
        descriptor.setEJBRefs(ejbRefs);
        XMLTree resRefTree = xmlTree.getFirstElement(RES_REF);
        Vector<JNDIInfo> resRefs = new Vector<JNDIInfo>();
        if (resRefTree != null) {
            Vector jndiTrees = resRefTree.getElements();
            for (int i = 0; i < jndiTrees.size(); ++i) {
                XMLTree jndiTree = (XMLTree)jndiTrees.get(i);
                String refName = XMLUtil.getSubtreeValue(jndiTree, REF_NAME);
                if (refName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "res-ref/ref-name");
                }
                String exportName = XMLUtil.getSubtreeValue(jndiTree, EXPORT_NAME);
                if (exportName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "res-ref/export-name");
                }
                JNDIInfo jndiInfo = new JNDIInfo(refName, exportName);
                resRefs.addElement(jndiInfo);
            }
        }
        descriptor.setResourceRefs(resRefs);
        XMLTree resEnvRefTree = xmlTree.getFirstElement(RES_ENV_REF);
        Vector<JNDIInfo> resEnvRefs = new Vector<JNDIInfo>();
        if (resEnvRefTree != null) {
            Vector jndiTrees = ejbRefTree.getElements();
            for (int i = 0; i < jndiTrees.size(); ++i) {
                XMLTree jndiTree = (XMLTree)jndiTrees.get(i);
                String refName = XMLUtil.getSubtreeValue(jndiTree, REF_NAME);
                if (refName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "res-env-ref/ref-name");
                }
                String exportName = XMLUtil.getSubtreeValue(jndiTree, EXPORT_NAME);
                if (exportName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "res-env-ref/export-name");
                }
                JNDIInfo jndiInfo = new JNDIInfo(refName, exportName);
                resEnvRefs.addElement(jndiInfo);
            }
        }
        descriptor.setResourceEnvRefs(resEnvRefs);
        if (treeName.equals(STATELESS) || treeName.equals(MESSAGE_DRIVEN)) {
            XMLTree threadPoolTree2;
            XMLTree beanPoolTree = xmlTree.getFirstElement(BEAN_POOL);
            if (beanPoolTree != null) {
                String poolMin = XMLUtil.getSubtreeValueDefault(beanPoolTree, POOL_MIN, "20");
                String poolMax = XMLUtil.getSubtreeValueDefault(beanPoolTree, POOL_MAX, "100");
                String poolStep = XMLUtil.getSubtreeValueDefault(beanPoolTree, POOL_STEP, "20");
                String poolPeriod = XMLUtil.getSubtreeValueDefault(beanPoolTree, RESIZING_PERIOD, "3600000");
            }
            if ((threadPoolTree2 = xmlTree.getFirstElement(THREAD_POOL)) != null) {
                String poolMin = XMLUtil.getSubtreeValueDefault(threadPoolTree2, POOL_MIN, "20");
                String poolMax = XMLUtil.getSubtreeValueDefault(threadPoolTree2, POOL_MAX, "100");
                String poolStep = XMLUtil.getSubtreeValueDefault(threadPoolTree2, POOL_STEP, "20");
                String poolPeriod = XMLUtil.getSubtreeValueDefault(threadPoolTree2, RESIZING_PERIOD, "3600000");
            }
            if (treeName.equals(STATELESS)) {
                ((EJBSessionDescriptor)descriptor).setToStateful(false);
            } else if (treeName.equals(MESSAGE_DRIVEN)) {
                String durable;
                String destination;
                EJBMessageDrivenDescriptor ejbMsgDesc = (EJBMessageDrivenDescriptor)descriptor;
                String factoryName = XMLUtil.getSubtreeValue(xmlTree, CONNECTION_FACTORY_NAME);
                if (factoryName != null) {
                    ejbMsgDesc.setFactoryName(factoryName);
                }
                if ((destination = XMLUtil.getSubtreeValue(xmlTree, DESTINATION)) != null) {
                    ejbMsgDesc.setDestination(destination);
                }
                ejbMsgDesc.setMaxMessage(Integer.parseInt(XMLUtil.getSubtreeValueDefault(xmlTree, MAX_MESSAGE, "10")));
                String msgSelector = XMLUtil.getSubtreeValue(xmlTree, MSG_SELECTOR);
                if (msgSelector != null) {
                    ejbMsgDesc.setMessageSelector(msgSelector);
                }
                if ((durable = XMLUtil.getSubtreeValue(xmlTree, DURABLE)) != null && durable.compareToIgnoreCase("true") == 0) {
                    ejbMsgDesc.setDurable(true);
                } else {
                    ejbMsgDesc.setDurable(false);
                }
                String ackMode = XMLUtil.getSubtreeValue(xmlTree, ACK_MODE);
                if (ackMode != null && ackMode.compareToIgnoreCase("Dups-ok-acknowledge") == 0) {
                    ejbMsgDesc.setAckMode(3);
                } else {
                    ejbMsgDesc.setAckMode(1);
                }
                this.fillJNDISPI(ejbMsgDesc, xmlTree);
            }
            return descriptor;
        }
        XMLTree beanPoolTree = xmlTree.getFirstElement(BEAN_POOL);
        if (beanPoolTree != null) {
            min = XMLUtil.getSubtreeValueDefault(beanPoolTree, POOL_MIN, "0");
            String max = XMLUtil.getSubtreeValueDefault(beanPoolTree, POOL_MAX, "100");
            string = XMLUtil.getSubtreeValueDefault(beanPoolTree, RESIZING_PERIOD, "3600000");
        }
        if ((connectPoolTree = xmlTree.getFirstElement(CONNECT_POOL)) != null) {
            min = XMLUtil.getSubtreeValueDefault(connectPoolTree, POOL_MIN, "0");
            String max = XMLUtil.getSubtreeValueDefault(connectPoolTree, POOL_MAX, "100");
            string = XMLUtil.getSubtreeValueDefault(connectPoolTree, RESIZING_PERIOD, "3600000");
        }
        if ((threadPoolTree = xmlTree.getFirstElement(THREAD_POOL)) != null) {
            min = XMLUtil.getSubtreeValueDefault(threadPoolTree, POOL_MIN, "20");
            String max = XMLUtil.getSubtreeValueDefault(threadPoolTree, POOL_MAX, "100");
            String step = XMLUtil.getSubtreeValueDefault(threadPoolTree, POOL_STEP, "20");
            string = XMLUtil.getSubtreeValueDefault(threadPoolTree, RESIZING_PERIOD, "3600000");
        }
        String capacity = XMLUtil.getSubtreeValueDefault(xmlTree, CAPACITY, "10000");
        String passivationTO = XMLUtil.getSubtreeValueDefault(xmlTree, PASSIVATION_TIMEOUT, "-1");
        String disconnectTO = XMLUtil.getSubtreeValueDefault(xmlTree, DISCONNECT_TIMEOUT, "-1");
        if (treeName.equals(STATEFUL)) {
            EJBSessionDescriptor sessionDescriptor = (EJBSessionDescriptor)descriptor;
            sessionDescriptor.setToStateful(true);
            String isLocal = XMLUtil.getSubtreeValueDefault(xmlTree, IS_LOCAL_FILE_DB, "true");
            if (isLocal.compareToIgnoreCase("true") == 0) {
                String fileDBName;
                sessionDescriptor.setLocalFileDB(true);
                String fileDBPath = XMLUtil.getSubtreeValue(xmlTree, FILE_DB_PATH);
                if (fileDBPath != null) {
                    sessionDescriptor.setFileDBPath(fileDBPath);
                }
                if ((fileDBName = XMLUtil.getSubtreeValue(xmlTree, FILE_DB_NAME)) != null) {
                    sessionDescriptor.setFileDBName(fileDBName);
                }
                String minHole = XMLUtil.getSubtreeValueDefault(xmlTree, MIN_HOLE, "1000");
                String packingRate = XMLUtil.getSubtreeValueDefault(xmlTree, PACKING_RATE, "0.5");
                if (packingRate != null) {
                    sessionDescriptor.setPackingRate(Float.valueOf(packingRate).floatValue());
                }
            } else {
                String connPoolSize;
                String backupPrimary;
                sessionDescriptor.setLocalFileDB(false);
                String remotePrimary = XMLUtil.getSubtreeValue(xmlTree, REMOTE_PRIMARY_FILE_DB);
                if (remotePrimary != null) {
                    sessionDescriptor.setPrimaryFileDBName(remotePrimary);
                }
                if ((backupPrimary = XMLUtil.getSubtreeValue(xmlTree, REMOTE_BACKUP_FILE_DB)) != null) {
                    sessionDescriptor.setBackupFileDBName(backupPrimary);
                }
                if ((connPoolSize = XMLUtil.getSubtreeValueDefault(xmlTree, CONN_POOL_SIZE, "20")) != null) {
                    sessionDescriptor.setConnectionPoolSize(Integer.valueOf(connPoolSize));
                }
            }
            String poolingBean = XMLUtil.getSubtreeValueDefault(xmlTree, POOLING_BEAN, "false");
            if (poolingBean != null) {
                sessionDescriptor.setPoolingBeans(Boolean.valueOf(poolingBean));
            }
            return sessionDescriptor;
        }
        EJBEntityDescriptor entityDescriptor = (EJBEntityDescriptor)descriptor;
        String engineType = XMLUtil.getSubtreeValueDefault(xmlTree, ENGINE_TYPE, EXCLUSIVE_ACCESS);
        ValidString.restrictChoice(ENGINE_TYPE, engineType, EXCLUSIVE_ACCESS, SINGLE_OBJECT, MULTIPLE_OBJECT);
        int engine = 0;
        if (engineType.compareToIgnoreCase(EXCLUSIVE_ACCESS) == 0) {
            engine = 1;
        } else if (engineType.compareToIgnoreCase(SINGLE_OBJECT) == 0) {
            engine = 2;
        } else if (engineType.compareToIgnoreCase(MULTIPLE_OBJECT) == 0) {
            engine = 3;
        }
        entityDescriptor.setEngineType(engine);
        String entityCacheSizeVal = XMLUtil.getSubtreeValueDefault(xmlTree, ENTITY_CACHE_SIZE, "0");
        if (entityCacheSizeVal != null) {
            int entityCacheSize = Integer.valueOf(entityCacheSizeVal);
            entityDescriptor.setEntityCacheSize(entityCacheSize);
        }
        if ((nmMethods = XMLUtil.getSubtreeValues(xmlTree, NON_MODIFYING_METHODS)) == null) {
            entityDescriptor.setNMMethods(new Vector());
        } else {
            entityDescriptor.setNMMethods(new Vector<String>(Arrays.asList(nmMethods)));
        }
        if (treeName.equals(BEAN_MANAGED)) {
            entityDescriptor.setIsConManaged(false);
            entityDescriptor.setSubEngineType(-1);
            return descriptor;
        }
        entityDescriptor.setIsConManaged(true);
        String subEngineType = XMLUtil.getSubtreeValueDefault(xmlTree, SUBENGINE_TYPE, READ_LOCKING);
        ValidString.restrictChoice(SUBENGINE_TYPE, subEngineType, READ_LOCKING, OPTIMISTIC_UPDATE, WRITE_LOCKING, WRITE_LOCKING_FIND);
        int subEngine = 0;
        if (subEngineType != null) {
            if (subEngineType.compareToIgnoreCase(READ_LOCKING) == 0) {
                subEngine = 1;
            } else if (subEngineType.compareToIgnoreCase(WRITE_LOCKING) == 0) {
                subEngine = 2;
            } else if (subEngineType.compareToIgnoreCase(OPTIMISTIC_UPDATE) == 0) {
                subEngine = 3;
            } else if (subEngineType.compareToIgnoreCase(WRITE_LOCKING_FIND) == 0) {
                subEngine = 4;
            }
        }
        entityDescriptor.setSubEngineType(subEngine);
        String initCachingVal = XMLUtil.getSubtreeValueDefault(xmlTree, INIT_CACHING, "false");
        if (initCachingVal.compareToIgnoreCase("true") != 0 && initCachingVal.compareToIgnoreCase("false") != 0) {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{INIT_CACHING, "boolean"});
        }
        entityDescriptor.setInitCaching(Boolean.valueOf(initCachingVal));
        String fetchSizeVal = XMLUtil.getSubtreeValueDefault(xmlTree, FETCH_SIZE, "10");
        entityDescriptor.setFetchSize(Integer.valueOf(fetchSizeVal));
        String instantQL = XMLUtil.getSubtreeValueDefault(xmlTree, ENABLE_INSTANT_QL, "false");
        entityDescriptor.setEnableInstantQL(Boolean.valueOf(instantQL));
        EJBDBInfo dbInfo = new EJBDBInfo();
        String isCreatingTable = XMLUtil.getSubtreeValueDefault(xmlTree, IS_CREATING_TABLE, "false");
        try {
            if (isCreatingTable.compareToIgnoreCase("true") == 0) {
                dbInfo.setIsCreatingTable(true);
            } else {
                dbInfo.setIsCreatingTable(false);
            }
        }
        catch (Exception ex) {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{IS_CREATING_TABLE, "boolean"});
        }
        String isDeletingTable = XMLUtil.getSubtreeValueDefault(xmlTree, IS_DELETING_TABLE, "false");
        try {
            if (isDeletingTable.compareToIgnoreCase("true") == 0) {
                dbInfo.setIsDeletingTable(true);
            } else {
                dbInfo.setIsDeletingTable(false);
            }
        }
        catch (Exception ex) {
            throw new XMLConverterException(12100, new String[]{IS_DELETING_TABLE, "boolean"});
        }
        String tableName = XMLUtil.getSubtreeValue(xmlTree, TABLE_NAME);
        if (tableName != null) {
            dbInfo.setTableName(tableName);
        }
        ArrayList<String> cmFieldList = new ArrayList<String>();
        ArrayList<String> cmFieldColList = new ArrayList<String>();
        ArrayList<String> cmFieldTypeList = new ArrayList<String>();
        ArrayList<String> cmFieldExcludeList = new ArrayList<String>();
        Enumeration e = xmlTree.elements(CMFIELDS);
        while (e.hasMoreElements()) {
            XMLTree cmFieldTree = (XMLTree)e.nextElement();
            String cmFieldName = XMLUtil.getSubtreeValue(cmFieldTree, FIELD);
            String isExclude = XMLUtil.getSubtreeValue(cmFieldTree, FIELD_EXCLUDE);
            if (isExclude != null && isExclude.equalsIgnoreCase("true")) {
                cmFieldExcludeList.add(cmFieldName);
                continue;
            }
            cmFieldList.add(cmFieldName);
            String colName = XMLUtil.getSubtreeValue(cmFieldTree, COLUMN_NAME);
            if (colName == null) {
                colName = "";
            }
            cmFieldColList.add(colName);
            String type = XMLUtil.getSubtreeValue(cmFieldTree, TYPE);
            if (type == null) {
                type = "";
            }
            cmFieldTypeList.add(type);
        }
        dbInfo.cmFields = cmFieldList;
        dbInfo.cmFieldColNames = cmFieldColList;
        dbInfo.cmFieldTypes = cmFieldTypeList;
        dbInfo.cmExcludeList = cmFieldExcludeList;
        String[] primKeys = XMLUtil.getSubtreeValues(xmlTree, PRIM_KEY_FIELDS);
        if (primKeys != null) {
            dbInfo.cmPkeyFields = new ArrayList<String>(Arrays.asList(primKeys));
        }
        ArrayList<String> methodList = new ArrayList<String>();
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<String> resultTypeList = new ArrayList<String>();
        Enumeration enum1 = xmlTree.elements(FIND_METHODS);
        while (enum1.hasMoreElements()) {
            XMLTree findMethodTree = (XMLTree)enum1.nextElement();
            String method = XMLUtil.getSubtreeValue(findMethodTree, METHOD);
            if (method == null) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "find-methods/method");
            }
            methodList.add(method);
            String sql = XMLUtil.getSubtreeValue(findMethodTree, SQL);
            if (sql == null) {
                sql = "";
            }
            sqlList.add(sql);
            String resultType = XMLUtil.getSubtreeValue(findMethodTree, RESULT_TYPE);
            if (resultType != null && resultType.compareToIgnoreCase("Remote") == 0) {
                resultTypeList.add("true");
                continue;
            }
            resultTypeList.add("false");
        }
        dbInfo.findMethods = methodList;
        dbInfo.findSQLs = sqlList;
        boolean[] resultTypes = new boolean[resultTypeList.size()];
        for (int k = 0; k < resultTypeList.size(); ++k) {
            resultTypes[k] = Boolean.valueOf((String)resultTypeList.get(k));
        }
        dbInfo.setEJBQLReturnTypes(resultTypes);
        String dbVendor = XMLUtil.getSubtreeValue(xmlTree, DB_VENDOR);
        if (dbVendor != null) {
            dbVendor = ValidString.restrictChoice(DB_VENDOR, subEngineType, ORACLE, INFORMIX, DB2, MSSQL, SYBASE);
            dbInfo.setDBVendor(dbVendor);
        }
        if ((dataSource = XMLUtil.getSubtreeValue(xmlTree, DATA_SOURCE_NAME)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, DATA_SOURCE_NAME);
        }
        dbInfo.setDataSourceName(dataSource);
        entityDescriptor.setEJBDBInfo(dbInfo);
        return descriptor;
    }
}

