/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import jeus.descriptor.tool.MultiSessionInfo;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusPort;
import jeus.util.VirtualDNS;
import jeus.util.properties.JeusNetPropertyValues;

public class SessionInfoManager {
    ArrayList primaryList;
    ArrayList backupList;
    String FS = System.getProperty("file.separator");
    String JEUS_HOME = JeusBootstrapProperties.JEUS_HOME;

    public void fillInfo() throws Exception {
        boolean validate;
        String JEUS_MAIN_PATH;
        FileInputStream in;
        XMLUtil xmlUtil;
        XMLTree systemTree;
        this.primaryList = new ArrayList();
        this.backupList = new ArrayList();
        TreeSet<MultiSessionInfo> sortPrimList = new TreeSet<MultiSessionInfo>();
        TreeSet<MultiSessionInfo> sortBackupList = new TreeSet<MultiSessionInfo>();
        String HOST_NAME = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
        int pos = HOST_NAME.indexOf(".");
        if (pos > 0) {
            HOST_NAME = HOST_NAME.substring(0, pos);
        }
        if (!(systemTree = (xmlUtil = new XMLUtil()).process((InputStream)(in = new FileInputStream(new File(JEUS_MAIN_PATH = this.JEUS_HOME + this.FS + "config" + this.FS + HOST_NAME + this.FS + "JEUSMain.xml"))), validate = false, WIOParameters.getPublicID(1), WIOParameters.getSystemID(1))).getName().equals("jeus-system")) {
            return;
        }
        Enumeration e = systemTree.elements("node");
        while (e.hasMoreElements()) {
            XMLTree sessionTree;
            XMLTree nodeTree = (XMLTree)e.nextElement();
            String nodeName = XMLUtil.getSubtreeValue(nodeTree, "name");
            String realnode = VirtualDNS.getRealNodeName(nodeName);
            int port = JeusPort.SessionServer;
            int idx = realnode.indexOf(":");
            if (idx == -1) {
                nodeName = realnode;
            } else {
                nodeName = realnode.substring(0, idx);
                port = Integer.parseInt(realnode.substring(idx + 1));
            }
            if ((sessionTree = nodeTree.getFirstElement("session-server")) == null) continue;
            Enumeration e2 = sessionTree.elements("session-manager");
            while (e2.hasMoreElements()) {
                MultiSessionInfo msInfo;
                XMLTree sessionManagerTree = (XMLTree)e2.nextElement();
                String multiSessionType = XMLUtil.getSubtreeValue(sessionManagerTree, "multi-session");
                String managerName = XMLUtil.getSubtreeValue(sessionManagerTree, "name");
                String backupTrigger = XMLUtil.getSubtreeValue(sessionManagerTree, "backup-trigger");
                if (multiSessionType != null && multiSessionType.equalsIgnoreCase("primary")) {
                    msInfo = new MultiSessionInfo(nodeName, managerName, port);
                    if (backupTrigger != null) {
                        msInfo.setBackupTrigger(backupTrigger);
                    }
                    sortPrimList.add(msInfo);
                }
                if (multiSessionType == null || !multiSessionType.equalsIgnoreCase("backup")) continue;
                msInfo = new MultiSessionInfo(nodeName, managerName, port);
                if (backupTrigger != null) {
                    msInfo.setBackupTrigger(backupTrigger);
                }
                sortBackupList.add(msInfo);
            }
        }
        for (MultiSessionInfo pms : sortPrimList) {
            this.primaryList.add(pms);
        }
        for (MultiSessionInfo bms : sortBackupList) {
            this.backupList.add(bms);
        }
    }

    public ArrayList getPrimaryList(boolean readAgain) throws Exception {
        if (readAgain) {
            this.fillInfo();
        }
        if (this.primaryList == null) {
            this.fillInfo();
        }
        return this.primaryList;
    }

    public ArrayList getBackupList(boolean readAgain) throws Exception {
        if (readAgain) {
            this.fillInfo();
        }
        if (this.backupList == null) {
            this.fillInfo();
        }
        return this.backupList;
    }

    public static void main(String[] argv) {
        SessionInfoManager sm = new SessionInfoManager();
        try {
            MultiSessionInfo oneInfo;
            ArrayList plist = sm.getPrimaryList(false);
            ArrayList blist = sm.getBackupList(false);
            StringBuffer stb = new StringBuffer();
            stb.append("PRIMARY : ");
            for (int i = 0; i < plist.size(); ++i) {
                oneInfo = (MultiSessionInfo)plist.get(i);
                stb.append("[" + oneInfo + "] ");
            }
            stb.append("\n ");
            stb.append("BACKUP : ");
            for (int j = 0; j < blist.size(); ++j) {
                oneInfo = (MultiSessionInfo)blist.get(j);
                stb.append("[" + oneInfo + "] ");
            }
            System.out.println(stb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

