/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.ConfgParserWrapper;
import jeus.tool.common.xml.XMLTree;
import jeus.util.JeusException;
import jeus.util.JeusRootClassLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    private static final String DefaultContentType = "text/html;charset=8859_1";
    private static final String DefaultScheme = "file";
    private static final int PCDataType = 3;
    private static final String DEFAULT_CONFG_PARSER_NAME = "jeus.tool.common.xml.wrappers.ConfgParserJeus";
    private ConfgParserWrapper confgParser;
    public static final String CONFG_PARSER_NAME_KEY = "jeus.tool.common.xml.config-parser";
    private static final boolean DefaultXMLValidate = WIOParameters.XML_VALIDATION;
    private static final boolean DefaultCheckType = WIOParameters.XML_VALIDATION;

    public XMLUtil() {
        try {
            String parser = System.getProperty(CONFG_PARSER_NAME_KEY, DEFAULT_CONFG_PARSER_NAME);
            this.confgParser = (ConfgParserWrapper)JeusRootClassLoader.loader.loadClass(parser).newInstance();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void clear() {
        this.confgParser.clear();
    }

    public XMLTree process(InputStream is, int type) throws Exception {
        return this.process(is, WIOParameters.XML_VALIDATION, DefaultContentType, DefaultScheme, type);
    }

    public XMLTree process(InputStream is, boolean checkType, int type) throws Exception {
        return this.process(is, checkType, DefaultContentType, DefaultScheme, type);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType, int type) throws Exception {
        return this.process(is, checkType, contentType, DefaultScheme, type);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType, String scheme, int type) throws Exception {
        return this.parse(new InputSource(is), checkType, type);
    }

    public XMLTree process(URL uri, int type) throws Exception {
        return this.process(uri, WIOParameters.XML_VALIDATION, type);
    }

    public XMLTree process(URL uri, boolean checkType, int type) throws Exception {
        return this.parse(new InputSource(uri.toString()), checkType, type);
    }

    public void write() throws IOException {
        this.write(null);
    }

    public void write(OutputStream os) throws IOException {
        this.confgParser.write(os);
    }

    private XMLTree parse(InputSource is, boolean validate, int type) throws Exception {
        XMLTree tree;
        try {
            tree = this.confgParser.parse(is, validate, type);
        }
        catch (SAXParseException sae) {
            String systemId = "";
            int lineNumber = -1;
            String message = "";
            String publicId = "";
            int columnNumber = -1;
            systemId = sae.getSystemId();
            lineNumber = sae.getLineNumber();
            message = sae.getMessage();
            publicId = sae.getPublicId();
            columnNumber = sae.getColumnNumber();
            String msg = "(" + WIOParameters.getMainFileName(type) + " : " + lineNumber + ")\n" + message;
            throw new JeusException(msg);
        }
        catch (Exception e) {
            throw e;
        }
        return tree;
    }

    public void generate(XMLTree xmlTree, String publicID, String systemID) throws Exception {
        String pID = publicID;
        String sID = systemID;
        if (!WIOParameters.FORCED_DTD) {
            pID = xmlTree.getPublicID();
            sID = xmlTree.getSystemID();
            if (pID == null || pID.trim().equals("")) {
                pID = publicID;
            }
            if (sID == null || sID.trim().equals("")) {
                sID = systemID;
            }
        }
        this.confgParser.generate(xmlTree, pID, sID);
    }

    public void generate(XMLTree xmlTree) throws Exception {
        this.confgParser.generate(xmlTree);
    }

    public void save(File xmlFile) throws Exception {
        File parentFile = xmlFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        xmlFile.createNewFile();
        FileOutputStream os = new FileOutputStream(xmlFile);
        this.write(os);
        os.flush();
        ((OutputStream)os).close();
    }

    public String saveString() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.write(bos);
        bos.flush();
        bos.close();
        return bos.toString();
    }

    public String saveToString(XMLTree xmlTree, int type) throws Exception {
        String publicID = xmlTree.getPublicID();
        String systemID = xmlTree.getSystemID();
        String defaultPublicID = WIOParameters.getPublicID(type);
        String defaultSystemID = WIOParameters.getSystemID(type);
        if (publicID == null || publicID.trim().equals("")) {
            publicID = defaultPublicID;
        }
        if (systemID == null || systemID.trim().equals("")) {
            systemID = defaultSystemID;
        }
        this.generate(xmlTree, publicID, systemID);
        return this.saveString();
    }

    public String saveToString(XMLTree xmlTree, String defaultPublicID, String defaultSystemID) throws Exception {
        String publicID = xmlTree.getPublicID();
        String systemID = xmlTree.getSystemID();
        if (publicID == null || publicID.trim().equals("")) {
            publicID = defaultPublicID;
        }
        if (systemID == null || systemID.trim().equals("")) {
            systemID = defaultSystemID;
        }
        this.generate(xmlTree, publicID, systemID);
        return this.saveString();
    }

    public void saveWIO(XMLTree xmlTree, int type, File xmlFile) throws Exception {
        String publicID = xmlTree.getPublicID();
        String systemID = xmlTree.getSystemID();
        String defaultPublicID = WIOParameters.getPublicID(type);
        String defaultSystemID = WIOParameters.getSystemID(type);
        if (publicID == null || publicID.trim().equals("")) {
            publicID = defaultPublicID;
        }
        if (systemID == null || systemID.trim().equals("")) {
            systemID = defaultSystemID;
        }
        this.generate(xmlTree, publicID, systemID);
        this.save(xmlFile);
    }

    public XMLTree process(InputStream is, String publicID, String systemID) throws Exception {
        return this.process(is, DefaultCheckType, DefaultContentType, DefaultScheme, publicID, systemID);
    }

    public XMLTree process(InputStream is, boolean checkType, String publicID, String systemID) throws Exception {
        return this.process(is, checkType, DefaultContentType, DefaultScheme, publicID, systemID);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType, String publicID, String systemID) throws Exception {
        return this.process(is, checkType, contentType, DefaultScheme, publicID, systemID);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType, String scheme, String publicID, String systemID) throws Exception {
        return this.parse(new InputSource(is), checkType, publicID, systemID);
    }

    public XMLTree process(URL uri, String publicID, String systemID) throws Exception {
        return this.process(uri, DefaultCheckType, publicID, systemID);
    }

    public XMLTree process(URL uri, boolean checkType, String publicID, String systemID) throws Exception {
        return this.parse(new InputSource(uri.toString()), checkType, publicID, systemID);
    }

    private XMLTree parse(InputSource is, String publicID, String systemID) throws Exception {
        return this.parse(is, DefaultXMLValidate, publicID, systemID);
    }

    private XMLTree parse(InputSource is, boolean validate, String publicID, String systemID) throws Exception {
        return this.confgParser.parse(is, validate, publicID, systemID);
    }

    public static String getSubtreeValue(XMLTree xmlTree, String subTreeName) {
        String subTreeValue = null;
        XMLTree subTree = xmlTree.getFirstElement(subTreeName);
        if (subTree != null) {
            subTreeValue = subTree.getValue();
        }
        return subTreeValue;
    }

    public static String getSubtreeValueDefault(XMLTree xmlTree, String subTreeName, String defaultVal) {
        String subTreeValue = null;
        XMLTree subTree = xmlTree.getFirstElement(subTreeName);
        if (subTree != null) {
            if (subTree.getValue() == null || subTree.getValue().trim().equals("")) {
                subTreeValue = defaultVal;
            }
            if ((subTreeValue = subTree.getValue()) == null) {
                return defaultVal;
            }
        } else {
            subTreeValue = defaultVal;
        }
        return subTreeValue;
    }

    public static String[] getSubtreeValues(XMLTree xmlTree, String subTreeName) {
        String[] subTreeValues = null;
        Vector subTrees = xmlTree.getElements(subTreeName);
        int subTreeCount = subTrees.size();
        if (subTreeCount != 0) {
            subTreeValues = new String[subTreeCount];
            for (int i = 0; i < subTreeCount; ++i) {
                subTreeValues[i] = ((XMLTree)subTrees.get(i)).getValue();
            }
        }
        return subTreeValues;
    }

    public static void constructSubtree(XMLTree xmlTree, String name, String value) {
        if (value == null) {
            return;
        }
        XMLTree subTree = new XMLTree(name, value);
        xmlTree.addElement(subTree);
    }

    public static void constructSubtreeDefault(XMLTree xmlTree, String name, String value, String defaultVal) {
        if (value == null) {
            return;
        }
        if (value.trim().equals("")) {
            return;
        }
        if (value.equals(defaultVal)) {
            return;
        }
        XMLTree subTree = new XMLTree(name, value);
        xmlTree.addElement(subTree);
    }

    public static void constructStrictSubtree(XMLTree xmlTree, String name, String value) {
        if (value == null) {
            return;
        }
        if (value.trim().equals("")) {
            return;
        }
        XMLTree subTree = new XMLTree(name, value);
        xmlTree.addElement(subTree);
    }

    public static void constructSubtrees(XMLTree xmlTree, String name, Object[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            XMLTree subTree = new XMLTree(name, (String)values[i]);
            xmlTree.addElement(subTree);
        }
    }

    public static void constructSubtrees(XMLTree xmlTree, String name, String[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            XMLTree subTree = new XMLTree(name, values[i]);
            xmlTree.addElement(subTree);
        }
    }
}

