/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml.wrappers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.tool.common.xml.ConfgParserBase;
import jeus.tool.common.xml.ConfgParserWrapper;
import jeus.tool.common.xml.XMLTree;
import jeus.xml.util.DomProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XSConfgParserWrapper
extends ConfgParserBase
implements ConfgParserWrapper {
    private static final HashMap schemaMap = new HashMap();
    private static final Properties JEUS_ATTRS = new Properties();
    Document doc = null;

    public static void setSchemaAttributes(Document doc) {
        Element root = doc.getDocumentElement();
        Properties attrs = null;
        NodeList deploymentType = root.getElementsByTagNameNS(root.getNamespaceURI(), "deployment-type");
        attrs = deploymentType.getLength() > 0 || root.getLocalName().startsWith("jeus-") ? JEUS_ATTRS : (Properties)schemaMap.get(doc.getDocumentElement().getTagName());
        if (attrs != null) {
            Enumeration<Object> keys = attrs.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = attrs.getProperty(key);
                doc.getDocumentElement().setAttribute(key, value);
            }
        }
    }

    public XMLTree parse(InputSource is, boolean validate, int type) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validate);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.parse(is);
        XMLTree xmlElement = new XMLTree();
        Element element = this.doc.getDocumentElement();
        xmlElement.setName(element.getLocalName());
        this.addElements(xmlElement, element);
        XSConfgParserWrapper.setSchemaAttributes(this.doc);
        return xmlElement;
    }

    protected void addElements(XMLTree xmlElement, Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            XMLTree childXMLTree = new XMLTree();
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 8) continue;
            childXMLTree.setName(childNode.getLocalName());
            if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) {
                this.addElements(childXMLTree, childNode);
                xmlElement.addElement(childXMLTree);
                continue;
            }
            xmlElement.appendValue(childNode.getNodeValue());
        }
    }

    protected void restoreElements(Element node, XMLTree xmlTree) {
        Enumeration e = xmlTree.elements();
        while (e.hasMoreElements()) {
            XMLTree elementTree = (XMLTree)e.nextElement();
            String elementName = elementTree.getName();
            String elementValue = elementTree.getValue();
            Element elementNode = this.createElement(elementName);
            elementNode.setNodeValue(elementValue);
            if (elementTree.getElements().isEmpty()) {
                elementNode.appendChild(this.createTextNode(elementValue));
            } else {
                this.restoreElements(elementNode, elementTree);
            }
            node.appendChild(elementNode);
        }
    }

    public XMLTree parse(InputSource is, boolean validate, String publicID, String systemID) throws Exception {
        return this.parse(is, validate, -1);
    }

    public void generate(XMLTree xmlTree, String publicID, String systemID) throws Exception {
        this.generate(xmlTree);
    }

    public void generate(XMLTree xmlTree) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.doc.appendChild(this.doc.createElement(xmlTree.getName()));
        Element root = this.doc.getDocumentElement();
        this.restoreElements(root, xmlTree);
        XSConfgParserWrapper.setSchemaAttributes(this.doc);
    }

    public void clear() {
        this.doc = null;
    }

    public void write(OutputStream os) throws IOException {
        if (os == null) {
            os = System.out;
        }
        DomProcessor.serialize(this.doc, os);
    }

    protected Text createTextNode(String textNodeName) {
        return this.doc.createTextNode(textNodeName);
    }

    protected Element createElement(String elementName) {
        return this.doc.createElement(elementName);
    }

    static {
        Properties applicationAttrs = new Properties();
        applicationAttrs.put("version", "1.4");
        applicationAttrs.put("xmlns", "http://java.sun.com/xml/ns/j2ee");
        applicationAttrs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        applicationAttrs.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        Properties ejbJarAttrs = new Properties();
        ejbJarAttrs.put("version", "2.1");
        ejbJarAttrs.put("xmlns", "http://java.sun.com/xml/ns/j2ee");
        ejbJarAttrs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ejbJarAttrs.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd");
        Properties webAttrs = new Properties();
        webAttrs.put("version", "2.4");
        webAttrs.put("xmlns", "http://java.sun.com/xml/ns/j2ee");
        webAttrs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webAttrs.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd");
        Properties connectorAttrs = new Properties();
        connectorAttrs.put("version", "1.5");
        connectorAttrs.put("xmlns", "http://java.sun.com/xml/ns/j2ee");
        connectorAttrs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        connectorAttrs.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd");
        Properties clientAttrs = new Properties();
        clientAttrs.put("version", "1.4");
        clientAttrs.put("xmlns", "http://java.sun.com/xml/ns/j2ee");
        clientAttrs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        clientAttrs.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd");
        JEUS_ATTRS.put("xmlns", "http://www.tmaxsoft.com/xml/ns/jeus");
        schemaMap.put("application", applicationAttrs);
        schemaMap.put("ejb-jar", ejbJarAttrs);
        schemaMap.put("web-app", webAttrs);
        schemaMap.put("connector", connectorAttrs);
        schemaMap.put("application-client", clientAttrs);
    }
}

