/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import jeus.tool.common.ConfigDialog;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.ConfigContainerPanel;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.schema.ConfigContainer;

public class AdvancedConfigPanel
extends ConfigPanel {
    private String title = "my title";
    ConfigContainer configContainer;
    XMLTree myTree;
    ConfigContainerPanel advancedPanel;
    JButton bt = new JButton();
    JCheckBox cb = new JCheckBox();

    public AdvancedConfigPanel(ConfigContainer anyConfig, ConfigPanel subPane) {
        if (subPane instanceof ConfigContainerPanel) {
            this.advancedPanel = (ConfigContainerPanel)subPane;
        }
        this.title = anyConfig.getName();
        this.configContainer = anyConfig;
        this.bt.setText("More..");
        this.bt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.showPanel();
            }
        });
        this.cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.checkBoxClicked();
            }
        });
        this.bt.setEnabled(false);
        this.setLayout(new FlowLayout());
        this.add((Component)this.cb, null);
        this.add((Component)this.bt, null);
    }

    public void checkBoxClicked() {
        if (this.cb.isSelected()) {
            this.bt.setEnabled(true);
        } else {
            this.bt.setEnabled(false);
        }
    }

    public void showPanel() {
        if (this.advancedPanel == null) {
            return;
        }
        XMLTree originalTree = this.advancedPanel.getMyTree();
        ConfigDialog advancedDlg = new ConfigDialog(this.advancedPanel);
        boolean returnVal = advancedDlg.showDialog();
        if (!advancedDlg.getOk()) {
            this.advancedPanel.setConfigurationValue(originalTree);
            return;
        }
        XMLTree newTree = (XMLTree)advancedDlg.getConfig();
        this.advancedPanel.setConfigurationValue(newTree);
    }

    public Vector getMessage() {
        return null;
    }

    public Object getValue() {
        if (this.advancedPanel == null) {
            return null;
        }
        if (this.cb.isSelected()) {
            return this.advancedPanel.getValue();
        }
        return null;
    }

    public void setValue(Object val) {
        this.resetValue();
        if (this.advancedPanel == null) {
            return;
        }
        if (val != null && val instanceof XMLTree) {
            XMLTree valTree = (XMLTree)val;
            this.cb.setSelected(true);
            this.bt.setEnabled(true);
            this.advancedPanel.setValue(val);
        }
    }

    public void resetValue() {
        this.cb.setSelected(false);
        this.bt.setEnabled(false);
        if (this.advancedPanel != null) {
            this.advancedPanel.resetValue();
        }
    }
}

