/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jeus.security.util.Base64Coder;
import jeus.tool.configui.ConfigManagerList;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.ScrollableTextArea;

public class ConfigItemPanel
extends ConfigPanel {
    JComponent itemComp = new JTextField();
    String itemType = "String";
    String defaultValue = "";
    int MIN_COL = 10;

    public ConfigItemPanel(JComponent comp) {
        this.itemComp = comp;
        this.setInit();
    }

    public ConfigManagerList getConfigManagerList() {
        return null;
    }

    public void setInit() {
        JTextField myField;
        this.setLayout(new BorderLayout());
        if (this.itemComp instanceof JTextField && (myField = (JTextField)this.itemComp).getColumns() < this.MIN_COL) {
            myField.setColumns(this.MIN_COL);
        }
        if (this.itemComp instanceof JCheckBox) {
            this.add((Component)this.itemComp, "West");
        } else {
            this.add((Component)this.itemComp, "Center");
        }
    }

    public void setType(String itemType) {
        this.itemType = itemType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getType() {
        return this.itemType;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public JComponent getItemComp() {
        return this.itemComp;
    }

    public Vector getMessage() {
        return null;
    }

    public Object getValue() {
        if (this.itemComp instanceof JPasswordField) {
            JPasswordField pf = (JPasswordField)this.itemComp;
            String password = String.valueOf(pf.getPassword());
            return Base64Coder.encode(password);
        }
        if (this.itemComp instanceof JTextField) {
            JTextField tf = (JTextField)this.itemComp;
            return tf.getText();
        }
        if (this.itemComp instanceof JComboBox) {
            JComboBox cb = (JComboBox)this.itemComp;
            return cb.getSelectedItem();
        }
        if (this.itemComp instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)this.itemComp;
            if (cb.isSelected()) {
                return new String("true");
            }
            return new String("false");
        }
        if (this.itemComp instanceof ScrollableTextArea) {
            ScrollableTextArea tf = (ScrollableTextArea)this.itemComp;
            return tf.getText();
        }
        return null;
    }

    public void setValue(Object val) {
        if (val instanceof String) {
            String strVal = (String)val;
            if (this.itemComp instanceof JPasswordField) {
                JPasswordField pf = (JPasswordField)this.itemComp;
                pf.setText(Base64Coder.decode(strVal));
            } else if (this.itemComp instanceof JTextField) {
                JTextField tf = (JTextField)this.itemComp;
                tf.setText(strVal);
            } else if (this.itemComp instanceof JComboBox) {
                JComboBox cb = (JComboBox)this.itemComp;
                if (cb.isEditable()) {
                    boolean contains = false;
                    for (int i = 0; i < cb.getItemCount(); ++i) {
                        Object item = cb.getItemAt(i);
                        if (!item.equals(val)) continue;
                        contains = true;
                    }
                    if (!contains) {
                        cb.addItem(strVal);
                    }
                }
                cb.setSelectedItem(strVal);
            } else if (this.itemComp instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)this.itemComp;
                if (strVal != null && strVal.equals("true")) {
                    cb.setSelected(true);
                } else {
                    cb.setSelected(false);
                }
            } else if (this.itemComp instanceof ScrollableTextArea) {
                ScrollableTextArea tf = (ScrollableTextArea)this.itemComp;
                tf.setText(strVal);
            }
        }
    }

    public void setEnabled(boolean val) {
        JComponent cb;
        if (this.itemComp instanceof JTextField) {
            JTextField tf = (JTextField)this.itemComp;
            tf.setEnabled(val);
        }
        if (this.itemComp instanceof ScrollableTextArea) {
            ScrollableTextArea ta = (ScrollableTextArea)this.itemComp;
            ta.setEnabled(val);
        }
        if (this.itemComp instanceof JComboBox) {
            cb = (JComboBox)this.itemComp;
            ((JComboBox)cb).setEnabled(val);
        }
        if (this.itemComp instanceof JCheckBox) {
            cb = (JCheckBox)this.itemComp;
            ((AbstractButton)cb).setEnabled(val);
        }
    }

    public void resetValue() {
        JComponent cb;
        if (this.itemComp instanceof JTextField) {
            JTextField tf = (JTextField)this.itemComp;
            tf.setText(this.defaultValue);
        }
        if (this.itemComp instanceof ScrollableTextArea) {
            ScrollableTextArea ta = (ScrollableTextArea)this.itemComp;
            ta.setText(this.defaultValue);
        }
        if (this.itemComp instanceof JComboBox) {
            cb = (JComboBox)this.itemComp;
            if (this.defaultValue != null && !this.defaultValue.trim().equals("")) {
                ((JComboBox)cb).setSelectedItem(this.defaultValue);
            }
        }
        if (this.itemComp instanceof JCheckBox) {
            cb = (JCheckBox)this.itemComp;
            if (this.defaultValue != null && this.defaultValue.compareToIgnoreCase("true") == 0) {
                ((AbstractButton)cb).setSelected(true);
            } else {
                ((AbstractButton)cb).setSelected(false);
            }
        }
    }
}

