/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.ConfigContainerPanel;
import jeus.tool.configui.ConfigItemPanel;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.MultiItemTable;
import jeus.tool.configui.XMLOptionParameter;
import jeus.tool.configui.schema.ConfigContainer;
import jeus.tool.configui.schema.ConfigItem;

public class ExclusiveConfigPanel
extends ConfigPanel
implements ActionListener {
    private String title = "List Display Pane";
    public ConfigContainer configContainer;
    XMLTree myTree;
    public Vector excludeList = new Vector();
    public Vector displayList = new Vector();
    public Hashtable panelList = new Hashtable();
    public Hashtable buttonTable = new Hashtable();
    public ButtonGroup bg = new ButtonGroup();
    public JPanel cardPane = new JPanel();
    protected Color REQUIRED_COLOR = Color.decode(XMLOptionParameter.REQ_COLOR);
    protected String externalID = "";

    public ExclusiveConfigPanel(ConfigContainer anyConfig) {
        this.title = anyConfig.getName();
        this.configContainer = anyConfig;
        if (anyConfig.getGlobalID() != null) {
            this.externalID = anyConfig.getGlobalID();
        }
        try {
            this.setInit();
        }
        catch (Exception e) {
            System.out.println("ExclusiveConfigPanel creation error");
            e.printStackTrace();
        }
    }

    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String val) {
        this.externalID = val;
    }

    public String getSelectedName() {
        int index = 0;
        Enumeration<AbstractButton> enum1 = this.bg.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton myButton = (JRadioButton)enum1.nextElement();
            if (myButton.isSelected()) {
                return (String)this.excludeList.get(index);
            }
            ++index;
        }
        return null;
    }

    public Vector getMessage() {
        return null;
    }

    private void setInit() throws Exception {
        JRadioButton tmp;
        String dispName;
        this.setLayout(new BorderLayout());
        JPanel radioPane = new JPanel();
        radioPane.setLayout(new FlowLayout());
        this.cardPane.setLayout(new CardLayout());
        ConfigItem[] subItems = this.configContainer.getConfigItem();
        ConfigContainer[] subContainers = this.configContainer.getConfigContainer();
        for (int i = 0; i < subItems.length; ++i) {
            this.excludeList.add(subItems[i].getName());
            dispName = subItems[i].getDisplayName();
            if (dispName == null || dispName.trim().equals("")) {
                dispName = subItems[i].getName();
            }
            this.displayList.add(dispName);
            JPanel ipane = this.getItemPanel(subItems[i]);
            this.cardPane.add((Component)ipane, subItems[i].getName());
            tmp = new JRadioButton(dispName);
            radioPane.add((Component)tmp, null);
            this.buttonTable.put(subItems[i].getName(), tmp);
            this.bg.add(tmp);
            tmp.addActionListener(this);
            if (i != 0) continue;
            tmp.setSelected(true);
        }
        for (int j = 0; j < subContainers.length; ++j) {
            this.excludeList.add(subContainers[j].getName());
            dispName = subContainers[j].getDisplayName();
            if (dispName == null || dispName.trim().equals("")) {
                dispName = subContainers[j].getName();
            }
            this.displayList.add(dispName);
            ConfigContainerPanel cpane = new ConfigContainerPanel(subContainers[j]);
            this.panelList.put(subContainers[j].getName(), cpane);
            this.cardPane.add((Component)cpane, subContainers[j].getName());
            tmp = new JRadioButton(dispName);
            radioPane.add((Component)tmp, null);
            this.buttonTable.put(subContainers[j].getName(), tmp);
            tmp.addActionListener(this);
            this.bg.add(tmp);
            if (subItems.length != 0 || j != 0) continue;
            tmp.setSelected(true);
        }
        this.add((Component)radioPane, "North");
        this.add((Component)this.cardPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        int index = 0;
        Enumeration<AbstractButton> enum1 = this.bg.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton myButton = (JRadioButton)enum1.nextElement();
            if (myButton.isSelected()) {
                CardLayout cl = (CardLayout)this.cardPane.getLayout();
                cl.show(this.cardPane, (String)this.excludeList.get(index));
            }
            ++index;
        }
    }

    public JPanel getItemPanel(ConfigItem subItem) {
        JPanel backPanel = new JPanel();
        backPanel.setLayout(new GridBagLayout());
        String itemName = subItem.getName();
        String itemDisplayName = subItem.getDisplayName();
        String itemType = subItem.getItemType();
        String defaultValue = subItem.getDefaultValue();
        String isMulti = subItem.getMulti();
        String required = subItem.getRequired();
        if (isMulti != null && isMulti.equals("true")) {
            MultiItemTable mTable = new MultiItemTable();
            String multiItemDisplay = itemName;
            if (itemDisplayName != null && !itemDisplayName.trim().equals("")) {
                multiItemDisplay = itemDisplayName;
            }
            String[] colNames = new String[]{multiItemDisplay};
            mTable.setColumnNames(colNames);
            this.panelList.put(itemName, mTable);
            backPanel.add((Component)mTable, new GridBagConstraints(1, 0, 0, 1, 9.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            return backPanel;
        }
        if (defaultValue == null || defaultValue.equals("")) {
            defaultValue = null;
        }
        String[] candValues = new String[]{};
        if (itemType != null && itemType.endsWith("Choice")) {
            candValues = subItem.getCandidateValue();
        }
        String labelName = "";
        labelName = itemDisplayName != null && !itemDisplayName.trim().equals("") ? itemDisplayName : itemName;
        JLabel itemLB = new JLabel("  " + labelName + "  ");
        if (required != null && required.equals("true")) {
            itemLB.setForeground(this.REQUIRED_COLOR);
        }
        backPanel.add((Component)itemLB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JComponent itemValueCmp = null;
        if (itemType == null) {
            itemType = "String";
        }
        if (itemType.equals("Boolean")) {
            itemValueCmp = new JCheckBox();
            if (defaultValue != null && defaultValue.equals("true")) {
                itemValueCmp.setSelected(true);
            }
        } else if (itemType.endsWith("Choice")) {
            itemValueCmp = new JComboBox();
            for (int j = 0; j < candValues.length; ++j) {
                ((JComboBox)itemValueCmp).addItem(candValues[j]);
                if (defaultValue == null) continue;
                ((JComboBox)itemValueCmp).setSelectedItem(defaultValue);
            }
            if (itemType.startsWith("Editable")) {
                ((JComboBox)itemValueCmp).setEditable(true);
            }
        } else if (itemType.equals("Empty")) {
            JCheckBox myCheck = new JCheckBox();
            myCheck.setSelected(true);
            myCheck.setEnabled(false);
            itemValueCmp = myCheck;
        } else {
            itemValueCmp = new JTextField();
            if (defaultValue != null) {
                ((JTextField)itemValueCmp).setText(defaultValue);
            }
        }
        ConfigItemPanel itemPanel = new ConfigItemPanel(itemValueCmp);
        this.panelList.put(itemName, itemPanel);
        itemPanel.setType(itemType);
        itemPanel.setDefaultValue(defaultValue);
        backPanel.add((Component)itemPanel, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        backPanel.add(Box.createVerticalGlue(), new GridBagConstraints(1, 1, 0, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        return backPanel;
    }

    public Object getConfigurationValue() throws XMLConverterException {
        this.myTree = new XMLTree();
        String selectedName = null;
        int index = 0;
        Enumeration<AbstractButton> enum1 = this.bg.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton myButton = (JRadioButton)enum1.nextElement();
            if (myButton.isSelected()) {
                selectedName = (String)this.excludeList.get(index);
            }
            ++index;
        }
        if (selectedName == null) {
            return this.myTree;
        }
        this.myTree.setName(selectedName);
        ConfigPanel myPane = (ConfigPanel)this.panelList.get(selectedName);
        if (myPane instanceof ConfigItemPanel) {
            ConfigItemPanel itemPane = (ConfigItemPanel)myPane;
            if (itemPane.getType() != null && itemPane.getType().equals("Empty")) {
                return this.myTree;
            }
            String value = (String)itemPane.getValue();
            this.myTree.setValue(value);
            return this.myTree;
        }
        if (myPane instanceof MultiItemTable) {
            MultiItemTable multiItemTable = (MultiItemTable)myPane;
            Vector<XMLTree> itemValues = new Vector<XMLTree>();
            String[] valueList = (String[])multiItemTable.getValue();
            if (valueList.length > 0) {
                for (int k = 0; k < valueList.length; ++k) {
                    if (valueList[k] == null || valueList[k].trim().equals("")) continue;
                    XMLTree elementTree = new XMLTree(selectedName);
                    elementTree.setValue(valueList[k]);
                    itemValues.addElement(elementTree);
                }
            }
            return itemValues;
        }
        if (myPane instanceof ConfigContainerPanel) {
            ConfigContainerPanel conPane = (ConfigContainerPanel)myPane;
            this.myTree = (XMLTree)conPane.getValue();
            return this.myTree;
        }
        return null;
    }

    public Object getValue() {
        Object val = null;
        try {
            val = this.getConfigurationValue();
        }
        catch (XMLConverterException e) {
            System.out.println(e.toString());
        }
        return val;
    }

    public void setValue(Object val) {
        if (val instanceof XMLTree) {
            XMLTree valTree = (XMLTree)val;
            this.setConfigurationValue(valTree);
        }
        if (val instanceof Vector) {
            Vector vals = (Vector)val;
            this.setConfigurationValue(vals);
        }
    }

    public void setConfigurationValue(Vector vals) {
        if (vals == null || vals.size() == 0) {
            return;
        }
        XMLTree oneTree = (XMLTree)vals.get(0);
        String configName = oneTree.getName();
        JRadioButton selectedBT = (JRadioButton)this.buttonTable.get(configName);
        selectedBT.setSelected(true);
        CardLayout cl = (CardLayout)this.cardPane.getLayout();
        cl.show(this.cardPane, configName);
        ConfigPanel myPane = (ConfigPanel)this.panelList.get(configName);
        if (myPane instanceof MultiItemTable) {
            MultiItemTable myTable = (MultiItemTable)myPane;
            String[] tmpList = new String[vals.size()];
            for (int x = 0; x < tmpList.length; ++x) {
                XMLTree tmpTree = (XMLTree)vals.get(x);
                tmpList[x] = tmpTree.getValue();
            }
            myTable.setValue(tmpList);
        } else {
            this.setConfigurationValue(oneTree);
        }
    }

    public void setConfigurationValue(XMLTree valTree) {
        String configName = valTree.getName();
        int nameIndex = configName.indexOf(configName);
        if (nameIndex == -1) {
            return;
        }
        this.myTree = valTree;
        JRadioButton selectedBT = (JRadioButton)this.buttonTable.get(configName);
        selectedBT.setSelected(true);
        CardLayout cl = (CardLayout)this.cardPane.getLayout();
        cl.show(this.cardPane, configName);
        ConfigPanel myPane = (ConfigPanel)this.panelList.get(configName);
        if (myPane instanceof ConfigItemPanel) {
            ConfigItemPanel itemPane = (ConfigItemPanel)myPane;
            String value = valTree.getValue();
            itemPane.setValue(value);
        } else if (myPane instanceof ConfigContainerPanel) {
            ConfigContainerPanel conPane = (ConfigContainerPanel)myPane;
            conPane.setValue(valTree);
        }
    }

    public void resetValue() {
        Enumeration elementEnum = this.panelList.keys();
        while (elementEnum.hasMoreElements()) {
            String itemName = (String)elementEnum.nextElement();
            ConfigPanel confElementPane = (ConfigPanel)this.panelList.get(itemName);
            confElementPane.resetValue();
        }
    }
}

