/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jeus.tool.configui.ConfigContainerPanel;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.schema.ConfigContainer;

public class ListConfigContainerPanel
extends ConfigContainerPanel
implements ListSelectionListener {
    private JPanel wrapper;
    private JList tabList;
    private DefaultListModel model;

    public ListConfigContainerPanel() {
    }

    public ListConfigContainerPanel(ConfigContainer desc) {
        super(desc);
    }

    public void valueChanged(ListSelectionEvent e) {
        Item item = (Item)this.tabList.getSelectedValue();
        if (item != null) {
            this.replaceConfigPane(item);
        }
    }

    protected void beginInitSubContainers(ConfigContainer[] subContainers) {
        this.wrapper = new JPanel();
        this.tabList = new JList();
        this.model = new DefaultListModel();
        this.wrapper.setLayout(new GridBagLayout());
        this.tabList.setSelectionMode(0);
        this.tabList.addListSelectionListener(this);
        this.tabList.setModel(this.model);
        this.tabList.setCellRenderer(new ItemCellRender());
        this.tabList.setSelectionBackground(Color.decode("#597FBF"));
        this.tabList.setSelectionForeground(Color.WHITE);
        JScrollPane tabListScroll = new JScrollPane(this.tabList);
        tabListScroll.setMinimumSize(new Dimension(150, 1));
        tabListScroll.setMaximumSize(new Dimension(150, 1));
        tabListScroll.setPreferredSize(new Dimension(150, 1));
        this.basicPane.setLayout(new GridBagLayout());
        this.basicPane.add((Component)tabListScroll, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.basicPane.add((Component)this.wrapper, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addConfigPane(ConfigContainer subContainer, ConfigPanel newPanel, int colspan, int rowspan, int x, int y) {
        if (!this._OnlyOneSubContainer) {
            super.addConfigPane(subContainer, newPanel, colspan, rowspan, x, y);
            Item item = this.createItem(subContainer, newPanel);
            this.model.addElement(item);
        } else {
            this.basicPane.add((Component)newPanel, new GridBagConstraints(x, y, colspan, rowspan, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    protected void endInitSubContainers(ConfigContainer[] subContainers, int x, int y, int colspan, int rowspan) {
        if (!this._OnlyOneSubContainer && this.model.getSize() > 0) {
            Item firstItem = (Item)this.model.get(0);
            this.tabList.setSelectedIndex(0);
            this.replaceConfigPane(firstItem);
        }
    }

    protected void replaceConfigPane(Item item) {
        this.wrapper.removeAll();
        this.wrapper.add((Component)new JScrollPane(item.panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.wrapper.updateUI();
    }

    public int getItemCount() {
        if (this.model != null) {
            return this.model.getSize();
        }
        return 0;
    }

    protected Item createItem(ConfigContainer subContainer, ConfigPanel panel) {
        Item item = new Item();
        item.panel = panel;
        item.displayName = panel.getTitle();
        item.smallIcon = panel.getSmallIcon();
        return item;
    }

    private static class ItemCellRender
    extends DefaultListCellRenderer {
        private Border focusBorder = BorderFactory.createLineBorder(Color.BLACK, 1);

        private ItemCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Item) {
                Item item = (Item)value;
                this.setText(" " + item.displayName + " ");
                if (item.smallIcon != null) {
                    this.setIcon(item.smallIcon);
                } else {
                    this.setIcon(null);
                }
            } else if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? this.focusBorder : noFocusBorder);
            return this;
        }
    }

    private static class Item {
        public ConfigPanel panel;
        public String displayName;
        public Icon smallIcon;

        private Item() {
        }
    }
}

