/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.rmi.RMISecurityManager;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import jeus.tool.common.ColumnEditableTableModel;
import jeus.tool.common.DefaultPathFileChooser;
import jeus.tool.configui.ConfigPanel;

public class MultiItemTable
extends ConfigPanel {
    private String[] columnNames;
    JScrollPane jScrollPane1 = new JScrollPane();
    protected AttributeTable displayTB = new AttributeTable();
    ColumnEditableTableModel model;
    Border border1;
    TitledBorder titledBorder1;
    public JPanel buttonPane = new JPanel();
    public JButton removeBT = new JButton();
    public JButton addBT = new JButton();
    private JTextField input = new JTextField();
    ImageIcon dotIcon;
    BorderLayout borderLayout1 = new BorderLayout();
    boolean firstRowDisable = false;
    int avoidColNum = -1;
    String avoidString = null;
    boolean fileSelection = false;
    String title = "";

    public MultiItemTable() {
        this.displayTB.setSelectionMode(0);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MultiItemTable(int colNum, String avoidString) {
        this.avoidColNum = colNum;
        this.avoidString = avoidString;
        this.displayTB.setSelectionMode(0);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getValue() {
        String[] values = this.getColumnData(0);
        return values;
    }

    public Vector getMessage() {
        return null;
    }

    public void setValue(Object val) {
        this.resetValue();
        String[] valueList = (String[])val;
        for (int i = 0; i < valueList.length; ++i) {
            Object[] oneRow = new String[]{valueList[i]};
            this.model.addRow(oneRow);
        }
    }

    public void resetValue() {
        if (this.getRowCount() > 0) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.model.removeRow(i);
            }
        }
    }

    private void setAllColumnsFixed() {
        int[] columns = new int[this.model.getColumnCount()];
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columns[i] = i;
        }
        this.displayTB.setColumnsFixed(columns);
    }

    public void setTableFixed() {
    }

    public void setColumnFixed(int column) {
        this.model.setColumnEditable(column, false);
        this.displayTB.setColumnFixed(column);
    }

    public void setColumnsFixed(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.model.setColumnEditable(columns[i], false);
        }
        this.displayTB.setColumnsFixed(columns);
    }

    public void setModifyMode() {
        this.buttonPane.remove(this.addBT);
        this.buttonPane.remove(this.removeBT);
    }

    public void setBrowseMode() {
        this.buttonPane.remove(this.addBT);
        this.buttonPane.remove(this.removeBT);
        this.setAllColumnsFixed();
    }

    public void setFileSelection() {
        this.fileSelection = true;
    }

    public void modifyColumnNames(String[] columnNames) {
        this.model.setColumnIdentifiers(columnNames);
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.model = new ColumnEditableTableModel(columnNames, 0);
        this.displayTB.setModel(this.model);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private void jbInit() throws Exception {
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setPreferredSize(new Dimension(250, 150));
        this.setLayout(this.borderLayout1);
        this.removeBT.setText("Remove");
        this.removeBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiItemTable.this.removeBT_actionPerformed(e);
            }
        });
        this.addBT.setText("Add");
        this.addBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiItemTable.this.addBT_actionPerformed(e);
            }
        });
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new GridBagLayout());
        if (this.fileSelection) {
            centerPane.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            centerPane.add((Component)this.removeBT, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            centerPane.add((Component)this.addBT, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            centerPane.add((Component)this.input, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            centerPane.add((Component)this.addBT, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            centerPane.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            centerPane.add((Component)this.removeBT, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)centerPane, "Center");
        this.jScrollPane1.getViewport().add((Component)this.displayTB, null);
        this.displayTB.getTableHeader().setReorderingAllowed(false);
    }

    public void setFirstRowDisable() {
        this.displayTB.setFirstRowDisable();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void modifyBT_actionPerformed(ActionEvent e) {
    }

    public void addBT_actionPerformed(ActionEvent e) {
        this.editingStopped();
        this.displayTB.getSelectionModel().clearSelection();
        if (this.fileSelection) {
            String title = "Add Class Path";
            System.setSecurityManager(null);
            DefaultPathFileChooser fileChooser = new DefaultPathFileChooser(title, false, true);
            fileChooser.setFileSelectionMode(2);
            int returnVal = fileChooser.showFileDialog(this, "Select");
            System.setSecurityManager(new RMISecurityManager());
            if (returnVal != 0) {
                return;
            }
            Object[] row = new String[]{fileChooser.getSelectedFile().getPath()};
            this.model.addRow(row);
        } else {
            String value = this.input.getText();
            if (value == null || value.trim().length() == 0) {
                return;
            }
            this.model.addRow(new String[]{value});
            this.input.setText(null);
        }
    }

    void removeBT_actionPerformed(ActionEvent e) {
        int row;
        this.editingStopped();
        while ((row = this.displayTB.getSelectedRow()) != -1) {
            String comVal;
            if (row < 0) {
                // empty if block
            }
            if (this.avoidColNum != -1 && (comVal = this.getValueAt(row, this.avoidColNum)).equals(this.avoidString)) {
                String message = this.avoidString + " : is not editable value";
                JOptionPane.showMessageDialog(this, message, "Information", 1);
                return;
            }
            this.model.removeRow(row);
        }
    }

    public void editingStopped() {
        this.displayTB.editingStopped(new ChangeEvent(this));
    }

    public String getValueAt(int row, int column) {
        return (String)this.model.getValueAt(row, column);
    }

    public void setValueAt(Object object, int row, int column) {
        this.model.setValueAt(object, row, column);
    }

    public String[] getColumnData(int column) {
        int rowCount = this.model.getRowCount();
        String[] columnData = new String[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            columnData[i] = this.getValueAt(i, column);
        }
        return columnData;
    }

    public void addRow(String[] row) {
        this.model.addRow(row);
    }

    public int getSelectedRow() {
        return this.displayTB.getSelectedRow();
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class AttributeTable
    extends JTable {
        private JTextField tableTextEditor;
        private boolean firstRowDisable;
        private int fixedColumn;
        boolean useFixedColumns;
        private int[] fixedColumns;

        public AttributeTable() {
            this.tableTextEditor = new JTextField();
            this.firstRowDisable = false;
            this.fixedColumn = -1;
            this.useFixedColumns = false;
            this.setupInitialTable();
        }

        public AttributeTable(TableModel model) {
            super(model);
            this.tableTextEditor = new JTextField();
            this.firstRowDisable = false;
            this.fixedColumn = -1;
            this.useFixedColumns = false;
            this.setupInitialTable();
        }

        public AttributeTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
            this.tableTextEditor = new JTextField();
            this.firstRowDisable = false;
            this.fixedColumn = -1;
            this.useFixedColumns = false;
            this.setupInitialTable();
        }

        private void setupInitialTable() {
            this.tableTextEditor.setCursor(Cursor.getPredefinedCursor(2));
            DefaultCellEditor tableEditor = new DefaultCellEditor(this.tableTextEditor);
            this.setDefaultEditor(Object.class, tableEditor);
            final WholeNumberField integerField = new WholeNumberField(0, 5);
            integerField.setHorizontalAlignment(4);
            DefaultCellEditor integerEditor = new DefaultCellEditor(integerField){

                public Object getCellEditorValue() {
                    return new Integer(integerField.getValue());
                }
            };
            this.setDefaultEditor(Integer.class, integerEditor);
            this.setCellSelectionEnabled(true);
            this.setColumnSelectionAllowed(true);
        }

        public void setFirstRowDisable() {
            this.firstRowDisable = true;
        }

        public void setColumnFixed(int column) {
            this.fixedColumn = column;
        }

        public void setColumnsFixed(int[] columns) {
            this.fixedColumns = columns;
            this.useFixedColumns = true;
        }

        public boolean isCellEditable(int row, int column) {
            if (this.firstRowDisable && row == 0) {
                return false;
            }
            if (this.fixedColumn != -1 && column == this.fixedColumn) {
                return false;
            }
            if (this.useFixedColumns) {
                for (int i = 0; i < this.fixedColumns.length; ++i) {
                    if (column != this.fixedColumns[i]) continue;
                    return false;
                }
            }
            return true;
        }

        public void processKeyEvent(KeyEvent ke) {
            JTextComponent c;
            super.processKeyEvent(ke);
            TableCellEditor editor = this.getCellEditor();
            if (editor instanceof DefaultCellEditor && ((DefaultCellEditor)editor).getComponent() instanceof JTextComponent && !(c = (JTextComponent)((DefaultCellEditor)editor).getComponent()).getCaret().isVisible()) {
                c.getCaret().setVisible(true);
            }
        }

        class WholeNumberField
        extends JTextField {
            private Toolkit toolkit;
            private NumberFormat integerFormatter;

            public WholeNumberField(int value, int columns) {
                super(columns);
                this.toolkit = Toolkit.getDefaultToolkit();
                this.integerFormatter = NumberFormat.getNumberInstance(Locale.US);
                this.integerFormatter.setParseIntegerOnly(true);
                this.setValue(value);
            }

            public int getValue() {
                int retVal = 0;
                try {
                    retVal = this.integerFormatter.parse(this.getText()).intValue();
                }
                catch (ParseException e) {
                    this.toolkit.beep();
                }
                return retVal;
            }

            public void setValue(int value) {
                this.setText(this.integerFormatter.format(value));
            }

            protected Document createDefaultModel() {
                return new WholeNumberDocument();
            }

            protected class WholeNumberDocument
            extends PlainDocument {
                protected WholeNumberDocument() {
                }

                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    char[] source = str.toCharArray();
                    char[] result = new char[source.length];
                    int j = 0;
                    for (int i = 0; i < result.length; ++i) {
                        if (Character.isDigit(source[i])) {
                            result[j++] = source[i];
                            continue;
                        }
                        WholeNumberField.this.toolkit.beep();
                        System.err.println("insertString: " + source[i]);
                    }
                    super.insertString(offs, new String(result, 0, j), a);
                }
            }
        }
    }
}

