/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.util.JeusException;
import jeus.util.JeusProperties;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_Converter;
import jeus.xml.binding.util.JAXBContextFactory;

public abstract class ModuleConversion {
    public static String FS = System.getProperty("file.separator");
    public final int EAR = 0;
    public final int EJB = 1;
    public final int SERVLET = 2;
    public final int CLIENT = 3;

    public String convertModule(int moduleType, String sourcePath, String targetPath, boolean deleteSource) throws Exception {
        targetPath = this.validatePath(sourcePath, targetPath);
        FileArchive homeArchive = null;
        FileArchive workingArchive = null;
        FileArchive targetArchive = null;
        InputJarArchive sourceArchive = null;
        String workingSpaceName = "WorkingSpace";
        File workingSpace = null;
        String[] sourceDirectoryAndFileName = FileUtils.separateDirAndFile((String)sourcePath);
        String sourceDir = sourceDirectoryAndFileName[0];
        String sourceFile = sourceDirectoryAndFileName[1];
        String[] targetDirectoryAndFileName = FileUtils.separateDirAndFile((String)targetPath);
        String targetDir = targetDirectoryAndFileName[0];
        String targetFile = targetDirectoryAndFileName[1];
        try {
            homeArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)sourceDir);
            targetArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)targetDir);
            sourceArchive = homeArchive.getEmbeddedJarArchive(sourceFile);
        }
        catch (IOException e) {
            throw new JeusException(JeusMessage_Converter._6101, (Object)sourceFile, (Throwable)e);
        }
        try {
            workingSpace = new File(sourceDir + FS + workingSpaceName);
            if (workingSpace.exists()) {
                workingSpace.delete();
            }
            workingSpace.mkdir();
            sourceArchive.extractArchive(homeArchive, workingSpaceName);
            if (deleteSource) {
                sourceArchive.delete();
            } else {
                sourceArchive.close();
            }
            workingArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)(sourceDir + FS + workingSpaceName));
        }
        catch (IOException e) {
            throw new JeusException(JeusMessage_Converter._6102, (Object)sourceArchive.getArchiveUri(), (Throwable)e);
        }
        try {
            if (moduleType == 0) {
                this.convertJarOrWar(workingSpace);
            } else if (moduleType == 1 || moduleType == 2) {
                this.convertJeusDD(moduleType, workingSpace, sourceFile);
            }
        }
        catch (Exception e) {
            workingSpace.delete();
            throw e;
        }
        File temp = null;
        temp = new File(targetArchive.getArchiveUri() + FS + targetFile);
        if (temp.exists()) {
            throw new JeusException(JeusMessage_Converter._6104, (Object)temp.getPath());
        }
        try {
            workingArchive.jarArchive((AbstractArchive)targetArchive, targetFile);
            workingArchive.delete();
            workingSpace.delete();
        }
        catch (IOException e) {
            throw new JeusException(JeusMessage_Converter._6103, (Object)temp.getPath(), (Throwable)e);
        }
        return targetPath;
    }

    private String validatePath(String sourcePath, String targetPath) throws JeusException {
        File source = new File(sourcePath);
        if (!source.exists()) {
            throw new JeusException(JeusMessage_Converter._6109, (Object)sourcePath);
        }
        String[] sourceDirectoryAndFileName = FileUtils.separateDirAndFile((String)sourcePath);
        String sourceFile = sourceDirectoryAndFileName[1];
        if (targetPath != null) {
            String[] targetDirectoryAndFileName = FileUtils.separateDirAndFile((String)targetPath);
            String targetDir = targetDirectoryAndFileName[0];
            String targetFile = targetDirectoryAndFileName[1];
            File target = new File(targetPath);
            if (target.exists()) {
                if (target.isDirectory()) {
                    targetPath = targetPath + FS + sourceFile;
                }
            } else if (targetFile.indexOf(".") >= 0) {
                File tDir = new File(targetDir);
                tDir.mkdirs();
            } else {
                File tDir = new File(targetPath);
                tDir.mkdirs();
                targetPath = targetPath + FS + sourceFile;
            }
        } else {
            targetPath = JeusProperties.JEUS_APP_HOME + FS + sourceFile;
        }
        return targetPath;
    }

    private void convertJarOrWar(File workingSpace) throws Exception {
        File[] fileList = workingSpace.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (file.getName().endsWith(".jar")) {
                this.convertModule(1, file.getAbsolutePath(), file.getAbsolutePath(), true);
                continue;
            }
            if (!file.getName().endsWith(".war")) continue;
            this.convertModule(2, file.getAbsolutePath(), file.getAbsolutePath(), true);
        }
    }

    public abstract void convertJeusDD(int var1, File var2, String var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshalDescriptor(Object descObject, String contextPackageName, File fpath) throws JAXBException, IOException {
        JAXBContext jc = JAXBContextFactory.getContext(contextPackageName);
        Marshaller m = jc.createMarshaller();
        try {
            if (fpath.getParent() != null) {
                new File(fpath.getParent()).mkdirs();
            }
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6108, (Object)fpath.getPath(), (Throwable)e);
        }
        FileOutputStream os = new FileOutputStream(fpath);
        try {
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(descObject, (OutputStream)os);
        }
        finally {
            os.close();
        }
    }

    public static void copyDirectory(String srcDir, String destDir) throws IOException {
        File srcDirFile = new File(srcDir);
        File[] srcDirFiles = srcDirFile.listFiles();
        ModuleConversion.makeDirectory(destDir);
        for (int i = 0; i < srcDirFiles.length; ++i) {
            File srcFile = srcDirFiles[i];
            if (srcFile.isFile()) {
                File targetFile = new File(destDir + FS + srcDirFiles[i].getName());
                ModuleConversion.copyFile(srcDirFiles[i], targetFile);
                continue;
            }
            ModuleConversion.copyDirectory(srcFile.getAbsolutePath(), destDir + FS + srcFile.getName());
        }
    }

    public static void makeDirectory(String directory) {
        ModuleConversion.makeDirectory(new File(directory));
    }

    public static void makeDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        String targetParent = target.getParent();
        if (targetParent != null) {
            new File(targetParent).mkdirs();
        }
        FileOutputStream outstr = new FileOutputStream(target);
        FileInputStream instr = new FileInputStream(source);
        while ((len = ((InputStream)instr).read(buffer)) > 0) {
            ((OutputStream)outstr).write(buffer, 0, len);
        }
        ((InputStream)instr).close();
        ((OutputStream)outstr).close();
    }
}

