/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.desctojaxb;

import java.util.Enumeration;
import javax.xml.bind.JAXBException;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ValidString;
import jeus.util.message.JeusMessage_Converter;
import jeus.xml.binding.jeusDD.ClientModuleInfoType;
import jeus.xml.binding.jeusDD.EnvType;
import jeus.xml.binding.jeusDD.JeusClientDdType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SecurityInfoType;

public class ClientDDJaxbConverter
extends XMLConverter {
    public static final String JEUS_CLIENT_DD = "jeus-client-dd";
    public static final String MODULE_INFO = "module-info";
    public static final String LOGGING = "system-log";
    public static final String LOG_FILE_NAME = "file-name";
    public static final String TARGET = "target";
    public static final String BUFFER_SIZE = "buffer-size";
    public static final String LEVEL = "level";
    public static final String SECURITY_INFO = "security-info";
    public static final String PROVIDER_NODE_NAME = "provider-node-name";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String ENV = "env";
    public static final String EJB_REF = "ejb-ref";
    public static final String RES_REF = "res-ref";
    public static final String RES_ENV_REF = "res-env-ref";
    public static final String REF_NAME = "ref-name";
    public static final String EXPORT_NAME = "export-name";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String MODULE_NAME = "module-name";
    public static final String APP_MAIN_CLASS = "app-main-class";
    public static final String APP_ARGUMENT = "app-argument";
    public static final String SCHEDULER = "scheduler";
    public static final String TYPE = "type";
    public static ObjectFactory factory = new ObjectFactory();

    public Object constructJAXBObject(XMLTree xmlTree) throws JAXBException, XMLConverterException {
        Boolean scheduling;
        XMLTree securityTree;
        JeusClientDdType clientDD = factory.createJeusClientDdType();
        if (!xmlTree.getName().equals(JEUS_CLIENT_DD)) {
            return null;
        }
        XMLTree moduleInfoTree = xmlTree.getFirstElement(MODULE_INFO);
        if (moduleInfoTree != null) {
            clientDD.setModuleInfo(this.fillModuleInfo(moduleInfoTree));
        }
        if ((securityTree = xmlTree.getFirstElement(SECURITY_INFO)) != null) {
            clientDD.setSecurityInfo(this.fillSecurityInfo(securityTree));
        }
        if ((scheduling = (Boolean)ValidString.getProperTypeFromString(xmlTree, SCHEDULER, 2, false, null)) != null && scheduling.booleanValue()) {
            clientDD.setScheduler(factory.createSchedulerType());
        }
        Enumeration enum1 = xmlTree.getElements(ENV).elements();
        while (enum1.hasMoreElements()) {
            XMLTree envTree = (XMLTree)enum1.nextElement();
            clientDD.getEnv().add(this.fillEnv(envTree));
        }
        XMLTree ejbRefTree = xmlTree.getFirstElement(EJB_REF);
        JndiRefType ejbRef = factory.createJndiRefType();
        Enumeration refs = ejbRefTree.elements();
        while (refs.hasMoreElements()) {
            XMLTree jndiTree = (XMLTree)refs.nextElement();
            ejbRef.getJndiInfo().add(this.fillRef(jndiTree));
        }
        clientDD.setEjbRef(ejbRef);
        XMLTree resRefTree = xmlTree.getFirstElement(RES_REF);
        JndiRefType resRef = factory.createJndiRefType();
        Enumeration refs1 = resRefTree.elements();
        while (refs1.hasMoreElements()) {
            XMLTree jndiTree = (XMLTree)refs1.nextElement();
            resRef.getJndiInfo().add(this.fillRef(jndiTree));
        }
        clientDD.setResRef(resRef);
        XMLTree resEnvRefTree = xmlTree.getFirstElement(RES_ENV_REF);
        JndiRefType resEnvRef = factory.createJndiRefType();
        Enumeration refs2 = resEnvRefTree.elements();
        while (refs2.hasMoreElements()) {
            XMLTree jndiTree = (XMLTree)refs2.nextElement();
            resEnvRef.getJndiInfo().add(this.fillRef(jndiTree));
        }
        clientDD.setResEnvRef(resEnvRef);
        ObjectFactory fac = new ObjectFactory();
        return fac.createJeusClientDd(clientDD);
    }

    public int getType() {
        return 1001;
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1001);
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1001);
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }

    private JndiInfoType fillRef(XMLTree jndiTree) throws JAXBException {
        String exportName;
        JndiInfoType jndiInfo = factory.createJndiInfoType();
        String refName = XMLUtil.getSubtreeValue(jndiTree, REF_NAME);
        if (refName != null) {
            jndiInfo.setRefName(refName);
        }
        if ((exportName = XMLUtil.getSubtreeValue(jndiTree, EXPORT_NAME)) != null) {
            jndiInfo.setExportName(exportName);
        }
        return jndiInfo;
    }

    private EnvType fillEnv(XMLTree envTree) throws JAXBException {
        String type;
        EnvType env = factory.createEnvType();
        String name = XMLUtil.getSubtreeValue(envTree, NAME);
        if (name != null) {
            env.setName(name);
        }
        if ((type = XMLUtil.getSubtreeValue(envTree, TYPE)) != null) {
            env.setType(type);
        }
        String value = XMLUtil.getSubtreeValue(envTree, VALUE);
        if (type.compareToIgnoreCase("int") == 0 || type.compareToIgnoreCase("Integer") == 0 || type.equals("java.lang.Integer")) {
            env.setValue(Integer.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("long") == 0 || type.equals("java.lang.Long")) {
            env.setValue(Long.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("float") == 0 || type.equals("java.lang.Float")) {
            env.setValue(Float.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("boolean") == 0 || type.equals("java.lang.Boolean")) {
            env.setValue(Boolean.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("double") == 0 || type.equals("java.lang.Double")) {
            env.setValue(Double.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("byte") == 0 || type.equals("java.lang.Byte")) {
            env.setValue(Byte.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("short") == 0 || type.equals("java.lang.Short")) {
            env.setValue(Short.valueOf(value).toString());
        } else if (type.compareToIgnoreCase("char") == 0 || type.equals("java.lang.Character")) {
            char[] carray = value.toCharArray();
            env.setValue(Character.toString(carray[0]));
        } else {
            env.setValue(value);
        }
        return env;
    }

    private SecurityInfoType fillSecurityInfo(XMLTree securityTree) throws JAXBException {
        String password;
        String user;
        SecurityInfoType securityInfo = factory.createSecurityInfoType();
        String nodeName = XMLUtil.getSubtreeValue(securityTree, PROVIDER_NODE_NAME);
        if (ValidString.notEmptyString(nodeName)) {
            securityInfo.setProviderNodeName(nodeName);
        }
        if (ValidString.notEmptyString(user = XMLUtil.getSubtreeValue(securityTree, USER))) {
            securityInfo.setUser(user);
        }
        if (ValidString.notEmptyString(password = XMLUtil.getSubtreeValue(securityTree, PASSWORD))) {
            securityInfo.setPasswd(password);
        }
        return securityInfo;
    }

    private ClientModuleInfoType fillModuleInfo(XMLTree moduleInfoTree) throws JAXBException, XMLConverterException {
        ClientModuleInfoType moduleInfo = factory.createClientModuleInfoType();
        String moduleName = XMLUtil.getSubtreeValue(moduleInfoTree, MODULE_NAME);
        if (!ValidString.notEmptyString(moduleName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, MODULE_NAME);
        }
        moduleInfo.setModuleName(moduleName);
        String mainClassName = XMLUtil.getSubtreeValue(moduleInfoTree, APP_MAIN_CLASS);
        if (ValidString.notEmptyString(mainClassName)) {
            moduleInfo.setAppMainClass(mainClassName);
        }
        Enumeration e = moduleInfoTree.elements(APP_ARGUMENT);
        StringBuffer arg = new StringBuffer();
        while (e.hasMoreElements()) {
            XMLTree argTree = (XMLTree)e.nextElement();
            arg.append(argTree.getValue());
            if (!e.hasMoreElements()) continue;
            arg.append(" ");
        }
        moduleInfo.setAppArgument(arg.toString());
        return moduleInfo;
    }
}

