/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.desctojaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.security.util.Base64Coder;
import jeus.security.util.EncryptionUtil;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ValidString;
import jeus.tool.converter.version.XMLVersionConverter;
import jeus.tool.converter.version.desctojaxb.WEBDDJaxbConverter;
import jeus.tool.converter.version.process.ProcessConversion;
import jeus.util.JeusException;
import jeus.util.JeusProperties;
import jeus.util.VirtualDNS;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Converter;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.AllTargetsType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.ClassFtpUnitType;
import jeus.xml.binding.jeusDD.ClusterDsType;
import jeus.xml.binding.jeusDD.ConsoleHandlerType;
import jeus.xml.binding.jeusDD.DataSourceType;
import jeus.xml.binding.jeusDD.DataSourceTypeType;
import jeus.xml.binding.jeusDD.DatabaseConnectionPoolType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.EngineCommandType;
import jeus.xml.binding.jeusDD.EngineContainerType;
import jeus.xml.binding.jeusDD.EngineTypeType;
import jeus.xml.binding.jeusDD.ExternalSourceType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.InvocationManagerActionType;
import jeus.xml.binding.jeusDD.InvocationType;
import jeus.xml.binding.jeusDD.InvocationTypeType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.JmsSourceType;
import jeus.xml.binding.jeusDD.JmsVendorType;
import jeus.xml.binding.jeusDD.JmxManagerType;
import jeus.xml.binding.jeusDD.JnsServerType;
import jeus.xml.binding.jeusDD.LifecycleInvocationType;
import jeus.xml.binding.jeusDD.LocalType;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.MailEntryType;
import jeus.xml.binding.jeusDD.MailPropertyType;
import jeus.xml.binding.jeusDD.MailSourceType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;
import jeus.xml.binding.jeusDD.NamingServerType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.OldPoolingType;
import jeus.xml.binding.jeusDD.PoolingType;
import jeus.xml.binding.jeusDD.ResourceType;
import jeus.xml.binding.jeusDD.SmtpHandlerType;
import jeus.xml.binding.jeusDD.SnmpAdaptorType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.TmConfigType;
import jeus.xml.binding.jeusDD.TypePropertyType;
import jeus.xml.binding.jeusDD.TypeResourceType;
import jeus.xml.binding.jeusDD.UrlEntryType;
import jeus.xml.binding.jeusDD.UrlSourceType;
import jeus.xml.binding.jeusDD.VendorType;
import jeus.xml.binding.jeusDD.WaitFreeConnectionType;
import jeus.xml.binding.jeusDD.WebComponentType;
import jeus.xml.binding.jeusDD.WebContextGroupType;

public class JeusMainJaxbConverter
extends XMLConverter {
    public static final String FS = System.getProperty("file.separator");
    public static final String JEUS_SYSTEM_CONFIG = "jeus-system";
    public static final String NODE_CONFIG = "node";
    public static final String NODE_NAME = "node-name";
    public static final String BACKUP_NODE = "backup-node";
    public static final String ENGINE_CONTAINER = "engine-container";
    public static final String COMMAND_OPTION = "command-option";
    public static final String SEQUENTIAL_START = "sequential-start";
    public static final String USER_CLASS_PATH = "user-class-path";
    public static final String INVOCATION_MANAGER_ACTION = "invocation-manager-action";
    public static final String ENGINE_COMMAND = "engine-command";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String SCHEDULING = "scheduler";
    public static final String ENABLE_JNLP = "enable-jnlp";
    public static final String ENABLE_WB = "enable-webadmin";
    public static final String SECURITY_SWITCH = "security-switch";
    public static final String CLASS_FTP = "class-ftp";
    public static final String USER_NOTIFY = "user-notify";
    public static final String USER_LOG = "user-log";
    public static final String SYSTEM_LOG = "system-log";
    public static final String CONTEXT_GROUP = "context-group";
    public static final String LOGGING = "logging";
    public static final String ERROR_LOG = "error-log";
    public static final String FILE_NAME = "file-name";
    public static final String VALID_DAY = "valid-day";
    public static final String TARGET = "target";
    public static final String BUFFER_SIZE = "buffer-size";
    public static final String LEVEL = "level";
    public static final String FILE_PER_DAY = "files-per-day";
    public static final String RESOURCE_WRAP = "resource";
    public static final String DATABASE = "database";
    public static final String DATA_SOURCE = "data-source";
    public static final String EXPORT_NAME = "export-name";
    public static final String DESCRIPTION = "description";
    public static final String BACKUP_DATA_SOURCE = "backup-data-source";
    public static final String PASSWORD = "password";
    public static final String CONNECTION_POOL = "connection-pool";
    public static final String WAIT_FREE_CONNECTION = "wait-free-connection";
    public static final String ENABLE_WAIT = "enable-wait";
    public static final String WAIT_TIME = "wait-time";
    public static final String MAX_USE_COUNT = "max-use-count";
    public static final String DB_CONNECTION_POOL = "db-connection-pool";
    public static final String POOL_NAME = "pool-name";
    public static final String CONNECTION_URL = "connection-url";
    public static final String DRIVER_CLASS_NAME = "driver-class-name";
    public static final String CONNECTION_ARGUMENT = "connection-argument";
    public static final String DYNAMIC_INCREMENT = "dynamic-increment";
    public static final String GET_CONNECTION_TIMEOUT = "get-connection-timeout";
    public static final String FETCH_SIZE = "fetch-size";
    public static final String DB_POOL_CONTROL = "db-pool-control";
    public static final String DBA_CONNECTION = "dba-connection";
    public static final String MAX_IDLE_TIME = "max-idle-time";
    public static final String MAX_ACTIVE_TIME = "max-active-time";
    public static final String CHECK_QUERY = "check-query";
    public static final String EXT_SOURCE = "external-source";
    public static final String IBMMQ = "IBMMQ";
    public static final String TMAX = "tmax";
    public static final String SONIC_MQ = "SONICMQ";
    public static final String BACKUP_HOST_NAME = "backup-host-name";
    public static final String BACKUP_PORT = "backup-port";
    public static final String TMAX_CONNECTION_POOL = "tmax-connection-pool";
    public static final String BACKUP_DELEGATE = "backup-delegate";
    public static final String TMAX_SECURITY = "tmax-security";
    public static final String SERVICE_TIMEOUT = "service-timeout";
    public static final String TX_TO = "transaction-timeout";
    public static final String TX_BLOCK_TO = "transaction-block-timeout";
    public static final String CONNECTION_TO = "connection-timeout";
    public static final String USER_NAMAE = "user-name";
    public static final String USER_PASSWORD = "user-password";
    public static final String DOMAIN_NAME = "domain-name";
    public static final String DOMAIN_PASSWORD = "domain-password";
    public static final String TMAX_ADDRESS = "tmax-address";
    public static final String TYPE_QCF = "IBM-QCF";
    public static final String TYPE_TCF = "IBM-TCF";
    public static final String TYPE_Q = "IBM-Q";
    public static final String TYPE_T = "IBM-T";
    public static final String TYPE_XAQCF = "IBM-XAQCF";
    public static final String TYPE_XATCF = "IBM-XATCF";
    public static final String TYPE_LOCALXAQCF = "IBM-LOCALXAQCF";
    public static final String TYPE_LOCALXATCF = "IBM-LOCALXATCF";
    public static final String TYPE_QCF_SONIC = "SONIC-QCF";
    public static final String TYPE_TCF_SONIC = "SONIC-TCF";
    public static final String TYPE_Q_SONIC = "SONIC-Q";
    public static final String TYPE_T_SONIC = "SONIC-T";
    public static final String TYPE_XAQCF_SONIC = "SONIC-XAQCF";
    public static final String TYPE_XATCF_SONIC = "SONIC-XATCF";
    public static final String TYPE_LOCALXAQCF_SONIC = "SONIC-LOCALXAQCF";
    public static final String TYPE_LOCALXATCF_SONIC = "SONIC-LOCALXATCF";
    public static final String TRANSPORT = "transport";
    public static final String CLIENT_ID = "client-id";
    public static final String QMANAGER = "qmanager";
    public static final String HOST_NAME = "host-name";
    public static final String PORT = "port";
    public static final String CHANNEL = "channel";
    public static final String CCSID = "ccs-id";
    public static final String REC_EXIT = "rec-exit";
    public static final String REC_EXIT_INIT = "rec-exit-init";
    public static final String SEC_EXIT = "sec-exit";
    public static final String SEC_EXIT_INIT = "sec-exit-init";
    public static final String SEND_EXIT = "send-exit";
    public static final String SEND_EXIT_INIT = "send-exit-init";
    public static final String TEMP_MODEL = "temp-model";
    public static final String MSG_RETENTION = "msg-retention";
    public static final String BROKER_PUB_Q = "broker-pubq";
    public static final String BROKER_SUB_Q = "broker-subq";
    public static final String BROKER_DUR_SUB_Q = "broker-dursubq";
    public static final String BROKER_CC_SUB_Q = "broker-ccsubq";
    public static final String BROKER_CCD_SUB_Q = "broker-ccdsubq";
    public static final String BROKER_Q_MGR = "broker-qmgr";
    public static final String BROKER_CON_Q = "broker-conq";
    public static final String EXPIRY = "expiry";
    public static final String PRIORITY = "priority";
    public static final String PERSISTENCE = "persistence";
    public static final String TARG_CLIENT = "targ-client";
    public static final String ENCODING = "encoding";
    public static final String QUEUE = "queue";
    public static final String TOPIC = "topic";
    public static final String BIND = "BIND";
    public static final String CLIENT = "CLIENT";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String APP = "APP";
    public static final String UNLIM = "UNLIM";
    public static final String QDEF = "QDEF";
    public static final String PERS = "PERS";
    public static final String NON = "NON";
    public static final String JMS = "JMS";
    public static final String MQ = "MQ";
    public static final String NATIVE = "NATIVE";
    public static final String SELECTOR_AT_BROKER = "selector-broker";
    public static final String PREFETCH_COUNT = "prefetch-count";
    public static final String PREFETCH_THRESHOLD = "prefetch-threshold";
    public static final String BROKER_HOST_NAME = "broker-host-name";
    public static final String BROKER_PORT = "broker-port";
    public static final String BROKER_PROTOCOL = "broker-protocol";
    public static final String BROKER_URL = "broker-url";
    public static final String CONNECT_ID = "client-id";
    public static final String CONNECT_URL = "connect-url";
    public static final String DEFAULT_PASSWORD = "default-password";
    public static final String DEFAULT_USER = "default-user";
    public static final String LOAD_BALANCING = "load-balance";
    public static final String MONITORING_INTERVAL = "monitor-interval";
    public static final String PERSISTENT_DELIVERY = "persistent-delivery";
    public static final String SEQUENTIAL = "sequential";
    public static final String MAIL_SOURCE = "mail-source";
    public static final String MAIL_ENTRY = "mail-entry";
    public static final String MAIL_PROPERTY = "mail-property";
    public static final String PROPERTY = "property";
    public static final String VALUE = "value";
    public static final String URL_SOURCE = "url-source";
    public static final String URL_ENTRY = "url-entry";
    public static final String NAMING_SERVER_CONFIG = "naming-server";
    public static final String NAMING_SERVER = "server";
    public static final String NAMING_LOCAL = "local";
    public static final String RESOLUTION = "resolution";
    public static final String SERVER_BUFFER_SIZE = "buffer-size";
    public static final String SERVER_BACK_LOG_SIZE = "backlog-size";
    public static final String LOCAL_BUFFER_SIZE = "buffer-size";
    public static final String EXPORT_COS_NAMING = "export-cos-naming";
    public static final String APPLICATION_CONFIG = "application";
    public static final String PATH = "path";
    public static final String EJB_MODULE = "ejb-module";
    public static final String WAR_MODULE = "war-module";
    public static final String DEPLOY_TARGET = "deploy-target";
    public static final String FAST_DEPLOY = "fast-deploy";
    public static final String CONTEXT_GROUP_NAME = "context-group-name";
    public static final String URI = "uri";
    public static final String TM_CONFIG = "tm-config";
    public static final String TM_ACTIVE_TIMEOUT = "active-timeout";
    public static final String TM_PREPARE_TIMEOUT = "prepare-timeout";
    public static final String TM_PREPARED_TIMEOUT = "prepared-timeout";
    public static final String TM_COMMIT_TIMEOUT = "commit-timeout";
    public static final String TM_RECOVERY_TIMEOUT = "recovery-timeout";
    public static final String TM_UNCOMPLETED_TIMEOUT = "uncompeleted-timeout";
    public static final String TM_CAPACITY = "capacity";
    public static final String TM_HEURISTIC = "heuristic-rollback";
    public static final String TM_RESOLUTION = "resolution";
    public static final String SESSION_SERVER = "session-server";
    public static final String SESSION_RESOLUTION = "resolution";
    public static final String BACK_LOG_SIZE = "backlog-size";
    public static final String SESSION_MANAGER = "session-manager";
    public static final String SESSION_NAME = "name";
    public static final String SESSION_PASSIVATIONTO = "passivation-to";
    public static final String SESSION_REMOVALTO = "removal-to";
    public static final String SESSION_FILEDBPATH = "file-db-path";
    public static final String SESSION_FILEDBNAME = "file-db-name";
    public static final String SESSION_MINHOLE = "min-hole";
    public static final String SESSION_PACKINGRATE = "packing-rate";
    public static final String SESSION_CHECKTO = "check-to";
    public static final String SESSION_BACKUPNAME = "backup-name";
    public static final String SESSION_BACKUPTRIGGER = "backup-trigger";
    public static final String SESSION_OPERATIONTO = "operation-to";
    public static final String POOLING = "pooling";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String STEP = "step";
    public static final String PERIOD = "period";
    public static final String JMX_MANAGER = "jmx-manager";
    public static final String MLET_URL = "mlet-url";
    public static final String HTML_ADAPTOR_PORT = "html-adaptor-port";
    public static final String RMI_CONNECTOR_PORT = "rmi-connector-port";
    public static final String SNMP_ADAPTOR = "snmp-adaptor";
    public static final String SNMP_ADAPTOR_PORT = "snmp-adaptor-port";
    public static final String SNMP_VERSION = "snmp-version";
    public static final String SNMP_MAX_PACKET_SIZE = "snmp-max-packet-size";
    public static final String SNMP_SECURITY = "snmp-security";
    public static final String EMAIL_NOTIFY = "email-notify";
    public static final String EMAIL_SMTP_ADDRESS = "smtp-address";
    public static final String EMAIL_TO_ADDRESS = "to-address";
    public static final String EMAIL_FROM_ADDRESS = "from-address";
    public static final String EMAIL_CC_ADDRESS = "cc-address";
    public static final String EMAIL_BCC_ADDRESS = "bcc-address";
    public static final String URL = "url";
    public static final String IS_PRE_CONN = "is-pre-conn";
    public static final String CLUSTER_DS = "cluster-ds";
    public static final String AUTO_DEPLOY = "auto-deploy";
    public static final String AUTO_DEPLOY_PATH = "auto-deploy-path";
    public static final String AUTO_DEPLOY_CHECK_INTERVAL = "auto-deploy-check-interval";
    public static final String LIFECYCLE_INVOCATION = "lifecycle-invocation";
    public static final String DATA_SOURCE_TYPE = "data-source-type";
    public static final String VENDOR = "vendor";
    public static final String DATABASE_NAME = "database-name";
    public static final String DATA_SOURCE_CLASS_NAME = "data-source-class-name";
    public static final String DATA_SOURCE_NAME = "data-source-name";
    public static final String SERVICE_NAME = "service-name";
    public static final String NETWORK_PROTOCOL = "network-protocol";
    public static final String ENCRYPTION = "encryption";
    public static final String CIPHER_ALGORITHM = "cipher-algorithm";
    public static final String CIPHER_PLAIN = "plain";
    public static final String CIPHER_BASE64 = "base64";
    public static final String CIPHER_3DES = "3des";
    public static final String CIPHER_DES = "DESede";
    public static final String PORT_NUMBER = "port-number";
    public static final String SERVER_NAME = "server-name";
    public static final String USER = "user";
    public static final String DRIVER_TYPE = "driver-type";
    public static final String EJB_MAIN_CONFIG = "ejb-engine";
    public static final String MODULE_LIST = "module-list";
    public static final String WEB_MAIN_CONFIG = "web-container";
    public static final String GROUP_DOCBASE = "group-docbase";
    public static final String VIRTUAL_HOST = "virtual-host";
    public static final String CONTEXT = "context";
    public static final String DOCBASE = "docbase";
    public static final String CONTEXT_NAME = "context-name";
    public static final String CONTEXT_PATH = "context-path";
    public static final String STARTUP_PREINVOKE = "startup-preinvoke";
    public static final String STARTUP_CLASS = "startup-class";
    public static final String SHUTDOWN_CLASS = "shutdown-class";
    public static final String PARAMETER = "parameter";
    public static final String METHOD = "method";
    public static final String STD_OUT = "stdout";
    public static final String BOTH = "stdout:file";
    public static final String FILE = "file";
    public static final String FATAL = "fatal";
    public static final String NOTICE = "notice";
    public static final String INFORMATION = "information";
    public static final String DEBUG = "debug";
    public static final String DEFAULT_BUFFER_SIZE = "4096";
    public Hashtable ECandEngine = new Hashtable();
    public XMLTree[] xmlTrees = null;
    private ObjectFactory jeusMainFactory = new ObjectFactory();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.converter");

    public int getType() {
        return 1;
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1);
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1);
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }

    public Object constructJAXBObject(XMLTree[] xmlTrees) throws JAXBException, IOException {
        XMLTree resourceTree;
        JeusSystemType jeusSystem = this.jeusMainFactory.createJeusSystemType();
        XMLTree xmlTree = xmlTrees[0];
        this.xmlTrees = xmlTrees;
        if (xmlTree == null || !xmlTree.getName().equals(JEUS_SYSTEM_CONFIG)) {
            return null;
        }
        Enumeration nodes = xmlTree.elements(NODE_CONFIG);
        while (nodes.hasMoreElements()) {
            XMLTree nodeTree = (XMLTree)nodes.nextElement();
            jeusSystem.getNode().add(this.superFillNode(nodeTree));
        }
        XMLTree namingServerTree = xmlTree.getFirstElement(NAMING_SERVER_CONFIG);
        if (namingServerTree != null) {
            jeusSystem.setNamingServer(this.superFillNamingServer(namingServerTree));
        }
        if ((resourceTree = xmlTree.getFirstElement(RESOURCE_WRAP)) != null) {
            jeusSystem.setResource(this.superFillResource(resourceTree));
        }
        Enumeration applications = xmlTree.elements(APPLICATION_CONFIG);
        while (applications.hasMoreElements()) {
            XMLTree applicationTree = (XMLTree)applications.nextElement();
            String name = XMLUtil.getSubtreeValue(applicationTree, "name");
            try {
                ApplicationType app = this.superFillApplication(applicationTree);
                jeusSystem.getApplication().add(app);
            }
            catch (Exception e) {
                if (name == null) continue;
                logger.log(JeusMessage_Converter._6503_LEVEL, JeusMessage_Converter._6503, (Object)name, (Throwable)e);
            }
        }
        for (int i = 1; i < xmlTrees.length; ++i) {
            if (xmlTrees[i].getName().equals(EJB_MAIN_CONFIG)) {
                Enumeration modules = xmlTrees[i].elements(MODULE_LIST);
                while (modules.hasMoreElements()) {
                    XMLTree moduleTree = (XMLTree)modules.nextElement();
                    String name = moduleTree.getValue();
                    try {
                        ApplicationType app = this.fillEJBMainModuleList(moduleTree, xmlTrees[i].getNodeName(), xmlTrees[i].getEngineName());
                        List appList = app.getNameAndPathAndDeploymentType();
                        for (int k = 0; k < appList.size(); ++k) {
                            JAXBElement element = (JAXBElement)appList.get(k);
                            Object obj = element.getValue();
                            if (!(obj instanceof EjbComponentType)) continue;
                            jeusSystem.getApplication().add(app);
                        }
                    }
                    catch (Exception e) {
                        if (name == null) continue;
                        logger.log(JeusMessage_Converter._6503_LEVEL, JeusMessage_Converter._6503, (Object)name, (Throwable)e);
                    }
                }
                continue;
            }
            if (!xmlTrees[i].getName().equals(WEB_MAIN_CONFIG)) continue;
            String jeus4EngConfigDir = XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + xmlTrees[i].getNodeName() + FS + xmlTrees[i].getEngineName();
            String jeus5EngConfigDir = JeusProperties.JEUS_CONFIG_HOME + FS + xmlTrees[i].getNodeName() + FS + xmlTrees[i].getEngineName();
            FileUtils.copy((String)(jeus4EngConfigDir + FS + "web.xml"), (String)(jeus5EngConfigDir + FS + "web.xml"));
            FileUtils.copy((String)(jeus4EngConfigDir + FS + "webcommon.xml"), (String)(jeus5EngConfigDir + FS + "webcommon.xml"));
            Enumeration contextGroups = xmlTrees[i].elements(CONTEXT_GROUP);
            while (contextGroups.hasMoreElements()) {
                XMLTree contextGroupTree = (XMLTree)contextGroups.nextElement();
                String groupName = XMLUtil.getSubtreeValue(contextGroupTree, GROUP_DOCBASE);
                this.convertContextToApplication(contextGroupTree, jeusSystem, i, groupName, null);
                Enumeration virtualHosts = contextGroupTree.elements(VIRTUAL_HOST);
                while (virtualHosts.hasMoreElements()) {
                    XMLTree virtualHostTree = (XMLTree)virtualHosts.nextElement();
                    String vsName = virtualHostTree.getValue();
                    this.convertContextToApplication(virtualHostTree, jeusSystem, i, groupName, vsName);
                }
            }
        }
        return jeusSystem;
    }

    private void convertContextToApplication(XMLTree rootContextTree, JeusSystemType jeusSystem, int index, String groupName, String vhostName) {
        Enumeration contexts = rootContextTree.elements(CONTEXT);
        while (contexts.hasMoreElements()) {
            XMLTree contextTree = (XMLTree)contexts.nextElement();
            String contextName = XMLUtil.getSubtreeValue(contextTree, CONTEXT_NAME);
            try {
                ApplicationType app = this.fillWEBMainModuleList(contextTree, this.xmlTrees[index].getNodeName(), this.xmlTrees[index].getEngineName(), groupName, vhostName);
                List appList = app.getNameAndPathAndDeploymentType();
                for (int i = 0; i < appList.size(); ++i) {
                    JAXBElement element = (JAXBElement)appList.get(i);
                    Object obj = element.getValue();
                    if (!(obj instanceof WebComponentType)) continue;
                    jeusSystem.getApplication().add(app);
                }
            }
            catch (Exception e) {
                if (contextName == null) continue;
                logger.log(JeusMessage_Converter._6503_LEVEL, JeusMessage_Converter._6503, (Object)contextName, (Throwable)e);
            }
        }
    }

    private JeusNodeType superFillNode(XMLTree nodeTree) throws JAXBException, IOException {
        XMLTree jmxManagerTree;
        Boolean enableWebadmin;
        Boolean scheduling;
        Boolean serialStartValue;
        JeusNodeType node = this.jeusMainFactory.createJeusNodeType();
        String nodeName = XMLUtil.getSubtreeValue(nodeTree, "name");
        if (!ValidString.notEmptyString(nodeName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "node/name");
        }
        node.setName(nodeName);
        String backupNode = XMLUtil.getSubtreeValue(nodeTree, BACKUP_NODE);
        if (ValidString.notEmptyString(backupNode)) {
            node.setBackupNode(backupNode);
        }
        Enumeration ecs = nodeTree.elements(ENGINE_CONTAINER);
        while (ecs.hasMoreElements()) {
            XMLTree engineContainerTree = (XMLTree)ecs.nextElement();
            node.getEngineContainer().add(this.fillEngineContainer(engineContainerTree, nodeName));
        }
        Boolean classFTP = (Boolean)ValidString.getProperTypeFromString(nodeTree, CLASS_FTP, 2, false, "false");
        if (classFTP != null) {
            node.setClassFtp(Boolean.valueOf(classFTP));
        }
        if ((serialStartValue = (Boolean)ValidString.getProperTypeFromString(nodeTree, SEQUENTIAL_START, 2, false, "false")) != null) {
            node.setSequentialStart(Boolean.valueOf(serialStartValue));
        }
        if ((scheduling = (Boolean)ValidString.getProperTypeFromString(nodeTree, SCHEDULING, 2, false, "false")) != null && scheduling.booleanValue()) {
            node.setScheduler(this.jeusMainFactory.createSchedulerType());
        }
        if ((enableWebadmin = (Boolean)ValidString.getProperTypeFromString(nodeTree, ENABLE_WB, 2, false, "false")) != null) {
            node.setEnableWebadmin(Boolean.valueOf(enableWebadmin));
        }
        XMLTree systemLog = nodeTree.getFirstElement(SYSTEM_LOG);
        XMLTree emailNotify = nodeTree.getFirstElement(EMAIL_NOTIFY);
        if (systemLog != null || emailNotify != null) {
            node.getSystemLogging().add(this.commonFillSystemLogging(systemLog, emailNotify));
        }
        if ((jmxManagerTree = nodeTree.getFirstElement(JMX_MANAGER)) != null) {
            node.setJmxManager(this.commonFillJmxManager(jmxManagerTree));
        }
        return node;
    }

    private NamingServerType superFillNamingServer(XMLTree namingServerTree) throws JAXBException, XMLConverterException {
        XMLTree nsLocalTree;
        NamingServerType namingServer = this.jeusMainFactory.createNamingServerType();
        XMLTree nsServerTree = namingServerTree.getFirstElement(NAMING_SERVER);
        if (nsServerTree != null) {
            XMLTree poolingTree;
            Integer backLogSize;
            JnsServerType server = this.jeusMainFactory.createJnsServerType();
            Boolean exportCosNaming = (Boolean)ValidString.getProperTypeFromString(nsServerTree, EXPORT_COS_NAMING, 2, false, "false");
            if (exportCosNaming != null) {
                server.setExportCosNaming(Boolean.valueOf(exportCosNaming));
            }
            if ((backLogSize = (Integer)ValidString.getProperTypeFromString(nsServerTree, "backlog-size", 0, false, "50")) != null) {
                server.setBacklogSize(Integer.valueOf(backLogSize));
            }
            if ((poolingTree = nsServerTree.getFirstElement(POOLING)) != null) {
                server.setPooling(this.commonFillPooling(poolingTree, "5", "10", "1", "60000"));
            }
            namingServer.setServer(server);
        }
        if ((nsLocalTree = namingServerTree.getFirstElement(NAMING_LOCAL)) != null) {
            LocalType local = this.jeusMainFactory.createLocalType();
            XMLTree poolingTree = nsLocalTree.getFirstElement(POOLING);
            if (poolingTree != null) {
                local.setPooling(this.commonFillPooling(poolingTree, "5", "10", "1", "60000"));
            }
            namingServer.setLocal(local);
        }
        return namingServer;
    }

    private ResourceType superFillResource(XMLTree resourceTree) throws JAXBException, XMLConverterException {
        XMLTree extSourceTree;
        XMLTree mailSourceTree;
        ResourceType resource = this.jeusMainFactory.createResourceType();
        XMLTree dataSourceTree = resourceTree.getFirstElement(DATA_SOURCE);
        if (dataSourceTree != null) {
            resource.setDataSource(this.fillDataSource(dataSourceTree));
        }
        if ((mailSourceTree = resourceTree.getFirstElement(MAIL_SOURCE)) != null) {
            MailSourceType mailSource = this.jeusMainFactory.createMailSourceType();
            Enumeration enum1 = mailSourceTree.elements(MAIL_ENTRY);
            while (enum1.hasMoreElements()) {
                XMLTree mailTree = (XMLTree)enum1.nextElement();
                mailSource.getMailEntry().add(this.subFillMailEntry(mailTree));
            }
            resource.setMailSource(mailSource);
        }
        XMLTree urlSourceTree = resourceTree.getFirstElement(URL_SOURCE);
        UrlSourceType urlSource = this.jeusMainFactory.createUrlSourceType();
        if (urlSourceTree != null) {
            Enumeration enum1 = urlSourceTree.elements(URL_ENTRY);
            while (enum1.hasMoreElements()) {
                XMLTree urlEntryTree = (XMLTree)enum1.nextElement();
                UrlEntryType urlEntry = this.jeusMainFactory.createUrlEntryType();
                String exportName = XMLUtil.getSubtreeValue(urlEntryTree, EXPORT_NAME);
                if (!ValidString.notEmptyString(exportName)) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "url-entry/export-name");
                }
                urlEntry.setExportName(exportName);
                String urlName = XMLUtil.getSubtreeValue(urlEntryTree, URL);
                if (!ValidString.notEmptyString(urlName)) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "url-entry/url");
                }
                urlEntry.setUrl(urlName);
                urlSource.getUrlEntry().add(urlEntry);
            }
            resource.setUrlSource(urlSource);
        }
        if ((extSourceTree = resourceTree.getFirstElement(EXT_SOURCE)) != null) {
            resource.setExternalSource(this.fillExternalSource(extSourceTree));
        }
        return resource;
    }

    private ApplicationType superFillApplication(XMLTree applicationTree) throws JAXBException, IOException {
        ApplicationType application = this.jeusMainFactory.createApplicationType();
        ObjectFactory objFact = new ObjectFactory();
        String applicationName = XMLUtil.getSubtreeValue(applicationTree, "name");
        if (!ValidString.notEmptyString(applicationName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "application/name");
        }
        String applicationPath4 = XMLUtil.getSubtreeValue(applicationTree, PATH);
        if (ValidString.notEmptyString(applicationPath4)) {
            String[] directoryAndFile = this.separateDirAndFile(applicationPath4);
            String FileName = directoryAndFile[1];
            String applicationPath5 = new String(JeusProperties.JEUS_APP_HOME + FS + FileName);
            JeusDeploymentManager.setApplicationPath(application, applicationPath5);
            File temp = new File(directoryAndFile[0] + FS + directoryAndFile[1]);
            if (!temp.exists()) {
                throw new JeusException("    application " + temp.getAbsolutePath() + " cannot convert because it does not exist");
            }
            ProcessConversion con = new ProcessConversion();
            try {
                con.getClass();
                con.convertModule(0, applicationPath4, applicationPath5, false);
                System.out.println("   Conversion Success - " + applicationPath4 + " To " + applicationPath5);
            }
            catch (Exception e) {
                System.out.println("   Conversion Fail - " + applicationPath4);
                System.out.print("     detail : ");
                logger.log(Level.SEVERE, "", (Throwable)e);
            }
        } else {
            throw new XMLConverterException(JeusMessage_Converter._6001, "application/path");
        }
        Boolean fastDeploy = (Boolean)ValidString.getProperTypeFromString(applicationTree, FAST_DEPLOY, 2, false, "false");
        if (fastDeploy != null) {
            application.setFastDeploy(Boolean.valueOf(fastDeploy));
        }
        Enumeration ejbModules = applicationTree.elements(EJB_MODULE);
        while (ejbModules.hasMoreElements()) {
            XMLTree ejbModuleTree = (XMLTree)ejbModules.nextElement();
            EjbComponentType ejbComponent = this.jeusMainFactory.createEjbComponentType();
            String uri = XMLUtil.getSubtreeValue(ejbModuleTree, URI);
            if (!ValidString.notEmptyString(uri)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "ejb-module/uri");
            }
            ejbComponent.setUri(uri);
            DeploymentTargetType deployTarget = this.commonFillDeployTarget("ejb", ejbModuleTree);
            if (deployTarget != null) {
                ejbComponent.setDeploymentTarget(deployTarget);
            }
            application.getNameAndPathAndDeploymentType().add(objFact.createApplicationTypeEjbComponent(ejbComponent));
        }
        Enumeration webModules = applicationTree.elements(WAR_MODULE);
        while (webModules.hasMoreElements()) {
            XMLTree webModuleTree = (XMLTree)webModules.nextElement();
            WebComponentType webComponent = this.jeusMainFactory.createWebComponentType();
            String uri = XMLUtil.getSubtreeValue(webModuleTree, URI);
            if (!ValidString.notEmptyString(uri)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "war-module/uri");
            }
            webComponent.setUri(uri);
            DeploymentTargetType deployTarget = this.commonFillDeployTarget("web", webModuleTree);
            if (deployTarget != null) {
                webComponent.setDeploymentTarget(deployTarget);
            }
            application.getNameAndPathAndDeploymentType().add(objFact.createApplicationTypeWebComponent(webComponent));
        }
        DeploymentTargetType deployTarget = this.commonFillDeployTarget("ear", applicationTree);
        if (deployTarget != null) {
            application.setDeploymentTarget(deployTarget);
        }
        JeusDeploymentManager.setApplicationDeploymentType(application, "EAR");
        return application;
    }

    private String[] separateDirAndFile(String path) throws JeusException {
        String[] temp = new String[2];
        File file = new File(path);
        String absolutePath = file.getAbsolutePath();
        int sepIndex = absolutePath.lastIndexOf(File.separator);
        if (sepIndex == -1) {
            throw new JeusException(" application/path is an absolute path used to locate the .ear file");
        }
        temp[0] = absolutePath.substring(0, sepIndex);
        temp[1] = absolutePath.substring(sepIndex + 1);
        return temp;
    }

    private ApplicationType fillEJBMainModuleList(XMLTree moduleTree, String nodeName, String engineName) throws JAXBException, IOException {
        ApplicationType application = this.jeusMainFactory.createApplicationType();
        ObjectFactory objFact = new ObjectFactory();
        String moduleName = moduleTree.getValue();
        if (!ValidString.notEmptyString(moduleName)) {
            return application;
        }
        String classLoadMode = XMLVersionConverter.JEUS4_EJB_CLASS_LODING_MODE;
        String ejbHomes = XMLVersionConverter.JEUS4_EJB_HOME;
        String engineContainerName = (String)this.ECandEngine.get(engineName);
        String jeus4EngDir = XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + nodeName + FS + engineName;
        if (classLoadMode.equalsIgnoreCase("JAR")) {
            String ejbHome4 = this.findEjbHome(ejbHomes, moduleName);
            boolean includeDD = false;
            if (ejbHome4 != null) {
                String ejbModule4 = ejbHome4 + FS + moduleName + ".jar";
                String ejbModule5 = JeusProperties.JEUS_APP_HOME + FS + moduleName + ".jar";
                InputJarArchive sourceJar = (InputJarArchive)JarArchiveFactory.openArchiveStatic((String)ejbModule4);
                InputStream jeusDd = sourceJar.getEntry("META-INF" + FS + "jeus-ejb-dd.xml");
                boolean bl = includeDD = jeusDd != null;
                if (includeDD) {
                    ProcessConversion con = new ProcessConversion();
                    try {
                        con.getClass();
                        con.convertModule(1, ejbModule4, ejbModule5, false);
                    }
                    catch (Exception e) {
                        logger.log(JeusMessage_Converter._6502_LEVEL, JeusMessage_Converter._6502, (Object)ejbModule4, (Throwable)e);
                        return null;
                    }
                } else {
                    FileUtils.copy((String)ejbModule4, (String)ejbModule5);
                }
            } else {
                throw new JeusException(JeusMessage_Converter._6201, (Object)moduleName);
            }
            JeusDeploymentManager.setApplicationPath(application, moduleName + ".jar");
            if (engineContainerName != null) {
                DeploymentTargetType deploymentTarget = this.jeusMainFactory.createDeploymentTargetType();
                AppTargetType target = this.jeusMainFactory.createAppTargetType();
                target.setEngineContainerName(engineContainerName);
                deploymentTarget.getAllTargetsOrTarget().add(target);
                application.setDeploymentTarget(deploymentTarget);
                JeusDeploymentManager.setApplicationDeploymentType(application, "COMPONENT");
                EjbComponentType ejbComponent = this.jeusMainFactory.createEjbComponentType();
                if (!includeDD) {
                    String jeusEjbDd4 = jeus4EngDir + FS + "jeus-ejb-dd_" + moduleName + ".xml";
                    String jeusEjbDd5 = JeusProperties.JEUS_CONFIG_HOME + FS + nodeName + FS + engineName + FS + "jeus-ejb-dd_" + moduleName + ".xml";
                    File temp = new File(jeusEjbDd4);
                    if (temp.exists()) {
                        XMLVersionConverter.processConversion(XMLVersionConverter.JEUS_EJB_DD, jeusEjbDd4, jeusEjbDd5);
                        ejbComponent.setJeusEjbDd(jeusEjbDd5);
                    } else {
                        System.out.println("===> " + jeusEjbDd4 + " does not exist ");
                        System.out.println("    after converting it, copy it to " + jeusEjbDd5 + " and fill <jeus-ejb-dd> element in jeusMain.xml\n");
                    }
                }
                application.getNameAndPathAndDeploymentType().add(objFact.createApplicationTypeEjbComponent(ejbComponent));
            }
        } else if (classLoadMode.equalsIgnoreCase("DIR")) {
            JeusDeploymentManager.setApplicationPath(application, ejbHomes);
            if (engineContainerName != null) {
                DeploymentTargetType deploymentTarget = this.jeusMainFactory.createDeploymentTargetType();
                AppTargetType target = this.jeusMainFactory.createAppTargetType();
                target.setEngineContainerName(engineContainerName);
                deploymentTarget.getAllTargetsOrTarget().add(target);
                application.setDeploymentTarget(deploymentTarget);
                JeusDeploymentManager.setApplicationDeploymentType(application, "COMPONENT");
                EjbComponentType ejbComponent = this.jeusMainFactory.createEjbComponentType();
                String ejbJar4 = jeus4EngDir + FS + "ejb-jar_" + moduleName + ".xml";
                String ejbJar5 = JeusProperties.JEUS_CONFIG_HOME + FS + nodeName + FS + engineName + FS + "ejb-jar_" + moduleName + ".xml";
                if (this.FileCopy(ejbJar4, ejbJar5)) {
                    ejbComponent.setEjbJar(ejbJar5);
                }
                String jeusEjbDd4 = jeus4EngDir + FS + "jeus-ejb-dd_" + moduleName + ".xml";
                String jeusEjbDd5 = JeusProperties.JEUS_CONFIG_HOME + FS + nodeName + FS + engineName + FS + "jeus-ejb-dd_" + moduleName + ".xml";
                File temp = new File(jeusEjbDd4);
                if (temp.exists()) {
                    XMLVersionConverter.processConversion(XMLVersionConverter.JEUS_EJB_DD, jeusEjbDd4, jeusEjbDd5);
                    ejbComponent.setJeusEjbDd(jeusEjbDd5);
                } else {
                    System.out.println("===> " + jeusEjbDd4 + " does not exist ");
                    System.out.println("    after converting it, copy it to " + jeusEjbDd5 + " and fill <jeus-ejb-dd> element in jeusMain.xml\n");
                }
                application.getNameAndPathAndDeploymentType().add(objFact.createApplicationTypeEjbComponent(ejbComponent));
            }
            application.setClassFtpUnit(ClassFtpUnitType.CLASS);
        }
        return application;
    }

    private ApplicationType fillWEBMainModuleList(XMLTree contextTree, String nodeName, String engineName, String groupDocbase, String vhost) throws JAXBException, IOException {
        ApplicationType application = this.jeusMainFactory.createApplicationType();
        ObjectFactory objFact = new ObjectFactory();
        String contextName = XMLUtil.getSubtreeValue(contextTree, CONTEXT_NAME);
        if (!ValidString.notEmptyString(contextName)) {
            return application;
        }
        String jeus4EngDir = XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + nodeName + FS + engineName;
        groupDocbase = groupDocbase == null ? "" : FS + groupDocbase;
        vhost = vhost == null ? "" : FS + vhost;
        String webDdPath = jeus4EngDir + FS + "jeus-web-dd_" + contextName + ".xml";
        XMLUtil xmlUtil = new XMLUtil();
        FileInputStream in = new FileInputStream(new File(webDdPath));
        WEBDDJaxbConverter converter = new WEBDDJaxbConverter();
        XMLTree jeusWebDdTree = null;
        try {
            jeusWebDdTree = xmlUtil.process((InputStream)in, WIOParameters.XML_VALIDATION, converter.getPublicID(), converter.getSystemID(), converter.getType());
        }
        catch (Exception e) {
            throw new JeusException("Getting [" + webDdPath + "] xmlTree is failed", (Throwable)e);
        }
        XMLTree conTree = jeusWebDdTree.getFirstElement(CONTEXT);
        String originalDocbase = XMLUtil.getSubtreeValue(conTree, DOCBASE);
        String docbase = originalDocbase == null ? "" : FS + originalDocbase;
        FileUtils.copyDirectory((String)(XMLVersionConverter.JEUS4_SERVLET_HOME + groupDocbase + vhost + docbase), (String)(JeusProperties.JEUS_APP_HOME + docbase));
        JeusDeploymentManager.setApplicationPath(application, originalDocbase);
        String engineContainerName = (String)this.ECandEngine.get(engineName);
        if (engineContainerName != null) {
            DeploymentTargetType deploymentTarget = this.jeusMainFactory.createDeploymentTargetType();
            AppTargetType target = this.jeusMainFactory.createAppTargetType();
            target.setEngineContainerName(engineContainerName);
            deploymentTarget.getAllTargetsOrTarget().add(target);
            application.setDeploymentTarget(deploymentTarget);
            JeusDeploymentManager.setApplicationDeploymentType(application, "COMPONENT");
            WebComponentType webbComponent = this.jeusMainFactory.createWebComponentType();
            String jeus4Dd = jeus4EngDir + FS + "jeus-web-dd_" + contextName + ".xml";
            String jeus5Dd = JeusProperties.JEUS_APP_HOME + docbase + FS + "WEB-INF" + FS + "jeus-web-dd.xml";
            XMLVersionConverter.processConversion(XMLVersionConverter.findingType("jeus_web_dd"), jeus4Dd, jeus5Dd);
            application.getNameAndPathAndDeploymentType().add(objFact.createApplicationTypeWebComponent(webbComponent));
        }
        return application;
    }

    private boolean FileCopy(String sourcePath, String targetPath) throws IOException {
        File temp = new File(sourcePath);
        if (!temp.exists()) {
            System.out.println("===> " + sourcePath + " does not exist");
            System.out.println("    copy it to " + targetPath + " and fill <ejb-jar> element in jeusMain.xml\n");
            return false;
        }
        File targetFile = new File(targetPath.substring(0, targetPath.lastIndexOf(File.separator)));
        targetFile.mkdirs();
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(sourcePath);
            os = new FileOutputStream(targetPath);
            ArchiveHelper.copy((InputStream)is, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new JeusException("Fail to Find " + sourcePath, (Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return true;
    }

    private String findEjbHome(String ejbHomes, String applicationName) {
        String clsp = FS.equals("/") ? ":" : ";";
        String ejbHome = null;
        int from = 0;
        int to = 1;
        while (to < ejbHomes.length()) {
            to = ejbHomes.indexOf(clsp, from);
            if (to > 0) {
                ejbHome = ejbHomes.substring(from, to - 1);
                File dir = new File(ejbHome);
                File[] files = dir.listFiles();
                for (int k = 0; k < files.length; ++k) {
                    if (!files[k].getName().equals(applicationName)) continue;
                    return ejbHome;
                }
                from = to + 1;
                continue;
            }
            return ejbHomes;
        }
        return ejbHomes;
    }

    private EngineContainerType fillEngineContainer(XMLTree engineContainerTree, String nodeName) throws JAXBException, IOException {
        XMLTree jmxTree;
        String invocationManager;
        XMLTree systemLog;
        XMLTree userNotifyTree;
        Boolean schedulingValue;
        XMLTree tmConfigTree;
        String userClassPath;
        EngineContainerType engineContainer = this.jeusMainFactory.createEngineContainerType();
        String containerName = XMLUtil.getSubtreeValue(engineContainerTree, "name");
        if (!ValidString.notEmptyString(containerName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "engine-container/name");
        }
        engineContainer.setName(containerName);
        String commandOption = XMLUtil.getSubtreeValue(engineContainerTree, COMMAND_OPTION);
        if (ValidString.notEmptyString(commandOption)) {
            engineContainer.setCommandOption(commandOption);
        }
        Enumeration ecs = engineContainerTree.elements(ENGINE_COMMAND);
        while (ecs.hasMoreElements()) {
            XMLTree engineCommandTree = (XMLTree)ecs.nextElement();
            engineContainer.getEngineCommand().add(this.subFillEngineCommand(engineCommandTree, engineContainer.getEngineCommand(), nodeName, containerName));
        }
        Boolean sequentialValue = (Boolean)ValidString.getProperTypeFromString(engineContainerTree, SEQUENTIAL_START, 2, false, "false");
        if (sequentialValue != null) {
            engineContainer.setSequentialStart(Boolean.valueOf(sequentialValue));
        }
        if (ValidString.notEmptyString(userClassPath = XMLUtil.getSubtreeValue(engineContainerTree, USER_CLASS_PATH))) {
            engineContainer.setUserClassPath(userClassPath);
        }
        if ((tmConfigTree = engineContainerTree.getFirstElement(TM_CONFIG)) != null) {
            engineContainer.setTmConfig(this.subFillTmConfig(tmConfigTree));
        }
        if ((schedulingValue = (Boolean)ValidString.getProperTypeFromString(engineContainerTree, SCHEDULING, 2, false, "true")) != null && schedulingValue.booleanValue()) {
            engineContainer.setScheduler(this.jeusMainFactory.createSchedulerType());
        }
        if ((userNotifyTree = engineContainerTree.getFirstElement(USER_NOTIFY)) != null) {
            engineContainer.setUserLogging(this.subFillUserLogging(userNotifyTree));
        }
        if ((systemLog = engineContainerTree.getFirstElement(SYSTEM_LOG)) != null) {
            engineContainer.getSystemLogging().add(this.commonFillSystemLogging(systemLog));
        }
        if (ValidString.notEmptyString(invocationManager = XMLUtil.getSubtreeValueDefault(engineContainerTree, INVOCATION_MANAGER_ACTION, "NoAction"))) {
            engineContainer.setInvocationManagerAction(InvocationManagerActionType.valueOf((String)invocationManager));
        }
        if ((jmxTree = engineContainerTree.getFirstElement(JMX_MANAGER)) != null) {
            engineContainer.setJmxManager(this.commonFillJmxManager(jmxTree));
        }
        this.subFillLifeCycleInvocation(engineContainer, nodeName + "_" + containerName);
        return engineContainer;
    }

    private DataSourceType fillDataSource(XMLTree dataSourceTree) throws JAXBException, XMLConverterException {
        DataSourceType dataSource = this.jeusMainFactory.createDataSourceType();
        Enumeration databases = dataSourceTree.elements(DATABASE);
        while (databases.hasMoreElements()) {
            XMLTree databaseTree = (XMLTree)databases.nextElement();
            dataSource.getDatabase().add(this.subFillDatebase(databaseTree));
        }
        this.construcDatabaseForWebMain(dataSource);
        Enumeration clusterDSes = dataSourceTree.elements(CLUSTER_DS);
        while (clusterDSes.hasMoreElements()) {
            String backup;
            XMLTree clusterDsTree = (XMLTree)clusterDSes.nextElement();
            ClusterDsType clusterDs = this.jeusMainFactory.createClusterDsType();
            String exportName = XMLUtil.getSubtreeValue(clusterDsTree, EXPORT_NAME);
            if (!ValidString.notEmptyString(exportName)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "cluster-ds/export-name");
            }
            clusterDs.setExportName(exportName);
            Boolean isPre = (Boolean)ValidString.getProperTypeFromString(clusterDsTree, IS_PRE_CONN, 2, false, "false");
            if (isPre != null) {
                clusterDs.setIsPreConn(Boolean.valueOf(isPre));
            }
            if ((backup = XMLUtil.getSubtreeValue(clusterDsTree, BACKUP_DATA_SOURCE)) != null && !backup.trim().equals("")) {
                int startindex = 0;
                int separatorIndex = backup.indexOf(",", startindex);
                while (separatorIndex != -1) {
                    clusterDs.getDataSource().add(backup.substring(startindex, separatorIndex));
                    startindex = separatorIndex + 1;
                    separatorIndex = backup.indexOf(",", startindex);
                }
            } else {
                clusterDs.getDataSource().add("undefined");
            }
            dataSource.getClusterDs().add(clusterDs);
        }
        return dataSource;
    }

    private void construcDatabaseForWebMain(DataSourceType dataSource) throws JAXBException, XMLConverterException {
        for (int i = 1; i < this.xmlTrees.length; ++i) {
            if (!this.xmlTrees[i].getName().equals(WEB_MAIN_CONFIG)) continue;
            Enumeration dbPoolConnections = this.xmlTrees[i].elements(DB_CONNECTION_POOL);
            while (dbPoolConnections.hasMoreElements()) {
                XMLTree dbaConnectionTree;
                XMLTree dbPoolControlTree;
                String fetchSize;
                String maxUse;
                String waitTime;
                DatabaseType database = this.jeusMainFactory.createDatabaseType();
                XMLTree dbPoolConnectionTree = (XMLTree)dbPoolConnections.nextElement();
                String name = XMLUtil.getSubtreeValue(dbPoolConnectionTree, POOL_NAME);
                if (name == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "db-connection-pool/pool-name");
                }
                database.setExportName(name);
                database.setDataSourceType(DataSourceTypeType.CONNECTION_POOL_DATA_SOURCE);
                String connectonUrl = XMLUtil.getSubtreeValue(dbPoolConnectionTree, CONNECTION_URL);
                this.parseConnectionUrl(connectonUrl, database);
                if (database.getVendor() == null) {
                    logger.log(JeusMessage_Converter._6504_LEVEL, JeusMessage_Converter._6504, (Object)name);
                    database.setVendor(null);
                }
                if (database.getVendor() == VendorType.ORACLE) {
                    database.setDataSourceClassName("oracle.jdbc.pool.OracleConnectionPoolDataSource");
                } else {
                    database.setDataSourceClassName("willDefine");
                    logger.log(JeusMessage_Converter._6505_LEVEL, JeusMessage_Converter._6505, (Object)database.getExportName());
                }
                String driverClassName = XMLUtil.getSubtreeValue(dbPoolConnectionTree, DRIVER_CLASS_NAME);
                if (driverClassName == null) {
                    throw new XMLConverterException(JeusMessage_Converter._6001, "db-connection-pool/driver-class-name");
                }
                database.setDataSourceClassName(driverClassName);
                String connectionArg = XMLUtil.getSubtreeValue(dbPoolConnectionTree, CONNECTION_ARGUMENT);
                Boolean encryption = (Boolean)ValidString.getProperTypeFromString(dbPoolConnectionTree, ENCRYPTION, 2, false, "false");
                this.parseConnectionArgument(connectionArg, encryption, database);
                DatabaseConnectionPoolType connectionPool = this.jeusMainFactory.createDatabaseConnectionPoolType();
                String checkQuery = XMLUtil.getSubtreeValue(dbPoolConnectionTree, CHECK_QUERY);
                if (checkQuery != null) {
                    connectionPool.setCheckQuery(checkQuery);
                }
                WaitFreeConnectionType waitFreeConnection = this.jeusMainFactory.createWaitFreeConnectionType();
                String dynamicIncrement = XMLUtil.getSubtreeValue(dbPoolConnectionTree, DYNAMIC_INCREMENT);
                if (dynamicIncrement != null) {
                    waitFreeConnection.setEnableWait(Boolean.valueOf(Boolean.valueOf(dynamicIncrement)));
                }
                if ((waitTime = XMLUtil.getSubtreeValue(dbPoolConnectionTree, GET_CONNECTION_TIMEOUT)) != null) {
                    waitFreeConnection.setWaitTime(Long.valueOf(Long.parseLong(waitTime)));
                }
                if (dynamicIncrement != null || waitTime != null) {
                    connectionPool.setWaitFreeConnection(waitFreeConnection);
                }
                if ((maxUse = XMLUtil.getSubtreeValue(dbPoolConnectionTree, MAX_USE_COUNT)) != null) {
                    connectionPool.setMaxUseCount(Integer.valueOf(Integer.parseInt(maxUse)));
                }
                if ((fetchSize = XMLUtil.getSubtreeValue(dbPoolConnectionTree, FETCH_SIZE)) != null) {
                    connectionPool.setStmtFetchSize(Integer.valueOf(Integer.parseInt(fetchSize)));
                }
                if ((dbPoolControlTree = dbPoolConnectionTree.getFirstElement(DB_POOL_CONTROL)) != null) {
                    String period;
                    String max;
                    OldPoolingType pooling = this.jeusMainFactory.createOldPoolingType();
                    String min = XMLUtil.getSubtreeValue(dbPoolControlTree, MIN);
                    if (min != null) {
                        pooling.setMin(Integer.valueOf(Integer.parseInt(min)));
                    }
                    if ((max = XMLUtil.getSubtreeValue(dbPoolControlTree, MAX)) == null) {
                        throw new XMLConverterException(JeusMessage_Converter._6001, "db-pool-control/max");
                    }
                    pooling.setMax(Integer.valueOf(Integer.parseInt(max)));
                    String step = XMLUtil.getSubtreeValue(dbPoolControlTree, STEP);
                    if (step != null) {
                        pooling.setStep(Integer.valueOf(Integer.parseInt(step)));
                    }
                    if ((period = XMLUtil.getSubtreeValue(dbPoolControlTree, MAX_IDLE_TIME)) != null) {
                        pooling.setPeriod(Long.valueOf(Long.parseLong(period)));
                    }
                    connectionPool.setPooling(pooling);
                }
                if ((dbaConnectionTree = dbPoolConnectionTree.getFirstElement(DBA_CONNECTION)) != null) {
                    String maxActiveTime = XMLUtil.getSubtreeValue(dbPoolConnectionTree, MAX_ACTIVE_TIME);
                    if (maxActiveTime != null) {
                        connectionPool.setDbaTimeout(Integer.valueOf(Integer.parseInt(maxActiveTime)));
                    }
                    DatabaseType dbaDatabase = this.jeusMainFactory.createDatabaseType();
                    dbaDatabase.setExportName(name + "_DBA");
                    dbaDatabase.setDataSourceType(DataSourceTypeType.CONNECTION_POOL_DATA_SOURCE);
                    String connectonUrl2 = XMLUtil.getSubtreeValue(dbaConnectionTree, CONNECTION_URL);
                    this.parseConnectionUrl(connectonUrl2, dbaDatabase);
                    if (dbaDatabase.getVendor() == null) {
                        logger.log(JeusMessage_Converter._6505_LEVEL, JeusMessage_Converter._6505, (Object)database.getExportName());
                        dbaDatabase.setVendor(null);
                    }
                    if (dbaDatabase.getVendor() == VendorType.ORACLE) {
                        dbaDatabase.setDataSourceClassName("oracle.jdbc.pool.OracleConnectionPoolDataSource");
                    } else {
                        dbaDatabase.setDataSourceClassName("willDefine");
                        logger.log(JeusMessage_Converter._6505_LEVEL, JeusMessage_Converter._6505, (Object)database.getExportName());
                    }
                    String connectionArg2 = XMLUtil.getSubtreeValue(dbaConnectionTree, CONNECTION_ARGUMENT);
                    this.parseConnectionArgument(connectionArg2, encryption, dbaDatabase);
                    dataSource.getDatabase().add(dbaDatabase);
                    connectionPool.setDelegationDba(name + "_DBA");
                }
                database.setConnectionPool(connectionPool);
                dataSource.getDatabase().add(database);
            }
        }
    }

    private void parseConnectionArgument(String connectionArg, boolean encryption, DatabaseType database) throws XMLConverterException, JAXBException {
        if (connectionArg == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "db-connection-pool/connection-argument");
        }
        StringTokenizer st = new StringTokenizer(connectionArg, ";");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            int valueStart = propertyString.indexOf(61);
            if (valueStart < 0) {
                logger.log(JeusMessage_Converter._6506_LEVEL, JeusMessage_Converter._6506, new Object[]{CONNECTION_ARGUMENT, database.getExportName(), DB_CONNECTION_POOL});
                return;
            }
            String name = propertyString.substring(0, valueStart);
            String value = propertyString.substring(valueStart + 1);
            if (name.equalsIgnoreCase(USER)) {
                database.setUser(value);
                continue;
            }
            if (name.equalsIgnoreCase(PASSWORD)) {
                if (encryption) {
                    StringBuffer sf = new StringBuffer("{base64}");
                    sf.append(value);
                    database.setPassword(sf.toString());
                    continue;
                }
                database.setPassword(value);
                continue;
            }
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(name);
            property.setValue(value);
            property.setType("java.lang.String");
            database.getProperty().add(property);
        }
    }

    private void parseConnectionUrl(String connectonUrl, DatabaseType database) throws XMLConverterException {
        if (connectonUrl == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "db-connection-pool/connection-url");
        }
        StringTokenizer st = new StringTokenizer(connectonUrl, ":");
        int count = 0;
        while (st.hasMoreTokens()) {
            switch (++count) {
                case 1: {
                    st.nextToken();
                    break;
                }
                case 2: {
                    database.setVendor(VendorType.fromValue((String)st.nextToken()));
                    break;
                }
                case 3: {
                    database.setDriverType(st.nextToken());
                    break;
                }
                case 4: {
                    database.setServerName(st.nextToken().substring(1));
                    break;
                }
                case 5: {
                    database.setPortNumber(Long.valueOf(Long.parseLong(st.nextToken())));
                    break;
                }
                case 6: {
                    database.setDatabaseName(st.nextToken());
                }
            }
        }
    }

    private ExternalSourceType fillExternalSource(XMLTree extSourceTree) throws JAXBException, XMLConverterException {
        ExternalSourceType externalSource = this.jeusMainFactory.createExternalSourceType();
        Enumeration enum1 = extSourceTree.elements(IBMMQ);
        while (enum1.hasMoreElements()) {
            XMLTree ibmTree = (XMLTree)enum1.nextElement();
            externalSource.getJmsSource().add(this.subFillIBMMQ(ibmTree));
        }
        Enumeration enumMQ = extSourceTree.elements(SONIC_MQ);
        while (enumMQ.hasMoreElements()) {
            XMLTree sonicTree = (XMLTree)enumMQ.nextElement();
            externalSource.getJmsSource().add(this.subFillSONICMQ(sonicTree));
        }
        return externalSource;
    }

    private EngineCommandType subFillEngineCommand(XMLTree engineCommandTree, List engineCommandList, String nodeName, String containerName) throws JAXBException, XMLConverterException {
        XMLTree errorLogTree;
        XMLTree JMSMainTree;
        String name;
        EngineCommandType engineCommand = this.jeusMainFactory.createEngineCommandType();
        String type = XMLUtil.getSubtreeValue(engineCommandTree, TYPE);
        if (!ValidString.notEmptyString(type)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "engine-command/type");
        }
        String resultType = ValidString.restrictChoice("engine-command/type", type, "ejb", "servlet", "jms", "ws");
        if (resultType != null) {
            engineCommand.setType(EngineTypeType.valueOf((String)resultType));
        }
        if (!ValidString.notEmptyString(name = XMLUtil.getSubtreeValue(engineCommandTree, "name"))) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "engine-command/name");
        }
        String engineName = new String(type + "_" + name);
        if (engineCommandList.contains(engineName)) {
            throw new XMLConverterException(JeusMessage_Converter._6003, engineName);
        }
        engineCommand.setType(EngineTypeType.valueOf((String)type));
        engineCommand.setName(name);
        this.ECandEngine.put(nodeName + "_" + engineName, nodeName + "_" + containerName);
        if (type.equalsIgnoreCase("ejb")) {
            XMLTree systemLogTree;
            XMLTree EJBMainTree = this.findXmlTree(nodeName + "_" + engineName);
            if (EJBMainTree != null && (systemLogTree = EJBMainTree.getFirstElement(SYSTEM_LOG)) != null) {
                engineCommand.setSystemLogging(this.commonFillSystemLogging(systemLogTree));
            }
        } else if (type.equalsIgnoreCase("servlet")) {
            XMLTree errorLogTree2;
            XMLTree loggingTree;
            XMLTree CGTree;
            XMLTree WEBMainTree = this.findXmlTree(nodeName + "_" + engineName);
            if (WEBMainTree != null && (CGTree = WEBMainTree.getFirstElement(CONTEXT_GROUP)) != null && (loggingTree = CGTree.getFirstElement(LOGGING)) != null && (errorLogTree2 = loggingTree.getFirstElement(ERROR_LOG)) != null) {
                engineCommand.setSystemLogging(this.commonFillSystemLogging(errorLogTree2));
            }
        } else if (type.equalsIgnoreCase("jms") && (JMSMainTree = this.findXmlTree(nodeName + "_" + engineName)) != null && (errorLogTree = JMSMainTree.getFirstElement(ERROR_LOG)) != null) {
            engineCommand.setSystemLogging(this.commonFillSystemLogging(errorLogTree));
        }
        return engineCommand;
    }

    private TmConfigType subFillTmConfig(XMLTree tmConfigTree) throws JAXBException, XMLConverterException {
        Integer capacity;
        Long uncompleted;
        Long recovery;
        Long commit;
        Long prepared;
        Long prepare;
        Long active;
        TmConfigType tmConfig = this.jeusMainFactory.createTmConfigType();
        XMLTree tmPoolTree = tmConfigTree.getFirstElement(POOLING);
        if (tmPoolTree != null) {
            tmConfig.setPooling(this.commonFillPooling(tmPoolTree, "2", "30", "4", "2"));
        }
        if ((active = (Long)ValidString.getProperTypeFromString(tmConfigTree, TM_ACTIVE_TIMEOUT, 3, false, "600000")) != null) {
            tmConfig.setActiveTimeout(Long.valueOf(active));
        }
        if ((prepare = (Long)ValidString.getProperTypeFromString(tmConfigTree, TM_PREPARE_TIMEOUT, 3, false, "120000")) != null) {
            tmConfig.setPrepareTimeout(Long.valueOf(prepare));
        }
        if ((prepared = (Long)ValidString.getProperTypeFromString(tmConfigTree, TM_PREPARED_TIMEOUT, 3, false, "60000")) != null) {
            tmConfig.setPreparedTimeout(Long.valueOf(prepared));
        }
        if ((commit = (Long)ValidString.getProperTypeFromString(tmConfigTree, TM_COMMIT_TIMEOUT, 3, false, "240000")) != null) {
            tmConfig.setCommitTimeout(Long.valueOf(commit));
        }
        if ((recovery = (Long)ValidString.getProperTypeFromString(tmConfigTree, TM_RECOVERY_TIMEOUT, 3, false, "120000")) != null) {
            tmConfig.setRecoveryTimeout(Long.valueOf(recovery));
        }
        if ((uncompleted = (Long)ValidString.getProperTypeFromString(tmConfigTree, TM_UNCOMPLETED_TIMEOUT, 3, false, "86400000")) != null) {
            tmConfig.setUncompletedTimeout(Long.valueOf(uncompleted));
        }
        if ((capacity = (Integer)ValidString.getProperTypeFromString(tmConfigTree, TM_CAPACITY, 0, false, "10000")) != null) {
            tmConfig.setCapacity(Integer.valueOf(capacity));
        }
        return tmConfig;
    }

    private SystemLoggingType subFillUserLogging(XMLTree userNotifyTree) throws JAXBException, XMLConverterException {
        XMLTree userLogEmailTree;
        SystemLoggingType userLogging = this.jeusMainFactory.createSystemLoggingType();
        XMLTree userLogTree = userNotifyTree.getFirstElement(USER_LOG);
        HandlerType handler = this.jeusMainFactory.createHandlerType();
        if (userLogTree != null) {
            String target = XMLUtil.getSubtreeValueDefault(userLogTree, TARGET, STD_OUT);
            if (target.equalsIgnoreCase(STD_OUT)) {
                handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            } else if (target.equalsIgnoreCase(FILE)) {
                handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(userLogTree));
            } else if (target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("default:stdout") || target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("file:stdout")) {
                handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
                handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(userLogTree));
            } else {
                throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{"user-log/target", "stdout|file"});
            }
        }
        if ((userLogEmailTree = userNotifyTree.getFirstElement(EMAIL_NOTIFY)) != null) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillEmailNotify(userLogEmailTree));
        }
        userLogging.setHandler(handler);
        return userLogging;
    }

    private SmtpHandlerType commonFillEmailNotify(XMLTree userLogEmailTree) throws JAXBException, XMLConverterException {
        String bcc;
        SmtpHandlerType smtpHandler = this.jeusMainFactory.createSmtpHandlerType();
        smtpHandler.setName(EMAIL_NOTIFY);
        String smtp = XMLUtil.getSubtreeValue(userLogEmailTree, EMAIL_SMTP_ADDRESS);
        if (!ValidString.notEmptyString(smtp)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, EMAIL_SMTP_ADDRESS);
        }
        smtpHandler.setSmtpHostAddress(smtp);
        String from = XMLUtil.getSubtreeValue(userLogEmailTree, EMAIL_FROM_ADDRESS);
        if (!ValidString.notEmptyString(from)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, EMAIL_FROM_ADDRESS);
        }
        smtpHandler.setFromAddress(from);
        String to = XMLUtil.getSubtreeValue(userLogEmailTree, EMAIL_TO_ADDRESS);
        if (!ValidString.notEmptyString(to)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, EMAIL_TO_ADDRESS);
        }
        smtpHandler.setToAddress(to);
        String cc = XMLUtil.getSubtreeValue(userLogEmailTree, EMAIL_CC_ADDRESS);
        if (ValidString.notEmptyString(cc)) {
            smtpHandler.setCcAddress(cc);
        }
        if (ValidString.notEmptyString(bcc = XMLUtil.getSubtreeValue(userLogEmailTree, EMAIL_BCC_ADDRESS))) {
            smtpHandler.setBccAddress(bcc);
        }
        return smtpHandler;
    }

    private void subFillLifeCycleInvocation(EngineContainerType engineContainer, String engineContainerName) throws XMLConverterException, JAXBException {
        XMLTree ejbXMLTree = this.findXMLTrees(engineContainerName, "ejb");
        XMLTree servletTree = this.findXMLTrees(engineContainerName, "servlet");
        if (ejbXMLTree != null) {
            this.hypoSubFillLifeCycleInvocation(ejbXMLTree, engineContainer);
        }
        if (servletTree != null) {
            this.hypoSubFillLifeCycleInvocation(servletTree, engineContainer);
        }
    }

    private void hypoSubFillLifeCycleInvocation(XMLTree xmlTree, EngineContainerType engineContainer) throws JAXBException, XMLConverterException {
        Enumeration startClasses = xmlTree.elements(STARTUP_CLASS);
        while (startClasses.hasMoreElements()) {
            LifecycleInvocationType lifecycleInvocation = this.commonFillStartupOrShutdownClass(STARTUP_CLASS, startClasses, xmlTree);
            engineContainer.getLifecycleInvocation().add(lifecycleInvocation);
        }
        Enumeration shutdownClasses = xmlTree.elements(SHUTDOWN_CLASS);
        while (shutdownClasses.hasMoreElements()) {
            LifecycleInvocationType lifecycleInvocation = this.commonFillStartupOrShutdownClass(SHUTDOWN_CLASS, shutdownClasses, xmlTree);
            engineContainer.getLifecycleInvocation().add(lifecycleInvocation);
        }
    }

    private LifecycleInvocationType commonFillStartupOrShutdownClass(String type, Enumeration startClasses, XMLTree ejbXMLTree) throws JAXBException, XMLConverterException {
        Boolean startupPreinvoke;
        String startupParameter;
        String INVOCATION_TYPE_FALSE;
        String INVOCATION_TYPE_TRUE;
        if (type.equals(STARTUP_CLASS)) {
            INVOCATION_TYPE_TRUE = "BEFORE_INVOCATION";
            INVOCATION_TYPE_FALSE = "AFTER_INVOCATION";
        } else {
            INVOCATION_TYPE_TRUE = "AFTER_UNDEPLOY";
            INVOCATION_TYPE_FALSE = "BEFORE_UNDEPLOY";
        }
        LifecycleInvocationType lifecycleInvocation = this.jeusMainFactory.createLifecycleInvocationType();
        XMLTree startupTree = (XMLTree)startClasses.nextElement();
        InvocationType invocation = this.jeusMainFactory.createInvocationType();
        String startupMethod = XMLUtil.getSubtreeValue(startupTree, METHOD);
        if (ValidString.notEmptyString(startupMethod)) {
            Vector classAndMethod = this.parseFullMethodtoClassAndMethodAndParms(startupMethod);
            lifecycleInvocation.setClassName((String)classAndMethod.get(0));
            MethodParamType invocationMethod = this.jeusMainFactory.createMethodParamType();
            invocationMethod.setMethodName((String)classAndMethod.get(1));
            int numOfParams = classAndMethod.size() - 2;
            if (numOfParams > 0) {
                MethodParamsType methodParams = this.jeusMainFactory.createMethodParamsType();
                for (int i = 0; i < numOfParams; ++i) {
                    methodParams.getMethodParam().add((String)classAndMethod.get(i + 2));
                }
                invocationMethod.setMethodParams(methodParams);
            }
            invocation.setInvocationMethod(invocationMethod);
        }
        if (ValidString.notEmptyString(startupParameter = XMLUtil.getSubtreeValue(startupTree, PARAMETER))) {
            Vector parameters = this.parseParameters(startupParameter);
            for (int i = 0; i < parameters.size(); ++i) {
                String param = (String)parameters.elementAt(i);
                invocation.getInvocationArgument().add(param);
            }
        }
        if ((startupPreinvoke = (Boolean)ValidString.getProperTypeFromString(ejbXMLTree, STARTUP_PREINVOKE, 2, false, "false")).booleanValue()) {
            invocation.setInvocationType(InvocationTypeType.valueOf((String)INVOCATION_TYPE_TRUE));
        } else {
            invocation.setInvocationType(InvocationTypeType.valueOf((String)INVOCATION_TYPE_FALSE));
        }
        lifecycleInvocation.getInvocation().add(invocation);
        return lifecycleInvocation;
    }

    private Vector parseFullMethodtoClassAndMethodAndParms(String startupMethod) {
        Vector<String> classAndMethodAndParams = new Vector<String>();
        int index1 = startupMethod.indexOf("::");
        classAndMethodAndParams.add(startupMethod.substring(0, index1));
        int index2 = startupMethod.indexOf("(", index1 + 1);
        classAndMethodAndParams.add(startupMethod.substring(index1 + 2, index2));
        int index3 = startupMethod.indexOf(",", index2 + 1);
        int index4 = startupMethod.indexOf(")", index2 + 1);
        if (index3 == -1) {
            if (index2 + 1 < index4) {
                classAndMethodAndParams.add(startupMethod.substring(index2 + 1, index4));
            }
            return classAndMethodAndParams;
        }
        int temp = index2;
        while (index3 != -1) {
            classAndMethodAndParams.add(startupMethod.substring(temp + 1, index3));
            temp = index3;
            index3 = startupMethod.indexOf(",", temp + 1);
        }
        classAndMethodAndParams.add(startupMethod.substring(temp + 1, index4));
        return classAndMethodAndParams;
    }

    private Vector parseParameters(String parameters) {
        Vector<String> paramVector = new Vector<String>();
        int index = parameters.indexOf(",");
        if (index == -1) {
            paramVector.add(parameters);
            return paramVector;
        }
        int temp = 0;
        while (index != -1) {
            paramVector.add(parameters.substring(temp, index));
            temp = index + 1;
            index = parameters.indexOf(",", temp);
        }
        paramVector.add(parameters.substring(temp));
        return paramVector;
    }

    private DatabaseType subFillDatebase(XMLTree databaseTree) throws JAXBException, XMLConverterException {
        XMLTree connectionPoolTree;
        String driverType;
        String user;
        String serverName;
        Long portNum;
        String networkProtocol;
        String description;
        String serviceName;
        String dataSourceName;
        String exportName;
        DatabaseType database = this.jeusMainFactory.createDatabaseType();
        String vendor = XMLUtil.getSubtreeValue(databaseTree, VENDOR);
        if (!ValidString.notEmptyString(vendor)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "database/vendor");
        }
        String resultVendor = ValidString.restrictChoice("database/vendor", vendor, "oracle", "sybase", "mssql", "db2", "others");
        if (resultVendor != null) {
            database.setVendor(VendorType.valueOf((String)resultVendor));
        }
        if (!ValidString.notEmptyString(exportName = XMLUtil.getSubtreeValue(databaseTree, EXPORT_NAME))) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "database/export-name");
        }
        database.setExportName(exportName);
        String dataSourceClassName = XMLUtil.getSubtreeValue(databaseTree, DATA_SOURCE_CLASS_NAME);
        if (!ValidString.notEmptyString(dataSourceClassName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "database/data-source-class-name");
        }
        database.setDataSourceClassName(dataSourceClassName);
        String dataSourceType = XMLUtil.getSubtreeValue(databaseTree, DATA_SOURCE_TYPE);
        if (!ValidString.notEmptyString(dataSourceType)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "database/data-source-type");
        }
        database.setDataSourceType(DataSourceTypeType.valueOf((String)dataSourceType));
        String databaseName = XMLUtil.getSubtreeValue(databaseTree, DATABASE_NAME);
        if (ValidString.notEmptyString(databaseName)) {
            database.setDatabaseName(databaseName);
        }
        if (ValidString.notEmptyString(dataSourceName = XMLUtil.getSubtreeValue(databaseTree, DATA_SOURCE_NAME))) {
            database.setDataSourceName(dataSourceName);
        }
        if ((serviceName = XMLUtil.getSubtreeValue(databaseTree, SERVICE_NAME)) != null) {
            database.setServiceName(serviceName);
        }
        if (ValidString.notEmptyString(description = XMLUtil.getSubtreeValue(databaseTree, DESCRIPTION))) {
            database.setDescription(description);
        }
        if (ValidString.notEmptyString(networkProtocol = XMLUtil.getSubtreeValue(databaseTree, NETWORK_PROTOCOL))) {
            database.setNetworkProtocol(networkProtocol);
        }
        String resultAlgorithm = null;
        Boolean encryption = (Boolean)ValidString.getProperTypeFromString(databaseTree, ENCRYPTION, 2, false, "false");
        if (encryption == null) {
            resultAlgorithm = CIPHER_PLAIN;
        } else if (encryption.booleanValue()) {
            String algorithm = XMLUtil.getSubtreeValueDefault(databaseTree, CIPHER_ALGORITHM, CIPHER_BASE64);
            resultAlgorithm = ValidString.restrictChoice(CIPHER_ALGORITHM, algorithm, CIPHER_BASE64, CIPHER_3DES);
        } else {
            resultAlgorithm = CIPHER_PLAIN;
        }
        String password = XMLUtil.getSubtreeValue(databaseTree, PASSWORD);
        if (ValidString.notEmptyString(password)) {
            String finalPassword = password;
            if (resultAlgorithm.equalsIgnoreCase(CIPHER_BASE64)) {
                finalPassword = Base64Coder.decode(password);
            } else if (resultAlgorithm.equalsIgnoreCase(CIPHER_3DES) || resultAlgorithm.equalsIgnoreCase(CIPHER_DES)) {
                if (EncryptionUtil.isCreated()) {
                    EncryptionUtil.setSecretKeyDir(XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + "security");
                } else {
                    EncryptionUtil.init(XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + "security");
                }
                resultAlgorithm = CIPHER_DES;
                finalPassword = EncryptionUtil.decryptPassword(resultAlgorithm, password);
                if (finalPassword == null) {
                    resultAlgorithm = CIPHER_PLAIN;
                    finalPassword = password;
                }
            }
            EncryptionUtil.setSecretKeyDir(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security");
            if (resultAlgorithm.equals(CIPHER_PLAIN)) {
                database.setPassword(EncryptionUtil.encryptPassword(null, finalPassword));
            } else {
                database.setPassword("{" + resultAlgorithm + "}" + EncryptionUtil.encryptPasswordForConverter(resultAlgorithm, finalPassword, JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security"));
            }
        }
        if ((portNum = (Long)ValidString.getProperTypeFromString(databaseTree, PORT_NUMBER, 3, false, null)) != null) {
            database.setPortNumber(Long.valueOf(portNum));
        }
        if (ValidString.notEmptyString(serverName = XMLUtil.getSubtreeValue(databaseTree, SERVER_NAME))) {
            database.setServerName(serverName);
        }
        if (ValidString.notEmptyString(user = XMLUtil.getSubtreeValue(databaseTree, USER))) {
            database.setUser(user);
        }
        if (ValidString.notEmptyString(driverType = XMLUtil.getSubtreeValue(databaseTree, DRIVER_TYPE))) {
            database.setDriverType(driverType);
        }
        if ((connectionPoolTree = databaseTree.getFirstElement(CONNECTION_POOL)) != null) {
            XMLTree waitFreeConnectionTree;
            DatabaseConnectionPoolType connectionPool = this.jeusMainFactory.createDatabaseConnectionPoolType();
            XMLTree poolingTree = connectionPoolTree.getFirstElement(POOLING);
            if (poolingTree != null) {
                connectionPool.setPooling(this.commonFillPooling1(poolingTree, "2", "30", "4", "2"));
            }
            if ((waitFreeConnectionTree = connectionPoolTree.getFirstElement(WAIT_FREE_CONNECTION)) != null) {
                connectionPool.setWaitFreeConnection(this.commonFillwaitTreeConnection(waitFreeConnectionTree));
            }
            database.setConnectionPool(connectionPool);
        }
        Enumeration properties = databaseTree.elements(PROPERTY);
        while (properties.hasMoreElements()) {
            XMLTree propertyTree = (XMLTree)properties.nextElement();
            String name = XMLUtil.getSubtreeValue(propertyTree, "name");
            String value = XMLUtil.getSubtreeValue(propertyTree, VALUE);
            String type = XMLUtil.getSubtreeValue(propertyTree, TYPE);
            if (!ValidString.notEmptyString(name) || !ValidString.notEmptyString(value)) continue;
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(name);
            property.setValue(value);
            property.setType(type);
            database.getProperty().add(property);
        }
        return database;
    }

    private WaitFreeConnectionType commonFillwaitTreeConnection(XMLTree waitFreeConnectionTree) throws JAXBException, XMLConverterException {
        Long waitTime;
        WaitFreeConnectionType waitFreeConnection = this.jeusMainFactory.createWaitFreeConnectionType();
        Boolean enableWait = (Boolean)ValidString.getProperTypeFromString(waitFreeConnectionTree, ENABLE_WAIT, 2, false, "false");
        if (enableWait != null) {
            waitFreeConnection.setEnableWait(Boolean.valueOf(enableWait));
        }
        if ((waitTime = (Long)ValidString.getProperTypeFromString(waitFreeConnectionTree, WAIT_TIME, 3, false, "10000")) != null) {
            waitFreeConnection.setWaitTime(Long.valueOf(waitTime));
        }
        return waitFreeConnection;
    }

    private MailEntryType subFillMailEntry(XMLTree mailTree) throws JAXBException, XMLConverterException {
        MailEntryType mailEntry = this.jeusMainFactory.createMailEntryType();
        String exportName = XMLUtil.getSubtreeValue(mailTree, EXPORT_NAME);
        if (!ValidString.notEmptyString(exportName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "mail-entry/export-name");
        }
        mailEntry.setExportName(exportName);
        Enumeration enum2 = mailTree.elements(MAIL_PROPERTY);
        while (enum2.hasMoreElements()) {
            XMLTree propertyTree = (XMLTree)enum2.nextElement();
            MailPropertyType mailProperty = this.jeusMainFactory.createMailPropertyType();
            String propertyName = XMLUtil.getSubtreeValue(propertyTree, "name");
            if (!ValidString.notEmptyString(propertyName)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "mail-property/name");
            }
            mailProperty.setName(propertyName);
            String propertyValue = XMLUtil.getSubtreeValue(propertyTree, VALUE);
            if (!ValidString.notEmptyString(propertyValue)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "mail-property/value");
            }
            mailProperty.setValue(propertyValue);
            mailEntry.getMailProperty().add(mailProperty);
        }
        return mailEntry;
    }

    private JmsSourceType subFillIBMMQ(XMLTree ibmmqTree) throws JAXBException, XMLConverterException {
        JmsSourceType jmsSource = this.jeusMainFactory.createJmsSourceType();
        jmsSource.setVendor(JmsVendorType.IBMMQ);
        jmsSource.setFactoryClassName("undefined");
        System.out.println(" ====> you should set ibm mq factory class name by yourself");
        XMLTree QCFTree = ibmmqTree.getFirstElement(TYPE_QCF);
        XMLTree TCFTree = ibmmqTree.getFirstElement(TYPE_TCF);
        XMLTree QTree = ibmmqTree.getFirstElement(TYPE_Q);
        XMLTree TTree = ibmmqTree.getFirstElement(TYPE_T);
        XMLTree XAQCFTree = ibmmqTree.getFirstElement(TYPE_XAQCF);
        XMLTree XATCFTree = ibmmqTree.getFirstElement(TYPE_XATCF);
        XMLTree LOCALXAQCFTree = ibmmqTree.getFirstElement(TYPE_LOCALXAQCF);
        XMLTree LOCALXATCFTree = ibmmqTree.getFirstElement(TYPE_LOCALXATCF);
        if (QCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.QCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (TCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.TCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (QTree != null) {
            jmsSource.setResourceType(TypeResourceType.Q);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (TTree != null) {
            jmsSource.setResourceType(TypeResourceType.T);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (XAQCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.XAQCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (XATCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.XATCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (LOCALXAQCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.LOCALXAQCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (LOCALXATCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.LOCALXATCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        return jmsSource;
    }

    private JmsSourceType subFillSONICMQ(XMLTree sonicTree) throws JAXBException, XMLConverterException {
        JmsSourceType jmsSource = this.jeusMainFactory.createJmsSourceType();
        jmsSource.setVendor(JmsVendorType.SONICMQ);
        jmsSource.setFactoryClassName("undefined");
        System.out.println(" ====> you should set sonic mq factory class name by yourself");
        XMLTree QCFTree = sonicTree.getFirstElement(TYPE_QCF_SONIC);
        XMLTree TCFTree = sonicTree.getFirstElement(TYPE_TCF_SONIC);
        XMLTree QTree = sonicTree.getFirstElement(TYPE_Q_SONIC);
        XMLTree TTree = sonicTree.getFirstElement(TYPE_T_SONIC);
        XMLTree XAQCFTree = sonicTree.getFirstElement(TYPE_XAQCF_SONIC);
        XMLTree XATCFTree = sonicTree.getFirstElement(TYPE_XATCF_SONIC);
        XMLTree LOCALXAQCFTree = sonicTree.getFirstElement(TYPE_LOCALXAQCF_SONIC);
        XMLTree LOCALXATCFTree = sonicTree.getFirstElement(TYPE_LOCALXATCF_SONIC);
        if (QCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.QCF);
            this.hypoSubFillSONIC(QCFTree, jmsSource);
        }
        if (TCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.TCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (QTree != null) {
            jmsSource.setResourceType(TypeResourceType.Q);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (TTree != null) {
            jmsSource.setResourceType(TypeResourceType.T);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (XAQCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.XAQCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (XATCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.XATCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (LOCALXAQCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.LOCALXAQCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        if (LOCALXATCFTree != null) {
            jmsSource.setResourceType(TypeResourceType.LOCALXATCF);
            this.hypoSubFillIBM(QCFTree, jmsSource);
        }
        return jmsSource;
    }

    private void hypoSubFillIBM(XMLTree xmlTree, JmsSourceType jmsSource) throws XMLConverterException, JAXBException {
        String exportName = XMLUtil.getSubtreeValue(xmlTree, EXPORT_NAME);
        if (!ValidString.notEmptyString(exportName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "IBMMQ/export-name");
        }
        jmsSource.setExportName(exportName);
        String qManager = XMLUtil.getSubtreeValue(xmlTree, QMANAGER);
        if (ValidString.notEmptyString(qManager)) {
            jmsSource.setQueueManager(qManager);
        } else if (!jmsSource.getResourceType().equals((Object)"T")) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "IBMMQ/qmanager");
        }
        this.setStringProperty(xmlTree, DESCRIPTION, jmsSource);
        this.setIntergerProperty(xmlTree, TRANSPORT, jmsSource);
        this.setStringProperty(xmlTree, "client-id", jmsSource);
        this.setIntergerProperty(xmlTree, PORT, jmsSource);
        this.setStringProperty(xmlTree, HOST_NAME, jmsSource);
        this.setStringProperty(xmlTree, CHANNEL, jmsSource);
        this.setIntergerProperty(xmlTree, CCSID, jmsSource);
        this.setStringProperty(xmlTree, REC_EXIT, jmsSource);
        this.setStringProperty(xmlTree, REC_EXIT_INIT, jmsSource);
        this.setStringProperty(xmlTree, SEC_EXIT, jmsSource);
        this.setStringProperty(xmlTree, SEC_EXIT_INIT, jmsSource);
        this.setStringProperty(xmlTree, SEND_EXIT, jmsSource);
        this.setStringProperty(xmlTree, SEND_EXIT_INIT, jmsSource);
        this.setStringProperty(xmlTree, TEMP_MODEL, jmsSource);
        this.setIntergerProperty(xmlTree, MSG_RETENTION, jmsSource);
        this.setStringProperty(xmlTree, BROKER_PUB_Q, jmsSource);
        this.setStringProperty(xmlTree, BROKER_SUB_Q, jmsSource);
        this.setStringProperty(xmlTree, BROKER_CC_SUB_Q, jmsSource);
        this.setStringProperty(xmlTree, BROKER_Q_MGR, jmsSource);
        this.setStringProperty(xmlTree, BROKER_CON_Q, jmsSource);
        String value = XMLUtil.getSubtreeValue(xmlTree, QUEUE);
        if (ValidString.notEmptyString(value)) {
            jmsSource.setQueue(value);
        } else if (jmsSource.getResourceType().equals((Object)"Q")) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "IBMMQ/queue");
        }
        this.setLongProperty(xmlTree, EXPIRY, jmsSource);
        this.setIntergerProperty(xmlTree, PRIORITY, jmsSource);
        this.setIntergerProperty(xmlTree, PERSISTENCE, jmsSource);
        this.setIntergerProperty(xmlTree, TARG_CLIENT, jmsSource);
        this.setIntergerProperty(xmlTree, ENCODING, jmsSource);
        value = XMLUtil.getSubtreeValue(xmlTree, TOPIC);
        if (ValidString.notEmptyString(value)) {
            jmsSource.setTopic(value);
        } else if (jmsSource.getResourceType().equals((Object)"T")) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "IBMMQ/topic");
        }
        this.setStringProperty(xmlTree, BROKER_DUR_SUB_Q, jmsSource);
        this.setStringProperty(xmlTree, BROKER_DUR_SUB_Q, jmsSource);
    }

    private void setStringProperty(XMLTree xmlTree, String name, JmsSourceType jmsSource) throws JAXBException {
        String value = XMLUtil.getSubtreeValue(xmlTree, name);
        if (ValidString.notEmptyString(value)) {
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(this.convertName(name));
            property.setType("java.lang.String");
            property.setValue(value);
            jmsSource.getProperty().add(property);
        }
    }

    private void setLongProperty(XMLTree xmlTree, String name, JmsSourceType jmsSource) throws JAXBException {
        String value = XMLUtil.getSubtreeValue(xmlTree, name);
        if (ValidString.notEmptyString(value)) {
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(this.convertName(name));
            property.setType("java.lang.Long");
            property.setValue(JeusMainJaxbConverter.getLongValue(value));
            jmsSource.getProperty().add(property);
        }
    }

    private void setIntergerProperty(XMLTree xmlTree, String name, JmsSourceType jmsSource) throws JAXBException, XMLConverterException {
        String value = XMLUtil.getSubtreeValue(xmlTree, name);
        if (ValidString.notEmptyString(value)) {
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(this.convertName(name));
            property.setType("java.lang.Integer");
            if (name.equals(ENCODING)) {
                property.setValue(JeusMainJaxbConverter.getEncoding(value));
            } else {
                try {
                    property.setValue(JeusMainJaxbConverter.getIntValue(value));
                }
                catch (NumberFormatException e) {
                    throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{name, "integer"});
                }
            }
            jmsSource.getProperty().add(property);
        }
    }

    private void setBooleanProperty(XMLTree xmlTree, String name, JmsSourceType jmsSource) throws JAXBException {
        String value = XMLUtil.getSubtreeValue(xmlTree, name);
        if (ValidString.notEmptyString(value)) {
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(this.convertName(name));
            property.setType("java.lang.Boolean");
            property.setValue(String.valueOf(Boolean.getBoolean(value)));
            jmsSource.getProperty().add(property);
        }
    }

    private String convertName(String s1) {
        String s2 = new String();
        if (s1.equals(CONNECT_URL)) {
            return "ConnectionURLs";
        }
        if (s1.equals(SELECTOR_AT_BROKER)) {
            return "SelectorAtBroker";
        }
        if (s1.equals(QMANAGER)) {
            return "QueueManager";
        }
        if (s1.equals(TRANSPORT)) {
            return "TransportType";
        }
        if (s1.equals(CCSID)) {
            return "CCSID";
        }
        if (s1.equals(REC_EXIT)) {
            return "RecieveExit";
        }
        if (s1.equals(REC_EXIT_INIT)) {
            return "RecieveExitInit";
        }
        if (s1.equals(SEC_EXIT)) {
            return "SecurityExit";
        }
        if (s1.equals(SEC_EXIT_INIT)) {
            return "SecurityExitInit";
        }
        if (s1.equals(TEMP_MODEL)) {
            return "TemporaryModel";
        }
        if (s1.equals(MSG_RETENTION)) {
            return "MessageRetention";
        }
        if (s1.equals(BROKER_PUB_Q)) {
            return "BrokerPubQueue";
        }
        if (s1.equals(BROKER_SUB_Q)) {
            return "BrokerSubQueue";
        }
        if (s1.equals(BROKER_CC_SUB_Q)) {
            return "BrokerCCPubQueue";
        }
        if (s1.equals(BROKER_Q_MGR)) {
            return "BrokerQueueManager";
        }
        if (s1.equals(BROKER_CON_Q)) {
            return "BrokerControlQueue";
        }
        if (s1.equals(TARG_CLIENT)) {
            return "TargetClient";
        }
        if (s1.equals(BROKER_DUR_SUB_Q)) {
            return "BrokerDurSubQueue";
        }
        if (s1.equals(BROKER_CCD_SUB_Q)) {
            return "BrokerCCDSubQueue";
        }
        s2 = s1.substring(0, 1).toUpperCase() + s1.substring(1);
        int index = s2.indexOf(45);
        while (index > -1) {
            s2 = s2.substring(0, index) + s2.substring(index + 1, index + 2).toUpperCase() + s2.substring(index + 2);
            index = s2.indexOf(45);
        }
        return s2;
    }

    public static String getIntValue(String s) throws NumberFormatException {
        int value = s.equalsIgnoreCase(APP) ? -2 : (s.equalsIgnoreCase(QDEF) ? -1 : (s.equalsIgnoreCase(BIND) || s.equalsIgnoreCase(JMS) || s.equalsIgnoreCase(NO) ? 0 : (s.equalsIgnoreCase(CLIENT) || s.equalsIgnoreCase(NON) || s.equalsIgnoreCase(MQ) || s.equalsIgnoreCase(YES) ? 1 : (s.equalsIgnoreCase(PERS) ? 2 : Integer.parseInt(s)))));
        return String.valueOf(value);
    }

    public static String getEncoding(String s) {
        int i = 0;
        if (s.equalsIgnoreCase(NATIVE)) {
            return String.valueOf(273);
        }
        i = s.charAt(0) == 'N' ? (i |= 1) : (i |= 2);
        i = s.charAt(1) == 'N' ? (i |= 0x10) : (i |= 0x20);
        i = s.charAt(2) == 'N' ? (i |= 0x100) : (s.charAt(2) == 'R' ? (i |= 0x200) : (i |= 0x300));
        return String.valueOf(i);
    }

    public static String getLongValue(String s) {
        long value = s.equalsIgnoreCase(APP) ? -2L : (s.equalsIgnoreCase(UNLIM) ? 0L : Long.parseLong(s));
        return String.valueOf(value);
    }

    private void hypoSubFillSONIC(XMLTree xmlTree, JmsSourceType jmsSource) throws XMLConverterException, JAXBException {
        String exportName = XMLUtil.getSubtreeValue(xmlTree, EXPORT_NAME);
        if (!ValidString.notEmptyString(exportName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "SONICMQ/export-name");
        }
        jmsSource.setExportName(exportName);
        String queue = XMLUtil.getSubtreeValue(xmlTree, QUEUE);
        if (ValidString.notEmptyString(queue)) {
            jmsSource.setQueue(queue);
        } else if (jmsSource.getResourceType().equals((Object)"Q")) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "SONICMQ/queue");
        }
        String topic = XMLUtil.getSubtreeValue(xmlTree, TOPIC);
        if (ValidString.notEmptyString(topic)) {
            jmsSource.setTopic(topic);
        } else if (jmsSource.getResourceType().equals((Object)"T")) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "SONICMQ/topic");
        }
        this.setIntergerProperty(xmlTree, PREFETCH_COUNT, jmsSource);
        this.setIntergerProperty(xmlTree, PREFETCH_THRESHOLD, jmsSource);
        String brokerHostName = XMLUtil.getSubtreeValue(xmlTree, BROKER_HOST_NAME);
        Long brokerPort = (Long)ValidString.getProperTypeFromString(xmlTree, BROKER_PORT, 3, false, null);
        String brokerProtocol = XMLUtil.getSubtreeValue(xmlTree, BROKER_PROTOCOL);
        if (ValidString.notEmptyString(brokerHostName) && brokerPort != null && ValidString.notEmptyString(brokerProtocol)) {
            TypePropertyType property = this.jeusMainFactory.createTypePropertyType();
            property.setName(this.convertName(BROKER_URL));
            property.setType("java.lang.String");
            property.setValue(brokerProtocol + "://" + brokerHostName + ":" + brokerPort);
            jmsSource.getProperty().add(property);
        }
        this.setStringProperty(xmlTree, "client-id", jmsSource);
        this.setStringProperty(xmlTree, "client-id", jmsSource);
        this.setStringProperty(xmlTree, CONNECT_URL, jmsSource);
        this.setStringProperty(xmlTree, DEFAULT_PASSWORD, jmsSource);
        this.setStringProperty(xmlTree, DEFAULT_USER, jmsSource);
        this.setBooleanProperty(xmlTree, LOAD_BALANCING, jmsSource);
        this.setIntergerProperty(xmlTree, MONITORING_INTERVAL, jmsSource);
        this.setBooleanProperty(xmlTree, PERSISTENT_DELIVERY, jmsSource);
        this.setBooleanProperty(xmlTree, SEQUENTIAL, jmsSource);
        this.setBooleanProperty(xmlTree, SELECTOR_AT_BROKER, jmsSource);
    }

    private JmxManagerType commonFillJmxManager(XMLTree jmxTree) throws JAXBException, XMLConverterException {
        Integer snmpAdaptorPort;
        JmxManagerType jmxManager = this.jeusMainFactory.createJmxManagerType();
        Integer htmlAdaptorPort = (Integer)ValidString.getProperTypeFromString(jmxTree, HTML_ADAPTOR_PORT, 0, false, "-1");
        if (htmlAdaptorPort != null) {
            jmxManager.setHtmlAdaptorPort(Integer.valueOf(htmlAdaptorPort));
        }
        XMLTree snmpAdatorTree = jmxTree.getFirstElement(SNMP_ADAPTOR);
        if (jmxTree != null && (snmpAdaptorPort = (Integer)ValidString.getProperTypeFromString(snmpAdatorTree, SNMP_ADAPTOR_PORT, 0, false, "-1")) != null && snmpAdaptorPort >= 1) {
            Boolean snmpSecurity;
            Integer snmpMaxPacketSize;
            SnmpAdaptorType snmpAdaptor = this.jeusMainFactory.createSnmpAdaptorType();
            snmpAdaptor.setSnmpAdaptorPort(snmpAdaptorPort.intValue());
            Integer snmpVersion = (Integer)ValidString.getProperTypeFromString(snmpAdatorTree, SNMP_VERSION, 0, false, "3");
            if (snmpVersion != null) {
                snmpAdaptor.setSnmpVersion(Integer.valueOf(snmpVersion));
            }
            if ((snmpMaxPacketSize = (Integer)ValidString.getProperTypeFromString(snmpAdatorTree, SNMP_MAX_PACKET_SIZE, 0, false, DEFAULT_BUFFER_SIZE)) != null) {
                snmpAdaptor.setSnmpMaxPacketSize(Integer.valueOf(snmpMaxPacketSize));
            }
            if ((snmpSecurity = (Boolean)ValidString.getProperTypeFromString(snmpAdatorTree, SNMP_SECURITY, 2, false, "false")) != null) {
                snmpAdaptor.setSnmpSecurity(Boolean.valueOf(snmpSecurity));
            }
            jmxManager.setSnmpAdaptor(snmpAdaptor);
        }
        Enumeration mletURLs = jmxTree.elements(MLET_URL);
        while (mletURLs.hasMoreElements()) {
            XMLTree mletTree = (XMLTree)mletURLs.nextElement();
            jmxManager.getMletUrl().add(mletTree.getValue());
        }
        return jmxManager;
    }

    private DeploymentTargetType commonFillDeployTarget(String type, XMLTree xmlTree) throws JAXBException {
        Enumeration deployTargets = xmlTree.elements(DEPLOY_TARGET);
        DeploymentTargetType deploymentTarget = this.jeusMainFactory.createDeploymentTargetType();
        if (deployTargets.hasMoreElements()) {
            while (deployTargets.hasMoreElements()) {
                XMLTree deployTargetTree = (XMLTree)deployTargets.nextElement();
                AppTargetType target = this.jeusMainFactory.createAppTargetType();
                String engineContainerName = XMLUtil.getSubtreeValue(deployTargetTree, ENGINE_CONTAINER);
                if (ValidString.notEmptyString(engineContainerName)) {
                    target.setEngineContainerName(engineContainerName);
                } else {
                    String nodeName = XMLUtil.getSubtreeValue(deployTargetTree, NODE_NAME);
                    if (ValidString.notEmptyString(nodeName)) {
                        target.setNodeName(nodeName);
                    }
                }
                String contextGroupName = XMLUtil.getSubtreeValue(deployTargetTree, CONTEXT_GROUP_NAME);
                if (ValidString.notEmptyString(contextGroupName)) {
                    WebContextGroupType webContextGroupType = this.jeusMainFactory.createWebContextGroupType();
                    webContextGroupType.setName(contextGroupName);
                    target.setWebContextGroup(webContextGroupType);
                }
                deploymentTarget.getAllTargetsOrTarget().add(target);
            }
        } else if (type.equals("ear")) {
            boolean ExistejbModuleTarget = false;
            Enumeration ejbModules = xmlTree.elements(EJB_MODULE);
            while (ejbModules.hasMoreElements()) {
                XMLTree ejbModuleTree = (XMLTree)ejbModules.nextElement();
                Enumeration ejbDeployTargets = ejbModuleTree.elements(DEPLOY_TARGET);
                if (!ejbDeployTargets.hasMoreElements()) continue;
                ExistejbModuleTarget = true;
            }
            boolean ExistwebModuleTarget = false;
            Enumeration webModules = xmlTree.elements(WAR_MODULE);
            while (webModules.hasMoreElements()) {
                XMLTree webModuleTree = (XMLTree)webModules.nextElement();
                Enumeration webDeployTargets = webModuleTree.elements(DEPLOY_TARGET);
                if (!webDeployTargets.hasMoreElements()) continue;
                ExistwebModuleTarget = true;
            }
            if (!ExistejbModuleTarget && !ExistwebModuleTarget) {
                AllTargetsType allTargets = this.jeusMainFactory.createAllTargetsType();
                deploymentTarget.getAllTargetsOrTarget().add(allTargets);
            }
        } else {
            return null;
        }
        return deploymentTarget;
    }

    private SystemLoggingType commonFillSystemLogging(XMLTree systemLog, XMLTree emailNotify) throws JAXBException, XMLConverterException {
        SystemLoggingType systemLogging = this.jeusMainFactory.createSystemLoggingType();
        String level = XMLUtil.getSubtreeValueDefault(systemLog, LEVEL, FATAL);
        String resultLevel = ValidString.restrictChoice("system-log/level", level, FATAL, NOTICE, INFORMATION, DEBUG);
        if (resultLevel != null) {
            systemLogging.setLevel(LoggingLevelType.valueOf((String)resultLevel));
        }
        HandlerType handler = this.jeusMainFactory.createHandlerType();
        String target = XMLUtil.getSubtreeValueDefault(systemLog, TARGET, STD_OUT);
        if (target.equalsIgnoreCase(STD_OUT)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            systemLogging.setHandler(handler);
        } else if (target.equalsIgnoreCase(FILE)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(systemLog));
            systemLogging.setHandler(handler);
        } else if (target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("default:stdout") || target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("file:stdout")) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(systemLog));
            systemLogging.setHandler(handler);
        } else {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{TARGET, "stdout|file"});
        }
        if (emailNotify != null) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillEmailNotify(emailNotify));
        }
        systemLogging.setHandler(handler);
        return systemLogging;
    }

    private SystemLoggingType commonFillSystemLogging(XMLTree systemLog) throws JAXBException, XMLConverterException {
        SystemLoggingType systemLogging = this.jeusMainFactory.createSystemLoggingType();
        String level = XMLUtil.getSubtreeValueDefault(systemLog, LEVEL, FATAL);
        String resultLevel = ValidString.restrictChoice("system-log/level", level, FATAL, NOTICE, INFORMATION, DEBUG);
        if (resultLevel != null) {
            systemLogging.setLevel(LoggingLevelType.valueOf((String)resultLevel));
        }
        HandlerType handler = this.jeusMainFactory.createHandlerType();
        String target = XMLUtil.getSubtreeValueDefault(systemLog, TARGET, STD_OUT);
        if (target.equalsIgnoreCase(STD_OUT)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            systemLogging.setHandler(handler);
        } else if (target.equalsIgnoreCase(FILE)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(systemLog));
            systemLogging.setHandler(handler);
        } else if (target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("default:stdout") || target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("file:stdout")) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(systemLog));
            systemLogging.setHandler(handler);
        } else {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{TARGET, "stdout|file"});
        }
        return systemLogging;
    }

    private ConsoleHandlerType commonFillConsolHandler() throws JAXBException {
        ConsoleHandlerType consoleHandler = this.jeusMainFactory.createConsoleHandlerType();
        consoleHandler.setName("console");
        return consoleHandler;
    }

    private FileHandlerType commonFillFileHandler(XMLTree logTree) throws JAXBException, XMLConverterException {
        Integer validDay;
        String fileName;
        FileHandlerType fileHandler = this.jeusMainFactory.createFileHandlerType();
        fileHandler.setName(FILE);
        Integer buffersize = (Integer)ValidString.getProperTypeFromString(logTree, "buffer-size", 0, false, DEFAULT_BUFFER_SIZE);
        if (buffersize != null) {
            fileHandler.setBufferSize(Integer.valueOf(buffersize));
        }
        if ((fileName = XMLUtil.getSubtreeValue(logTree, FILE_NAME)) != null) {
            fileHandler.setFileName(fileName);
        }
        if ((validDay = (Integer)ValidString.getProperTypeFromString(logTree, VALID_DAY, 0, false, "-1")) != null) {
            fileHandler.setValidDay(Integer.valueOf(validDay));
        }
        return fileHandler;
    }

    private PoolingType commonFillPooling(XMLTree smConnectionPool, String defaultMin, String defaultMax, String defaultStep, String defaultPeriod) throws JAXBException, XMLConverterException {
        Integer period;
        Integer max;
        PoolingType pooling = this.jeusMainFactory.createPoolingType();
        Integer min = (Integer)ValidString.getProperTypeFromString(smConnectionPool, MIN, 0, false, defaultMin);
        if (min != null) {
            pooling.setMin(Integer.valueOf(min));
        }
        if ((max = (Integer)ValidString.getProperTypeFromString(smConnectionPool, MAX, 0, false, defaultMax)) != null) {
            pooling.setMax(Integer.valueOf(max));
        }
        if ((period = (Integer)ValidString.getProperTypeFromString(smConnectionPool, PERIOD, 0, false, defaultPeriod)) != null) {
            pooling.setPeriod(Long.valueOf(period.intValue()));
        }
        return pooling;
    }

    private OldPoolingType commonFillPooling1(XMLTree smConnectionPool, String defaultMin, String defaultMax, String defaultStep, String defaultPeriod) throws JAXBException, XMLConverterException {
        Integer period;
        Integer step;
        Integer max;
        OldPoolingType pooling = this.jeusMainFactory.createOldPoolingType();
        Integer min = (Integer)ValidString.getProperTypeFromString(smConnectionPool, MIN, 0, false, defaultMin);
        if (min != null) {
            pooling.setMin(Integer.valueOf(min));
        }
        if ((max = (Integer)ValidString.getProperTypeFromString(smConnectionPool, MAX, 0, false, defaultMax)) != null) {
            pooling.setMax(Integer.valueOf(max));
        }
        if ((step = (Integer)ValidString.getProperTypeFromString(smConnectionPool, STEP, 0, false, defaultStep)) != null) {
            pooling.setStep(Integer.valueOf(step));
        }
        if ((period = (Integer)ValidString.getProperTypeFromString(smConnectionPool, PERIOD, 0, false, defaultPeriod)) != null) {
            pooling.setPeriod(Long.valueOf(period.intValue()));
        }
        return pooling;
    }

    private XMLTree findXmlTree(String engineName) {
        for (int k = 1; k < this.xmlTrees.length; ++k) {
            if (this.xmlTrees[k] == null || this.xmlTrees[k].getEngineName() == null || !this.xmlTrees[k].getEngineName().equals(engineName)) continue;
            return this.xmlTrees[k];
        }
        return null;
    }

    private XMLTree findXMLTrees(String engineContainerName, String type) {
        String xmlTreeEngineName = null;
        for (int k = 1; k < this.xmlTrees.length; ++k) {
            if (this.xmlTrees[k] == null || (xmlTreeEngineName = this.xmlTrees[k].getEngineName()) == null || !engineContainerName.equals(this.ECandEngine.get(xmlTreeEngineName)) || xmlTreeEngineName.indexOf(type) <= -1) continue;
            return this.xmlTrees[k];
        }
        return null;
    }
}

