/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.JeusFileNameFilter;
import jeus.tool.converter.version.XMLVersionConverter;
import jeus.tool.converter.version.process.ProcessConversion;

public class ConversionUtil {
    private static String FS = System.getProperty("file.separator");
    private static String CONFIG_DIR = WIOParameters.CONFIG_DIR;
    static String PACKAGE_PREFIX = "jeus.xml.binding.jeusDD";

    public static File[] getOldEngineDirs(int engineType) {
        File[] engineDirs = null;
        File nodeConfigDir = new File(XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS);
        int index = 0;
        File[] engineDirList = nodeConfigDir.listFiles(new JeusFileNameFilter(engineType, ProcessConversion.NODE_NAME));
        File[] temp = new File[engineDirList.length];
        if (engineDirList != null) {
            for (int k = 0; k < engineDirList.length; ++k) {
                File engineDir = engineDirList[k];
                if (!engineDir.isDirectory()) continue;
                temp[index++] = engineDir;
            }
            engineDirs = new File[index];
            for (int i = 0; i < index; ++i) {
                engineDirs[i] = temp[i];
            }
        }
        return engineDirs;
    }

    public static String[] getOldEngineXMLPaths(int engineType, File[] engineDirs) {
        String[] engineDirPath = new String[engineDirs.length];
        if (engineDirs != null) {
            for (int k = 0; k < engineDirs.length; ++k) {
                engineDirPath[k] = ConversionUtil.getOldPath(engineType, engineDirs[k].getName(), null);
            }
        }
        return engineDirPath;
    }

    public static String getOldPath(int docType, String engineName, String fileName) {
        if (docType == XMLVersionConverter.JEUS_CONFIG) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + "JEUSMain.xml";
        }
        if (docType == XMLVersionConverter.EJB_MAIN) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + "EJBMain.xml";
        }
        if (docType == XMLVersionConverter.WEB_MAIN) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + "WEBMain.xml";
        }
        if (docType == XMLVersionConverter.JMS_MAIN) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + "JMSMain.xml";
        }
        if (docType == XMLVersionConverter.REALM_MAIN) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + "file-realm.xml";
        }
        if (docType == XMLVersionConverter.JEUS_EJB_DD) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + fileName;
        }
        if (docType == XMLVersionConverter.JEUS_WEB_DD) {
            return XMLVersionConverter.JEUS4_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + fileName;
        }
        if (docType == XMLVersionConverter.JEUS_CLIENT_DD) {
            // empty if block
        }
        return "not_defined";
    }

    public static String getNewPath(int docType, String engineName, String fileName) {
        if (docType == XMLVersionConverter.JEUS_CONFIG) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + "JEUSMain.xml";
        }
        if (docType == XMLVersionConverter.EJB_MAIN) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + "EJBMain.xml";
        }
        if (docType == XMLVersionConverter.WEB_MAIN) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + "WEBMain.xml";
        }
        if (docType == XMLVersionConverter.JMS_MAIN) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + "JMSMain.xml";
        }
        if (docType == XMLVersionConverter.REALM_MAIN) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + "security" + FS + "SYSTEM_DOMAIN" + FS + "accounts.xml";
        }
        if (docType == XMLVersionConverter.JEUS_EJB_DD) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + fileName;
        }
        if (docType == XMLVersionConverter.JEUS_WEB_DD) {
            return CONFIG_DIR + FS + ProcessConversion.NODE_NAME + FS + engineName + FS + fileName;
        }
        if (docType == XMLVersionConverter.JEUS_CLIENT_DD) {
            // empty if block
        }
        return "not_defined";
    }

    public static int getEngineXMLTrees(String[] ejbSourcePaths, XMLConverter ejbMainConverter, File[] ejbEngineDirs, XMLTree[] xmlTrees, int count) throws Exception {
        boolean validate = WIOParameters.XML_VALIDATION;
        XMLUtil xmlUtil = new XMLUtil();
        for (int k = 0; k < ejbSourcePaths.length; ++k) {
            File ejbXmlFile = new File(ejbSourcePaths[k]);
            FileInputStream is = new FileInputStream(ejbXmlFile);
            xmlTrees[count] = xmlUtil.process((InputStream)is, validate, ejbMainConverter.getPublicID(), ejbMainConverter.getSystemID(), ejbMainConverter.getType());
            xmlTrees[count].setNodeName(ProcessConversion.NODE_NAME);
            xmlTrees[count++].setEngineName(ejbEngineDirs[k].getName());
        }
        return count;
    }
}

