/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic;

import java.util.logging.Level;
import jeus.security.base.Subject;
import jeus.security.util.LoginUtil;
import jeus.tool.converter.weblogic.process.ProcessConversion;
import jeus.util.SecurityUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.properties.JeusNetPropertyValues;

public class WeblogicConverter {
    String CONVERT_TYPE = "domain";
    String DOMAIN_DIR = null;
    String SOURCE_PATH = null;
    String MODULE_NAME = null;
    String SAVE_DIR = null;
    String USER = null;
    String PASSWORD = null;

    public static void main(String[] argv) {
        WeblogicConverter wlj = new WeblogicConverter();
        if (!wlj.parseArgs(argv)) {
            return;
        }
        wlj.processConversion();
    }

    public boolean parseArgs(String[] args) {
        if (args.length < 1) {
            WeblogicConverter.printUsage();
            return false;
        }
        this.CONVERT_TYPE = args[0];
        if (!this.convertTypeValidate(this.CONVERT_TYPE)) {
            WeblogicConverter.printUsage();
            return false;
        }
        int i = 1;
        while (i + 1 < args.length) {
            String argType = args[i];
            String argValue = args[i + 1];
            this.fillArgValue(argType, argValue);
            i += 2;
        }
        if (this.CONVERT_TYPE.equals("domain")) {
            if (this.USER == null || this.PASSWORD == null) {
                System.out.println("please input user name and passward");
                return false;
            }
            SecurityUtil.installClientSecurity(JeusNetPropertyValues.LOCAL_HOSTNAME);
            LoginUtil.loginWithRuntimeException(Subject.makeSubject("SYSTEM_DOMAIN", this.USER, this.PASSWORD));
        } else if ((this.CONVERT_TYPE.equals("ejbDD") || this.CONVERT_TYPE.equals("webDD")) && this.MODULE_NAME == null) {
            WeblogicConverter.printUsage();
            return false;
        }
        return true;
    }

    public void fillArgValue(String type, String value) {
        if (type.equalsIgnoreCase("-m")) {
            this.MODULE_NAME = value;
        }
        if (type.equalsIgnoreCase("-s")) {
            this.SOURCE_PATH = value;
        }
        if (type.equalsIgnoreCase("-sd")) {
            this.SAVE_DIR = value;
        }
        if (type.equalsIgnoreCase("-U")) {
            this.USER = value;
        }
        if (type.equalsIgnoreCase("-P")) {
            this.PASSWORD = value;
        }
    }

    public void processConversion() {
        try {
            ProcessConversion con = new ProcessConversion();
            String targetPath = null;
            if (this.CONVERT_TYPE.equalsIgnoreCase("domain")) {
                this.DOMAIN_DIR = this.SOURCE_PATH;
                con.convertDomainToJeus(this.DOMAIN_DIR);
            } else if (this.CONVERT_TYPE.equalsIgnoreCase("ear")) {
                con.getClass();
                targetPath = con.convertModule(0, this.SOURCE_PATH, null, false);
            } else if (this.CONVERT_TYPE.equalsIgnoreCase("ejb")) {
                con.getClass();
                targetPath = con.convertModule(1, this.SOURCE_PATH, null, false);
            } else if (this.CONVERT_TYPE.equalsIgnoreCase("war")) {
                con.getClass();
                targetPath = con.convertModule(2, this.SOURCE_PATH, null, false);
            } else if (this.CONVERT_TYPE.equalsIgnoreCase("ejbDD")) {
                con.getClass();
                targetPath = con.doConvertJeusDD(1, this.SOURCE_PATH, this.SAVE_DIR, this.MODULE_NAME, true);
            } else if (this.CONVERT_TYPE.equalsIgnoreCase("webDD")) {
                con.getClass();
                targetPath = con.doConvertJeusDD(2, this.SOURCE_PATH, this.SAVE_DIR, this.MODULE_NAME, true);
            }
            if (this.CONVERT_TYPE.equalsIgnoreCase("domain")) {
                System.out.println("Conversion Success - " + this.SOURCE_PATH + "\n");
                WeblogicConverter.printPostconversion();
            } else {
                System.out.println("Conversion Success - " + this.SOURCE_PATH + " To " + targetPath + "\n");
            }
        }
        catch (Exception e) {
            JeusLogger.getLogger((String)"jeus.converter").log(Level.SEVERE, "Conversion is failed - " + this.SOURCE_PATH, e);
        }
    }

    public boolean convertTypeValidate(String deployType) {
        if (deployType.equalsIgnoreCase("domain") || deployType.equalsIgnoreCase("ear") || deployType.equalsIgnoreCase("ejb") || deployType.equalsIgnoreCase("war") || deployType.equalsIgnoreCase("ejbDD") || deployType.equalsIgnoreCase("webDD")) {
            return true;
        }
        System.out.println("\n[ERROR] Convert Type must be one of : domain, ear, ejb, war, ejbDD, webDD");
        return false;
    }

    private static void printPostconversion() {
        System.out.println("***********************************************************************");
        System.out.println("you must do the followings");
        System.out.println("put the startup class or shutdown class in %JEUS_HOME%/lib/application");
        System.out.println("add wl.jar to %JEUS_HOME%/lib/system");
        System.out.println("put DB driver class in %JEUS_HOME%/lib/datasource");
        System.out.println("change DB password properly in jeusMain.xml");
        System.out.println("we does not support the followings");
        System.out.println("invoke the non-main method in startup or shutdown class");
        System.out.println("convert other application but ear, ejb, war");
        System.out.println("************************************************************************");
    }

    protected static void printUsage() {
        System.out.println("\nusage: <> is required argument, [] is optional argument. ");
        System.out.println("--------------------------------------------------------------------");
        System.out.println("wltojeus domain <-s domain_dir> <-U user_name> <-P password>");
        System.out.println(" or, ");
        System.out.println("wltojeus ear <-s source_path> ");
        System.out.println("wltojeus ejb <-s source_path> ");
        System.out.println("wltojeus war <-s source_path> ");
        System.out.println("wltojeus ejbDD <-s source_path> <-m module_name> [-sd save_dir]");
        System.out.println("wltojeus webDD <-s source_path> <-m module_name> [-sd save_dir]");
        System.out.println("--------------------------------------------------------------------");
        System.out.println(" ear, ejb and ear module is saved in APP_HOME");
        System.out.println(" if [-sd save_dir] not specified, current working directory will be the destination.");
    }
}

